<?php
/*
 * Passport Post By ID Widget
 * -------------------------------------------------------------------------
 *
 * @package WordPress
 * @subpackage passport
 * @since Passport 1.0
 */
class Passport_Post_By_ID_Widget extends WP_Widget {

function __construct() {
	$widget_ops = array( 'classname' => 'widget_post_by_id', 'description' => esc_html__( 'Display post by ID', 'passport' ) );
	parent::__construct( 'passport_post_by_id_widget', esc_html__( 'Passport Post by ID', 'passport' ), $widget_ops	);

	$this->alt_option_name = 'widget_post_by_id';
    add_action( 'wp_enqueue_scripts', array( $this, 'passport_widget_inline_style' ) );

}


/**
 * Styling the widget
 */
public function passport_widget_inline_style() { 
    $i = 0;

    $widget_options = get_option( $this->option_name );

    $custom_widget_css = '';
        if( is_array( $widget_options ) && count( $widget_options ) > 0 ) {
			foreach ( $widget_options as $key => $widget_option ) {
     
                $widget_title_bgcolor_option = isset( $widget_option['widget_title_bgcolor'] ) ? $widget_option['widget_title_bgcolor'] : '';
 
                if ( isset( $widget_title_bgcolor_option ) ) {
                    $custom_widget_css .= "#{$this->id_base}-{$key} .widget-title {";
                    $custom_widget_css .= ! empty( $widget_title_bgcolor_option ) ? 'background-color:'. $widget_title_bgcolor_option .';' :'background-color: #333333;';
                    $custom_widget_css .= "}";
                    $custom_widget_css .= "#{$this->id_base}-{$key} .widget-title span {";
                    $custom_widget_css .= 'color: #ffffff;';
                    $custom_widget_css .= "}";
    	       }
            $i++;
	    }
    }
    wp_add_inline_style( PASSPORT_THEME_SLUG . '-custom-style', $custom_widget_css );   
}


// Creating widget front-end
// This is where the action happens
public function widget( $args, $instance ) {

    global $post;
    global $passport_section_settings;
    global $passport_front_page_column;
    global $passport_headline_column;
    global $passport_footer_column;

	$title				= ! empty( $instance['title'] ) ? $instance['title'] : '';
	$id					= ! empty( $instance['id'] ) ? absint( $instance['id'] ) : '';
    $post_type			= ! empty( $instance['post_type'] ) ? $instance['post_type'] : 'post';
	$show_title			= ! empty( $instance['show_title'] ) ? $instance['show_title'] : false;
	$show_media			= ! empty( $instance['show_media'] ) ? $instance['show_media'] : false;
	$image_position		= ! empty( $instance['image_position'] ) ? $instance['image_position'] : 'left';
	$show_date			= ! empty( $instance['show_date'] ) ? $instance['show_date'] : false;
	$show_excerpt		= ! empty( $instance['show_excerpt'] ) ? $instance['show_excerpt'] : false;
	$show_button		= ! empty( $instance['show_button'] ) ? $instance['show_button'] : false;
	$widget_icon		= ! empty( $instance['widget_icon'] ) ? $instance['widget_icon'] : '';
	$frontpage_id		= get_option( 'page_on_front' );
	$attachment_id		= get_post_thumbnail_id( $frontpage_id );
    $theme_setting		= get_theme_mod( 'passport_theme_setting', 'full_width_container' );

	$widget_args = array(
		'p'				     => $id,
		'post_type'		     => $post_type,
        'posts_per_page'     => 1,
        'ignore_sticky_posts'=> TRUE,
	);

	$wp_query	= new WP_Query( $widget_args );

	if ( $wp_query->have_posts() ) : ?>
		<?php echo $args['before_widget']; ?>
		<?php if ( ! empty( $title ) ) {  echo '<h4 class="widget-title"><i class="'. $widget_icon .'"></i> <span>'. $title .'</span></h4>'; } ?>
		<?php while ( $wp_query->have_posts() ) : $wp_query->the_post(); 

                 //Activate Post Format
                $post_format    = get_post_format( get_the_ID() );
                $aside_active   = get_post_meta( get_the_ID(), 'as_active', true );
                $audio_active	= get_post_meta( get_the_ID(), 'a_active', true );
                $gallery_active	= get_post_meta( get_the_ID(), 'g_active', true );
                $image_active	= get_post_meta( get_the_ID(), 'i_active', true );
                $link_active	= get_post_meta( get_the_ID(), 'l_active', true );
                $quote_active	= get_post_meta( get_the_ID(), 'q_active', true );
                $video_active	= get_post_meta( get_the_ID(), 'v_active', true);

                //Check if do not want to show the content
                $aside_no_content	= get_post_meta( get_the_ID(), 'as_no_content', true);
                $audio_no_content	= get_post_meta( get_the_ID(), 'a_no_content', true );
                $gallery_no_content = get_post_meta( get_the_ID(), 'g_no_content', true );
                $image_no_content	= get_post_meta( get_the_ID(), 'i_no_content', true ); 
                $link_no_content	= get_post_meta( get_the_ID(), 'l_no_content', true );
                $quote_no_content	= get_post_meta( get_the_ID(), 'q_no_content', true );
                $video_no_content	= get_post_meta( get_the_ID(), 'v_no_content', true);

				$archive_year		= get_the_time( 'Y' ); 
				$archive_month		= get_the_time( 'm' ); 
				$archive_day		= get_the_time( 'd' );
	
            if ( ! empty( $id ) ) : ?>
                <div class="widget-post-item clearfix">
		            <?php if( 'left' == $image_position || 'right' == $image_position ): ?>
				        <?php if( ! empty( $show_media ) &&  ( has_post_thumbnail() || 0 != $attachment_id ) ) : ?>
                            <a href="<?php the_permalink(); ?>" class="<?php  if ( 'left' == $image_position ) { echo 'alignleft'; } else { echo 'alignright'; } ?>">
                                <figure class="bglayer">
					                <?php 
                                        if( 'right' == $image_position && 'full_width_container' == $theme_setting && is_front_page() ) : 
                                            the_post_thumbnail( 'medium-570-299', array( 'class' => 'alignright wp-post-image' ) ); 	    			    
                                        elseif( 'right' == $image_position ) : 
                                            the_post_thumbnail( 'small-140-110', array( 'class' => 'alignright wp-post-image' ) );
			                            elseif( 'left' == $image_position && 'full_width_container' == $theme_setting && is_front_page() ) : 
                                            the_post_thumbnail( 'medium-570-299', array( 'class' => 'alignleft wp-post-image' ) );	    			    
                                        elseif( 'left' == $image_position ) :
                                            the_post_thumbnail( 'small-140-110', array( 'class' => 'alignleft wp-post-image' ) );
					                    endif; 
                                    ?>
                                    <span class="icon-hero"><?php echo passport_icon_shows(); ?></span>
                                </figure>
                            </a>
				        <?php endif; ?>
				        <div class="post-content">
					        <?php if ( $show_title ) : ?>
						        <h4 class="entry-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
					        <?php endif; ?>
					        <?php if ( $show_date ) : ?>
						        <p class="post-info clearfix"><span><i class="fa fa-clock-o"></i> <a href="<?php echo esc_url( get_day_link( $archive_year, $archive_month, $archive_day ) ); ?>"><?php echo get_the_date(); ?></a></span></p>
					        <?php endif; ?>
					        <?php if ( $show_excerpt && 'full_width_container' == $theme_setting && 'post' == $post_type ) : ?>
						        <?php echo passport_excerpt( '65' ); ?>
					        <?php elseif ( $show_excerpt ) : ?>
                                <?php echo passport_excerpt( '25' ); ?>
                            <?php endif; ?>
					        <?php if ( $show_button ) : ?>
						        <p><a class="btn btn-color" href="<?php the_permalink(); ?>" role="button"><?php esc_html_e( 'Read more', 'passport' ); ?></a></p>
					        <?php endif; ?>
					    </div>
			        <?php else: ?>
                        <article id="post-<?php the_ID(); ?>" <?php post_class(); ?> aria-label="post-<?php the_ID(); ?>">
                            <div class="post-media">
                                <?php if( ! empty( $show_media ) &&  ( has_post_thumbnail() || 0 != $attachment_id ) ) : ?>
                                    <?php   
                                       if( false == $post_format ) {
                                           get_template_part( 'partials/partials', 'image' );
                                        } elseif( 'aside' == $post_format && ! empty( $aside_active ) ) {
                                            echo passport_display_aside_post_format();
                                        } elseif( 'link' == $post_format && ! empty( $link_active ) ) {
                                            echo passport_display_link_post_format();
                                        } elseif( 'quote' == $post_format && ! empty( $quote_active ) ) {
	                                        echo passport_display_quote_post_format();
                                        } elseif( 'image' == $post_format && ! empty( $image_active ) ) {
	                                        echo passport_display_image_post_format();
                                        } elseif( 'gallery' == $post_format && ! empty( $gallery_active ) ) {
                                            echo passport_display_gallery_post_format();
                                        } elseif( 'audio' == $post_format && ! empty( $audio_active ) ) {
		                                    echo passport_display_audio_post_format();
                                        } elseif( 'video' == $post_format && ! empty( $video_active ) ) {
	                                        echo passport_display_video_post_format();
                                        } else {
                                            get_template_part( 'partials/partials', 'image' );
                                        }
                                    ?>
                                <?php endif; ?>
                            </div>
                            <?php if( ( false == get_post_format() && 'publish' === get_post_status() )
                                    || ( 'aside' == $post_format && 'on' !== $aside_no_content && 'publish' === get_post_status() )  
                                    || ( 'link' == $post_format && 'on' !== $link_no_content && 'publish' === get_post_status() )
                                    || ( 'quote' == $post_format && 'on' !== $quote_no_content && 'publish' === get_post_status() )
                                    || ( 'image' == $post_format && 'on' !== $image_no_content && 'publish' === get_post_status() )
                                    || ( 'gallery' == $post_format && 'on' !== $gallery_no_content && 'publish' === get_post_status() )
                                    || ( 'audio' == $post_format && 'on' !== $audio_no_content && 'publish' === get_post_status() )
                                    || ( 'video' == $post_format && 'on' !== $video_no_content && 'publish' === get_post_status() ) ) : 
                            ?>
                            <div class="post-content">
                                <?php if( 'post' == $post_type ) : ?>
                                    <header class="entry-header">
                                        <?php if ( $show_title ) : ?>
                                            <h4 class="entry-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
                                        <?php endif; ?>
                                        <?php if ( $show_date ) : ?>
	                                        <p class="post-info">
		                                        <?php echo passport_get_simple_likes_button( get_the_ID() ); ?>
	                                            |	<a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>"><i class="fa fa-user"></i> <?php echo get_the_author(); ?></a>
	                                            |	<a href="<?php echo esc_url( get_day_link( $archive_year, $archive_month, $archive_day ) ); ?>"><i class="fa fa-clock-o"></i> <?php echo get_the_date(); ?></a>
	                                        </p>
                                        <?php endif; ?>
                                    </header>
                                <?php else : ?>
                                    <?php if ( $show_title ) : ?>
                                        <h4 class="entry-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
                                    <?php endif; ?>
                                <?php endif; ?>
                                <?php if ( $show_excerpt ) : ?>
                                    <div class="entry-content"><?php echo passport_excerpt( '25' ); ?></div>
                                <?php endif; ?>
                            </div>
                            <?php // endif; ?>
                            <?php endif; ?>
                            <div class="clear"></div>   
                        </article>
			        <?php endif; ?>
                </div>
            <?php endif; ?>
		<?php endwhile; ?>
		<?php echo $args['after_widget']; ?>
<?php
		// Reset the global $the_post as this query will have stomped on it
		wp_reset_postdata();

		endif;
	}
		

// Widget Backend 
public function form( $instance ) {
	
//Set up some default widget settings.
		$instance			= wp_parse_args( (array) $instance, array( 
			'title'				   => '', 
			'id'				   => '', 
			'post_type'			   => 'post', 
			'show_title'		   => '1', 
			'show_media'		   => '1', 
			'image_position'	   => 'center', 
			'show_date'			   => '1', 
			'show_excerpt'		   => '0', 
			'show_button'		   => '0', 
			'widget_icon'		   => '', 
			'widget_title_bgcolor' => '#333333'
		) );
		$title				  = $instance['title'];
		$id					  = $instance['id'];
		$show_title			  = $instance['show_title'];
		$show_media			  = $instance['show_media'];
		$show_date			  = $instance['show_date'];
		$show_excerpt		  = $instance['show_excerpt'];
		$show_button		  = $instance['show_button'];
		$widget_icon		  = $instance['widget_icon'];
		$widget_title_bgcolor = $instance['widget_title_bgcolor'];

// Widget admin form
?>
	<p>
		<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php esc_html_e( 'Widget Title:', 'passport' ); ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
	</p>

	<p>
		<label for="<?php echo $this->get_field_id( 'id' ); ?>"><?php esc_html_e( 'Post ID:', 'passport' ); ?></label>
		<input id="<?php echo $this->get_field_id( 'id' ); ?>" name="<?php echo $this->get_field_name( 'id' ); ?>" type="text" value="<?php echo esc_attr( $id ); ?>" size="3" />
	</p>

	<p>
		<label for="<?php echo $this->get_field_id( 'post_type' ); ?>"><?php esc_html_e( 'Post type:', 'passport' ); ?></label>
		<select name="<?php echo $this->get_field_name( 'post_type' ); ?>" id="<?php echo $this->get_field_id( 'post_type' ); ?>">
			<option value="post"<?php selected( $instance['post_type'], 'post' ); ?>><?php esc_html_e( 'post', 'passport' ); ?></option>
			<option value="page"<?php selected( $instance['post_type'], 'page' ); ?>><?php esc_html_e( 'page', 'passport' ); ?></option>
		</select>
	</p>

	<p>
		<input class="checkbox" type="checkbox" <?php checked( $show_title ); ?> id="<?php echo $this->get_field_id( 'show_title' ); ?>" name="<?php echo $this->get_field_name( 'show_title' ); ?>" />
		<label for="<?php echo $this->get_field_id( 'show_title' ); ?>"><?php esc_html_e( 'Display title?', 'passport' ); ?></label>
	</p>

	<p>
		<input class="checkbox" type="checkbox" <?php checked( $show_media ); ?> id="<?php echo $this->get_field_id( 'show_media' ); ?>" name="<?php echo $this->get_field_name( 'show_media' ); ?>" />
		<label for="<?php echo $this->get_field_id( 'show_media' ); ?>"><?php esc_html_e( 'Display featured image / post format?', 'passport' ); ?></label><br />
    </p>

	<p>
		<label for="<?php echo $this->get_field_id( 'image_position' ); ?>"><?php esc_html_e( 'Featured image Position:', 'passport' ); ?></label>
		<select name="<?php echo $this->get_field_name( 'image_position' ); ?>" id="<?php echo $this->get_field_id( 'image_position' ); ?>">
			<option value="left"<?php selected( $instance['image_position'], 'left' ); ?>><?php esc_html_e( 'Left', 'passport' ); ?></option>
			<option value="right"<?php selected( $instance['image_position'], 'right' ); ?>><?php esc_html_e( 'Right', 'passport' ); ?></option>
			<option value="center"<?php selected( $instance['image_position'], 'center' ); ?>><?php esc_html_e( 'center', 'passport' ); ?></option>
		</select>
	    <small><?php esc_html_e( 'Post format will show at the center position, the other positions will not.', 'passport' ); ?></small>
	</p>

	<p>
		<input class="checkbox" type="checkbox" <?php checked( $show_date ); ?> id="<?php echo $this->get_field_id( 'show_date' ); ?>" name="<?php echo $this->get_field_name( 'show_date' ); ?>" />
		<label for="<?php echo $this->get_field_id( 'show_date' ); ?>"><?php esc_html_e( 'Display the post date?', 'passport' ); ?></label>
	</p>

	<p>
		<input class="checkbox" type="checkbox" <?php checked( $show_excerpt ); ?> id="<?php echo $this->get_field_id( 'show_excerpt' ); ?>" name="<?php echo $this->get_field_name( 'show_excerpt' ); ?>" />
		<label for="<?php echo $this->get_field_id( 'show_excerpt' ); ?>"><?php esc_html_e( 'Show the excerpt?', 'passport' ); ?></label>
	</p>

	<p>
		<input class="checkbox" type="checkbox" <?php checked( $show_button ); ?> id="<?php echo $this->get_field_id( 'show_button' ); ?>" name="<?php echo $this->get_field_name( 'show_button' ); ?>" />
		<label for="<?php echo $this->get_field_id( 'show_button' ); ?>"><?php esc_html_e( 'Show the button?', 'passport' ); ?></label>
	</p>

	<h4><?php esc_html_e( 'Widget Style', 'passport' ); ?></h4>
	<p>
		<label for="<?php echo $this->get_field_id( 'widget_icon' ); ?>"><?php esc_html_e( 'Icon:', 'passport' ); ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'widget_icon' ); ?>" name="<?php echo $this->get_field_name( 'widget_icon' ); ?>" type="text" value="<?php echo esc_attr( $widget_icon ); ?>" />
		<br />
		<small><?php esc_html_e( 'Please choose your  fontawesome icon. For example: fa fa-home.', 'passport' ); ?></small>
		<small><a href="<?php echo esc_url( 'https://fortawesome.github.io/Font-Awesome/cheatsheet/' ); ?>" target="_blank"><b><?php esc_html_e( 'Find your icon', 'passport' ); ?></b></a></small>
	</p>

	<label for="<?php echo $this->get_field_id( 'widget_title_bgcolor' ); ?>" style="display:block;"><?php esc_html_e( 'Widget Title Background Color:', 'passport' ); ?></label><br />
	<input class="widefat color" id="<?php echo $this->get_field_id( 'widget_title_bgcolor' ); ?>" name="<?php echo $this->get_field_name( 'widget_title_bgcolor' ); ?>" type="text" value="<?php echo esc_attr( $widget_title_bgcolor ); ?>" />
	<div class="colorpicker"></div>

<?php
}


// Updating widget replacing old instances with new instances
public function update( $new_instance, $old_instance ) {
	$instance = $old_instance;

	//Define Array
	$post_type = array( 'post', 'page' );
	$image_position_array = array( 'left', 'right', 'center' );
	
	//Update new instances
	$instance['title']				  = wp_filter_nohtml_kses( $new_instance['title'] );
	$instance['id']					  = (int) $new_instance['id'];
	if ( in_array( $new_instance['post_type'], $post_type ) ) {
		$instance['post_type']		  = $new_instance['post_type'];
	} else {
		$instance['post_type']		  = 'post';
	}
	$instance['show_title']			  = isset( $new_instance['show_title'] ) ? (bool) $new_instance['show_title'] : false;
	$instance['show_media']			  = isset( $new_instance['show_media'] ) ? (bool) $new_instance['show_media'] : false;
	if ( in_array( $new_instance['image_position'], $image_position_array ) ) {
		$instance['image_position']   = $new_instance['image_position'];
	} else {
		$instance['image_position']   = 'left';
	}
	$instance['show_date']			  = isset( $new_instance['show_date'] ) ? (bool) $new_instance['show_date'] : false;
	$instance['show_excerpt']		  = isset( $new_instance['show_excerpt'] ) ? (bool) $new_instance['show_excerpt'] : false;
	$instance['show_button']		  = isset( $new_instance['show_button'] ) ? (bool) $new_instance['show_button'] : false;
	$instance['widget_icon']		  = wp_filter_nohtml_kses( $new_instance['widget_icon'] );
	$instance['widget_title_bgcolor'] = wp_filter_nohtml_kses( $new_instance['widget_title_bgcolor'] );

	return $instance;
}

} // Class widget ends here


// Register and load the widget
function passport_post_by_id_load_widget() {
	register_widget( 'Passport_Post_By_ID_Widget' );
}
add_action( 'widgets_init', 'passport_post_by_id_load_widget' );