<?php
/*
 * Passport Parallax Widget
 * -------------------------------------------------------------------------
 *
 * @package WordPress
 * @subpackage passport
 * @since Passport 1.0
 */
class Passport_Parallax_Widget extends WP_Widget {

function __construct() {
	$widget_ops = array( 'classname' => 'widget_parallax clearfix', 'description' => esc_html__( 'Parallax', 'passport' ) );
	parent::__construct( 'passport_parallax_widget', esc_html__( 'Passport Parallax', 'passport' ), $widget_ops	);

	$this->alt_option_name = 'widget_parallax';
    add_action( 'wp_enqueue_scripts', array( $this, 'passport_widget_inline_style' ) );

}


/**
 * Styling the widget
 */
public function passport_widget_inline_style() { 
    $i = 0;

    $widget_options = get_option( $this->option_name );

    $custom_widget_css = '';
        if( is_array( $widget_options ) && count( $widget_options ) > 0 ) {
			foreach ( $widget_options as $key => $widget_option ) {

                $widget_id                  = isset( $widget_option['id'] ) ? $widget_option['id'] : '';
                $widget_bg_attachment       = isset( $widget_option['bg_attachment'] ) ? $widget_option['bg_attachment'] : '';
                $widget_bg_height           = isset( $widget_option['bg_height'] ) ? $widget_option['bg_height'] : '';
                $widget_horizontal_position = isset( $widget_option['horizontal_position'] ) ? $widget_option['horizontal_position'] : '';
                $widget_vertical_position   = isset( $widget_option['vertical_position'] ) ? $widget_option['vertical_position'] : '';
                $widget_title_color         = isset( $widget_option['title_color'] ) ? $widget_option['title_color'] : '';
                $widget_excerpt_color       = isset( $widget_option['excerpt_color'] ) ? $widget_option['excerpt_color'] : '';
                $widget_button_font_color   = isset( $widget_option['button_font_color'] ) ? $widget_option['button_font_color'] : '';
                $widget_button_border_color = isset( $widget_option['button_bg_color'] ) ? $widget_option['button_bg_color'] : '';
                $widget_button_bg_color     = isset( $widget_option['button_bg_color'] ) ? $widget_option['button_bg_color'] : '';
 	            $thumb_id		            = get_post_thumbnail_id( $widget_id );
	            $thumb_url_array            = wp_get_attachment_image_src( $thumb_id, 'full', true );
	            $thumb_url		            = $thumb_url_array[0];

                if ( isset( $thumb_url ) || isset( $widget_bg_attachment ) || isset( $widget_bg_height ) || isset( $widget_horizontal_position ) || isset( $widget_vertical_position ) || isset( $widget_title_color ) || isset( $widget_excerpt_color ) || isset( $widget_button_font_color ) || isset( $widget_button_bg_color ) || isset( $widget_button_border_color ) ) {
                    $custom_widget_css .= "#{$this->id_base}-{$key} .parallax {";
                    $custom_widget_css .= ! empty( $thumb_url ) ? 'background-image:url( '. $thumb_url .' );' : '';
                    $custom_widget_css .= 'background-position: 50% 0px;';
                    $custom_widget_css .= 'background-size: cover;';
                    $custom_widget_css .= ! empty( $widget_bg_attachment ) ? 'background-attachment: '. $widget_bg_attachment .';' : 'background-attachment: scroll;';
                    $custom_widget_css .= ! empty( $widget_bg_height ) ? 'height:'. $widget_bg_height .'px;' : 'height: 750px;';
                    $custom_widget_css .= "}";

                    $custom_widget_css .= "#{$this->id_base}-{$key} .parallax-wrapper {";
                    $custom_widget_css .= ! empty( $widget_bg_height ) ? 'min-height: '. $widget_bg_height .'px;' : 'min-height: 750px;';
                    $custom_widget_css .= "}";

                    $custom_widget_css .= "#{$this->id_base}-{$key} .parallax-headline {";
                    $custom_widget_css .= ! empty( $widget_horizontal_position ) ? 'text-align: '. $widget_horizontal_position .';' : 'text-align: center;';
                    $custom_widget_css .= ! empty( $widget_vertical_position ) ? 'vertical-align: '. $widget_vertical_position .';' : 'vertical-align: middle;';
                    $custom_widget_css .= "}";

                    $custom_widget_css .= "#{$this->id_base}-{$key} .parallax-title {";
                    $custom_widget_css .= ! empty( $widget_title_color ) ? 'color: '. $widget_title_color .';' : 'color: #ffffff;';
                    $custom_widget_css .= "}";
                    
                    $custom_widget_css .= "#{$this->id_base}-{$key} .parallax-caption {";
                    $custom_widget_css .= ! empty( $widget_excerpt_color ) ? 'color: '. $widget_excerpt_color .';' : 'color: #A99D75;';
                    $custom_widget_css .= "}";

                    $custom_widget_css .= "#{$this->id_base}-{$key} .parallax-button {";
                    $custom_widget_css .= ! empty( $widget_button_font_color ) ? 'color: '. $widget_button_font_color .';' : 'color: #ffffff;';
                    $custom_widget_css .= ! empty( $widget_button_border_color ) ? 'border-color: '. $widget_button_border_color .';' : 'border-color: #ffffff;';
                    $custom_widget_css .= ! empty( $widget_button_bg_color ) ? 'background-color: '. $widget_button_bg_color .';' : 'background-color: transparent;';
                    $custom_widget_css .= "}";
    	       }
            $i++;
	    }
    }
    wp_add_inline_style( PASSPORT_THEME_SLUG . '-custom-style', $custom_widget_css );   
}


// Creating widget front-end
// This is where the action happens
public function widget( $args, $instance ) {

	$id					= ! empty( $instance['id'] ) ? absint( $instance['id'] ) : '';
	$button_text		= ! empty( $instance['button_text']) ? $instance['button_text'] : '';
 
	$img_post			= get_post( $id );

	$show_title			= get_the_title( $id );
	$show_excerpt		= ! empty( $img_post ) ? $img_post->post_excerpt : '';

	$widget_args = array(
		'p'				=> $id,
		'post_type'		=> 'post'
	);

	$wp_query	= new WP_Query( $widget_args );

	if ( $wp_query->have_posts() ) : ?>
	<?php echo $args['before_widget']; ?>

	<div id="parallax-<?php echo $id; ?>" class="parallax">
		<div class="item overlay clearfix">
			<div class="parallax-wrapper">
				<div class="parallax-headline">
					<?php if ( ! empty ( $show_excerpt ) ) : ?>
						<h4 id="hero" class = "parallax-caption"><?php echo $show_excerpt; ?></h4>
					<?php endif; ?>
					<?php if ( ! empty ( $show_title ) ) : ?>
						<h1 class = "parallax-title"><?php echo $show_title; ?></h1>
					<?php endif; ?>
					<?php if ( ! empty ( $button_text ) ) : ?>
						<a href="<?php echo esc_url( get_the_permalink( $id) ); ?>" class ="parallax-button" role="button"><?php echo $button_text; ?></a>
					<?php endif; ?>
				</div>
			</div>
		</div>
	</div>
    <?php echo $args['after_widget']; ?>
<?php
		// Reset the global $the_post as this query will have stomped on it
		wp_reset_postdata();

		endif;

	}
		
// Widget Backend 
public function form( $instance ) {
	
//Set up some default widget settings.
		$instance			= wp_parse_args( (array) $instance, array( 
			'id'				  => '',
			'bg_attachment'		  => 'scroll',
            'bg_height'           => '',
			'horizontal_position' => 'center', 
			'vertical_position'	  => 'middle',
			'button_text'		  => '', 
			'title_color'		  => '#ffffff', 
			'excerpt_color'		  => '#A99D75', 
			'button_font_color'	  => '#ffffff', 
			'button_bg_color'	  => '#034f84'
		) );
		$id					= $instance['id'];
		$bg_attachment		= $instance['bg_attachment'];
        $bg_height          = $instance['bg_height'];
		$horizontal_position= $instance['horizontal_position'];
		$vertical_position	= $instance['vertical_position'];
		$button_text		= $instance['button_text'];
		$title_color		= $instance['title_color'];		
		$excerpt_color		= $instance['excerpt_color'];
		$button_font_color	= $instance['button_font_color'];
		$button_bg_color	= $instance['button_bg_color'];
		
// Widget admin form
?>
	
	<p>
		<label for="<?php echo $this->get_field_id( 'id' ); ?>"><?php esc_html_e( 'Post ID:', 'passport' ); ?></label>
		<input id="<?php echo $this->get_field_id( 'id' ); ?>" name="<?php echo $this->get_field_name( 'id' ); ?>" type="text" value="<?php echo esc_attr( $id ); ?>" size="3" />
	</p>

	<p>
		<label for="<?php echo $this->get_field_id( 'bg_attachment' ); ?>"><?php esc_html_e( 'Background Attachment:', 'passport' ); ?></label>
		<select name="<?php echo $this->get_field_name( 'bg_attachment' ); ?>" id="<?php echo $this->get_field_id( 'bg_attachment' ); ?>">
			<option value="scroll"<?php selected( $instance['bg_attachment'], 'scroll' ); ?>><?php esc_html_e( 'Scroll', 'passport' ); ?></option>
			<option value="fixed"<?php selected( $instance['bg_attachment'], 'fixed' ); ?>><?php esc_html_e( 'Fixed', 'passport' ); ?></option>
		</select>
	</p>

	<p>
		<label for="<?php echo $this->get_field_id( 'bg_height' ); ?>"><?php esc_html_e( 'Background Height (px):', 'passport' ); ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'bg_height' ); ?>" name="<?php echo $this->get_field_name( 'bg_height' ); ?>" type="text" value="<?php echo esc_attr( $bg_height ); ?>" />
	</p>

	<label for="text-position"><?php esc_html_e( 'Text Position:', 'passport' ); ?></label>
	<p>
		<label for="<?php echo $this->get_field_id( 'horizontal_position' ); ?>"><?php esc_html_e( 'Horizontal Position:', 'passport' ); ?></label>
		<select name="<?php echo $this->get_field_name( 'horizontal_position' ); ?>" id="<?php echo $this->get_field_id( 'horizontal_position' ); ?>">
			<option value="left"<?php selected( $instance['horizontal_position'], 'left' ); ?>><?php esc_html_e( 'Left', 'passport' ); ?></option>
			<option value="center"<?php selected( $instance['horizontal_position'], 'center' ); ?>><?php esc_html_e( 'Center', 'passport' ); ?></option>
			<option value="right"<?php selected( $instance['horizontal_position'], 'right' ); ?>><?php esc_html_e( 'Right', 'passport' ); ?></option>
		</select>
	</p>

	<p>
		<label for="<?php echo $this->get_field_id( 'vertical_position' ); ?>"><?php esc_html_e( 'Vertical Position:', 'passport' ); ?></label>
		<select name="<?php echo $this->get_field_name( 'vertical_position' ); ?>" id="<?php echo $this->get_field_id( 'vertical_position' ); ?>">
			<option value="top"<?php selected( $instance['vertical_position'], 'top' ); ?>><?php esc_html_e( 'Top', 'passport' ); ?></option>
			<option value="middle"<?php selected( $instance['vertical_position'], 'middle' ); ?>><?php esc_html_e( 'Middle', 'passport' ); ?></option>
			<option value="bottom"<?php selected( $instance['vertical_position'], 'bottom' ); ?>><?php esc_html_e( 'Bottom', 'passport' ); ?></option>
		</select>
	</p>

	<p>
		<label for="<?php echo $this->get_field_id( 'button_text' ); ?>"><?php esc_html_e( 'Button Text:', 'passport' ); ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'button_text' ); ?>" name="<?php echo $this->get_field_name( 'button_text' ); ?>" type="text" value="<?php echo esc_attr( $button_text ); ?>" />
	</p>

	<label for="<?php echo $this->get_field_id( 'title_color' ); ?>" style="display:block;"><?php esc_html_e( 'Title Color:', 'passport' ); ?></label><br />
	<input class="widefat color" id="<?php echo $this->get_field_id( 'title_color' ); ?>" name="<?php echo $this->get_field_name( 'title_color' ); ?>" type="text" value="<?php echo esc_attr( $title_color ); ?>" />
	<div class="colorpicker"></div>

	<label for="<?php echo $this->get_field_id( 'excerpt_color' ); ?>" style="display:block;"><?php esc_html_e( 'Excerpt Color:', 'passport' ); ?></label><br />
	<input class="widefat color" id="<?php echo $this->get_field_id( 'excerpt_color' ); ?>" name="<?php echo $this->get_field_name( 'excerpt_color' ); ?>" type="text" value="<?php echo esc_attr( $excerpt_color ); ?>" />
	<div class="colorpicker"></div>

	<label for="<?php echo $this->get_field_id( 'button_font_color' ); ?>" style="display:block;"><?php esc_html_e( 'Button Font Color:', 'passport' ); ?></label><br />
	<input class="widefat color" id="<?php echo $this->get_field_id( 'button_font_color' ); ?>" name="<?php echo $this->get_field_name( 'button_font_color' ); ?>" type="text" value="<?php echo esc_attr( $button_font_color ); ?>" />
	<div class="colorpicker"></div>

	<label for="<?php echo $this->get_field_id( 'button_bg_color' ); ?>" style="display:block;"><?php esc_html_e( 'Button Background Color:', 'passport' ); ?></label><br />
	<input class="widefat color" id="<?php echo $this->get_field_id( 'button_bg_color' ); ?>" name="<?php echo $this->get_field_name( 'button_bg_color' ); ?>" type="text" value="<?php echo esc_attr( $button_bg_color ); ?>" />
	<div class="colorpicker"></div>

<?php
}
	
// Updating widget replacing old instances with new instances
public function update( $new_instance, $old_instance ) {

	$instance = $old_instance;

	//Define Array
	$horizontal_position_array	= array( 'left', 'center', 'right' );
	$vertical_position_array	= array( 'top', 'middle', 'bottom' );
	$bg_attachment_array		= array( 'scroll', 'fixed' );
	
	//Update new instances
	$instance['id']					= (int) $new_instance['id'];
	if ( in_array( $new_instance['bg_attachment'], $bg_attachment_array ) ) {
		$instance['bg_attachment']			= $new_instance['bg_attachment'];
	} else {
		$instance['bg_attachment']			= 'scroll';
	}
    $instance['bg_height'] 		    = wp_filter_nohtml_kses( $new_instance['bg_height'] );
	if ( in_array( $new_instance['horizontal_position'], $horizontal_position_array ) ) {
		$instance['horizontal_position']	= $new_instance['horizontal_position'];
	} else {
		$instance['horizontal_position']	= 'center';
	}
	if ( in_array( $new_instance['vertical_position'], $vertical_position_array ) ) {
		$instance['vertical_position']		= $new_instance['vertical_position'];
	} else {
		$instance['vertical_position']		= 'middle';
	}
    $instance['button_text'] 		= wp_filter_nohtml_kses( $new_instance['button_text'] );
	$instance['title_color']		= wp_filter_nohtml_kses( $new_instance['title_color']);
	$instance['excerpt_color']		= wp_filter_nohtml_kses( $new_instance['excerpt_color']);
	$instance['button_font_color']	= wp_filter_nohtml_kses( $new_instance['button_font_color']);
	$instance['button_bg_color']	= wp_filter_nohtml_kses( $new_instance['button_bg_color']);

	return $instance;
}

} // Class widget ends here

// Register and load the widget
function passport_parallax_load_widget() {
	register_widget( 'Passport_Parallax_Widget' );
}
add_action( 'widgets_init', 'passport_parallax_load_widget' );