<?php
/*
 * Passport Most Popular Posts Widget
 * -------------------------------------------------------------------------
 *
 * @package WordPress
 * @subpackage passport
 * @since Passport 1.0
 */
class Passport_Most_Popular_Posts_Widget extends WP_Widget {

function __construct() {
	$widget_ops = array( 'classname' => 'widget_most_popular_posts', 'description' => esc_html__( 'Most popular posts', 'passport' ) );
	parent::__construct( 'passport_most_popular_posts_widget', esc_html__( 'Passport Most Popular Posts', 'passport' ), $widget_ops	);

    $this->alt_option_name = 'widget_most_popular_posts';
    add_action( 'wp_enqueue_scripts', array( $this, 'passport_widget_inline_style' ) );

}


/**
 * Styling the widget
 */
public function passport_widget_inline_style() { 
    $i = 0;

    $widget_options = get_option( $this->option_name );

    $custom_widget_css = '';
        if( is_array( $widget_options ) && count( $widget_options ) > 0 ) {
			foreach ( $widget_options as $key => $widget_option ) {
     
                $widget_title_bgcolor_option = isset( $widget_option['widget_title_bgcolor'] ) ? $widget_option['widget_title_bgcolor'] : '';
 
                if ( isset( $widget_title_bgcolor_option ) ) {
                    $custom_widget_css .= "#{$this->id_base}-{$key} .widget-title {";
                    $custom_widget_css .= ! empty( $widget_title_bgcolor_option ) ? 'background-color:'. $widget_title_bgcolor_option .';' :'background-color: #333333;';
                    $custom_widget_css .= "}";
                    $custom_widget_css .= "#{$this->id_base}-{$key} .widget-title span {";
                    $custom_widget_css .= 'color: #ffffff;';
                    $custom_widget_css .= "}";
    	       }
            $i++;
	    }
    }
    wp_add_inline_style( PASSPORT_THEME_SLUG . '-custom-style', $custom_widget_css );   
}


// Creating widget front-end
public function widget( $args, $instance ) {
	global $post;

	$title				= ! empty( $instance['title'] ) ? $instance['title'] : '';
	$title				= apply_filters( 'widget_title', $title, $instance, $this->id_base );
	$number				= ! empty( $instance['number'] ) ? absint( $instance['number'] ) : 5;
	$widget_icon		= ! empty( $instance['widget_icon'] ) ? $instance['widget_icon'] : '';
	$frontpage_id		= get_option( 'page_on_front' );
	$attachment_id		= get_post_thumbnail_id( $frontpage_id );

	$widget_args = array(
		'meta_key'				=> '_post_like_count',
		'orderby'				=> 'meta_value_num',
		'order'					=> 'DESC',
		'posts_per_page'		=> $number,
		'ignore_sticky_posts'	=> TRUE,
		 );

	$wp_query = new WP_Query( $widget_args );

	echo $args['before_widget'];
	if ( ! empty( $title ) ) {  echo '<h4 class="widget-title"><i class="'. $widget_icon .'"></i> <span>'. $title .'</span></h4>'; }
	if ( $wp_query->have_posts() ) : ?>
		<div class="post-views">
			<ul class="list-unstyled">
				<?php while ( $wp_query->have_posts() ) : $wp_query->the_post();
					$title = get_the_title( $post->ID );
					$image = get_the_post_thumbnail( $post->ID, 'small-100-70', array( 'class' => 'alignleft' ) );
					$archive_year		= get_the_time( 'Y' ); 
					$archive_month		= get_the_time( 'm' ); 
					$archive_day		= get_the_time( 'd' );
				?>
			    <li class="widget-post-item clearfix">
                    <div class="<?php if( ! empty( $image ) || 0 != $attachment_id ) { echo 'has-thumbnail'; } else { echo 'no-thumbnail'; } ?> list">
                        <figure class="bglayer alignleft">
                            <a href="<?php echo esc_url( get_permalink( $post->ID ) ); ?>">
                                <?php if( ! empty( $image ) ) { echo $image; } ?>
                            </a>
                        </figure>
				        <div class="post-content clearfix">
					        <h4 class="entry-title"><a href="<?php echo esc_url( get_permalink( $post->ID ) ); ?>"><?php echo passport_short_title( $title, 40 ); ?></a></h4>
				            <p class="post-info clearfix">
							    <?php echo passport_get_simple_likes_button( get_the_ID() ); ?>
						        |	<i class="fa fa-clock-o"></i> <a href="<?php echo esc_url( get_day_link( $archive_year, $archive_month, $archive_day ) ); ?>"><?php echo the_time( 'M j, Y' ); ?></a>
						    </p>
					    </div>
                    </div>
			    </li>
				<?php endwhile; ?>
			</ul>
		</div>
<?php 
	endif;
	echo $args['after_widget'];
	wp_reset_postdata();	
 }
		
// Widget Backend 
public function form( $instance ) {
	
//Set up some default widget settings.
		$instance			= wp_parse_args( (array) $instance, array( 
			'title'				   => '', 
			'number'			   => 5,
			'widget_icon'		   => '', 
			'widget_title_bgcolor' => '#333333' 
		) );
		$title				  = $instance['title'];
		$number				  = $instance['number'];
		$widget_icon		  = $instance['widget_icon'];
		$widget_title_bgcolor = $instance['widget_title_bgcolor'];

// Widget admin form
?>
	<p>
		<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php esc_html_e( 'Widget Title:', 'passport' ); ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
	</p>

	<p>
		<label for="<?php echo $this->get_field_id( 'number' ); ?>"><?php esc_html_e( 'Number of posts to show:', 'passport' ); ?></label>
		<input id="<?php echo $this->get_field_id( 'number' ); ?>" name="<?php echo $this->get_field_name( 'number' ); ?>" type="text" value="<?php echo esc_attr( $number ); ?>" size="3" />
	</p>

	<h4><?php esc_html_e( 'Widget Style', 'passport' ); ?></h4>
	<p>
		<label for="<?php echo $this->get_field_id( 'widget_icon' ); ?>"><?php esc_html_e( 'Icon:', 'passport' ); ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'widget_icon' ); ?>" name="<?php echo $this->get_field_name( 'widget_icon' ); ?>" type="text" value="<?php echo esc_attr( $widget_icon ); ?>" />
		<br />
		<small><?php esc_html_e( 'Please choose your  fontawesome icon. For example: fa fa-home.', 'passport' ); ?></small>
		<small><a href="<?php echo esc_url( 'https://fortawesome.github.io/Font-Awesome/cheatsheet/' ); ?>" target="_blank"><b><?php esc_html_e( 'Find your icon', 'passport' ); ?></b></a></small>
	</p>

	<label for="<?php echo $this->get_field_id( 'widget_title_bgcolor' ); ?>" style="display:block;"><?php esc_html_e( 'Widget Title Background Color:', 'passport' ); ?></label><br />
	<input class="widefat color" id="<?php echo $this->get_field_id( 'widget_title_bgcolor' ); ?>" name="<?php echo $this->get_field_name( 'widget_title_bgcolor' ); ?>" type="text" value="<?php echo esc_attr( $widget_title_bgcolor ); ?>" />
	<div class="colorpicker"></div>

<?php }
	
// Updating widget replacing old instances with new instances
public function update( $new_instance, $old_instance ) {
	
	$instance	= $old_instance;

	//Update new instances
	$instance['title']				  = wp_filter_nohtml_kses( $new_instance['title']);
	$instance['number']				  = (int) $new_instance['number'];
	$instance['widget_icon']		  = wp_filter_nohtml_kses( $new_instance['widget_icon']);
	$instance['widget_title_bgcolor'] = wp_filter_nohtml_kses( $new_instance['widget_title_bgcolor']);

	return $instance;
}

} // Class widget ends here

// Register and load the widget
function passport_most_popular_posts_load_widget() {
	register_widget( 'Passport_Most_Popular_Posts_Widget' );
}
add_action( 'widgets_init', 'passport_most_popular_posts_load_widget' );