<?php
/*
 * Passport Image Widget
 * -------------------------------------------------------------------------
 *
 * @package WordPress
 * @subpackage passport
 * @since Passport 1.0
 *
 */
class Passport_Image_Widget extends WP_Widget {

function __construct() {
	$widget_ops = array( 'classname' => 'widget_image', 'description' => esc_html__( 'Image Widget', 'passport' ) );
	parent::__construct( 'passport_image_widget', esc_html__( 'Passport Image Widget', 'passport' ), $widget_ops );

    $this->alt_option_name = 'widget_image';

	add_action( 'admin_enqueue_scripts', array( $this, 'upload_scripts' ) );
    add_action( 'wp_enqueue_scripts', array( $this, 'passport_widget_inline_style' ) );

}


/**
 * Styling the widget
 */
public function passport_widget_inline_style() { 
    $i = 0;

    $widget_options = get_option( $this->option_name );

    $custom_widget_css = '';
        if( is_array( $widget_options ) && count( $widget_options ) > 0 ) {
			foreach ( $widget_options as $key => $widget_option ) {

                $widget_width_option      = isset( $widget_option['width'] ) ? $widget_option['width'] : '';
                $widget_height_option     = isset( $widget_option['height'] ) ? $widget_option['height'] : '';
                $widget_btn_color_option  = isset( $widget_option['btn_color'] ) ? $widget_option['btn_color'] : '';
                $widget_opacity_option    = isset( $widget_option['opacity'] ) ? $widget_option['opacity'] : '';

                if ( isset( $widget_min_height_option ) || isset( $widget_btn_color_option ) || isset( $widget_opacity_option ) ) {
                    $custom_widget_css .= "#{$this->id_base}-{$key} figcaption {";
                    $custom_widget_css .= ! empty( $widget_height_option ) ? 'min-height:'. $widget_height_option .'px;' : '';
                    $custom_widget_css .= "}";
                    $custom_widget_css .= "#{$this->id_base}-{$key} .img-btn {";
                    $custom_widget_css .= ! empty( $widget_btn_color_option ) ? 'background-color:'. $widget_btn_color_option .';' :'background-color: #333333;';
                    $custom_widget_css .= ! empty( $widget_btn_color_option ) ? 'border-color:'. $widget_btn_color_option .';' :'border-color: #333333;';
                    $custom_widget_css .= "}";
                    $custom_widget_css .= "#{$this->id_base}-{$key} img {";
                    $custom_widget_css .= ! empty( $widget_width_option ) ? 'width:'. $widget_width_option .'px;' : '';
                    $custom_widget_css .= ! empty( $widget_height_option ) ? 'height:'. $widget_height_option .'px;' : '';                               
                    $custom_widget_css .= ! empty( $widget_opacity_option ) ? 'opacity:'. $widget_opacity_option .';' :'opacity: 1.0;';
                    $custom_widget_css .= "}";
    	       }
            $i++;
	    }
    }
    wp_add_inline_style( PASSPORT_THEME_SLUG . '-custom-style', $custom_widget_css );   
}


/**
 * Upload the Javascripts for the media uploader
 */
function upload_scripts( $instance ) {  

	wp_register_script( 
        PASSPORT_THEME_SLUG . '-wp-media-upload', 
        get_template_directory_uri().'/assets/js/wp-media-uploadjs', 
        array( 
            'jquery'
        ),
        PASSPORT_VERSION,
        true
    );
	wp_enqueue_script( PASSPORT_THEME_SLUG . '-wp-media-upload' );	
}

// Creating widget front-end
// This is where the action happens
public function widget( $args, $instance ) {
	global $_wp_additional_image_sizes;
	
	$widget_image = ! empty( $instance['widget_image'] ) ? $instance['widget_image'] : '';
	$link		  = ! empty( $instance['link']) ? $instance['link'] : '';
	$alt		  = ! empty( $instance['alt']) ? $instance['alt'] : '';
	$caption	  = ! empty( $instance['caption']) ? $instance['caption'] : '';
	$text_btn	  = ! empty( $instance['text_btn']) ? $instance['text_btn'] : '';
	$target		  = ! empty( $instance['target']) ? $instance['target'] : '_blank';

?>
	<?php echo $args['before_widget']; ?>
		<?php if( ! empty ( $widget_image ) ) : ?>
			<div class="image-widget clearfix">
				<figure class="bglayer">
					<img src="<?php echo esc_url( $widget_image ); ?>" class="aligncenter attachment-widget-image" alt="<?php echo esc_attr( $alt ); ?>">
				    <figcaption class="img-caption">
                        <?php echo $caption; ?>
                    </figcaption>
                </figure>
			    <?php if ( ! empty ( $text_btn ) ) : ?>
				    <a class="img-btn btn btn-color" href="<?php echo esc_url( $link ); ?>" role="button" target='<?php echo $target; ?>'><?php echo $text_btn; ?></a>
			    <?php endif; ?>
			</div>
		<?php endif; ?>
	<?php echo $args['after_widget']; ?> 
<?php
}
		
// Widget Backend 
public function form( $instance ) {
			
//Set up some default widget settings.
	$instance	  = wp_parse_args( (array) $instance, array( 
		'widget_image'	=> '', 
        'width'         => '',
        'height'        => '',
        'opacity'       => '1.0',
		'link'			=> '', 
		'alt'			=> '', 
		'caption'		=> '',
		'text_btn'		=> '', 
		'target'		=> '_blank', 
		'btn_color'		=> '#333333' 
	) );
	$widget_image = $instance['widget_image'];
    $width        = $instance['width'];
    $height       = $instance['height'];
    $opacity      = $instance['opacity'];
	$link		  = $instance['link'];
	$alt		  = $instance['alt'];
	$caption	  = $instance['caption'];
	$text_btn	  = $instance['text_btn'];
	$target		  = $instance['target'];
	$btn_color	  = $instance['btn_color'];
	
// Widget admin form
?>

	<label for="<?php echo $this->get_field_id( 'widget_image' ); ?>"><?php esc_html_e( 'Widget Image:', 'passport' ); ?></label>
	<div id="<?php echo $this->get_field_id( 'widget_image' ); ?>" class="media-upload-wrapper" > 
	    <p class="hide-if-no-js">
		    <a title="Choose Image" href="javascript:;" class="choose-image button button-small"><?php esc_html_e( 'Choose image', 'passport' ); ?></a>				
	    </p>
	    <div class="media-upload-container hidden">
		    <img src="<?php echo esc_url( $widget_image ); ?>" class="wp-post-image" alt="image-widget"/>
	    </div><!-- #media-upload-container -->
	    <p class="hide-if-no-js hidden">
		    <a title="Remove Image" href="javascript:;" class="remove-image button button-small"><?php esc_html_e( 'Remove image', 'passport' ); ?></a>
	    </p><!-- .hide-if-no-js -->
	    <p class="media-upload-meta">
		    <input type="hidden" class="media" name="<?php echo $this->get_field_name( 'widget_image' ); ?>" value="<?php echo esc_attr( $widget_image ); ?>" />
	    </p><!-- #media-upload-meta -->
	</div>
    
    <p>
		<label for="<?php echo $this->get_field_id( 'width' ); ?>"><?php esc_html_e( 'Width', 'passport' ); ?></label> x
        <label for="<?php echo $this->get_field_id( 'height' ); ?>"><?php esc_html_e( 'Height', 'passport' ); ?></label> (px) :
		<input size="4" id="<?php echo $this->get_field_id( 'width' ); ?>" name="<?php echo $this->get_field_name( 'width' ); ?>" type="text" value="<?php echo esc_attr( $width ); ?>" /> x
  	    <input size="4" id="<?php echo $this->get_field_id( 'height' ); ?>" name="<?php echo $this->get_field_name( 'height' ); ?>" type="text" value="<?php echo esc_attr( $height ); ?>" />
    </p>

    <p>
		<label for="<?php echo $this->get_field_id( 'opacity' ); ?>"><?php esc_html_e( 'Opacity :', 'passport' ); ?></label>
		<input size="6" id="<?php echo $this->get_field_id( 'opacity' ); ?>" name="<?php echo $this->get_field_name( 'opacity' ); ?>" type="text" value="<?php echo esc_attr( $opacity ); ?>" />
    </p>

	<p>
		<label for="<?php echo $this->get_field_id( 'alt' ); ?>"><?php esc_html_e( 'ALT:', 'passport' ); ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'alt' ); ?>" name="<?php echo $this->get_field_name( 'alt' ); ?>" type="text" value="<?php echo esc_attr( $alt ); ?>" />
	</p>

	<p>
		<label for="<?php echo $this->get_field_id( 'caption' ); ?>">Caption:</label>
		<textarea rows="8" class="widefat" id="<?php echo $this->get_field_id( 'caption' ); ?>" name="<?php echo $this->get_field_name( 'caption' ); ?>"><?php echo esc_textarea( $caption ); ?></textarea>
	</p>

	<p>
		<label for="<?php echo $this->get_field_id( 'link' ); ?>"><?php esc_html_e( 'Link:', 'passport' ); ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'link' ); ?>" name="<?php echo $this->get_field_name( 'link' ); ?>" type="text" value="<?php echo esc_attr( $link ); ?>" />
	</p>

	<p>
		<label for="<?php echo $this->get_field_id( 'text_btn' ); ?>"><?php esc_html_e( 'Text in button:', 'passport' ); ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'text_btn' ); ?>" name="<?php echo $this->get_field_name( 'text_btn' ); ?>" type="text" value="<?php echo esc_attr( $text_btn ); ?>" />
	</p>

	<p>
		<label for="<?php echo $this->get_field_id( 'target' ); ?>"><?php esc_html_e( 'Target:', 'passport' ); ?></label>
		<select name="<?php echo $this->get_field_name( 'target' ); ?>" id="<?php echo $this->get_field_id( 'target' ); ?>">
			<option value="_self"<?php selected( $instance['target'], '_self' ); ?>><?php esc_html_e( 'Stay in Window', 'passport' ); ?></option>
			<option value="_blank"<?php selected( $instance['target'], '_blank' ); ?>><?php esc_html_e( 'Open new Window', 'passport' ); ?></option>
		</select>
	</p>

	<h4><?php esc_html_e( 'Widget Style', 'passport' ); ?></h4>
		<label for="<?php echo $this->get_field_id( 'btn_color' ); ?>" style="display:block;"><?php esc_html_e( 'Button Background Color:', 'passport' ); ?></label><br />
		<input class="widefat color" name="<?php echo $this->get_field_name( 'btn_color' ); ?>" type="text" value="<?php echo esc_attr( $btn_color ); ?>" />
	<div class="colorpicker"></div>

<?php 
} 

// Updating widget replacing old instances with new instances
public function update( $new_instance, $old_instance ) {

	$instance		= $old_instance;

	//Define Array
	$get_intermediate_image_sizes = get_intermediate_image_sizes();
		foreach( $get_intermediate_image_sizes as $_size ) {
			$size[] = $_size;
		}
	$target_array	= array( '_blank', '_self' );

	//Update new instances
	$instance['widget_image']	= wp_filter_nohtml_kses( $new_instance['widget_image'] );
	$instance['width']			= ( int ) $new_instance['width'];
	$instance['height']			= ( int ) $new_instance['height'];
	$instance['opacity']    	= wp_filter_nohtml_kses( $new_instance['opacity'] );
	$instance['alt']			= wp_filter_nohtml_kses( $new_instance['alt'] );
	$instance['caption']		= wp_kses_post( $new_instance['caption'] );
	$instance['link']			= wp_filter_nohtml_kses( $new_instance['link'] );
	$instance['text_btn']		= wp_filter_nohtml_kses( $new_instance['text_btn'] );
	if ( in_array( $new_instance['target'], $target_array ) ) {
		$instance['target']		= $new_instance['target'];
	} else {
		$instance['target']		= '_blank';
	}
	$instance['btn_color']		= wp_filter_nohtml_kses( $new_instance['btn_color'] );
	

		return $instance;
	}


} // Class widget ends here

// Register and load the widget
function passport_image_load_widget() {
	register_widget( 'Passport_Image_Widget' );
}
add_action( 'widgets_init', 'passport_image_load_widget' );