<?php
/*
 * Passport Tabs Widget
 * -------------------------------------------------------------------------
 *
 * @package WordPress
 * @subpackage passport
 * @since passport 1.0
 */
class Passport_Contact_Us_Widget extends WP_Widget {

function __construct() {
	$widget_ops = array( 'classname' => 'widget_contact_us clearfix', 'description' => esc_html__( 'Contact Us', 'passport' ) );
	parent::__construct( 'passport_contact_us_widget', esc_html__( 'Passport Contact Us', 'passport' ), $widget_ops );

    $this->alt_option_name = 'widget_contact_us';
    add_action( 'wp_enqueue_scripts', array( $this, 'passport_widget_inline_style' ) );

}


/**
 * Styling the widget
 */
public function passport_widget_inline_style() { 
    $i = 0;

    $widget_options = get_option( $this->option_name );

    $custom_widget_css = '';
        if( is_array( $widget_options ) && count( $widget_options ) > 0 ) {
			foreach ( $widget_options as $key => $widget_option ) {
     
                $widget_title_bgcolor_option = isset( $widget_option['widget_title_bgcolor'] ) ? $widget_option['widget_title_bgcolor'] : '';
 
                if ( isset( $widget_title_bgcolor_option ) ) {
                    $custom_widget_css .= "#{$this->id_base}-{$key} .widget-title {";
                    $custom_widget_css .= ! empty( $widget_title_bgcolor_option ) ? 'background-color:'. $widget_title_bgcolor_option .';' :'background-color: #333333;';
                    $custom_widget_css .= "}";
                    $custom_widget_css .= "#{$this->id_base}-{$key} .widget-title span {";
                    $custom_widget_css .= 'color: #ffffff;';
                    $custom_widget_css .= "}";
    	       }
            $i++;
	    }
    }
    wp_add_inline_style( PASSPORT_THEME_SLUG . '-custom-style', $custom_widget_css );   
}


// Creating widget front-end
// This is where the action happens
public function widget( $args, $instance ) {
	
	global $post;

	$title				= ! empty( $instance['title'] ) ? $instance['title'] : '';
	$company_name		= ! empty( $instance['company_name'] ) ? $instance['company_name'] : '';
  	$address		    = ! empty( $instance['address'] ) ? $instance['address'] : '';
    $phone_number   	= ! empty( $instance['phone_number'] ) ? $instance['phone_number'] : '';
    $company_email		= ! empty( $instance['company_email'] ) ? sanitize_email( $instance['company_email'] ) : '';
    $company_facebook	= ! empty( $instance['company_facebook'] ) ? $instance['company_facebook'] : '';
    $company_twitter	= ! empty( $instance['company_twitter'] ) ? $instance['company_twitter'] : '';
    $company_gplus      = ! empty( $instance['company_gplus'] ) ? $instance['company_gplus'] : '';
    $company_instagram	= ! empty( $instance['company_instagram'] ) ? $instance['company_instagram'] : '';
    $company_linkedin	= ! empty( $instance['company_linkedin'] ) ? $instance['company_linkedin'] : '';
	$google_map			= ! empty( $instance['google_map'] ) ? $instance['google_map'] :'';
	$widget_icon		= ! empty( $instance['widget_icon'] ) ? $instance['widget_icon'] : '';
?> 	
	<?php echo $args['before_widget']; ?>
      <?php if ( ! empty( $title ) ) {  echo '<h4 class="widget-title"><i class="'. $widget_icon .'"></i> <span>'. $title .'</span></h4>'; } ?>
        <div class="about-us">
            <?php if ( ! empty ( $google_map ) ) : ?>
                <div class="google-map"><?php echo $google_map; ?></div>
            <?php endif; ?>
            <?php if( ! empty( $phone_number ) || ! empty( $company_email ) || ! empty( $company_facebook ) || ! empty( $company_twitter ) || ! empty( $company_gplus ) || ! empty( $company_instagram ) || ! empty( $company_linkedin ) ) : ?>
                <ul class="address">
                   <li class="company-header"><h3 class="entry-title"><?php echo $company_name; ?></h3></li>
                   <li class="area"><p><?php echo $address; ?></p></li>
                   <li class="buttons">
                        <?php if( '' != $phone_number ) : ?>
                            <div class="social"><a href="tel:<?php echo $phone_number; ?>" class="phone" aria-label="Phone"><i class="fa fa-phone" aria-hidden="true"></i></a></div>
                        <?php endif; ?>
                        <?php if( '' != $company_email ) : ?>
                            <div class="social"><a href="mailto:'<?php echo antispambot( $company_email ); ?>'" class="envelope" aria-label="Mail"><i class="fa fa-envelope" aria-hidden="true"></i></a></div>
                        <?php endif; ?>
                        <?php if( '' != $company_facebook ) : ?>
                            <div class="social"><a href="<?php echo esc_url( $company_facebook ); ?>'" class="facebook" aria-label="Facebook"><i class="fa fa-facebook" aria-hidden="true"></i></a></div>
                        <?php endif; ?>
                        <?php if( '' != $company_twitter ) : ?>
                            <div class="social"><a href="<?php echo esc_url( $company_twitter ); ?>'" class="twitter" aria-label="Twitter"><i class="fa fa-twitter" aria-hidden="true"></i></a></div>
                        <?php endif; ?>
                        <?php if( '' != $company_gplus ) : ?>
                            <div class="social"><a href="<?php echo esc_url( $company_gplus ); ?>" class="gplus" aria-label="Google Plus"><i class="fa fa-google-plus" aria-hidden="true"></i></a></div>
                        <?php endif; ?>
                        <?php if( '' != $company_instagram ) : ?>
                            <div class="social"><a href="<?php echo esc_url( $company_instagram ); ?>" class="instagram" aria-label="Instagram"><i class="fa fa-instagram" aria-hidden="true"></i></a></div>
                        <?php endif; ?>
                        <?php if( '' != $company_linkedin ) : ?>
                            <div class="social"><a href="<?php echo esc_url( $company_linkedin ); ?>" class="linkedin" aria-label="LinkedIn"><i class="fa fa-linkedin" aria-hidden="true"></i></a></div>
                        <?php endif; ?>
                    </li>
                </ul>
            <?php endif; ?>
        </div>
	<?php wp_reset_postdata(); // Reset Post Data ?>
	<?php echo $args['after_widget']; ?>
<?php }
		

// Widget Backend 
public function form( $instance ) {
	
//Set up some default widget settings.
	$instance			= wp_parse_args( (array) $instance, array( 
		'title'				   => '', 
        'company_name'         => '',
        'address'              => '',
        'phone_number'         => '',
        'company_email'        => '',
        'company_facebook'     => '',
        'company_twitter'      => '',
        'company_gplus'        => '',
        'company_instagram'    => '',
        'company_linkedin'     => '',
		'google_map'		   => '', 
        'widget_icon'          => '',
		'widget_title_bgcolor' => '#333333'
	) );
    $title                = $instance['title'];
	$company_name		  = $instance['company_name'];
    $address    	      = $instance['address'];
    $phone_number		  = $instance['phone_number'];
    $company_email		  = $instance['company_email'];
    $company_facebook	  = $instance['company_facebook'];
    $company_twitter	  = $instance['company_twitter'];
    $company_gplus		  = $instance['company_gplus'];
    $company_instagram	  = $instance['company_instagram'];
    $company_linkedin	  = $instance['company_linkedin'];
	$google_map			  = $instance['google_map'];
	$widget_icon		  = $instance['widget_icon'];
	$widget_title_bgcolor = $instance['widget_title_bgcolor'];

// Widget admin form
?>
	<p>
		<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php esc_html_e( 'Widget Title:', 'passport' ); ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
	</p>

    <p>
		<label for="<?php echo $this->get_field_id( 'company_name' ); ?>"><?php esc_html_e( 'Company Name:', 'passport' ); ?></label> 
        <input type="text" value="<?php echo esc_attr( $company_name ); ?>" name="<?php echo $this->get_field_name( 'company_name' ); ?>" id="<?php echo $this->get_field_id( 'company_name' ); ?>" size="35"/>
	</p>

    <p>
		<label for="<?php echo $this->get_field_id( 'address' ); ?>"><?php esc_html_e( 'Address:', 'passport' ); ?></label>
		<textarea id="<?php echo $this->get_field_id( 'address' ); ?>" name="<?php echo $this->get_field_name( 'address' ); ?>" rows="5" cols="35"><?php echo esc_textarea( $address ); ?></textarea>
	</p>

    <p>
		<label for="<?php echo $this->get_field_id( 'phone_number' ); ?>"><?php esc_html_e( 'Phone:', 'passport' ); ?></label> 
        <input type="text" value="<?php echo esc_attr( $phone_number ); ?>" name="<?php echo $this->get_field_name( 'phone_number' ); ?>" id="<?php echo $this->get_field_id( 'phone_number' ); ?>" size="35"/>
	</p>

    <p>
		<label for="<?php echo $this->get_field_id( 'company_email' ); ?>"><?php esc_html_e( 'Email:', 'passport' ); ?></label> 
        <input type="text" value="<?php echo esc_attr( $company_email ); ?>" name="<?php echo $this->get_field_name( 'company_email' ); ?>" id="<?php echo $this->get_field_id( 'company_email' ); ?>" size="35"/>
	</p>

    <p>
		<label for="<?php echo $this->get_field_id( 'company_facebook' ); ?>"><?php esc_html_e( 'Facebook:', 'passport' ); ?></label> 
        <input type="text" value="<?php echo esc_attr( $company_facebook ); ?>" name="<?php echo $this->get_field_name( 'company_facebook' ); ?>" id="<?php echo $this->get_field_id( 'company_facebook' ); ?>" size="35"/>
	</p>

    <p>
		<label for="<?php echo $this->get_field_id( 'company_twitter' ); ?>"><?php esc_html_e( 'Twitter:', 'passport' ); ?></label> 
        <input type="text" value="<?php echo esc_attr( $company_twitter ); ?>" name="<?php echo $this->get_field_name( 'company_twitter' ); ?>" id="<?php echo $this->get_field_id( 'company_twitter' ); ?>" size="35"/>
	</p>

    <p>
		<label for="<?php echo $this->get_field_id( 'company_gplus' ); ?>"><?php esc_html_e( 'Google Plus:', 'passport' ); ?></label> 
        <input type="text" value="<?php echo esc_attr( $company_gplus ); ?>" name="<?php echo $this->get_field_name( 'company_gplus' ); ?>" id="<?php echo $this->get_field_id( 'company_gplus' ); ?>" size="35"/>
	</p>

    <p>
		<label for="<?php echo $this->get_field_id( 'company_instagram' ); ?>"><?php esc_html_e( 'Instagram:', 'passport' ); ?></label> 
        <input type="text" value="<?php echo esc_attr( $company_instagram ); ?>" name="<?php echo $this->get_field_name( 'company_instagram' ); ?>" id="<?php echo $this->get_field_id( 'company_instagram' ); ?>" size="35"/>
	</p>

    <p>
		<label for="<?php echo $this->get_field_id( 'company_linkedin' ); ?>"><?php esc_html_e( 'LinkedIn:', 'passport' ); ?></label> 
        <input type="text" value="<?php echo esc_attr( $company_linkedin ); ?>" name="<?php echo $this->get_field_name( 'company_linkedin' ); ?>" id="<?php echo $this->get_field_id( 'company_linkedin' ); ?>" size="35"/>
	</p>

	<p>
		<label for="<?php echo $this->get_field_id( 'google_map' ); ?>"><?php esc_html_e( 'Google Map Embed Code:', 'passport' ); ?></label>
		<textarea id="<?php echo $this->get_field_id( 'google_map' ); ?>" name="<?php echo $this->get_field_name( 'google_map' ); ?>" rows="5" cols="35"><?php echo esc_textarea( $google_map ); ?></textarea>
	</p>

	<h4><?php esc_html_e( 'Widget Style', 'passport' ); ?></h4>
	<p>
		<label for="<?php echo $this->get_field_id( 'widget_icon' ); ?>"><?php esc_html_e( 'Icon:', 'passport' ); ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'widget_icon' ); ?>" name="<?php echo $this->get_field_name( 'widget_icon' ); ?>" type="text" value="<?php echo esc_attr( $widget_icon ); ?>" />
		<br />
		<small><?php esc_html_e( 'Please choose your  fontawesome icon. For example: fa fa-home.', 'passport' ); ?></small>
		<small><a href="<?php echo esc_url( 'http://fontawesome.bootstrapcheatsheets.com/' ); ?>" target="_blank"><b><?php esc_html_e( 'Find your icon', 'passport' ); ?></b></a></small>
	</p>

	<label for="<?php echo $this->get_field_id( 'widget_title_bgcolor' ); ?>" style="display:block;"><?php esc_html_e( 'Widget Title Background Color:', 'passport' ); ?></label><br />
	<input class="widefat color" id="<?php echo $this->get_field_id( 'widget_title_bgcolor' ); ?>" name="<?php echo $this->get_field_name( 'widget_title_bgcolor' ); ?>" type="text" value="<?php echo esc_attr( $widget_title_bgcolor ); ?>" />
	<div class="colorpicker"></div>

<?php }
	
// Updating widget replacing old instances with new instances
public function update( $new_instance, $old_instance ) {
	$instance = $old_instance;

	//Update new instances
	$instance['title']				  = wp_filter_nohtml_kses( $new_instance['title'] );
	$instance['company_name']         = wp_filter_nohtml_kses( $new_instance['company_name'] );	
	$instance['address']              = wp_filter_nohtml_kses( $new_instance['address'] );
	$instance['phone_number']         = wp_filter_nohtml_kses( $new_instance['phone_number'] );
	$instance['company_email']        = is_email( $new_instance['company_email'] );	
	$instance['company_facebook']     = wp_filter_nohtml_kses( $new_instance['company_facebook'] );	
	$instance['company_twitter']      = wp_filter_nohtml_kses( $new_instance['company_twitter'] );	
	$instance['company_gplus']        = wp_filter_nohtml_kses( $new_instance['company_gplus'] );	
	$instance['company_instagram']    = wp_filter_nohtml_kses( $new_instance['company_instagram'] );	
	$instance['company_linkedin']     = wp_filter_nohtml_kses( $new_instance['company_linkedin'] );	
	$instance['google_map']			  = isset( $new_instance['google_map'] ) ? $new_instance['google_map'] : '';
	$instance['widget_icon']		  = wp_filter_nohtml_kses( $new_instance['widget_icon'] );
	$instance['widget_title_bgcolor'] = wp_filter_nohtml_kses( $new_instance['widget_title_bgcolor'] );

	return $instance;
	}
		
} // Class widget ends here

// Register and load the widget
function passport_contact_us_load_widget() {
	register_widget( 'Passport_Contact_Us_widget' );
}
add_action( 'widgets_init', 'passport_contact_us_load_widget' );