<?php
/*
 * Passport Column Widget
 * -------------------------------------------------------------------------
 *
 * @package WordPress
 * @subpackage passport
 * @since passport 1.0
 */
class Passport_Column_Widget extends WP_Widget {

function __construct() {
	$widget_ops = array( 'classname' => 'widget_column clearfix', 'description' => esc_html__( 'Choose your content and put it in each column', 'passport' ) );
	parent::__construct( 'passport_column_widget', esc_html__( 'Passport Column', 'passport' ), $widget_ops );

    $this->alt_option_name = 'widget_column';
    add_action( 'wp_enqueue_scripts', array( $this, 'passport_widget_inline_style' ) );

}


/**
 * Styling the widget
 */
public function passport_widget_inline_style() { 
    $i = 0;

    $widget_options = get_option( $this->option_name );

    $custom_widget_css = '';
        if( is_array( $widget_options ) && count( $widget_options ) > 0 ) {
			foreach ( $widget_options as $key => $widget_option ) {

                $widget_bgcolor_option = isset( $widget_option['widget_bgcolor'] ) ? $widget_option['widget_bgcolor'] : '';

                if ( isset( $widget_bgcolor_option ) ) {
                    $custom_widget_css .= "#{$this->id_base}-{$key} .card {";
                    $custom_widget_css .= ! empty( $widget_bgcolor_option ) ? 'background-color:'. $widget_bgcolor_option .';' :'background-color: #f1f1f1;';
                    $custom_widget_css .= "}";
                }
            $i++;
	    }
    }
    wp_add_inline_style( PASSPORT_THEME_SLUG . '-custom-style', $custom_widget_css );   
}


// Creating widget front-end
// This is where the action happens
public function widget( $args, $instance ) {
	
	global $post;
	
	$first_column		= ! empty( $instance['first_column'] ) ? $instance['first_column'] : esc_html__( 'News Update', 'passport' );
	$second_column		= ! empty( $instance['second_column'] ) ? $instance['second_column'] : esc_html__( 'Progress Bar', 'passport' );
	$third_column		= ! empty( $instance['third_column'] ) ? $instance['third_column'] : esc_html__( 'Event Schdule', 'passport' );
?>
	<?php echo $args['before_widget']; ?>
    <div class="container">
        <div class="column layout">
	        <div class="col-xxs col-xs-12 col-sm-6 col-md-4 col-lg-4">
                <div class="row">
                    <div class="widget-column">
                        <div class="card animateblock btm">
				        <?php 	
					        if( esc_html__( 'News Update', 'passport' ) == $first_column ) { 
						        echo passport_news_update(); 
					        } elseif( esc_html__( 'Progress Bar', 'passport' ) == $first_column ) { 
						        echo passport_progressbar(); 
					        } elseif( esc_html__( 'Event Schedule', 'passport' ) == $first_column ) { 
						        echo passport_program_schedule(); 
					        } 
				         ?>
			            </div>  
                    </div>
                </div>
		    </div> 
		    <div class="col-xxs col-xs-12 col-sm-6 col-md-4 col-lg-4">
                <div class="row">
                    <div class="widget-column">
			            <div class="card animateblock btm">
				        <?php 
					        if( esc_html__( 'News Update', 'passport' ) == $second_column ) { 
						        echo passport_news_update(); 
					        } elseif( esc_html__( 'Progress Bar', 'passport' ) == $second_column ) { 
						        echo passport_progressbar(); 
					        } elseif( esc_html__( 'Event Schedule', 'passport' ) == $second_column ) { 
						        echo passport_program_schedule(); 
					        } 
				         ?>
			            </div>
                    </div>
		        </div>
            </div>
		    <div class="col-xxs col-xs-12 col-sm-6 col-md-4 col-lg-4">
                <div class="row">
                    <div class="widget-column">
			            <div class="card animateblock btm">
				        <?php 
					        if( esc_html__( 'News Update', 'passport' ) == $third_column ) { 
						        echo passport_news_update(); 
					        } elseif( esc_html__( 'Progress Bar', 'passport' ) == $third_column ) { 
						        echo passport_progressbar(); 
					        } elseif( esc_html__( 'Event Schedule', 'passport' ) == $third_column ) { 
						        echo passport_program_schedule(); 
					        } 
				         ?>
			            </div>
                    </div>
                </div>
		    </div>
        </div>
    </div>
	<?php wp_reset_postdata(); // Reset Post Data ?>
	<?php echo $args['after_widget']; ?>
<?php }


// Widget Backend 
public function form( $instance ) {

//Set up some default widget settings.
	$instance			= wp_parse_args( (array) $instance, array( 
		'first_column'		=> esc_html__( 'News Update', 'passport' ),
		'second_column'		=> esc_html__( 'Progress Bar', 'passport' ),
		'third_column'		=> esc_html__( 'Event Schedule', 'passport' ), 
		'widget_bgcolor'	=> '#f1f1f1' 
	) );
	$first_column		= $instance['first_column'];
	$second_column		= $instance['second_column'];
	$third_column		= $instance['third_column'];
	$widget_bgcolor		= $instance['widget_bgcolor'];

// Widget admin form
?>
	<p>
		<label for="<?php echo $this->get_field_id( 'first_column' ); ?>"><?php esc_html_e( 'Column Name:', 'passport' ); ?></label>
		<select name="<?php echo $this->get_field_name( 'first_column' ); ?>" id="<?php echo $this->get_field_id( 'first_column' ); ?>">
			<?php $column_names = array( esc_html__( 'News Update', 'passport' ), esc_html__( 'Progress Bar', 'passport' ), esc_html__( 'Event Schedule', 'passport' ) ); ?>
			<?php foreach( $column_names as $column_name ) : ?>
				<option value="<?php echo $column_name; ?>"<?php selected( $instance['first_column'], $column_name ); ?>><?php echo $column_name; ?></option>
			<?php endforeach; ?>
		</select>
	</p>

	<p>
		<label for="<?php echo $this->get_field_id( 'second_column' ); ?>"><?php esc_html_e( 'Column Name:', 'passport' ); ?></label>
		<select name="<?php echo $this->get_field_name( 'second_column' ); ?>" id="<?php echo $this->get_field_id( 'second_column' ); ?>">
			<?php $column_names = array( esc_html__( 'News Update', 'passport' ), esc_html__( 'Progress Bar', 'passport' ), esc_html__( 'Event Schedule', 'passport' ) ); ?>
			<?php foreach( $column_names as $column_name ) : ?>
				<option value="<?php echo $column_name; ?>"<?php selected( $instance['second_column'], $column_name ); ?>><?php echo $column_name; ?></option>
			<?php endforeach; ?>
		</select>
	</p>

	<p>
		<label for="<?php echo $this->get_field_id( 'third_column' ); ?>"><?php esc_html_e( 'Column Name:', 'passport' ); ?></label>
		<select name="<?php echo $this->get_field_name( 'third_column' ); ?>" id="<?php echo $this->get_field_id( 'third_column' ); ?>">
			<?php $column_names = array( esc_html__( 'News Update', 'passport' ), esc_html__( 'Progress Bar', 'passport' ), esc_html__( 'Event Schedule', 'passport' ) ); ?>
			<?php foreach( $column_names as $column_name ) : ?>
				<option value="<?php echo $column_name; ?>"<?php selected( $instance['third_column'], $column_name ); ?>><?php echo $column_name; ?></option>
			<?php endforeach; ?>
		</select>
	</p>

	<h4><?php esc_html_e( 'Widget Style', 'passport' ); ?></h4>
	<label for="<?php echo $this->get_field_id( 'widget_bgcolor' ); ?>" style="display:block;"><?php esc_html_e( 'Widget Background Color:', 'passport' ); ?></label><br />
	<input class="widefat color" id="<?php echo $this->get_field_id( 'widget_bgcolor' ); ?>" name="<?php echo $this->get_field_name( 'widget_bgcolor' ); ?>" type="text" value="<?php echo esc_attr( $widget_bgcolor ); ?>" />
	<div class="colorpicker"></div>

<?php }
	
// Updating widget replacing old instances with new instances
public function update( $new_instance, $old_instance ) {
	$instance = $old_instance;

	//Define Array
	$column_names	  = array( esc_html__( 'News Update', 'passport' ), esc_html__( 'Progress Bar', 'passport' ), esc_html__( 'Event Schedule', 'passport' ) );

	//Update new instances
	if ( in_array( $new_instance['first_column'], $column_names ) ) {
		$instance['first_column']	= $new_instance['first_column'];
	} else {
		$instance['first_column']	= esc_html__( 'News Update', 'passport' );
	}
	if ( in_array( $new_instance['second_column'], $column_names ) ) {
		$instance['second_column']	= $new_instance['second_column'];
	} else {
		$instance['second_column']	= esc_html__( 'Progress Bar', 'passport' );
	}
	if ( in_array( $new_instance['third_column'], $column_names ) ) {
		$instance['third_column']	= $new_instance['third_column'];
	} else {
		$instance['third_column']	=  esc_html__( 'Event Schedule', 'passport' );
	}
	$instance['widget_bgcolor']		= wp_filter_nohtml_kses( $new_instance['widget_bgcolor'] );

	return $instance;
	}
		
} // Class widget ends here

// Register and load the widget
function passport_column_load_widget() {
	register_widget( 'Passport_Column_Widget' );
}
add_action( 'widgets_init', 'passport_column_load_widget' );