<?php
/*
 * Passport Accordion Widget
 * -------------------------------------------------------------------------
 *
 * @package WordPress
 * @subpackage passport
 * @since passport 1.0
 */
class Passport_Accordion_Widget extends WP_Widget {

function __construct() {
    
	$widget_ops = array( 'classname' => 'widget_accordion clearfix', 'description' => esc_html__( 'Use Bootstrap Accordion', 'passport' ) );
	parent::__construct( 'passport_accordion_widget', esc_html__( 'Passport Accordion', 'passport' ), $widget_ops );

    $this->alt_option_name = 'widget_accordion';
    add_action( 'wp_enqueue_scripts', array( $this, 'passport_widget_inline_style' ) );

}


/**
 * Styling the widget
 */
public function passport_widget_inline_style() { 
    $i = 0;

    $widget_options = get_option( $this->option_name );

    $custom_widget_css = '';
        if( is_array( $widget_options ) && count( $widget_options ) > 0 ) {
			foreach ( $widget_options as $key => $widget_option ) {
     
                 $widget_title_bgcolor_option = isset( $widget_option['widget_title_bgcolor'] ) ? $widget_option['widget_title_bgcolor'] : '';
 
                if ( isset( $widget_title_bgcolor_option ) ) {
                    $custom_widget_css .= "#{$this->id_base}-{$key} .panel-heading {";
                    $custom_widget_css .= ! empty( $widget_title_bgcolor_option ) ? 'background-color:'. $widget_title_bgcolor_option .';' :'background-color: #333333;';
                    $custom_widget_css .= "}";
                    $custom_widget_css .= "#{$this->id_base}-{$key} .panel-title > a {";
                    $custom_widget_css .= 'color: #ffffff;';
                    $custom_widget_css .= "}";
    	       }
            $i++;
	    }
    }
    wp_add_inline_style( PASSPORT_THEME_SLUG . '-custom-style', $custom_widget_css );   
}


// Creating widget front-end
// This is where the action happens
public function widget( $args, $instance ) {
	
	global $post;

	$category_name		= ! empty( $instance['category_name'] ) ? $instance['category_name'] : 'uncategories';
	$number				= ! empty( $instance['number'] ) ? absint( $instance['number'] ) : 5;
	$exclude			= ! empty( $instance['exclude'] ) ? $instance['exclude'] : '';
	$excludeArry		= explode( ',', $exclude );
	$orderby			= ! empty( $instance['orderby'] ) ?  $instance['orderby'] : 'date';
	$order				= ! empty( $instance['order'] ) ? $instance['order'] : 'desc';
	$frontpage_id		= get_option( 'page_on_front' );
	$attachment_id		= get_post_thumbnail_id( $frontpage_id );

	$widget_args			= array(
		'post_type'			=> 'post',
		'category_name'		=> $category_name,
		'posts_per_page'	=> $number,
		'order'				=> $order,
		'orderby'			=> $orderby,
		'post__not_in'		=> $excludeArry
	);
				
	$wp_query	= new WP_Query( $widget_args );

?>
	<?php echo $args['before_widget']; ?>   
		<div class="panel-group" role="tablist" aria-multiselectable="true">                                 
			<?php if ( $wp_query->have_posts() ) : ?>
				<?php while ( $wp_query->have_posts() ) : $wp_query->the_post(); 
 					$archive_year		= get_the_time( 'Y' ); 
					$archive_month		= get_the_time( 'm' ); 
					$archive_day		= get_the_time( 'd' );
 				?>
				<div class="panel panel-default">
					<div class="panel-heading" role="tab" id="<?php echo 'heading-'.$post->ID.''; ?>">
						<h5 class="panel-title">
							<a role="button" data-toggle="collapse" data-parent="#accordion" href="#<?php echo 'collapse-'. $post->ID .''; ?>" aria-expanded="<?php if ( $wp_query->current_post == 0 ) { echo 'true'; } else { echo 'false'; } ?>" aria-controls="<?php echo 'collapse-'. $post->ID .''; ?>">
								<?php the_title(); ?>
							</a>
						</h5>
					</div><!-- .panel-heading -->
					<div id="<?php echo 'collapse-'. $post->ID .''; ?>" class="panel-collapse collapse <?php if ( $wp_query->current_post == 0 ) { echo 'in'; } ?>" role="tabpanel" aria-labelledby="<?php echo 'heading-'. $post->ID .''; ?>">
						<div class="panel-body">
                            <figure>
							    <?php the_post_thumbnail( 'large-image' ); ?>
                            </figure>
							<hr>
							<a href="<?php echo esc_url( get_day_link( $archive_year, $archive_month, $archive_day ) ); ?>">
                                <span class="post-info clearfix"><?php echo get_the_date( 'M j, Y' ); ?></span>
                            </a>
							<p><?php echo passport_excerpt( '20' ); ?></p>
						</div><!-- .panel-body -->
					</div>
				</div>            
				<?php endwhile; ?>
			<?php endif;?>
		</div><!-- #accordion -->
	<?php wp_reset_postdata(); // Reset Post Data ?>
	<?php echo $args['after_widget']; ?>
<?php }


// Widget Backend 
public function form( $instance ) {
	
//Set up some default widget settings.
	$instance			= wp_parse_args( (array) $instance, array( 
		'category_name'		   => 'uncategories', 
		'number'			   => '5', 
		'orderby'			   => 'date', 
		'order'				   => 'desc', 
		'exclude'			   => '', 
		'widget_title_bgcolor' => '#333333' 
	) );
	$category_name		  = $instance['category_name'];
	$number				  = $instance['number'];
	$orderby			  = $instance['orderby'];
	$order				  = $instance['order'];
	$exclude			  = $instance['exclude'];
	$widget_title_bgcolor = $instance['widget_title_bgcolor'];

// Widget admin form
?>
	<p>
		<label for="<?php echo $this->get_field_id( 'category_name' ); ?>"><?php esc_html_e( 'Category Name (Slug):', 'passport' ); ?></label>
		<small><a class="alignright" href="/wp-admin/edit-tags.php?taxonomy=category"><b><?php esc_html_e( 'Add new category', 'passport' ); ?></b></a></small>
		<select name="<?php echo $this->get_field_name( 'category_name' ); ?>" id="<?php echo $this->get_field_id( 'category_name' ); ?>">
			<?php $categories = get_categories(); ?>
			<?php foreach( $categories as $category ) : $cat_name = $category->slug; ?>
				<option value="<?php echo $cat_name; ?>"<?php selected( $instance['category_name'], $cat_name ); ?>><?php echo $cat_name; ?></option>
			<?php endforeach; ?>
		</select>
		<br />
		<small><?php esc_html_e( 'This selection will display your new category when it has at least one post in that category.', 'passport' ); ?></small>
	</p>

	<p>
		<label for="<?php echo $this->get_field_id( 'number' ); ?>"><?php esc_html_e( 'Number of posts to show:', 'passport' ); ?></label>
		<input id="<?php echo $this->get_field_id( 'number' ); ?>" name="<?php echo $this->get_field_name( 'number' ); ?>" type="text" value="<?php echo esc_attr( $number ); ?>" size="3" />
	</p>


	<p>
		<label for="<?php echo $this->get_field_id( 'exclude' ); ?>"><?php esc_html_e( 'Exclude:', 'passport' ); ?></label> 
        <input type="text" value="<?php echo esc_attr( $exclude ); ?>" name="<?php echo $this->get_field_name( 'exclude' ); ?>" id="<?php echo $this->get_field_id( 'exclude' ); ?>" size="35"/>
		<br />
		<small><?php esc_html_e( 'Post IDs, separated by commas.', 'passport' ); ?></small>
	</p>

	<p>
		<label for="<?php echo $this->get_field_id( 'orderby' ); ?>"><?php esc_html_e( 'Order by:', 'passport' ); ?></label>
		<select name="<?php echo $this->get_field_name( 'orderby' ); ?>" id="<?php echo $this->get_field_id( 'orderby', 'passport' ); ?>">
			<option value="none"<?php selected( $instance['orderby'], 'none' ); ?>><?php esc_html_e( 'None', 'passport' ); ?></option>
            <option value="date"<?php selected( $instance['orderby'], 'date' ); ?>><?php esc_html_e( 'Date', 'passport' ); ?></option>
            <option value="author"<?php selected( $instance['orderby'], 'author' ); ?>><?php esc_html_e( 'Author', 'passport' ); ?></option>
            <option value="title"<?php selected( $instance['orderby'], 'title' ); ?>><?php esc_html_e( 'Title', 'passport' ); ?></option>
            <option value="name"<?php selected( $instance['orderby'], 'name' ); ?>><?php esc_html_e( 'Name', 'passport' ); ?></option>
            <option value="type"<?php selected( $instance['orderby'], 'type' ); ?>><?php esc_html_e( 'Type', 'passport' ); ?></option>
            <option value="modified"<?php selected( $instance['orderby'], 'modified' ); ?>><?php esc_html_e( 'Modified', 'passport' ); ?></option>
            <option value="rand"<?php selected( $instance['orderby'], 'rand' ); ?>><?php esc_html_e( 'Rand', 'passport' ); ?></option>
		</select>
	</p>

	<p>
		<label for="<?php echo $this->get_field_id( 'order' ); ?>"><?php esc_html_e( 'Order:', 'passport' ); ?></label>
		<select name="<?php echo $this->get_field_name( 'order' ); ?>" id="<?php echo $this->get_field_id( 'order' ); ?>">
			<option value="desc"<?php selected( $instance['order'], 'desc' ); ?>><?php esc_html_e( 'DESC', 'passport' ); ?></option>
			<option value="asc"<?php selected( $instance['order'], 'asc' ); ?>><?php esc_html_e( 'ASC', 'passport' ); ?></option>
		</select>
	</p>

	<h4><?php esc_html_e( 'Widget Style', 'passport' ); ?></h4>
	<label for="<?php echo $this->get_field_id( 'widget_title_bgcolor' ); ?>" style="display:block;"><?php esc_html_e( 'Widget Title Background Color:', 'passport' ); ?></label><br />
	<input class="widefat color" id="<?php echo $this->get_field_id( 'widget_title_bgcolor' ); ?>" name="<?php echo $this->get_field_name( 'widget_title_bgcolor' ); ?>" type="text" value="<?php echo esc_attr( $widget_title_bgcolor ); ?>" />
	<div class="colorpicker"></div>

<?php }

// Updating widget replacing old instances with new instances
public function update( $new_instance, $old_instance ) {
	$instance = $old_instance;

	//Define Array
	$categories			  = get_categories();
	foreach( $categories as $category ) {
		$catsArray[]	= '' . $category->slug . '';
	}
	$orderbyArry		  = array( 'none', 'date', 'author', 'title', 'name', 'parent', 'type', 'modified', 'rand' );
	$orderArry			  = array( ' desc' , 'asc' );

	//Update new instances
	if ( in_array( $new_instance['category_name'], $catsArray ) ) {
		$instance['category_name']	  = $new_instance['category_name'];
	} else {
		$instance['category_name']	  = 'uncategories';
	}
	$instance['number']				  = (int) $new_instance['number'];
	if ( in_array( $new_instance['orderby'], $orderbyArry ) ) {
		$instance['orderby']		  = $new_instance['orderby'];
	} else {
		$instance['orderby']		  = 'date';
	}
	if ( in_array( $new_instance['order'], $orderArry ) ) {
		$instance['order']			  = $new_instance['order'];
	} else {
		$instance['order']			  = 'desc';
	}
	$instance['exclude']			  = wp_filter_nohtml_kses( $new_instance['exclude'] );	
	$instance['widget_title_bgcolor'] = wp_filter_nohtml_kses( $new_instance['widget_title_bgcolor'] );

	return $instance;
	}
} // Class widget ends here


// Register and load the widget
function passport_accordion_load_widget() {
	register_widget( 'Passport_Accordion_Widget' );
}
add_action( 'widgets_init', 'passport_accordion_load_widget' );