<?php
/**
 * Register Menu
 * -------------------------------------------------------------------------
 * Register four menus, which are, Primary menu, Secondary menu, Extra menu
 * and, the footer menu.
 *
 * @package WordPress
 * @subpackage passport
 * @since Passport 1.0
 *
 **/
if( ! function_exists( 'passport_register_menus' ) ) {

    function passport_register_menus() { 
	    /* Register Menu */
	    register_nav_menus(
		    array(
		    PASSPORT_THEME_SLUG . '-primary-menu'	=>  esc_html__( 'Primary Menu', 'passport' ),
		    PASSPORT_THEME_SLUG . '-secondary-menu'	=>  esc_html__( 'Secondary Menu', 'passport' ),
		    PASSPORT_THEME_SLUG . '-extra-menu'		=>  esc_html__( 'Extra Menu', 'passport' ),
		    PASSPORT_THEME_SLUG . '-footer-menu'	=>  esc_html__( 'Footer Menu', 'passport' )
		    )
	    );
    }

}
add_action( 'init', 'passport_register_menus' );


/*Primary menu*/
if ( ! function_exists ( 'passport_primary_menu' ) ) {

    function passport_primary_menu() {
	    wp_nav_menu( array(
		    'menu'				=> '',
		    'theme_location'	=> PASSPORT_THEME_SLUG . '-primary-menu',
		    'depth'				=> 2,
		    'container_id'		=> 'primary-menu-container',
		    'container_class'	=> 'primary-navbar collapse navbar-collapse navHeaderCollapse',
		    'menu_id'			=> 'primary-menu',
		    'menu_class'		=> 'primary-menu nav navbar-nav navbar-right',
		    'fallback_cb'		=> 'passport_bootstrap_navwalker::fallback',
		    'item-wrap'			=> '<ul id="%1$" class="%2$">%3$</ul>',
		    'walker'			=> new passport_Bootstrap_Navwalker()
		    )
	    );
    }
}


/*Secondary menu*/
if ( ! function_exists ( 'passport_secondary_menu' ) ) {

    function passport_secondary_menu() {
	    wp_nav_menu( array(
		    'menu'				=> '',
		    'theme_location'	=> PASSPORT_THEME_SLUG . '-secondary-menu',
		    'depth'				=> 1,
		    'container_id'		=> 'secondary-menu-container',
            'container_class'   => 'menu-secondary-menu-container',
		    'menu_id'			=> 'secondary-menu',
		    'menu_class'		=> 'secondary-menu nav navbar-nav navbar-left',
            'fallback_cb'		=> 'passport_bootstrap_navwalker::fallback',
		    ) 
	    );
    }
}


/*Extra menu or Floating menu*/
if ( ! function_exists ( 'passport_extra_menu' ) ) {

    function passport_extra_menu() {
	    wp_nav_menu( array(
		    'menu'				=> '',
		    'theme_location'	=> PASSPORT_THEME_SLUG . '-extra-menu',
		    'depth'				=> 1,
		    'container_id'		=> 'extra-menu-container',
            'container_class'   => 'menu-extra-menu-container',
		    'menu_id'			=> 'extra-menu',
		    'menu_class'		=> 'extra-menu nav navbar-nav navbar-right',
		    'fallback_cb'		=> 'passport_bootstrap_navwalker::fallback',
		    ) 
	    );
    }
}


/*Footer menu*/
if ( ! function_exists ( 'passport_footer_menu' ) ) {

    function passport_footer_menu() {
	    wp_nav_menu( array(
		    'menu'				=> '',
		    'theme_location'	=> PASSPORT_THEME_SLUG . '-footer-menu',
		    'depth'				=> 1,
		    'container_id'		=> 'footer-menu-container',
            'container_class'   => 'menu-footer-menu-container',
		    'menu_id'			=> 'footer-menu',
		    'menu_class'		=> 'footer-menu nav navbar-nav navbar-left',
		    'fallback_cb'		=> 'passport_bootstrap_navwalker::fallback',
		    ) 
	    );
    }
}

/**
 * Secondary menu bar function
 * -------------------------------------------------------------------------
 * To design the secondary menu bar in front-end.
 * 
 * @since Passport 1.0
 *
 **/
if ( ! function_exists ( 'passport_secondary_bar' ) ) {

    function passport_secondary_bar() { 
    ?>
        <nav id="secondary-menu-bar" class="navbar navbar-inverse navbar-static-top">
	        <?php echo passport_secondary_menu() ?>
		    <div class="search-for navbar-right clearfix">
		        <div class="hd-search">
				    <?php get_search_form(); ?>
			    </div>
		    </div>
	    </nav>
    <?php 
    }
}