<?php
/**
 *  Theme Customizer function
 * -------------------------------------------------------------------------
 * Customize Apperance Options
 *
 * @package WordPress
 * @subpackage passport
 * @since Passport 1.0
 *
 **/
if ( ! function_exists ( 'passport_customize_register' ) ) {

    function passport_customize_register( $wp_customize ) {
            
        //Color
	    $wp_customize->add_panel( 'passport_theme_colors_panel', array(
		    'priority'			=> 41,
		    'title'				=> esc_html__( 'Theme Colors Options', 'passport' ),
		    'capability'		=> 'edit_theme_options',
		    'description'		=> esc_html__( 'Change the color as you want.', 'passport' )
	    ) );

	    $wp_customize->add_section( 'passport_theme_colors', array(
		    'title'				=> esc_html__( 'Theme Colors', 'passport' ),
		    'priority'			=> 1,
		    'panel'				=> 'passport_theme_colors_panel',
	    ) );


	    //Theme Color
	    //Primary Color
	    $wp_customize->add_setting( 'passport_primary_color', array(
		    'default'			=> '#ffffff',
		    'sanitize_callback' => 'sanitize_hex_color',
		    'transport'			=> 'refresh',
	    ) );

	    $wp_customize->add_control( new WP_Customize_color_control( $wp_customize, 'passport_primary_color_control', array(
		    'label'				=> esc_html__( 'Primary Color', 'passport' ),
		    'section'			=> 'passport_theme_colors',
		    'settings'			=> 'passport_primary_color',
	    ) ) );

	    $wp_customize->add_setting( 'passport_primary_font_color', array(
		    'default'			=> '#1e6864',
		    'sanitize_callback' => 'sanitize_hex_color',
		    'transport'			=> 'refresh',
	    ) );

	    $wp_customize->add_control( new WP_Customize_color_control( $wp_customize, 'passport_primary_font_color_control', array(
		    'label'				=> esc_html__( 'Primary Font Color', 'passport' ),
		    'section'			=> 'passport_theme_colors',
		    'settings'			=> 'passport_primary_font_color',
	    ) ) );


	    //Secondary Color
	    $wp_customize->add_setting( 'passport_secondary_color', array(
		    'default'			=> '#1e6864',
		    'sanitize_callback' => 'sanitize_hex_color',
		    'transport'			=> 'refresh',
	    ) );

	    $wp_customize->add_control( new WP_Customize_color_control( $wp_customize, 'passport_secondary_color_control', array(
		    'label'				=> esc_html__( 'Secondary Color', 'passport' ),
		    'section'			=> 'passport_theme_colors',
		    'settings'			=> 'passport_secondary_color',
	    ) ) );

	    $wp_customize->add_setting( 'passport_secondary_font_color', array(
		    'default'			=> '#ffffff',
		    'sanitize_callback' => 'sanitize_hex_color',
		    'transport'			=> 'refresh',
	    ) );

	    $wp_customize->add_control( new WP_Customize_color_control( $wp_customize, 'passport_secondary_font_color_control', array(
		    'label'				=> esc_html__( 'Secondary Font Color', 'passport' ),
		    'section'			=> 'passport_theme_colors',
		    'settings'			=> 'passport_secondary_font_color',
	    ) ) );
    

        //Widget Color
        $wp_customize->add_section( 'passport_widget_colors', array(
		    'title'				=> esc_html__( 'Widget Colors', 'passport' ),
		    'priority'			=> 2,
		    'panel'				=> 'passport_theme_colors_panel',
	    ) );

 	    //Widget Background Color
	    $wp_customize->add_setting( 'passport_widget_bgcolor', array(
		    'default'			=> '#ffffff',
		    'sanitize_callback' => 'sanitize_hex_color',
		    'transport'			=> 'refresh',
	    ) );

	    $wp_customize->add_control( new WP_Customize_color_control( $wp_customize, 'passport_widget_bgcolor_control', array(
		    'label'				=> esc_html__( 'Widget Background Color', 'passport' ),
		    'section'			=> 'passport_widget_colors',
		    'settings'			=> 'passport_widget_bgcolor',
	    ) ) );  


	    //Widget Text Color
	    $wp_customize->add_setting( 'passport_widget_heading_color', array(
		    'default'			=> '#333333',
		    'sanitize_callback' => 'sanitize_hex_color',
		    'transport'			=> 'refresh',
	    ) );

	    $wp_customize->add_control( new WP_Customize_color_control( $wp_customize, 'passport_widget_heading_color_control', array(
		    'label'				=> esc_html__( 'Widget Heading Color', 'passport' ),
		    'section'			=> 'passport_widget_colors',
		    'settings'			=> 'passport_widget_heading_color',
	    ) ) );


	    //Hover theme color
	    $wp_customize->add_setting( 'passport_hover_widget_bgcolor', array(
		    'default'			=> '#e7e7e7',
		    'sanitize_callback' => 'sanitize_hex_color',
		    'transport'			=> 'refresh',
	    ) );
	
	    $wp_customize->add_control( new WP_Customize_color_control( $wp_customize, 'passport_hover_widget_bgcolor_control', array(
		    'label'				=> esc_html__( 'Hover Widget Background Color', 'passport' ),
		    'section'			=> 'passport_widget_colors',
		    'settings'			=> 'passport_hover_widget_bgcolor',
	    ) ) );
	

	    //Hover theme font color
	    $wp_customize->add_setting( 'passport_hover_widget_font_color', array(
		    'default'			=> '#333333',
		    'sanitize_callback' => 'sanitize_hex_color',
		    'transport'			=> 'refresh',
	    ) );

	    $wp_customize->add_control( new WP_Customize_color_control( $wp_customize, 'passport_hover_widget_font_color_control', array(
		    'label'				=> esc_html__( 'Hover Theme Font Color', 'passport' ),
		    'section'			=> 'passport_widget_colors',
		    'settings'			=> 'passport_hover_widget_font_color',
	    ) ) );


	    //Item Background color
	    $wp_customize->add_section( 'passport_item_bgcolors', array(
		    'title'				=> esc_html__( 'Item Background Colors', 'passport' ),
		    'priority'			=> 2,
		    'panel'				=> 'passport_theme_colors_panel',
	    ) );


	    //Post Background Color
	    $wp_customize->add_setting( 'passport_post_bgcolor', array(
		    'default'			=> '#ffffff',
		    'sanitize_callback' => 'sanitize_hex_color',
		    'transport'			=> 'refresh',
	    ) );

	    $wp_customize->add_control( new WP_Customize_color_control( $wp_customize, 'passport_post_bgcolor_control', array(
		    'label'				=> esc_html__( 'Post Background Color', 'passport' ),
		    'section'			=> 'passport_item_bgcolors',
		    'settings'			=> 'passport_post_bgcolor',
	    ) ) );
	

	    //Author Section Background Color
	    $wp_customize->add_setting( 'passport_author_bgcolor', array(
		    'default'			=> '#ffffff',
		    'sanitize_callback' => 'sanitize_hex_color',
		    'transport'			=> 'refresh',
	    ) );

	    $wp_customize->add_control( new WP_Customize_color_control( $wp_customize, 'passport_author_bgcolor_control', array(
		    'label'				=> esc_html__( 'Author Background Color', 'passport' ),
		    'section'			=> 'passport_item_bgcolors',
		    'settings'			=> 'passport_author_bgcolor',
	    ) ) );


	    //Related Posts Section Background Color
	    $wp_customize->add_setting( 'passport_related_posts_bgcolor', array(
		    'default'			=> '#ffffff',
		    'sanitize_callback' => 'sanitize_hex_color',
		    'transport'			=> 'refresh',
	    ) );

	    $wp_customize->add_control( new WP_Customize_color_control( $wp_customize, 'passport_related_posts_bgcolor_control', array(
		    'label'				=> esc_html__( 'Related Posts Background Color', 'passport' ),
		    'section'			=> 'passport_item_bgcolors',
		    'settings'			=> 'passport_related_posts_bgcolor',
	    ) ) );


	    //Comment Section Background Color
	    $wp_customize->add_setting( 'passport_comment_bgcolor', array(
		    'default'			=> '#ffffff',
		    'sanitize_callback' => 'sanitize_hex_color',
		    'transport'			=> 'refresh',
	    ) );

	    $wp_customize->add_control( new WP_Customize_color_control( $wp_customize, 'passport_comment_bgcolor_control', array(
		    'label'				=> esc_html__( 'Comment Background Color', 'passport' ),
		    'section'			=> 'passport_item_bgcolors',
		    'settings'			=> 'passport_comment_bgcolor',
	    ) ) );


	    //Horizontal Line Color
	    $wp_customize->add_setting( 'passport_horizontal_line_color', array(
		    'default'			=> '#eeeeee',
		    'sanitize_callback' => 'sanitize_hex_color',
		    'transport'			=> 'refresh',
	    ) );

	    $wp_customize->add_control( new WP_Customize_color_control( $wp_customize, 'passport_horizontal_line_color_control', array(
		    'label'				=> esc_html__( 'Horizontal Line Color', 'passport' ),
		    'section'			=> 'passport_item_bgcolors',
		    'settings'			=> 'passport_horizontal_line_color',
	    ) ) );


	    //Menu Color
	    $wp_customize->add_section( 'passport_menu_colors', array(
		    'title'				=> esc_html__( 'Menu Colors', 'passport' ),
		    'priority'			=> 3,
		    'panel'				=> 'passport_theme_colors_panel',
	    ) );


	    //Menu Item Background Color
	    $wp_customize->add_setting( 'passport_active_menu_bgcolor', array(
		    'default'			=> '#ffffff',
		    'sanitize_callback' => 'sanitize_hex_color',
		    'transport'			=> 'refresh',
	    ) );

	    $wp_customize->add_control( new WP_Customize_color_control( $wp_customize, 'passport_active_menu_bgcolor_control', array(
		    'label'				=> esc_html__( 'Active Menu Background Color', 'passport' ),
		    'section'			=> 'passport_menu_colors',
		    'settings'			=> 'passport_active_menu_bgcolor',
	    ) ) );


	    //Menu Font Color
	    $wp_customize->add_setting( 'passport_active_menu_font_color', array(
		    'default'			=> '#1e6864',
		    'sanitize_callback' => 'sanitize_hex_color',
		    'transport'			=> 'refresh',
	    ) );

	    $wp_customize->add_control( new WP_Customize_color_control( $wp_customize, 'passport_active_menu_font_color_control', array(
		    'label'				=> esc_html__( 'Active Menu Font Color', 'passport' ),
		    'section'			=> 'passport_menu_colors',
		    'settings'			=> 'passport_active_menu_font_color',
	    ) ) );


	    //Menu Item Hover Background Color
	    $wp_customize->add_setting( 'passport_hover_menu_item_bgcolor', array(
		    'default'			=> '#ffffff',
		    'sanitize_callback' => 'sanitize_hex_color',
		    'transport'			=> 'refresh',
	    ) );

	    $wp_customize->add_control( new WP_Customize_color_control( $wp_customize, 'passport_hover_menu_item_bgcolor_control', array(
		    'label'				=> esc_html__( 'Hover Menu Item Background Color', 'passport' ),
		    'section'			=> 'passport_menu_colors',
		    'settings'			=> 'passport_hover_menu_item_bgcolor',
	    ) ) );

	    //Hover Menu Font Color
	    $wp_customize->add_setting( 'passport_hover_menu_font_color', array(
		    'default'			=> '#ff8b2a',
		    'sanitize_callback' => 'sanitize_hex_color',
		    'transport'			=> 'refresh',
	    ) );

	    $wp_customize->add_control( new WP_Customize_color_control( $wp_customize, 'passport_hover_menu_font_color_control', array(
		    'label'				=> esc_html__( 'Hover Menu Font Color', 'passport' ),
		    'section'			=> 'passport_menu_colors',
		    'settings'			=> 'passport_hover_menu_font_color',
	    ) ) );

	    //Dropdown Menu Background Color
	    $wp_customize->add_setting( 'passport_dropdown_menu_bgcolor', array(
		    'default'			=> '#ffffff',
		    'sanitize_callback' => 'sanitize_hex_color',
		    'transport'			=> 'refresh',
	    ) );

	    $wp_customize->add_control( new WP_Customize_color_control( $wp_customize, 'passport_dropdown_menu_bgcolor_control', array(
		    'label'				=> esc_html__( 'Dropdown Menu Background Color', 'passport' ),
		    'section'			=> 'passport_menu_colors',
		    'settings'			=> 'passport_dropdown_menu_bgcolor',
	    ) ) );


	    //Menu Font Color
	    $wp_customize->add_setting( 'passport_dropdown_menu_font_color', array(
		    'default'			=> '#1e6864',
		    'sanitize_callback' => 'sanitize_hex_color',
		    'transport'			=> 'refresh',
	    ) );

	    $wp_customize->add_control( new WP_Customize_color_control( $wp_customize, 'passport_dropdown_menu_font_color_control', array(
		    'label'				=> esc_html__( 'Dropdown Menu Font Color', 'passport' ),
		    'section'			=> 'passport_menu_colors',
		    'settings'			=> 'passport_dropdown_menu_font_color',
	    ) ) );

	    //Heading and Paragraph Color
	    $wp_customize->add_section( 'passport_heading_and_paragraph_colors', array(
		    'title'				=> esc_html__( 'Heading and Paragraph Colors', 'passport' ),
		    'priority'			=> 4,
		    'panel'				=> 'passport_theme_colors_panel',
	    ) );


	    //H1 Color
	    $wp_customize->add_setting( 'passport_h1_color', array(
		    'default'			=> '#333333',
		    'sanitize_callback' => 'sanitize_hex_color',
		    'transport'			=> 'refresh',
	    ) );

	    $wp_customize->add_control( new WP_Customize_color_control( $wp_customize, 'passport_h1_color_control', array(
		    'label'				=> esc_html__( 'H1 Color', 'passport' ),
		    'section'			=> 'passport_heading_and_paragraph_colors',
		    'settings'			=> 'passport_h1_color',
	    ) ) );


	    //H2 Color
	    $wp_customize->add_setting( 'passport_h2_color', array(
		    'default'			=> '#333333',
		    'sanitize_callback' => 'sanitize_hex_color',
		    'transport'			=> 'refresh',
	    ) );

	    $wp_customize->add_control( new WP_Customize_color_control( $wp_customize, 'passport_h2_color_control', array(
		    'label'				=> esc_html__( 'H2 Color', 'passport' ),
		    'section'			=> 'passport_heading_and_paragraph_colors',
		    'settings'			=> 'passport_h2_color',
	    ) ) );


	    //H3 Color
	    $wp_customize->add_setting( 'passport_h3_color', array(
		    'default'			=> '#333333',
		    'sanitize_callback' => 'sanitize_hex_color',
		    'transport'			=> 'refresh',
	    ) );

	    $wp_customize->add_control( new WP_Customize_color_control( $wp_customize, 'passport_h3_color_control', array(
		    'label'				=> esc_html__( 'H3 Color', 'passport' ),
		    'section'			=> 'passport_heading_and_paragraph_colors',
		    'settings'			=> 'passport_h3_color',
	    ) ) );


	    //H4 Color
	    $wp_customize->add_setting( 'passport_h4_color', array(
		    'default'			=> '#333333',
		    'sanitize_callback' => 'sanitize_hex_color',
		    'transport'			=> 'refresh',
	    ) );

	    $wp_customize->add_control( new WP_Customize_color_control( $wp_customize, 'passport_h4_color_control', array(
		    'label'				=> esc_html__( 'H4 Color', 'passport' ),
		    'section'			=> 'passport_heading_and_paragraph_colors',
		    'settings'			=> 'passport_h4_color',
	    ) ) );


	    //H5 Color
	    $wp_customize->add_setting( 'passport_h5_color', array(
		    'default'			=> '#333333',
		    'sanitize_callback' => 'sanitize_hex_color',
		    'transport'			=> 'refresh',
	    ) );

	    $wp_customize->add_control( new WP_Customize_color_control( $wp_customize, 'passport_h5_color_control', array(
		    'label'				=> esc_html__( 'H5 Color', 'passport' ),
		    'section'			=> 'passport_heading_and_paragraph_colors',
		    'settings'			=> 'passport_h5_color',
	    ) ) );


	    //P Color
	    $wp_customize->add_setting( 'passport_p_color', array(
		    'default'			=> '#333333',
		    'sanitize_callback' => 'sanitize_hex_color',
		    'transport'			=> 'refresh',
	    ) );

	    $wp_customize->add_control( new WP_Customize_color_control( $wp_customize, 'passport_p_color_control', array(
		    'label'				=> esc_html__( 'P Color', 'passport' ),
		    'section'			=> 'passport_heading_and_paragraph_colors',
		    'settings'			=> 'passport_p_color',
	    ) ) );


	    //P meta color
	    $wp_customize->add_setting( 'passport_p_meta_color', array(
		    'default'			=> '#999999',
		    'sanitize_callback' => 'sanitize_hex_color',
		    'transport'			=> 'refresh',
	    ) );

	    $wp_customize->add_control( new WP_Customize_color_control( $wp_customize, 'passport_p_meta_color_control', array(
		    'label'				=> esc_html__( 'Meta Color', 'passport' ),
		    'section'			=> 'passport_heading_and_paragraph_colors',
		    'settings'			=> 'passport_p_meta_color',
	    ) ) );
	

	    //Hover p meta color
	    $wp_customize->add_setting( 'passport_hover_p_meta_color', array(
		    'default'			=> '#1e6864',
		    'sanitize_callback' => 'sanitize_hex_color',
		    'transport'			=> 'refresh',
	    ) );

	    $wp_customize->add_control( new WP_Customize_color_control( $wp_customize, 'passport_hover_p_meta_color_control', array(
		    'label'				=> esc_html__( 'Hover Meta Color', 'passport' ),
		    'section'			=> 'passport_heading_and_paragraph_colors',
		    'settings'			=> 'passport_hover_p_meta_color',
	    ) ) );


	    //Span Color
	    $wp_customize->add_setting( 'passport_span_color', array(
		    'default'			=> '#333333',
		    'sanitize_callback' => 'sanitize_hex_color',
		    'transport'			=> 'refresh',
	    ) );

	    $wp_customize->add_control( new WP_Customize_color_control( $wp_customize, 'passport_span_color_control', array(
		    'label'				=> esc_html__( 'Span Color', 'passport' ),
		    'section'			=> 'passport_heading_and_paragraph_colors',
		    'settings'			=> 'passport_span_color',
	    ) ) );


	    //Link Color
	    $wp_customize->add_setting( 'passport_link_color', array(
		    'default'			=> '#1e6864',
		    'sanitize_callback' => 'sanitize_hex_color',
		    'transport'			=> 'refresh',
	    ) );

	    $wp_customize->add_control( new WP_Customize_color_control( $wp_customize, 'passport_link_color_control', array(
		    'label'				=> esc_html__( 'Link Color', 'passport' ),
		    'section'			=> 'passport_heading_and_paragraph_colors',
		    'settings'			=> 'passport_link_color',
	    ) ) );


	    //Footer Color
	    $wp_customize->add_section( 'passport_footer_colors', array(
		    'title'				=> esc_html__( 'Footer Colors', 'passport' ),
		    'priority'			=> 5,
		    'panel'				=> 'passport_theme_colors_panel',
	    ) );


	    //Footer Background Color
	    $wp_customize->add_setting( 'passport_footer_bgcolor', array(
		    'default'			=> '#dddddd',
		    'sanitize_callback' => 'sanitize_hex_color',
		    'transport'			=> 'refresh',
	    ) );

	    $wp_customize->add_control( new WP_Customize_color_control( $wp_customize, 'passport_footer_bgcolor_control', array(
		    'label'				=> esc_html__( 'Footer Background Color', 'passport' ),
		    'section'			=> 'passport_footer_colors',
		    'settings'			=> 'passport_footer_bgcolor',
	    ) ) );


	    //Footer Paragraph Color
	    $wp_customize->add_setting( 'passport_footer_heading_color', array(
		    'default'			=> '#333333',
		    'sanitize_callback' => 'sanitize_hex_color',
		    'transport'			=> 'refresh',
	    ) );

	    $wp_customize->add_control( new WP_Customize_color_control( $wp_customize, 'passport_footer_heading_color_control', array(
		    'label'				=> esc_html__( 'Footer Heading Color', 'passport' ),
		    'section'			=> 'passport_footer_colors',
		    'settings'			=> 'passport_footer_heading_color',
	    ) ) );


	    //Footer Paragraph Color
	    $wp_customize->add_setting( 'passport_footer_p_color', array(
		    'default'			=> '#333333',
		    'sanitize_callback' => 'sanitize_hex_color',
		    'transport'			=> 'refresh',
	    ) );

	    $wp_customize->add_control( new WP_Customize_color_control( $wp_customize, 'passport_footer_p_color_control', array(
		    'label'				=> esc_html__( 'Footer Paragraph Color', 'passport' ),
		    'section'			=> 'passport_footer_colors',
		    'settings'			=> 'passport_footer_p_color',
	    ) ) );


	    //Footer Meta Color
	    $wp_customize->add_setting( 'passport_footer_meta_color', array(
		    'default'			=> '#a0a0a0',
		    'sanitize_callback' => 'sanitize_hex_color',
		    'transport'			=> 'refresh',
	    ) );

	    $wp_customize->add_control( new WP_Customize_color_control( $wp_customize, 'passport_footer_meta_color_control', array(
		    'label'				=> esc_html__( 'Footer Meta Color', 'passport' ),
		    'section'			=> 'passport_footer_colors',
		    'settings'			=> 'passport_footer_meta_color',
	    ) ) );


	    //Footer span Color
	    $wp_customize->add_setting( 'passport_footer_span_color', array(
		    'default'			=> '#a0a0a0',
		    'sanitize_callback' => 'sanitize_hex_color',
		    'transport'			=> 'refresh',
	    ) );

	    $wp_customize->add_control( new WP_Customize_color_control( $wp_customize, 'passport_footer_span_color_control', array(
		    'label'				=> esc_html__( 'Footer Span Color', 'passport' ),
		    'section'			=> 'passport_footer_colors',
		    'settings'			=> 'passport_footer_span_color',
	    ) ) );


	    //Footer hover Color
	    $wp_customize->add_setting( 'passport_footer_hover_color', array(
		    'default'			=> '#eeeeee',
		    'sanitize_callback' => 'sanitize_hex_color',
		    'transport'			=> 'refresh',
	    ) );

	    $wp_customize->add_control( new WP_Customize_color_control( $wp_customize, 'passport_footer_hover_color_control', array(
		    'label'				=> esc_html__( 'Footer Hover Text Color', 'passport' ),
		    'section'			=> 'passport_footer_colors',
		    'settings'			=> 'passport_footer_hover_color',
	    ) ) );


	    //Footer link Color
	    $wp_customize->add_setting( 'passport_footer_link_color', array(
		    'default'			=> '#a0a0a0',
		    'sanitize_callback' => 'sanitize_hex_color',
		    'transport'			=> 'refresh',
	    ) );

	    $wp_customize->add_control( new WP_Customize_color_control( $wp_customize, 'passport_footer_link_color_control', array(
		    'label'				=> esc_html__( 'Footer Link Color', 'passport' ),
		    'section'			=> 'passport_footer_colors',
		    'settings'			=> 'passport_footer_link_color',
	    ) ) );


	    //Button
	    $wp_customize->add_section( 'passport_button_colors', array(
		    'title'				=> esc_html__( 'Button Colors', 'passport' ),
		    'priority'			=> 6,
		    'panel'				=> 'passport_theme_colors_panel',
	    ) );


	    //Button color
	    $wp_customize->add_setting( 'passport_button_color', array(
		    'default'			=> '#1e6864',
		    'sanitize_callback' => 'sanitize_hex_color',
		    'transport'			=> 'refresh',
	    ) );

	    $wp_customize->add_control( new WP_Customize_color_control( $wp_customize, 'passport_button_color_control', array(
		    'label'				=> esc_html__( 'Button Color', 'passport' ),
		    'section'			=> 'passport_button_colors',
		    'settings'			=> 'passport_button_color',
	    ) ) );


	    //Button Border Color
	    $wp_customize->add_setting( 'passport_button_border_color', array(
		    'default'			=> '#1e6864',
		    'sanitize_callback' => 'sanitize_hex_color',
		    'transport'			=> 'refresh',
	    ) );

	    $wp_customize->add_control( new WP_Customize_color_control( $wp_customize, 'passport_button_border_color_control', array(
		    'label'				=> esc_html__( 'Button Border Color', 'passport' ),
		    'section'			=> 'passport_button_colors',
		    'settings'			=> 'passport_button_border_color',
	    ) ) );


	    //Button Link Color
	    $wp_customize->add_setting( 'passport_button_link_color', array(
		    'default'			=> '#ffffff',
		    'sanitize_callback' => 'sanitize_hex_color',
		    'transport'			=> 'refresh',
	    ) );

	    $wp_customize->add_control( new WP_Customize_color_control( $wp_customize, 'passport_button_link_color_control', array(
		    'label'				=> esc_html__( 'Button Link Color', 'passport' ),
		    'section'			=> 'passport_button_colors',
		    'settings'			=> 'passport_button_link_color',
	    ) ) );


	    //Hover Button Color
	    $wp_customize->add_setting( 'passport_hover_button_color', array(
		    'default'			=> '#cccccc',
		    'sanitize_callback' => 'sanitize_hex_color',
		    'transport'			=> 'refresh',
	    ) );

	    $wp_customize->add_control( new WP_Customize_color_control( $wp_customize, 'passport_hover_button_color_control', array(
		    'label'				=> esc_html__( 'Hover Button Color', 'passport' ),
		    'section'			=> 'passport_button_colors',
		    'settings'			=> 'passport_hover_button_color',
	    ) ) );


	    //Hover Border Color
	    $wp_customize->add_setting( 'passport_hover_border_color', array(
		    'default'			=> '#cccccc',
		    'sanitize_callback' => 'sanitize_hex_color',
		    'transport'			=> 'refresh',
	    ) );

	    $wp_customize->add_control( new WP_Customize_color_control( $wp_customize, 'passport_hover_border_color_control', array(
		    'label'				=> esc_html__( 'Hover Border Color', 'passport' ),
		    'section'			=> 'passport_button_colors',
		    'settings'			=> 'passport_hover_border_color',
	    ) ) );


	    //Hover Button Link Color
	    $wp_customize->add_setting( 'passport_hover_button_link_color', array(
		    'default'			=> '#333333',
		    'sanitize_callback' => 'sanitize_hex_color',
		    'transport'			=> 'refresh',
	    ) );

	    $wp_customize->add_control( new WP_Customize_color_control( $wp_customize, 'passport_hover_button_link_color_control', array(
		    'label'				=> esc_html__( 'Hover Button Link Color', 'passport' ),
		    'section'			=> 'passport_button_colors',
		    'settings'			=> 'passport_hover_button_link_color',
	    ) ) );


	    //Slider
	    $wp_customize->add_section( 'passport_slider_and_box_colors', array(
		    'title'				=> esc_html__( 'Slider and Box Colors', 'passport' ),
		    'priority'			=> 7,
		    'panel'				=> 'passport_theme_colors_panel',
	    ) );


	    //Slider Background Color
	    $wp_customize->add_setting( 'passport_slider_background_color', array(
		    'default'			=> '#eeeeee',
		    'sanitize_callback' => 'sanitize_hex_color',
		    'transport'			=> 'refresh',
	    ) );

	    $wp_customize->add_control( new WP_Customize_color_control( $wp_customize, 'passport_slider_background_color_control', array(
		    'label'				=> esc_html__( 'Slider Background Color', 'passport' ),
		    'section'			=> 'passport_slider_and_box_colors',
		    'settings'			=> 'passport_slider_background_color',
	    ) ) );


	    //Slider Text/Link Color
	    $wp_customize->add_setting( 'passport_slider_text_color', array(
		    'default'			=> '#333333',
		    'sanitize_callback' => 'sanitize_hex_color',
		    'transport'			=> 'refresh',
	    ) );

	    $wp_customize->add_control( new WP_Customize_color_control( $wp_customize, 'passport_slider_text_color_control', array(
		    'label'				=> esc_html__( 'Slider Header Color and Arrows', 'passport' ),
		    'section'			=> 'passport_slider_and_box_colors',
		    'settings'			=> 'passport_slider_text_color',
	    ) ) );

	    //Slider Span Color
	    $wp_customize->add_setting( 'passport_slider_excerpt_color', array(
		    'default'			=> '#333333',
		    'sanitize_callback' => 'sanitize_hex_color',
		    'transport'			=> 'refresh',
	    ) );

	    $wp_customize->add_control( new WP_Customize_color_control( $wp_customize, 'passport_slider_excerpt_color_control', array(
		    'label'				=> esc_html__( 'Slider Paragraph Color', 'passport' ),
		    'section'			=> 'passport_slider_and_box_colors',
		    'settings'			=> 'passport_slider_excerpt_color',
	    ) ) );

	    //Box Background Color
	    $wp_customize->add_setting( 'passport_box_background_color', array(
		    'default'			=> '#eeeeee',
		    'sanitize_callback' => 'sanitize_hex_color',
		    'transport'			=> 'refresh',
	    ) );

	    $wp_customize->add_control( new WP_Customize_color_control( $wp_customize, 'passport_box_background_color_control', array(
		    'label'				=> esc_html__( 'Box Background Color', 'passport' ),
		    'section'			=> 'passport_slider_and_box_colors',
		    'settings'			=> 'passport_box_background_color',
	    ) ) );


	    //Box Text/Link Color
	    $wp_customize->add_setting( 'passport_box_text_color', array(
		    'default'			=> '#333333',
		    'sanitize_callback' => 'sanitize_hex_color',
		    'transport'			=> 'refresh',
	    ) );

	    $wp_customize->add_control( new WP_Customize_color_control( $wp_customize, 'passport_box_text_color_control', array(
		    'label'				=> esc_html__( 'Box Header Color', 'passport' ),
		    'section'			=> 'passport_slider_and_box_colors',
		    'settings'			=> 'passport_box_text_color',
	    ) ) );

  
  	    //Box Span Color
	    $wp_customize->add_setting( 'passport_box_excerpt_color', array(
		    'default'			=> '#333333',
		    'sanitize_callback' => 'sanitize_hex_color',
		    'transport'			=> 'refresh',
	    ) );

	    $wp_customize->add_control( new WP_Customize_color_control( $wp_customize, 'passport_box_excerpt_color_control', array(
		    'label'				=> esc_html__( 'Box Paragraph Color', 'passport' ),
		    'section'			=> 'passport_slider_and_box_colors',
		    'settings'			=> 'passport_box_excerpt_color',
	    ) ) );


	    //Sticky Label
	    $wp_customize->add_section( 'passport_sticky_label_colors', array(
		    'title'				=> esc_html__( 'Sticky Label Colors', 'passport' ),
		    'priority'			=> 8,
		    'panel'				=> 'passport_theme_colors_panel',
	    ) );


	    //Sticky Label Color
	    $wp_customize->add_setting( 'passport_sticky_label_color', array(
		    'default'			=> '#fae03c',
		    'sanitize_callback' => 'sanitize_hex_color',
		    'transport'			=> 'refresh',
	    ) );

	    $wp_customize->add_control( new WP_Customize_color_control( $wp_customize, 'passport_sticky_label_color_control', array(
		    'label'				=> esc_html__( 'Sticky Label Color', 'passport' ),
		    'section'			=> 'passport_sticky_label_colors',
		    'settings'			=> 'passport_sticky_label_color',
	    ) ) );


	    //Sticky Text Color
	    $wp_customize->add_setting( 'passport_sticky_text_color', array(
		    'default'			=> '#ffffff',
		    'sanitize_callback' => 'sanitize_hex_color',
		    'transport'			=> 'refresh',
	    ) );

	    $wp_customize->add_control( new WP_Customize_color_control( $wp_customize, 'passport_sticky_text_color_control', array(
		    'label'				=> esc_html__( 'Sticky Text Color', 'passport' ),
		    'section'			=> 'passport_sticky_label_colors',
		    'settings'			=> 'passport_sticky_text_color',
	    ) ) );

        //Sticky Label
	    $wp_customize->add_section( 'passport_box_shadow', array(
		    'title'				=> esc_html__( 'Box Shadow', 'passport' ),
		    'priority'			=> 9,
		    'panel'				=> 'passport_theme_colors_panel',
	    ) );

        //Box Shadow
	    $wp_customize->add_setting( 'passport_hide_box_shadow', array(
		    'sanitize_callback' => 'passport_sanitize_checkbox' 
	    ) );

	    $wp_customize->add_control( 'passport_hide_box_shadow', array(
            'type'				=> 'checkbox',
            'label'				=> esc_html__( 'Hide Box Shadow', 'passport' ),
            'section'			=> 'passport_box_shadow',
	    ) );


	    //Menu Configuration
	    //Menu
	    $wp_customize->add_panel( 'passport_menu_config', array(
		    'priority'			=> 101,
		    'title'				=> esc_html__( 'Menu Configuration', 'passport' ),
		    'capability'		=> 'edit_theme_options',
		    'description'		=> esc_html__( 'Change the menu configuartion as you want.', 'passport' )

	    ) );

	    $wp_customize->add_section( 'passport_primary_menu', array(
		    'title'				=> esc_html__( 'Primary Menu', 'passport' ),
		    'priority'			=> 1,
		    'panel'				=> 'passport_menu_config',
	    ) );


	    //Change Opacity
	    $wp_customize->add_setting( 'passport_primary_bg_opacity', array(
		    'default'			=> '1.0',
		    'sanitize_callback' => 'passport_sanitize_bg_opacity',
		    'transport'			=> 'refresh',
	    ) );
 
	    $wp_customize->add_control( 'passport_primary_bg_opacity', array(
            'type'				=> 'select',
            'label'				=> esc_html__( 'Change Opacity', 'passport' ),
            'section'			=> 'passport_primary_menu',
		    'settings'			=> 'passport_primary_bg_opacity',
		    'choices' => array(
			    '0.1'	=> esc_html__( '10%', 'passport' ),
			    '0.2'	=> esc_html__( '20%', 'passport' ),
			    '0.3'	=> esc_html__( '30%', 'passport' ),
			    '0.4'	=> esc_html__( '40%', 'passport' ),
			    '0.5'	=> esc_html__( '50%', 'passport' ),
			    '0.6'	=> esc_html__( '60%', 'passport' ),			
			    '0.7'	=> esc_html__( '70%', 'passport' ),
			    '0.8'	=> esc_html__( '80%', 'passport' ),
			    '0.9'	=> esc_html__( '90%', 'passport' ),
			    '1.0'	=> esc_html__( '100%', 'passport' ),
	    ) ) );


	    //Show Menu Image
	    $wp_customize->add_setting( 'passport_show_menu_image', array(
		    'sanitize_callback' => 'passport_sanitize_checkbox' 
	    ) );
 
	    $wp_customize->add_control( 'passport_show_menu_image', array(
            'type'				=> 'checkbox',
            'label'				=> esc_html__( 'Show image on submenu.', 'passport' ),
            'section'			=> 'passport_primary_menu',
	    ) );


	    //Menu Alignment
	    $wp_customize->add_setting( 'passport_menu_image_alignment', array(
		    'default'			=> 'alignleft',
		    'sanitize_callback' => 'passport_sanitize_menu_image_alignment',
		    'transport'			=> 'refresh',
	    ) );

	    $wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'passport_menu_image_alignment', array(
		    'label'				=> esc_html__( 'Column', 'passport' ),
		    'section'			=> 'passport_primary_menu',
		    'settings'			=> 'passport_menu_image_alignment',
		    'type'				=> 'radio',
		    'choices'			=> array(
				    'alignleft'		=> esc_html__( 'Left', 'passport' ),
				    'alignright'	=> esc_html__( 'Right', 'passport' ),
	    ), ) ) );


	    //Secondary Menu
	    $wp_customize->add_section( 'passport_secondary_menu', array(
		    'title'				=> esc_html__( 'Secondary Menu', 'passport' ),
		    'priority'			=> 1,
		    'panel'				=> 'passport_menu_config',
	    ) );


	    //Hide Secondary Menu Bar
	    $wp_customize->add_setting( 'passport_hide_secondary_menu_section', array(
		    'sanitize_callback' => 'passport_sanitize_checkbox' 
	    ) );

	    $wp_customize->add_control( 'passport_hide_secondary_menu_section', array(
            'type'				=> 'checkbox',
            'label'				=> esc_html__( 'Hide Secondary Menu Bar', 'passport' ),
            'section'			=> 'passport_secondary_menu',
	    ) );


	    //Secondary Menu
	    $wp_customize->add_section( 'passport_extra_menu', array(
		    'title'				=> esc_html__( 'Extra Menu', 'passport' ),
		    'priority'			=> 1,
		    'panel'				=> 'passport_menu_config',
	    ) );


	    //Hide Extra Menu Bar
	    $wp_customize->add_setting( 'passport_hide_extra_menu_section', array(
		    'sanitize_callback' => 'passport_sanitize_checkbox' 
	    ) );
 
	    $wp_customize->add_control( 'passport_hide_extra_menu_section', array(
            'type'				=> 'checkbox',
            'label'				=> esc_html__( 'Hide Extra Menu Bar', 'passport' ),
            'section'			=> 'passport_extra_menu',
	    ) );


	    //Layout
	    $wp_customize->add_panel( 'passport_layout', array(
		    'priority'			=> 105,
		    'title'				=> esc_html__( 'Layout', 'passport' ),
		    'capability'		=> 'edit_theme_options',
		    'description'		=> esc_html__( 'Change the configuartion as you want.', 'passport' )
	    ) );

	    $wp_customize->add_section( 'passport_section_1' , array(
		    'title'				=> esc_html__( 'Section 1','passport' ),
		    'priority'			=> 1,
		    'capability'		=> 'edit_theme_options',
		    'panel'				=> 'passport_layout',
	    ) );

	    $wp_customize->add_setting( 'passport_section_1_settings', array(
		    'default'			=> 'main_content',
		    'sanitize_callback' => 'passport_sanitize_main_content',
		    'transport'			=> 'refresh',
	    ) );

	    $wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'passport_section_1_settings', array(
		    'label'				=> esc_html__( 'Column', 'passport' ),
		    'section'			=> 'passport_section_1',
		    'settings'			=> 'passport_section_1_settings',
		    'type'				=> 'radio',
		    'choices'			=> array(
				    'main_content'  => esc_html__( 'Main Content', 'passport' ),
				    'sidebar'	    => esc_html__( 'Sidebar', 'passport' ),
	    ), ) ) );

	    $wp_customize->add_setting( 'passport_section_1_sidebar_position', array(
		    'default'			=> 'left',
		    'sanitize_callback' => 'passport_sanitize_sidebar_position',
		    'transport'			=> 'refresh',
	    ) );
 
	    $wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'passport_section_1_sidebar_position', array(
		    'label'				=> esc_html__( 'Sidebar Position', 'passport' ),
		    'section'			=> 'passport_section_1',
		    'settings'			=> 'passport_section_1_sidebar_position',
		    'type'				=> 'radio',
		    'choices'			=> array(
				    'left'		    => esc_html__( 'left', 'passport' ),
				    'right'		    => esc_html__( 'right', 'passport' ),	
	    ), ) ) );

	    $wp_customize->add_setting( 'passport_section_1_sidebar_width', array(
		    'default'			=> 'sidebar_25',
		    'sanitize_callback' => 'passport_sanitize_sidebar_width',
		    'transport'			=> 'refresh',
	    ) );
 
	    $wp_customize->add_control( 'passport_section_1_sidebar_width', array(
		    'type'				=> 'select',
		    'label'				=> esc_html__( 'Sidebar Width:', 'passport' ),
		    'section'			=> 'passport_section_1',
		    'settings'			=> 'passport_section_1_sidebar_width',
		    'choices' => array(
			    'sidebar_25'		=> esc_html__( 'Sidebar 25%', 'passport' ),
			    'sidebar_33'		=> esc_html__( 'Sidebar 33%', 'passport' ),
	    ), ) );

	    $wp_customize->add_section( 'passport_section_2' , array(
		    'title'				=> esc_html__( 'Section 2','passport' ),
		    'priority'			=> 2,
		    'capability'		=> 'edit_theme_options',
		    'panel'				=> 'passport_layout',
	    ) );

	    $wp_customize->add_setting( 'passport_section_2_settings', array(
		    'default'			=> 'sidebar',
		    'sanitize_callback' => 'passport_sanitize_main_content',
		    'transport'			=> 'refresh',
	    ) );

	    $wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'passport_section_2_settings', array(
		    'label'				=> esc_html__( 'Column', 'passport' ),
		    'section'			=> 'passport_section_2',
		    'settings'			=> 'passport_section_2_settings',
		    'type'				=> 'radio',
		    'choices'			=> array(
				    'main_content'  => esc_html__( 'Main Content', 'passport' ),
				    'sidebar'	    => esc_html__( 'Sidebar', 'passport' ),
	    ), ) ) );

	    $wp_customize->add_setting( 'passport_section_2_sidebar_position', array(
		    'default'			=> 'right',
		    'sanitize_callback' => 'passport_sanitize_sidebar_position',
		    'transport'			=> 'refresh',
	    ) );
 
	    $wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'passport_section_2_sidebar_position', array(
		    'label'				=> esc_html__( 'Sidebar Position', 'passport' ),
		    'section'			=> 'passport_section_2',
		    'settings'			=> 'passport_section_2_sidebar_position',
		    'type'				=> 'radio',
		    'choices'			=> array(
				    'left'		    => esc_html__( 'left', 'passport' ),
				    'right'		    => esc_html__( 'right', 'passport' ),	
	    ), ) ) );

	    $wp_customize->add_setting( 'passport_section_2_sidebar_width', array(
		    'default'			=> 'sidebar_25',
		    'sanitize_callback' => 'passport_sanitize_sidebar_width',
		    'transport'			=> 'refresh',
	    ) );
 
	    $wp_customize->add_control( 'passport_section_2_sidebar_width', array(
		    'type'				=> 'select',
		    'label'				=> esc_html__( 'Sidebar Width:', 'passport' ),
		    'section'			=> 'passport_section_2',
		    'settings'			=> 'passport_section_2_sidebar_width',
		    'choices' => array(
			    'sidebar_25'		=> esc_html__( 'Sidebar 25%', 'passport' ),
			    'sidebar_33'		=> esc_html__( 'Sidebar 33%', 'passport' ),
	    ), ) );

	    $wp_customize->add_section( 'passport_section_3' , array(
		    'title'				=> esc_html__( 'Section 3','passport' ),
		    'priority'			=> 3,
		    'capability'		=> 'edit_theme_options',
		    'panel'				=> 'passport_layout',
	    ) );

	    $wp_customize->add_setting( 'passport_section_3_settings', array(
		    'default'			=> 'sidebar',
		    'sanitize_callback' => 'passport_sanitize_main_content',
		    'transport'			=> 'refresh',
	    ) );

	    $wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'passport_section_3_settings', array(
		    'label'				=> esc_html__( 'Column', 'passport' ),
		    'section'			=> 'passport_section_3',
		    'settings'			=> 'passport_section_3_settings',
		    'type'				=> 'radio',
		    'choices'			=> array(
				    'main_content'  => esc_html__( 'Main Content', 'passport' ),
				    'sidebar'	    => esc_html__( 'Sidebar', 'passport' ),
	    ), ) ) );

	    $wp_customize->add_setting( 'passport_section_3_sidebar_position', array(
		    'default'			=> 'left',
		    'sanitize_callback' => 'passport_sanitize_sidebar_position',
		    'transport'			=> 'refresh',
	    ) );
 
	    $wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'passport_section_3_sidebar_position', array(
		    'label'				=> esc_html__( 'Sidebar Position', 'passport' ),
		    'section'			=> 'passport_section_3',
		    'settings'			=> 'passport_section_3_sidebar_position',
		    'type'				=> 'radio',
		    'choices'			=> array(
				    'left'		    => esc_html__( 'left', 'passport' ),
				    'right'		    => esc_html__( 'right', 'passport' ),	
	    ), ) ) );

	    $wp_customize->add_setting( 'passport_section_3_sidebar_width', array(
		    'default'			=> 'sidebar_25',
		    'sanitize_callback' => 'passport_sanitize_sidebar_width',
		    'transport'			=> 'refresh',
	    ) );
 
	    $wp_customize->add_control( 'passport_section_3_sidebar_width', array(
		    'type'				=> 'select',
		    'label'				=> esc_html__( 'Sidebar Width:', 'passport' ),
		    'section'			=> 'passport_section_3',
		    'settings'			=> 'passport_section_3_sidebar_width',
		    'choices' => array(
			    'sidebar_25'		=> esc_html__( 'Sidebar 25%', 'passport' ),
			    'sidebar_33'		=> esc_html__( 'Sidebar 33%', 'passport' ),
	    ), ) );

	    $wp_customize->add_section( 'passport_section_4' , array(
		    'title'				=> esc_html__( 'Section 4','passport' ),
		    'priority'			=> 4,
		    'capability'		=> 'edit_theme_options',
		    'panel'				=> 'passport_layout',
	    ) );

	    $wp_customize->add_setting( 'passport_section_4_settings', array(
		    'default'			=> 'main_content',
		    'sanitize_callback' => 'passport_sanitize_main_content',
		    'transport'			=> 'refresh',
	    ) );

	    $wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'passport_section_4_settings', array(
		    'label'				=> esc_html__( 'Column', 'passport' ),
		    'section'			=> 'passport_section_4',
		    'settings'			=> 'passport_section_4_settings',
		    'type'				=> 'radio',
		    'choices'			=> array(
				    'main_content'  => esc_html__( 'Main Content', 'passport' ),
				    'sidebar'	    => esc_html__( 'Sidebar', 'passport' ),
	    ), ) ) );

	    $wp_customize->add_setting( 'passport_section_4_sidebar_position', array(
		    'default'			=> 'left',
		    'sanitize_callback' => 'passport_sanitize_sidebar_position',
		    'transport'			=> 'refresh',
	    ) );
 
	    $wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'passport_section_4_sidebar_position', array(
		    'label'				=> esc_html__( 'Sidebar Position', 'passport' ),
		    'section'			=> 'passport_section_4',
		    'settings'			=> 'passport_section_4_sidebar_position',
		    'type'				=> 'radio',
		    'choices'			=> array(
				    'left'		    => esc_html__( 'left', 'passport' ),
				    'right'		    => esc_html__( 'right', 'passport' ),	
	    ), ) ) );

	    $wp_customize->add_setting( 'passport_section_4_sidebar_width', array(
		    'default'			=> 'sidebar_25',
		    'sanitize_callback' => 'passport_sanitize_sidebar_width',
		    'transport'			=> 'refresh',
	    ) );
 
	    $wp_customize->add_control( 'passport_section_4_sidebar_width', array(
		    'type'				=> 'select',
		    'label'				=> esc_html__( 'Sidebar Width:', 'passport' ),
		    'section'			=> 'passport_section_4',
		    'settings'			=> 'passport_section_4_sidebar_width',
		    'choices' => array(
			    'sidebar_25'		=> esc_html__( 'Sidebar 25%', 'passport' ),
			    'sidebar_33'		=> esc_html__( 'Sidebar 33%', 'passport' ),
	    ), ) );

	    $wp_customize->add_section( 'passport_section_5' , array(
		    'title'				=> esc_html__( 'Section 5','passport' ),
		    'priority'			=> 5,
		    'capability'		=> 'edit_theme_options',
		    'panel'				=> 'passport_layout',
	    ) );
  
	    $wp_customize->add_setting( 'passport_section_5_settings', array(
		    'default'			=> '3',
		    'sanitize_callback' => 'passport_sanitize_column',
		    'transport'			=> 'refresh',
	    ) );

	    $wp_customize->add_control( 'passport_section_5_settings', array(
		    'type'				=> 'select',
		    'label'				=> esc_html__( 'Section 5', 'passport' ),
		    'section'			=> 'passport_section_5',
		    'settings'			=> 'passport_section_5_settings',
		    'choices'			=> array(
			    '1'		=> esc_html__( 'One Column', 'passport' ),
			    '2'		=> esc_html__( 'Two Column', 'passport' ),
			    '3'		=> esc_html__( 'Three Column', 'passport' ),
			    '4'		=> esc_html__( 'Four Column', 'passport' ),
	    ), ) );

        
	    //Headline Section
	    $wp_customize->add_section( 'passport_headline_section' , array(
		    'title'				=> esc_html__( 'Headline','passport' ),
		    'priority'			=> 6,
		    'capability'		=> 'edit_theme_options',
		    'panel'				=> 'passport_layout',
	    ) ); 

	
	    //Headline Column
	    $wp_customize->add_setting( 'passport_headline_column', array(
		    'default'			=> 'sidebar',
		    'sanitize_callback' => 'passport_sanitize_main_content',
		    'transport'			=> 'refresh',
	    ) );

	    $wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'passport_headline_column', array(
		    'label'				=> esc_html__( 'Column', 'passport' ),
		    'section'			=> 'passport_headline_section',
		    'settings'			=> 'passport_headline_column',
		    'type'				=> 'radio',
		    'choices'			=> array(
				    'main_content'  => esc_html__( 'Main Content', 'passport' ),
				    'sidebar'	    => esc_html__( 'Sidebar', 'passport' ),
	    ) ) ) );


	    //Headline Sidebar Position
	    $wp_customize->add_setting( 'passport_headline_sidebar_position', array(
		    'default'			=> 'right',
		    'sanitize_callback' => 'passport_sanitize_sidebar_position',
		    'transport'			=> 'refresh',
	    ) );
 
	    $wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'passport_headline_sidebar_position', array(
		    'label'				=> esc_html__( 'Sidebar Position', 'passport' ),
		    'section'			=> 'passport_headline_section',
		    'settings'			=> 'passport_headline_sidebar_position',
		    'type'				=> 'radio',
		    'choices'			=> array(
				    'left'	        => esc_html__( 'left', 'passport' ),
				    'right'		    => esc_html__( 'right', 'passport' ),	
	    ), ) ) );


	    //Headline Sidebar Width
	    $wp_customize->add_setting( 'passport_headline_sidebar_width', array(
		    'default'			=> 'sidebar_25',
		    'sanitize_callback' => 'passport_sanitize_sidebar_width',
		    'transport'			=> 'refresh',
	    ) );
 
	    $wp_customize->add_control( 'passport_headline_sidebar_width', array(
		    'type'				=> 'select',
		    'label'				=> esc_html__( 'Sidebar Width:', 'passport' ),
		    'section'			=> 'passport_headline_section',
		    'settings'			=> 'passport_headline_sidebar_width',
		    'choices'			=> array(
				    'sidebar_25'    => esc_html__( 'Sidebar 25%', 'passport' ),
				    'sidebar_33'    => esc_html__( 'Sidebar 33%', 'passport' ),
	    ) ) );


	    //Home - Blog Layout
	    $wp_customize->add_section( 'passport_blog_layout' , array(
		    'title'				=> esc_html__( 'Blog / Archive / Template Layout','passport' ),
		    'priority'			=> 7,
		    'capability'		=> 'edit_theme_options',
		    'panel'				=> 'passport_layout',
	    ) );  


	    //Blog Main Content
	    $wp_customize->add_setting( 'passport_blog_main_content', array(
		    'default'			=> 'main_content',
		    'sanitize_callback' => 'passport_sanitize_main_content',
		    'transport'			=> 'refresh',
	    ) );

	    $wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'passport_blog_main_content', array(
		    'label'				=> esc_html__( 'Blog main content', 'passport' ),
		    'section'			=> 'passport_blog_layout',
		    'settings'			=> 'passport_blog_main_content',
		    'type'				=> 'radio',
		    'choices'			=> array(
				    'main_content'  => esc_html__( 'Main Content', 'passport' ),
				    'sidebar'	    => esc_html__( 'Sidebar', 'passport' ),
	    ), ) ) );

	
	    //Blog Sidebar Position
	    $wp_customize->add_setting( 'passport_blog_sidebar_position', array(
		    'default'			=> 'left',
		    'sanitize_callback' => 'passport_sanitize_sidebar_position',
		    'transport'			=> 'refresh',
	    ) );
 
	    $wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'passport_blog_sidebar_position', array(
		    'label'				=> esc_html__( 'Blog Sidebar Position', 'passport' ),
		    'section'			=> 'passport_blog_layout',
		    'settings'			=> 'passport_blog_sidebar_position',
		    'type'				=> 'radio',
		    'choices'			=> array(
				    'left'		    => esc_html__( 'left', 'passport' ),
				    'right'		    => esc_html__( 'right', 'passport' ),	
	    ), ) ) );


	    //Blog Sidebar Width
	    $wp_customize->add_setting( 'passport_blog_sidebar_width', array(
		    'default'			=> 'sidebar_25',
		    'sanitize_callback' => 'passport_sanitize_sidebar_width',
		    'transport'			=> 'refresh',
	    ) );
 
	    $wp_customize->add_control( 'passport_blog_sidebar_width', array(
		    'type'				=> 'select',
		    'label'				=> esc_html__( 'Blog Sidebar Width:', 'passport' ),
		    'section'			=> 'passport_blog_layout',
		    'settings'			=> 'passport_blog_sidebar_width',
		    'choices' => array(
			    'sidebar_25'		=> esc_html__( 'Sidebar 25%', 'passport' ),
			    'sidebar_33'		=> esc_html__( 'Sidebar 33%', 'passport' ),
	    ), ) );


	    //Page Layout
	    $wp_customize->add_section( 'passport_page_layout' , array(
		    'title'				=> esc_html__( 'Page Layout', 'passport' ),
		    'priority'			=> 8,
		    'capability'		=> 'edit_theme_options',
		    'panel'				=> 'passport_layout',
	    ) );  


	    //Page Main Content
	    $wp_customize->add_setting( 'passport_page_main_content', array(
		    'default'			=> 'main_content',
		    'sanitize_callback' => 'passport_sanitize_main_content',
		    'transport'			=> 'refresh',
	    ) );

	    $wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'passport_page_main_content', array(
		    'label'				=> esc_html__( 'Page main content', 'passport' ),
		    'section'			=> 'passport_page_layout',
		    'settings'			=> 'passport_page_main_content',
		    'type'				=> 'radio',
		    'choices'			=> array(
				    'main_content'		=> esc_html__( 'Main Content', 'passport' ),
				    'sidebar'			=> esc_html__( 'Sidebar', 'passport' ),
	    ), ) ) );


	    //Page Sidebar Position
	     $wp_customize->add_setting( 'passport_page_sidebar_position', array(
		    'default'			=> 'left',
		    'sanitize_callback' => 'passport_sanitize_sidebar_position',
		    'transport'			=> 'refresh',
	    ) );
 
	    $wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'passport_page_sidebar_position', array(
		    'label'				=> esc_html__( 'Page Sidebar Position', 'passport' ),
		    'section'			=> 'passport_page_layout',
		    'settings'			=> 'passport_page_sidebar_position',
		    'type'				=> 'radio',
		    'choices'			=> array(
				    'left'				=> esc_html__( 'left', 'passport' ),
				    'right'				=> esc_html__( 'right', 'passport' ),	
	    ), ) ) );


	    //Page Sidebar Width
	    $wp_customize->add_setting( 'passport_page_sidebar_width', array(
		    'default'			=> 'sidebar_25',
		    'sanitize_callback' => 'passport_sanitize_sidebar_width',
		    'transport'			=> 'refresh',
	    ) );
 
	    $wp_customize->add_control( 'passport_page_sidebar_width', array(
		    'type'				=> 'select',
		    'label'				=> esc_html__( 'Sidebar Width:', 'passport' ),
		    'section'			=> 'passport_page_layout',
		    'settings'			=> 'passport_page_sidebar_width',
		    'choices' => array(
			    'sidebar_25'		=> esc_html__( 'Sidebar 25%', 'passport' ),
			    'sidebar_33'		=> esc_html__( 'Sidebar 33%', 'passport' ),
	    ), ) );


	    //Post Page Layout
	    $wp_customize->add_section( 'passport_post_layout' , array(
		    'title'				=> esc_html__( 'Post Page Layout','passport' ),
		    'priority'			=> 9,
		    'capability'		=> 'edit_theme_options',
		    'panel'				=> 'passport_layout',
	    ) );  


	    //Post Main Content
	    $wp_customize->add_setting( 'passport_post_main_content', array(
		    'default'			=> 'main_content',
		    'sanitize_callback' => 'passport_sanitize_main_content',
		    'transport'			=> 'refresh',
	    ) );

	    $wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'passport_post_main_content', array(
		    'label'				=> esc_html__( 'Main content', 'passport' ),
		    'section'			=> 'passport_post_layout',
		    'settings'			=> 'passport_post_main_content',
		    'type'				=> 'radio',
		    'choices'			=> array(
			    'main_content'		=> esc_html__( 'Main Content', 'passport' ),
			    'sidebar'			=> esc_html__( 'Sidebar', 'passport' ),
	    ), ) ) );


	    //Post Sidebar Position
	    $wp_customize->add_setting( 'passport_post_sidebar_position', array(
		    'default'			=> 'left',
		    'sanitize_callback' => 'passport_sanitize_sidebar_position',
		    'transport'			=> 'refresh',
	    ) );
 
	    $wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'passport_post_sidebar_position', array(
		    'label'				=> esc_html__( 'Sidebar Position', 'passport' ),
		    'section'			=> 'passport_post_layout',
		    'settings'			=> 'passport_post_sidebar_position',
		    'type'				=> 'radio',
		    'choices'			=> array(
			    'left'				=> esc_html__( 'left', 'passport' ),
			    'right'				=> esc_html__( 'right', 'passport' ),	
	    ), ) ) );


	    //Post Sidebar Width
	    $wp_customize->add_setting( 'passport_post_sidebar_width', array(
		    'default'			=> 'sidebar_25',
		    'sanitize_callback' => 'passport_sanitize_sidebar_width',
		    'transport'			=> 'refresh',
	    ) );
 
	    $wp_customize->add_control( 'passport_post_sidebar_width', array(
		    'type'				=> 'select',
		    'label'				=> esc_html__( 'Sidebar Width:', 'passport' ),
		    'section'			=> 'passport_post_layout',
		    'settings'			=> 'passport_post_sidebar_width',
		    'choices'			=> array(
			    'sidebar_25'		=> esc_html__( 'Sidebar 25%', 'passport' ),
			    'sidebar_33'		=> esc_html__( 'Sidebar 33%', 'passport' ),
	    ), ) );


	    //Footer
	    $wp_customize->add_section( 'passport_footer' , array(
		    'title'				=> esc_html__( 'Footer','passport' ),
		    'priority'			=> 10,
		    'capability'		=> 'edit_theme_options',
		    'panel'				=> 'passport_layout',
	    ) );  


	    //Footer Column
	    $wp_customize->add_setting( 'passport_footer_column', array(
		    'default'			=> '3',
		    'sanitize_callback' => 'passport_sanitize_column',
		    'transport'			=> 'refresh',
	    ) );

	    $wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'passport_footer_column', array(
		    'label'				=> esc_html__( 'Footer Column', 'passport' ),
		    'section'			=> 'passport_footer',
		    'settings'			=> 'passport_footer_column',
		    'type'				=> 'select',
		    'choices'			=> array(
			    '1'		=> esc_html__( 'One Column', 'passport' ),
			    '2'		=> esc_html__( 'Two Column', 'passport' ),
			    '3'		=> esc_html__( 'Three Column', 'passport' ),
			    '4'		=> esc_html__( 'Four Column', 'passport' ),
	    ), ) ) );


	    //404
	    $wp_customize->add_section( 'passport_404_page' , array(
		    'title'				=> esc_html__( '404 Page','passport' ),
		    'priority'			=> 110,
		    'capability'		=> 'edit_theme_options',
	    ) );  


	    //Title 404
	    $wp_customize->add_setting( 'passport_title_404', array(
		    'default'			=> '',
		    'sanitize_callback' => 'passport_sanitize_text',
	    ) );
 
	    $wp_customize->add_control( 'passport_title_404', array(
		    'label'				=> esc_html__( 'Heading', 'passport' ),
		    'section'			=> 'passport_404_page',
		    'settings'			=> 'passport_title_404',
		    'type'				=> 'text',
            'input_attrs' => array(
                'placeholder' => esc_html__( '404 Page Not Found', 'passport' ),
            ),
	    ) );


	    //404 Image
	    $wp_customize->add_setting( 'passport_404_image', array(  
		    'default'			=> '',
		    'sanitize_callback' => 'esc_url_raw',
		    'type'				=> 'theme_mod',
	    ) );
	
	    $wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'passport_404_image', array(
		    'label'				=> esc_html__( '404 Image', 'passport' ),
		    'section'			=> 'passport_404_page',
		    'settings'			=> 'passport_404_image',
	    ) ) );

                
 	    //General Configuration
	    $wp_customize->add_panel( 'passport_general_config_panel', array(
		    'priority'			=> 200,
		    'title'				=> esc_html__( 'General Configuration', 'passport' ),
		    'capability'		=> 'edit_theme_options',
		    'description'		=> esc_html__( 'Change the configuartion as you want.', 'passport' )
	    ) );


	    //Theme Setting
	    $wp_customize->add_section( 'passport_theme_section', array(
		    'title'				=> esc_html__( 'Theme Setting', 'passport' ),
		    'priority'			=> 1,
		    'panel'				=> 'passport_general_config_panel',
	    ) );


	    //Theme Setting
	    $wp_customize->add_setting( 'passport_theme_setting', array(
		    'default'			=> 'full_width_container',
		    'sanitize_callback' => 'passport_sanitize_theme_setting',
		    'transport'			=> 'refresh',
	    ) );
 
	    $wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'passport_theme_setting', array(
		    'label'				=> esc_html__( 'Theme Setting', 'passport' ),
		    'section'			=> 'passport_theme_section',
		    'settings'			=> 'passport_theme_setting',
		    'type'				=> 'radio',
		    'choices'			=> array(
				    'full_width_container'	=> esc_html__( 'Full Container', 'passport' ),
				    'fix_width_container'	=> esc_html__( 'Fix Container', 'passport' ),
	    ) ) ) );


	    //Post page
	    $wp_customize->add_section( 'passport_post_page_config', array(
		    'title'				=> esc_html__( 'Post page', 'passport' ),
		    'priority'			=> 2,
		    'panel'				=> 'passport_general_config_panel',
	    ) );
       

        //Hide Author Section
	    $wp_customize->add_setting( 'passport_hide_author_section', array(
		    'sanitize_callback' => 'passport_sanitize_checkbox' 
	    ) );

	    $wp_customize->add_control( 'passport_hide_author_section', array(
            'type'				=> 'checkbox',
            'label'				=> esc_html__( 'Hide Author Section', 'passport' ),
            'section'			=> 'passport_post_page_config',
	    ) );


	    //Hide Related Posts Section
	    $wp_customize->add_setting( 'passport_hide_related_posts_section', array(
		    'sanitize_callback' => 'passport_sanitize_checkbox' 
	    ) );

	    $wp_customize->add_control( 'passport_hide_related_posts_section', array(
            'type'				=> 'checkbox',
            'label'				=> esc_html__( 'Hide Related Posts Section', 'passport' ),
            'section'			=> 'passport_post_page_config',
	    ) );


	    //Related Posts Text
	    $wp_customize->add_setting( 'passport_related_posts_title', array(
		    'default'			=> '',
		    'sanitize_callback' => 'passport_sanitize_text',
	    ) );
 
	    $wp_customize->add_control( 'passport_related_posts_title', array(
		    'label'				=> esc_html__( 'Related post title', 'passport' ),
		    'section'			=> 'passport_post_page_config',
		    'settings'			=> 'passport_related_posts_title',
		    'type'				=> 'text',
            'input_attrs' => array(
                'placeholder' => esc_html__( 'Related Posts', 'passport' ),
            ),
	    ) );


        //Button
	    $wp_customize->add_section( 'passport_button', array(
		    'title'				=> esc_html__( 'Button', 'passport' ),
		    'priority'			=> 3,
		    'panel'				=> 'passport_general_config_panel',
	    ) );


	    //Event Schedule
	    $wp_customize->add_setting( 'passport_button_text', array(
		    'default'			=> 'Read More',
		    'sanitize_callback' => 'passport_sanitize_text',
	    ) );
 
	    $wp_customize->add_control( 'passport_button_text', array(
		    'label'				=> esc_html__( 'Button text', 'passport' ),
		    'section'			=> 'passport_button',
		    'settings'			=> 'passport_button_text',
		    'type'				=> 'text',
            'input_attrs' => array(
                'placeholder' => esc_html__( 'Read More', 'passport' ),
            ),
	    ) );


        //Others
	    $wp_customize->add_section( 'passport_others', array(
		    'title'				=> esc_html__( 'Others', 'passport' ),
		    'priority'			=> 3,
		    'panel'				=> 'passport_general_config_panel',
	    ) );

        /* Sanitize function */
        function passport_sanitize_bg_opacity( $input ) {
	        $valid = array(
		        '0.1'	=> esc_html__( '10%', 'passport' ),
		        '0.2'	=> esc_html__( '20%', 'passport' ),
		        '0.3'	=> esc_html__( '30%', 'passport' ),
		        '0.4'	=> esc_html__( '40%', 'passport' ),
		        '0.5'	=> esc_html__( '50%', 'passport' ),
		        '0.6'	=> esc_html__( '60%', 'passport' ),			
		        '0.7'	=> esc_html__( '70%', 'passport' ),
		        '0.8'	=> esc_html__( '80%', 'passport' ),
		        '0.9'	=> esc_html__( '90%', 'passport' ),
		        '1.0'	=> esc_html__( '100%', 'passport' ),
	        );

	        if ( array_key_exists( $input, $valid ) ) {
		        return $input;
		        } else {
		        return '';
	        }
        }


        function passport_sanitize_theme_setting ( $input ) {
	        $valid = array(
		        'full_width_container'	=> 'Full Width Container',
		        'fix_width_container' 	=> 'Fix Width Container',
		        );
 
	        if ( array_key_exists( $input, $valid ) ) {
		        return $input;
		        } else {
		        return '';
	        }
        }


        function passport_sanitize_menu_image_alignment ( $input ) {
	        $valid = array(
		        'alignleft'			=> 'Left',
		        'alignright'		=> 'Right',
		        );
 
	        if ( array_key_exists( $input, $valid ) ) {
		        return $input;
		        } else {
		        return '';
	        }
        }


        function passport_sanitize_main_content ( $input ) {
	        $valid = array(
		        'main_content'		=> 'Main Content',
		        'sidebar'			=> 'Sidebar',  
		        );
 
	        if ( array_key_exists( $input, $valid ) ) {
		        return $input;
		        } else {
		        return '';
	        }
        }


        function passport_sanitize_sidebar_position ( $input ) {
	        $valid = array(
		        'left'				=> 'left',
		        'right'				=> 'right',  
		        );
 
	        if ( array_key_exists( $input, $valid ) ) {
		        return $input;
		        } else {
		        return '';
	        }
        }


        function passport_sanitize_sidebar_width ( $input ) {
	        $valid = array(
		        'sidebar_25'		=> 'Sidebar 25%',
		        'sidebar_33'		=> 'Sidebar 33%',
		        );
 
	        if ( array_key_exists( $input, $valid ) ) {
		        return $input;
		        } else {
		        return '';
	        }
        }


        function passport_sanitize_column ( $input ) {
	        $valid = array(
		        '1'					=> 'One Column',
		        '2'                 => 'Two Column',
		        '3'					=> 'Three Column',
		        '4'					=> 'Four Column',
		        );
 
	        if ( array_key_exists( $input, $valid ) ) {
		        return $input;
		        } else {
		        return '';
	        }
        }


        function passport_sanitize_text( $input ) {
            return wp_kses_post( force_balance_tags( $input ) );
        }


        function passport_sanitize_checkbox( $input ) {
	
	        if ( $input ) {
		        $output = '1';
	        } else {
		        $output = false;
	        }
	        return $output;
        }
    }
}
add_action( 'customize_register', 'passport_customize_register' );


/**
 * Output Customize CSS
 * -------------------------------------------------------------------------
 * Show output in WP inline style.
 * 
 * @since Passport 1.0
 *
 **/
if ( ! function_exists ( 'passport_customize_inline_style' ) ) {

    function passport_customize_inline_style() {

	    $passport_primary_color						=	get_theme_mod( 'passport_primary_color', '#ffffff' );
	    $passport_primary_font_color				=	get_theme_mod( 'passport_primary_font_color', '#1e6864' );
	    $passport_primary_bg_opacity				=	get_theme_mod( 'passport_primary_bg_opacity', '1.0' );
	    $passport_secondary_color					=	get_theme_mod( 'passport_secondary_color', '#1e6864' );
	    $passport_secondary_font_color				=	get_theme_mod( 'passport_secondary_font_color', '#ffffff' );
	    $passport_widget_bgcolor					=	get_theme_mod( 'passport_widget_bgcolor', '#ffffff' );
   	    $passport_widget_heading_color				=	get_theme_mod( 'passport_widget_heading_color', '#333333' );
	    $passport_hover_widget_bgcolor				=	get_theme_mod( 'passport_hover_widget_bgcolor', '#e7e7e7' );
	    $passport_hover_widget_font_color			=	get_theme_mod( 'passport_hover_widget_font_color', '#333333' );
	    $passport_post_bgcolor						=	get_theme_mod( 'passport_post_bgcolor', '#ffffff' );
	    $passport_author_bgcolor					=	get_theme_mod( 'passport_author_bgcolor', '#ffffff' );
	    $passport_related_posts_bgcolor				=	get_theme_mod( 'passport_related_posts_bgcolor', '#ffffff' );
	    $passport_comment_bgcolor					=	get_theme_mod( 'passport_comment_bgcolor', '#ffffff' );
	    $passport_horizontal_line_color				=	get_theme_mod( 'passport_horizontal_line_color', '#eeeeee' );
	    $passport_active_menu_bgcolor				=	get_theme_mod( 'passport_active_menu_bgcolor', '#ffffff' );
	    $passport_active_menu_font_color			=	get_theme_mod( 'passport_active_menu_font_color', '#1e6864' );
	    $passport_hover_menu_item_bgcolor			=	get_theme_mod( 'passport_hover_menu_item_bgcolor', '#ffffff' );
	    $passport_hover_menu_font_color				=	get_theme_mod( 'passport_hover_menu_font_color', '#ff8b2a' );
	    $passport_dropdown_menu_bgcolor				=	get_theme_mod( 'passport_dropdown_menu_bgcolor', '#fffffff' );
	    $passport_dropdown_menu_font_color			=	get_theme_mod( 'passport_dropdown_menu_font_color', '#1e6864' );
	    $passport_h1_color							=	get_theme_mod( 'passport_h1_color', '#333333' );
	    $passport_h2_color							=	get_theme_mod( 'passport_h2_color', '#333333' );
	    $passport_h3_color							=	get_theme_mod( 'passport_h3_color', '#333333' );
	    $passport_h4_color							=	get_theme_mod( 'passport_h4_color', '#333333' );
	    $passport_h5_color							=	get_theme_mod( 'passport_h5_color', '#333333' );
	    $passport_p_color							=	get_theme_mod( 'passport_p_color', '#333333' );
	    $passport_p_meta_color						=	get_theme_mod( 'passport_p_meta_color', '#999999' );
	    $passport_hover_p_meta_color				=	get_theme_mod( 'passport_hover_p_meta_color', '#1e6864' );
	    $passport_span_color						=	get_theme_mod( 'passport_span_color', '#333333' );
	    $passport_link_color						=	get_theme_mod( 'passport_link_color', '#1e6864' );
	    $passport_footer_bgcolor					=	get_theme_mod( 'passport_footer_bgcolor', '#dddddd' );
	    $passport_footer_heading_color				=	get_theme_mod( 'passport_footer_heading_color', '#333333' );
	    $passport_footer_p_color					=	get_theme_mod( 'passport_footer_p_color', '#333333' );
	    $passport_footer_meta_color					=	get_theme_mod( 'passport_footer_meta_color', '#a0a0a0' );
	    $passport_footer_span_color					=	get_theme_mod( 'passport_footer_span_color', '#a0a0a0' );
	    $passport_footer_hover_color				=	get_theme_mod( 'passport_footer_hover_color', '#eeeeee' );
	    $passport_footer_link_color					=	get_theme_mod( 'passport_footer_link_color', '#a0a0a0' );
	    $passport_button_color						=	get_theme_mod( 'passport_button_color', '#1e6864' );
	    $passport_button_border_color				=	get_theme_mod( 'passport_button_border_color', '#1e6864' );
	    $passport_button_link_color					=	get_theme_mod( 'passport_button_link_color', '#ffffff' );
	    $passport_hover_button_color				=	get_theme_mod( 'passport_hover_button_color', '#cccccc' );
	    $passport_hover_border_color				=	get_theme_mod( 'passport_hover_border_color', '#cccccc' );
	    $passport_hover_button_link_color			=	get_theme_mod( 'passport_hover_button_link_color', '#333333' );
	    $passport_slider_background_color			=	get_theme_mod( 'passport_slider_background_color', '#eeeeee' );
	    $passport_slider_text_color					=	get_theme_mod( 'passport_slider_text_color', '#333333' );
	    $passport_slider_excerpt_color				=	get_theme_mod( 'passport_slider_excerpt_color', '#333333' );
	    $passport_box_background_color				=	get_theme_mod( 'passport_box_background_color', '#eeeeee' );
	    $passport_box_text_color					=	get_theme_mod( 'passport_box_text_color', '#333333' );	
        $passport_box_excerpt_color					=	get_theme_mod( 'passport_box_excerpt_color', '#333333' );
	    $passport_sticky_label_color				=	get_theme_mod( 'passport_sticky_label_color', '#fae03c' );
	    $passport_sticky_text_color					=	get_theme_mod( 'passport_sticky_text_color', '#ffffff' );
        $passport_hide_box_shadow                   =   get_theme_mod( 'passport_hide_box_shadow', '' );

	    $custom_customize_css = '';

	    /*General Colors*/
	    if ( isset( $passport_primary_color) || isset( $passport_primary_font_color ) || isset( $passport_secondary_color ) || isset( $passport_secondary_font_color ) || $passport_primary_bg_opacity ) { 
		    //Theme Colors
		    //Primary Colors
		    $custom_customize_css .= ".navbar-default, .navbar-default .navbar-collapse, .navbar-default .navbar-nav > li > a, .navbar-default .navbar-nav > li > a:link, .navbar-default .navbar-nav > li > a:visited, .footer, .on-top {"; 
		    $custom_customize_css .= $passport_primary_color ? 'background-color:'. $passport_primary_color .';' :'';
		    $custom_customize_css .= $passport_primary_color ? 'border-color:'. $passport_primary_color .';' :'';
		    $custom_customize_css .= $passport_primary_font_color ? 'color:'. $passport_primary_font_color .';' :'';
		    $custom_customize_css .= "}";
		    $custom_customize_css .= "#primary-menu-bar.navbar-default {";
		    $custom_customize_css .= $passport_primary_bg_opacity ? 'opacity:'. $passport_primary_bg_opacity .';' :'';
		    $custom_customize_css .= "}";
		    $custom_customize_css .= ".navbar-default .navbar-nav > li > a > span, .navbar-default .navbar-nav > li > a:link > span, .navbar-default .navbar-nav > li > a:visited > span, .footer-widget-item .widget .footer-widget-title span, .footer-widget-item .widget .footer-widget-title span a, .menu-footer-menu-container > .navbar-nav > li > a {";
		    $custom_customize_css .= $passport_primary_color ? 'color:'.$passport_primary_font_color .';' :'';
		    $custom_customize_css .= "}";

		    //Secondary Colors
		    $custom_customize_css .= ".navbar-inverse, .widget-title, .owl-next, .owl-prev, #wp-calendar thead, .pagination > .active > a, .pagination > .active > span, .pagination > .active > a:hover, .pagination > .active > span:hover, .pagination > .active > a:focus, .pagination > .active > span:focus, .comment-edit-link, .breadcrumb, .nav-tabs > li.active > a.tab-title {";		
		    $custom_customize_css .= $passport_secondary_color ? 'background-color: '. $passport_secondary_color .';' :'';
		    $custom_customize_css .= "}";
		    $custom_customize_css .= ".navbar-inverse .navbar-nav > li > a, .widget-title span, .widget-title span a, .owl-next, .owl-prev .fa-chevron-up, #wp-calendar thead, #today a {"; 
		    $custom_customize_css .= $passport_secondary_font_color ? 'color: '. $passport_secondary_font_color .';' :'';
		    $custom_customize_css .= "}";
		    $custom_customize_css .= ".pagination > .active > a, .pagination > .active > span, .pagination > .active > a:hover, .pagination > .active > span:hover, .pagination > .active > a:focus, .pagination > .active > span:focus, .breadcrumb > li, .breadcrumb > li > a, .breadcrumb > li + li:before {"; 
		    $custom_customize_css .= $passport_secondary_font_color ? 'color: '. $passport_secondary_font_color .';' :'';
		    $custom_customize_css .= "}";
		    $custom_customize_css .= ".fa-paper-plane, .related-posts .post-title a, .comment-author .fn, .lightbox-target a.lightbox-close:hover, #wp-calendar caption, #wp-calendar td a {"; 
		    $custom_customize_css .= $passport_secondary_color ? 'color: '. $passport_secondary_color .';' :'';
		    $custom_customize_css .= "}";
		    $custom_customize_css .= ".related-posts-title, .comments, .comment-reply-title, .pagination > .active > a, .pagination > .active > span, .pagination > .active > a:hover, .pagination > .active > span:hover, .pagination > .active > a:focus, .pagination > .active > span:focus {";		
		    $custom_customize_css .= $passport_secondary_color ? 'border-color: '. $passport_secondary_color .';' :'';
		    $custom_customize_css .= "}";
		    $custom_customize_css .= ".commentlist .bypostauthor, .commentlist li ul.children li.bypostauthor {";		
		    $custom_customize_css .= $passport_secondary_color ? 'border-color: '. $passport_secondary_color .';' :'';
		    $custom_customize_css .= "}";
        }

        /*Widget Color*/
        if ( isset( $passport_widget_bgcolor ) || isset( $passport_widget_heading_color )  || isset( $passport_hover_widget_bgcolor ) || isset( $passport_hover_widget_font_color ) ) {
		    $custom_customize_css .= ".widget-post-item, .widget_archive li, .widget_categories li, .widget_meta li, .widget_pages li, .widget_nav_menu li, .widget_recent_comments li, .widget_recent_entries li, .widget_rss li, .widget_calendar, .widget_tag_cloud .tagcloud a, .widget_author .author-widget, full-width .widget.widget_column {"; 
		    $custom_customize_css .= $passport_widget_bgcolor ? 'background-color:'. $passport_widget_bgcolor .';' :'';
		    $custom_customize_css .= "}";
		    $custom_customize_css .= ".widget_categories li, .widget_categories li a, .widget_archive li a, .widget_meta li a, .widget_pages li a, .widget_nav_menu li a, .widget_recent_comments li a, .widget_recent_entries li a, .widget_rss li a, .widget_rss li span, .widget_rss li .rssSummary { "; 
		    $custom_customize_css .= $passport_widget_heading_color ? 'color:'. $passport_widget_heading_color .';' :'';
		    $custom_customize_css .= "}";
		    $custom_customize_css .= "#today, .link-pages .btn:hover, .pager li > a:hover, .pager li > a:focus, .widget_nav_menu li:hover, .widget_nav_menu li ul li:hover, .widget_archive li:hover, .widget_categories li:hover, .widget_categories li ul li:hover, .widget_pages li:hover, .widget_pages li ul li:hover, .widget_tag_cloud .tagcloud a:hover, .widget_meta li:hover, .widget_recent_comments li:hover, .widget_recent_entries li:hover, .widget_rss li:hover {"; 
		    $custom_customize_css .= $passport_hover_widget_bgcolor ? 'background-color: '. $passport_hover_widget_bgcolor .';' :'';
		    $custom_customize_css .= $passport_hover_widget_bgcolor ? 'border-color: '. $passport_hover_widget_bgcolor .';' :'';
		    $custom_customize_css .= "}";
		    $custom_customize_css .= "#today, .link-pages .btn:hover, .pager li > a:hover, .pager li > a:focus, .widget_nav_menu li:hover a, .widget_nav_menu li ul li:hover a, .widget_archive li:hover a, .widget_categories li:hover, .widget_categories li:hover a, .widget_categories li ul li:hover a, .widget_pages li:hover a, .widget_pages li ul li:hover a, .widget_tag_cloud .tagcloud a:hover, .widget_meta li:hover a, .widget_nav_menu li:hover a, .widget_recent_comments li:hover a, .widget_recent_entries li:hover a, .widget_rss li:hover a, .widget_rss li:hover span, .widget_rss li:hover .rssSummary, .widget_recent_comments li:hover .comment-author-link, .breadcrumb > li:hover > a {"; 
		    $custom_customize_css .= $passport_hover_widget_font_color ? 'color: '. $passport_hover_widget_font_color .';' :'';
		    $custom_customize_css .= "}";
        }
	
	    //Item Background Color    	
        if ( isset( $passport_post_bgcolor ) || isset( $passport_author_bgcolor )  || isset( $passport_related_posts_bgcolor ) || isset( $passport_comment_bgcolor ) || isset( $passport_horizontal_line_color ) ) { 
		    $custom_customize_css .= ".post-item, .page-item, .grid-item, .link-pages .btn, .pager li > a, .pager li > span {"; 
		    $custom_customize_css .= $passport_post_bgcolor ? 'background-color:'. $passport_post_bgcolor .';' :'';
		    $custom_customize_css .= "}";
		    $custom_customize_css .= ".author-post {"; 
		    $custom_customize_css .= $passport_author_bgcolor ? 'background-color:'. $passport_author_bgcolor .';' :'';
		    $custom_customize_css .= "}";
		    $custom_customize_css .= ".related-posts .post-item {"; 
		    $custom_customize_css .= $passport_related_posts_bgcolor ? 'background-color:'. $passport_related_posts_bgcolor .';' :'';
		    $custom_customize_css .= "}";
		    $custom_customize_css .= ".comment-form, .comment-reply-title {"; 
		    $custom_customize_css .= $passport_comment_bgcolor ? 'background-color:'. $passport_comment_bgcolor .';' :'';
		    $custom_customize_css .= "}";
		    $custom_customize_css .= ".page-header {"; 
		    $custom_customize_css .= $passport_horizontal_line_color ? 'border-bottom: 1px solid '. $passport_horizontal_line_color .';' :'';
		    $custom_customize_css .= "}";
		    $custom_customize_css .= "hr {"; 
		    $custom_customize_css .= $passport_horizontal_line_color ? 'border-top: 1px solid '. $passport_horizontal_line_color .';' :'';
		    $custom_customize_css .= "}";
	    }

	    /*Menu Colors*/
	    if ( isset( $passport_active_menu_bgcolor )  || isset(  $passport_hover_menu_item_bgcolor ) || isset( $passport_active_menu_font_color ) ) { 
		    /*Active Menu*/
            $custom_customize_css .= ".navbar-default .navbar-nav > li.active > a, .navbar-default .navbar-nav > li.active > a:focus, .navbar-default .navbar-nav > li.active > a > span, .navbar-default .navbar-nav > li.active > a:focus > span {"; 
		    $custom_customize_css .= $passport_active_menu_bgcolor ? 'background-color:'. $passport_active_menu_bgcolor .';' :'';
		    $custom_customize_css .= $passport_active_menu_font_color ? 'color:'. $passport_active_menu_font_color .';' :'';
		    $custom_customize_css .= "}";
		    $custom_customize_css .= ".navbar-default .navbar-nav > li.active > a:hover > span, .navbar-default .navbar-nav > li.active > a:focus > span {";
		    $custom_customize_css .= $passport_hover_menu_item_bgcolor ? 'background-color:'. $passport_hover_menu_item_bgcolor .';' :'';
		    $custom_customize_css .= $passport_hover_menu_item_bgcolor ? 'border-color:'. $passport_hover_menu_item_bgcolor .';' :'';    
		    $custom_customize_css .= $passport_hover_menu_font_color ? 'color:'. $passport_hover_menu_font_color .';' :'';
		    $custom_customize_css .= "}";
            /*Active and Dropdown*/
		    $custom_customize_css .= ".dropdown-menu > .active > a, .dropdown-menu > .active > a:hover, .dropdown-menu > .active > a:focus {"; 
		    $custom_customize_css .= $passport_active_menu_bgcolor ? 'background-color:'. $passport_active_menu_bgcolor .';' :'';
		    $custom_customize_css .= $passport_active_menu_font_color ? 'color:'. $passport_active_menu_font_color .';' :'';
		    $custom_customize_css .= "}";
            /*Hover, active and focus state*/
		    $custom_customize_css .= ".navbar-default .navbar-nav > li > a:hover, .navbar-default .navbar-nav > li > a:active, .dropdown-menu > li > a:hover, .dropdown-menu > li > a:active, .dropdown-menu > li > a:hover > span, .dropdown-menu > li > a:active > span, .navbar-default .navbar-nav .open .dropdown-menu > li > a:hover, .navbar-default .navbar-nav .open .dropdown-menu > li > a:focus, .navbar-default .navbar-nav > .active > a, .navbar-default .navbar-nav > .active > a:hover, .navbar-default .navbar-nav > .active > a:focus {"; 	
		    $custom_customize_css .= $passport_hover_menu_item_bgcolor ? 'background-color:'. $passport_hover_menu_item_bgcolor .';' :'';
		    $custom_customize_css .= $passport_hover_menu_item_bgcolor ? 'border-color:'. $passport_hover_menu_item_bgcolor .';' :'';
		    $custom_customize_css .= $passport_hover_menu_font_color ? 'color:'. $passport_hover_menu_font_color .';' :'';
		    $custom_customize_css .= "}";
		    $custom_customize_css .= ".navbar-default .navbar-nav > li > a:hover > span, .navbar-default .navbar-nav > li > a:focus > span {";
		    $custom_customize_css .= $passport_hover_menu_font_color ? 'color:'. $passport_hover_menu_font_color .';' :'';
		    $custom_customize_css .= "}";
            /*Open dropdown*/
		    $custom_customize_css .= ".navbar-default .navbar-nav > .open > a, .navbar-default .navbar-nav > .open > a:hover, .navbar-default .navbar-nav > .open > a:focus {";
		    $custom_customize_css .= $passport_hover_menu_item_bgcolor ? 'background-color:'. $passport_hover_menu_item_bgcolor .';' :'';
		    $custom_customize_css .= $passport_hover_menu_item_bgcolor ? 'border-color:'. $passport_hover_menu_item_bgcolor .';' :'';            
            $custom_customize_css .= $passport_hover_menu_font_color ? 'color:'. $passport_hover_menu_font_color .';' :'';
		    $custom_customize_css .= "}";
		    $custom_customize_css .= ".navbar-nav .open .dropdown-menu {"; 	
		    $custom_customize_css .= $passport_dropdown_menu_bgcolor ? 'background-color:'. $passport_dropdown_menu_bgcolor .';' :'';
		    $custom_customize_css .= "}";
		    $custom_customize_css .= ".dropdown-menu > li > a {";
		    $custom_customize_css .= $passport_dropdown_menu_font_color ? 'color:'. $passport_dropdown_menu_font_color .';' :'';
		    $custom_customize_css .= "}";	
        }

	    /*Heading and Paragraph Colors*/
	    if (isset( $passport_h1_color ) || isset( $passport_h2_color ) || isset( $passport_h3_color )  || isset( $passport_h4_color ) || isset( $passport_h5_color ) || isset( $passport_p_color ) || isset( $passport_p_meta_color ) ||  isset( $passport_hover_p_meta_color ) || isset( $passport_span_color ) || isset( $passport_link_color ) || isset( $passport_related_post_color ) ) { 
		    $custom_customize_css .= "h1 {"; 
		    $custom_customize_css .= $passport_h1_color ? 'color:'. $passport_h1_color .';' :'';
		    $custom_customize_css .= "}";
		    $custom_customize_css .= "h2 {"; 
		    $custom_customize_css .= $passport_h2_color ? 'color:'. $passport_h2_color .';' :'';
		    $custom_customize_css .= "}";
		    $custom_customize_css .= "h3 {"; 
		    $custom_customize_css .= $passport_h3_color ? 'color:'. $passport_h3_color .';' :'';
		    $custom_customize_css .= "}";
		    $custom_customize_css .= "h4, .widget h4.entry-title a {"; 
		    $custom_customize_css .= $passport_h4_color ? 'color:'. $passport_h4_color .';' :'';
		    $custom_customize_css .= "}";
		    $custom_customize_css .= "h5 {"; 
		    $custom_customize_css .= $passport_h5_color ? 'color:'. $passport_h5_color .';' :'';
		    $custom_customize_css .= "}";
		    $custom_customize_css .= "p, ins {"; 
		    $custom_customize_css .= $passport_p_color ? 'color:'. $passport_p_color .';' :'';
		    $custom_customize_css .= "}";
		    $custom_customize_css .= "p.post-info, .post-info, p.post-info a:link, p.post-info a:visited, p.post-info , del {"; 
		    $custom_customize_css .= $passport_p_meta_color ? 'color:'. $passport_p_meta_color .';' :'';
		    $custom_customize_css .= "}";
		    $custom_customize_css .= "p.post-info span:hover, p.post-info a:hover {"; 
		    $custom_customize_css .= $passport_hover_p_meta_color ? 'color:'. $passport_hover_p_meta_color .';' :'';
		    $custom_customize_css .= "}";
		    $custom_customize_css .= "span {"; 
		    $custom_customize_css .= $passport_span_color ? 'color:'. $passport_span_color .';' :'';
		    $custom_customize_css .= "}";
		    $custom_customize_css .= "a, a:link, a:visited, .pagination > li > a, .pagination > li > span { "; 
		    $custom_customize_css .= $passport_link_color ? 'color:'. $passport_link_color .';' :'';
		    $custom_customize_css .= "}";
		    $custom_customize_css .= ".progress-bar { "; 
		    $custom_customize_css .= $passport_link_color ? 'background-color:'. $passport_link_color .';' :'';
		    $custom_customize_css .= "}";
	    }

	    /*Footer Colors*/
	    if (isset( $passport_footer_bgcolor ) || isset( $passport_footer_heading_color ) || isset( $passport_footer_p_color ) || isset( $passport_footer_meta_color ) || isset( $passport_footer_span_color ) || isset( $passport_footer_link_color ) || isset( $passport_footer_hover_color ) ) { 
		    $custom_customize_css .= ".site-footer, .footer-widget-title {"; 
		    $custom_customize_css .= $passport_footer_bgcolor ? 'background-color: '. $passport_footer_bgcolor .';' :'';
		    $custom_customize_css .= "}";
            $custom_customize_css .= ".footer-widget-item .widget .entry-title, .footer-widget-item .widget h4.entry-title a {"; 
		    $custom_customize_css .= $passport_footer_heading_color ? 'color: '. $passport_footer_heading_color .';' :'';
		    $custom_customize_css .= "}";
		    $custom_customize_css .= ".footer-widget-item .widget p, .footer-widget-item .rssSummary {"; 
		    $custom_customize_css .= $passport_footer_p_color ? 'color: '. $passport_footer_p_color .';' :'';
		    $custom_customize_css .= "}";
		    $custom_customize_css .= ".footer-widget-item .widget p.post-info, .footer-widget-item .widget .post-info, .footer-widget-item .widget p.post-info a:link, .footer-widget-item .widget p.post-info a:visited, .footer-widget-item .widget p.post-info span, .footer-widget-item .widget .recentcomments, .footer-widget-title {"; 
		    $custom_customize_css .= $passport_footer_meta_color ? 'color: '. $passport_footer_meta_color .';' :'';
		    $custom_customize_css .= "}";
		    $custom_customize_css .= ".footer-widget-item .widget span, .footer-widget-item .widget.widget_recent_comments li span, .footer-widget-item .widget.widget_recent_entries li span {"; 
		    $custom_customize_css .= $passport_footer_span_color ? 'color: '. $passport_footer_span_color .';' :'';
		    $custom_customize_css .= "}";
		    $custom_customize_css .= ".footer-widget-item .widget a, .footer-widget-item .widget.widget_categories li, .footer-widget-item .widget.widget_categories li a, .footer-widget-item .widget.widget_archive li, .footer-widget-item .widget.widget_archive li a, .footer-widget-item .widget.widget_meta li a, .footer-widget-item .widget.widget_pages li a, 
    .footer-widget-item .widget.widget_nav_menu li a, .footer-widget-item .widget.widget_recent_comments li a, .footer-widget-item .widget.widget_recent_entries li a, .footer-widget-item .widget.widget_rss li a, .footer-widget-item .widget.widget_nav_menu ul li.active a, .footer-widget-item .widget.widget_nav_menu li:after, .footer-widget-item .widget.widget_categories ul li.active a {"; 
		    $custom_customize_css .= $passport_footer_link_color ? 'color: '. $passport_footer_link_color .';' :'';
		    $custom_customize_css .= "}";
		    $custom_customize_css .= ".footer-widget-item .widget.widget_archive li:hover, .footer-widget-item .widget.widget_categories li:hover, .footer-widget-item .widget.widget_archive li:hover a, .footer-widget-item .widget.widget_categories li:hover a, .footer-widget-item .widget.widget_meta li:hover a, .footer-widget-item .widget.widget_pages li:hover a, .footer-widget-item .widget.widget_nav_menu li:hover a, .footer-widget-item .widget.widget_nav_menu li ul li:hover a, .footer-widget-item .widget.widget_recent_comments li:hover a, .footer-widget-item .widget.widget_recent_entries li:hover a, .footer-widget-item .widget.widget_rss li:hover a, .footer-widget-item .widget.widget_tag_cloud .tagcloud a:hover, .footer-widget-item .widget.widget_categories li:hover ul.children li a, .footer-widget-item .widget.widget_categories li:hover ul.children li a:before, .footer-widget-item .widget.widget_categories li ul.children li:hover a, .footer-widget-item .widget.widget_categories li ul.children li:hover a:before, .footer-widget-item .widget.widget_categories li.active:hover a, .footer-widget-item .widget.widget_recent_comments li:hover span, .footer-widget-item .widget.widget_recent_entries li:hover span {";		
		    $custom_customize_css .= $passport_footer_hover_color ? 'color: '. $passport_footer_hover_color .';' :'';
		    $custom_customize_css .= "}";
	    }

	    /*Button Colors*/
	    if ( isset( $passport_button_color )|| isset( $passport_button_border_color ) || isset( $passport_button_link_color ) || isset( $passport_hover_button_color ) || isset( $passport_hover_border_color ) || isset( $passport_hover_button_link_color ) ) { 
		    $custom_customize_css .= ".btn-color, .btn-color:link, .btn-color:visited, .es_textbox_button, .comment-reply-link, .comment-logout, .es_textbox_button:link, .es_textbox_button:visited, button, input[type='button'], input[type='reset'], input[type='submit'], .back-to-top {"; 
		    $custom_customize_css .= $passport_button_color ? 'background-color:'. $passport_button_color .';' :'';
		    $custom_customize_css .= $passport_button_border_color ? 'border-color:'. $passport_button_border_color .';' :'';
		    $custom_customize_css .= $passport_button_link_color ? 'color:'. $passport_button_link_color .';' :'';
		    $custom_customize_css .= "}";
		    $custom_customize_css .= "a.btn-color, a.btn-color:link, a.btn-color:visited, a.comment-logout, a.comment-logout:link, a.comment-logout:visited, a.comment-edit-link, a.comment-edit-link:link, a.comment-edit-link:visited, a.back-to-top {"; 
		    $custom_customize_css .= $passport_button_link_color ? 'color:'. $passport_button_link_color .';' :'';
		    $custom_customize_css .= "}";
		    $custom_customize_css .= ".btn:hover, .btn-color:hover, .btn-color:link:hover, .btn-color:visited:hover, a.btn-color:hover, a.btn-color:link:hover, a.btn-color:visited:hover, a.comment-logout:hover, .es_textbox_button:hover, button:hover, input[type='button']:hover, input[type='reset']:hover, input[type='submit']:hover, a.back-to-top:hover {"; 
		    $custom_customize_css .= $passport_hover_button_color ? 'background-color:'. $passport_hover_button_color .';' :'';
		    $custom_customize_css .= $passport_hover_border_color ? 'border-color:'. $passport_hover_border_color .';' :'';
		    $custom_customize_css .= $passport_hover_button_link_color ? 'color:'. $passport_hover_button_link_color .';' :'';
		    $custom_customize_css .= "}";
	    }

	    /*Slider*/
	    if ( isset( $passport_slider_background_color )|| isset( $passport_slider_text_color ) || isset( $passport_box_background_color )|| isset( $passport_box_text_color ) ) { 
		    $custom_customize_css .= ".carousel-control .fa:before, .carousel-control .fa:link:before, .carousel-control .fa:visited:before, .carousel-control .fa:hover:before, .carousel-indicators li.active {"; 
		    $custom_customize_css .= $passport_slider_background_color ? 'background:'. $passport_slider_background_color .';' :'';
		    $custom_customize_css .= $passport_slider_text_color ? 'color:'. $passport_slider_text_color .';' :'';
		    $custom_customize_css .= "}";
            $custom_customize_css .= ".carousel-indicators li {"; 
		    $custom_customize_css .= $passport_slider_background_color ? 'border-color:'. $passport_slider_background_color .';' :'';
		    $custom_customize_css .= "}";
		    $custom_customize_css .= ".carousel-control .fa:before, .carousel-control .fa:link:before, .carousel-control .fa:visited:before, .carousel-control .fa:hover:before, .carousel-title a, .owl-carousel-slider .carousel-caption a {"; 
		    $custom_customize_css .= $passport_slider_text_color ? 'color:'. $passport_slider_text_color .';' :'';
		    $custom_customize_css .= "}";
		    $custom_customize_css .= ".carousel.gallery .carousel-excerpt p {"; 
		    $custom_customize_css .= $passport_slider_excerpt_color ? 'color:'. $passport_slider_excerpt_color .';' :'';
		    $custom_customize_css .= "}";
		    $custom_customize_css .= ".caption-background, .additional-info {"; 
		    $custom_customize_css .= $passport_slider_background_color ? 'background-color:'. $passport_slider_background_color .';' :'';
		    $custom_customize_css .= "}";
		    $custom_customize_css .= ".post-gallery .carousel-indicators .active {"; 
		    $custom_customize_css .= $passport_slider_background_color ? 'background-color:'. $passport_slider_background_color .';' :'';
		    $custom_customize_css .= "}";
		    $custom_customize_css .= ".post-gallery .carousel-indicators li {"; 
		    $custom_customize_css .= $passport_slider_background_color ? 'border-color:'. $passport_slider_background_color .';' :'';
		    $custom_customize_css .= "}";
		    $custom_customize_css .= ".box-item .caption-background {"; 
		    $custom_customize_css .= $passport_box_background_color ? 'background-color:'. $passport_box_background_color .';' :'';
		    $custom_customize_css .= "}";
		    $custom_customize_css .= ".widget_posts_in_box_format .box-caption a, .widget_posts_in_box_format .box-caption a:link, .widget_posts_in_box_format .box-caption a:visited, .widget_posts_in_box_format .box-caption p.post-info {"; 
		    $custom_customize_css .= $passport_box_text_color ? 'color:'. $passport_box_text_color .';' :'';
		    $custom_customize_css .= "}";
            $custom_customize_css .= ".box-item .caption-excerpt p {"; 
		    $custom_customize_css .= $passport_box_excerpt_color ? 'color:'. $passport_box_excerpt_color .';' :'';
		    $custom_customize_css .= "}";
	    }

        /*Box Shadow*/
	    if ( isset( $passport_sticky_label_color ) || isset( $passport_sticky_text_color ) ) { 
		    $custom_customize_css .= ".grid-item, .page-item, .post-item, .widget-post-item, .author-post, .related-posts-title, .related-posts .post-item, .comments, .comment-body, .comment-form, .comment-reply-title, .breadcrumb, .pager li > a, .pager li > span, .widget-title, .widget_archive ul, .widget_meta ul, .widget_pages ul, .widget_nav_menu ul, .widget_recent_comments ul, .widget_recent_entries ul, .widget_rss ul, .widget_calendar, .widget_tag_cloud .tagcloud a, .navbar-default, ul.dropdown-menu {"; 
		    $custom_customize_css .= $passport_hide_box_shadow ? 'box-shadow: none' : 'box-shadow: 0 1px 6px rgba( 0, 0, 0, 0.1);';
		    $custom_customize_css .= "}";
	    }

	    /*Sticky Label*/
	    if ( isset( $passport_sticky_label_color ) || isset( $passport_sticky_text_color ) ) { 
		    $custom_customize_css .= ".sticky .ribbon {"; 
		    $custom_customize_css .= $passport_sticky_label_color ? 'background-color:'. $passport_sticky_label_color .';' :'';
		    $custom_customize_css .= $passport_sticky_text_color ? 'color:'. $passport_sticky_text_color .';' :'';
		    $custom_customize_css .= "}";
	    }

	    wp_add_inline_style( PASSPORT_THEME_SLUG . '-custom-style', $custom_customize_css );
    }

}
add_action( 'wp_enqueue_scripts', 'passport_customize_inline_style' );


/**
 * Change the default of theme customizer function
 * -------------------------------------------------------------------------
 * Change the default title name and position in theme customizer.
 * 
 * @since Passport 1.0
 *
 **/
if ( ! function_exists ( 'passport_customize_register_init' ) ) {

    function passport_customize_register_init( $wp_customize ){
        // Any Customizer-changing code goes here
	    $wp_customize->get_section( 'colors' )->panel = esc_html__( 'passport_theme_colors_panel', 'passport' );
   	    $wp_customize->get_section( 'colors' )->title = esc_html__( 'General Color', 'passport' );
        $wp_customize->get_section( 'colors' )->priority = 1;
        $wp_customize->get_section( 'header_image' )->priority = 31;
	    $wp_customize->get_section( 'background_image' )->priority = 35;
    }

}
add_action( 'customize_register', 'passport_customize_register_init' );


/**
 * Styles the header text or brand name displayed on the blog
 * ------------------------------------------------------------------------
 *
 * @since Passport 1.0 
 * @see passport_custom_header_setup().
 *
 **/
if( ! function_exists( 'passport_header_style' ) ) {

    function passport_header_style() {
	    $header_textcolor  = get_header_textcolor();
	    $custom_header_css = '';

	    if ( display_header_text() ) {

	    $custom_header_css .= ".site-title a {";
	    $custom_header_css .= isset( $header_textcolor ) ? 'color:#'. $header_textcolor .';' : 'color: #1e6864;';
	    $custom_header_css .= "}";
	    $custom_header_css .= ".site-description {";
	    $custom_header_css .= isset( $header_textcolor ) ? 'color:#'. $header_textcolor .';' : 'color: #1e6864;';
	    $custom_header_css .= "}";
	    $custom_header_css .= ".navbar-default .navbar-toggle .icon-bar {";
	    $custom_header_css .= isset( $header_textcolor ) ? 'background-color:#'. $header_textcolor .';' : '';
	    $custom_header_css .= "}";

	    } elseif ( ! display_header_text() ) {

	    $custom_header_css .= ".navbar-brand {";
	    $custom_header_css .= "display: block;";
	    $custom_header_css .= "position: relative;";
	    $custom_header_css .= "}";
	
	    }
	    wp_add_inline_style( PASSPORT_THEME_SLUG . '-custom-style', $custom_header_css );
    }

}
add_action( 'wp_enqueue_scripts', 'passport_header_style' );