<?php
/**
 * Add text input in profile function
 * -------------------------------------------------------------------------
 * Add social media text input in the profile page.
 *
 * @since Passport 1.0 
 *
 **/
if ( ! function_exists ( 'passport_add_to_author_profile' ) ) {

    function passport_add_to_author_profile( $contactmethods ) {

		    $contactmethods['facebook_profile']	 = 'Facebook Profile URL';
		    $contactmethods['twitter_profile']	 = 'Twitter Profile URL'; 
		    $contactmethods['google_profile']	 = 'Google Profile URL';
		    $contactmethods['instagram_profile'] = 'Instagram Profile URL';
		    $contactmethods['linkedin_profile']	 = 'Linkedin Profile URL';
    
	    return $contactmethods;
    }

}
add_filter( 'user_contactmethods', 'passport_add_to_author_profile', 10, 1 );


/**
 * Author social media function.
 * -------------------------------------------------------------------------
 * Get the author meta and put it in html.
 *
 * @since Passport 1.0 
 *
 **/
if ( ! function_exists ( 'passport_author_social_media' ) ) {

    function passport_author_social_media() {
	
	    $user_email = get_the_author_meta( 'user_email' );
	    if ( $user_email && $user_email != '' ) {
		    echo '<div class="social"><a href="mailto:' . antispambot( $user_email ) . '" rel="author" aria-label="Mail"><i class="fa fa-envelope-square" aria-hidden="true"></i></a></div>';
	    }

	    $facebook_profile = get_the_author_meta( 'facebook_profile' );
	    if ( $facebook_profile != '' ) {
		    echo '<div class="social"><a href="' . esc_url( $facebook_profile ) . '" rel="author" aria-label="Facebook"><i class="fa fa-facebook-square" aria-hidden="true"></i></a></div>';
	    }

	    $twitter_profile = get_the_author_meta( 'twitter_profile' );
	    if ( $twitter_profile != '' ) {
		    echo '<div class="social"><a href="' . esc_url( $twitter_profile ) . '" rel="author" aria-label="Twitter"><i class="fa fa-twitter-square" aria-hidden="true"></i></a></div>';
	    }

	    $google_profile = get_the_author_meta( 'google_profile' );
	    if ( $google_profile != '' ) {
		    echo '<div class="social"><a href="' . esc_url( $google_profile ) . '" rel="author"  aria-label="Google Plus"><i class="fa fa-google-plus-square" aria-hidden="true"></i></a></div>';
	    }

	    $instagram_profile = get_the_author_meta( 'instagram_profile' );
	    if ( $instagram_profile != '' ) {
		    echo '<div class="social"><a href="' . esc_url( $instagram_profile ) . '" rel="author" aria-label="Instagram"><i class="fa fa-instagram" aria-hidden="true"></i></a></div>';
	    }

	    $linkedin_profile = get_the_author_meta( 'linkedin_profile' );
	    if ( $linkedin_profile != '' ) {
		    echo '<div class="social"><a href="' . esc_url( $linkedin_profile ) . '" rel="author" aria-label="LinkedIn"><i class="fa fa-linkedin-square" aria-hidden="true"></i></a></div>';
	    }
    }
}


/**
 * Show social media function.
 * -------------------------------------------------------------------------
 * Show social media on single and page
 *
 * @since Passport 1.0 
 *
 **/
if ( ! function_exists ( 'passport_show_social_share' ) ) {

    function passport_show_social_share() { 

        if ( is_single() || is_page() ) : ?>
            <!-- Button trigger modal -->
            <a href="#social-modal" data-toggle="modal" class="small"><i class="fa fa-paper-plane fa-2x"></i></a>
            <!-- Modal -->
            <div class="modal fade" id="social-modal" tabindex="-1" role="dialog" aria-labelledby="social-modal">
	            <div class="modal-dialog" role="document">
		            <div class="modal-social">
			            <div class="modal-body">
				            <?php echo passport_author_social_media(); ?>
			            </div>
		            </div>
	            </div>
            </div>
            <?php 
        endif;
    }
}