<?php
/**
 * 
 * Aside post format function
 * -------------------------------------------------------------------------
 *
 * @package WordPress
 * @subpackage passport
 * @since Passport 1.0
 *
 **/
if ( ! function_exists ( 'passport_display_aside_post_format' ) ) {

    function passport_display_aside_post_format() {
  
    global $passport_template_name;

	$html				= NULL;
	$aside_description	= get_post_meta( get_the_ID(), 'as_desc', true );
	$aside_author		= get_post_meta( get_the_ID(), 'as_author', true );

    if( 'template-masonry.php' == $passport_template_name ) : ?>
        <div class="flip-container">
	        <div class="flipper">
		        <div class="front">
			        <!-- front content -->
                    <?php echo passport_display_image(); ?>
		        </div>
		        <div class="back">
			        <!-- back content -->
                    <div class="overlay">
                        <div class="post-group">
	                        <div class="post-group-cell">
                                <?php passport_icon_shows(); ?>	
                                <p class="detail"><?php if ( ! empty( $aside_description ) ) { echo esc_textarea( $aside_description ); } ?></p>
                                <div class="author small right">
	                                <span class="mini-meta"><?php echo $aside_author; ?></span>
                                </div>
                                <div class="bgcolor"></div>
                            </div>
	                    </div>
	                </div>
	            </div>
	        </div>
	    </div>
        <?php else: ?>
            <?php echo passport_display_image(); ?>
	        <div class="overlay">
	            <div class="post-group">
	                <div class="post-group-cell">
                        <div class="post-group-row">
                            <?php passport_icon_shows(); ?>
	                        <p class="detail"><?php if ( ! empty( $aside_description ) ) { echo esc_html( $aside_description ); } ?></p>
                            <div class="author small right">
	                            <span class="mini-meta"><?php echo $aside_author; ?></span>
                            </div>
                        </div>
	                </div>
	            </div>
            </div>
    <?php endif;
    }
}


/**
 * 
 * Link post format function
 * -------------------------------------------------------------------------
 *
 * @package WordPress
 * @subpackage passport
 * @since Passport 1.0
 *
 **/
if ( ! function_exists ( 'passport_display_link_post_format' ) ) {
    
    function passport_display_link_post_format() {
	    
        global $passport_template_name;

	    $link				= NULL;
	    $html				= NULL;

	    $link_title			= get_post_meta( get_the_ID(), 'l_title', true );
	    $link_url			= get_post_meta( get_the_ID(), 'l_url', true );
	    $link_desc			= get_post_meta( get_the_ID(), 'l_desc', true );

	    $link	= '<a href= "'. esc_url( $link_url ) .'"><span>'. $link_desc .'</span><header>'. $link_title .'</header></a>';

         if( 'template-masonry.php' == $passport_template_name ) : ?>
        <div class="flip-container">
	        <div class="flipper">
		        <div class="front">
			        <!-- front content -->
                    <?php echo passport_display_image(); ?>
		        </div>
		        <div class="back">
			        <!-- back content -->
                    <div class="overlay">
                        <div class="post-group">
	                        <div class="post-group-cell">
                                <?php passport_icon_shows(); ?>	
                                <div class="link-text">
	                                <?php if ( ! empty( $link_title ) && ! empty ( $link ) ) { echo $link; } ?>
	                            </div>
                            </div>
	                    </div>
	                </div>
	            </div>
	        </div>
	    </div>
        <?php else: 
        passport_display_image(); ?>
	    <div class="overlay">
	        <div class="post-group">
                <div class="post-group-cell">
                    <div class="post-group-row">
                        <?php passport_icon_shows(); ?>
	                    <div class="link-text">
	                        <?php if ( ! empty( $link_title ) && ! empty ( $link ) ) { echo $link; } ?>
	                    </div>
                    </div>
                </div>
	        </div>
	    </div>
        <?php endif; 
    }
}


/**
 * 
 * Quote post format function
 * -------------------------------------------------------------------------
 *
 * @package WordPress
 * @subpackage passport
 * @since Passport 1.0
 *
 **/
if ( ! function_exists ( 'passport_display_quote_post_format' ) ) {

    function passport_display_quote_post_format() {

    global $passport_template_name;

    $html				= NULL;
    $quote_description	= get_post_meta( get_the_ID(), 'q_desc', true );
    $quote_author		= get_post_meta( get_the_ID(), 'q_author', true );
    $quote_photo		= get_post_meta( get_the_ID(), 'q_media', true );

    if( 'template-masonry.php' == $passport_template_name ) : ?>
        <div class="flip-container">
	        <div class="flipper">
		        <div class="front">
			        <!-- front content -->
                    <?php echo passport_display_image(); ?>
		        </div>
		        <div class="back">
			        <!-- back content -->
                    <div class="overlay">
                        <div class="post-group">
	                        <div class="post-group-cell">
                                <?php passport_icon_shows(); ?>	
                                <div class="author">
                                    <div class="quote-photo"></div>
                                    <span class="mini-meta"><?php echo $quote_author; ?></span>
                                    <blockquote>
                                        <span class="big-quote"><?php if ( ! empty( $quote_description ) ) { echo $quote_description; } ?></span>
                                    </blockquote>
                                </div>
                            </div>
	                    </div>
	                </div>
	            </div>
	        </div>
	    </div>
        <?php else: ?>
        <?php echo passport_display_image(); ?>
	    <div class="overlay">
	        <div class="post-group">
                <div class="post-group-cell">
                    <div class="post-group-row">
                        <?php passport_icon_shows(); ?>
                        <div class="author">
                            <div class="quote-photo"></div>
                            <span class="mini-meta"><?php echo $quote_author; ?></span>
                        </div>
	                    <blockquote>
	                        <span class="big-quote"><?php echo $quote_description; ?></span>
	                    </blockquote>
                    </div>
	            </div>
            </div>
        </div>
    <?php endif; 
    }
}


/**
 * 
 * Image post format function
 * ------------------------------------------------------------------------
 *
 * @package WordPress
 * @subpackage passport
 * @since Passport 1.0
 *
 **/
if ( ! function_exists ( 'passport_display_image_post_format' ) ) {

    function passport_display_image_post_format() {

    global $passport_template_name;

    if( 'template-masonry.php' == $passport_template_name  ) : ?>
        <div class="flip-container">
	        <div class="flipper">
		        <div class="front">
			        <!-- front content -->
                    <?php echo passport_display_image(); ?>
		        </div>
		        <div class="back">
			        <!-- back content -->
                    <div class="overlay">
                        <div class="post-group">
	                        <div class="post-group-cell">
                                <?php passport_icon_shows(); ?>
                                <h5 class="caption-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h5>
				                <div class="caption-excerpt"><?php echo passport_excerpt( '25' ); ?></div>
                            </div>
	                    </div>
	                </div>
	            </div>
	        </div>
	    </div>
    <?php else: ?>
    <div class="post-image">
        <figure>
	        <a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>">
		        <?php passport_display_image(); ?>
		    </a>
            <figcaption class="caption">
                <?php passport_icon_shows(); ?>
                <?php if ( is_front_page() && is_home() || is_front_page() ) : ?><!-- Default homepage, Static homepage -->
		            <h4 class="caption-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
				    <div class="caption-excerpt"><?php echo passport_excerpt( '25' ); ?></div>
                <?php elseif( is_single() || is_page() ) : ?><!-- Single -->
		            <h3 class="caption-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
				    <div class="caption-excerpt"><?php echo passport_excerpt( '30' ); ?></div>
                <?php elseif ( 'template-large-image.php' == $passport_template_name ) : ?><!-- Large image template -->
		            <h3 class="caption-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
				    <div class="caption-excerpt"><?php echo passport_excerpt( '32' ); ?></div>
                <?php elseif ( 'template-masonry.php' == $passport_template_name ) : ?><!-- Masonry template -->
		            <h4 class="caption-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
				    <div class="small caption-excerpt"><?php echo passport_excerpt( '15' ); ?></div>
                <?php elseif ( 'template-medium-image.php' == $passport_template_name || is_archive() || is_search() ) : ?><!-- Medium image template, Archives, Searches, Categories, Tags -->
 		            <h4 class="caption-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
				    <div class="caption-excerpt"><?php echo passport_excerpt( '18' ); ?></div>
                <?php elseif( is_home() || is_blog() ) : ?>
		            <h4 class="caption-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4><!-- blog page -->
				    <div class="caption-excerpt"><?php echo passport_excerpt( '25' ); ?></div>      
                <?php else : ?>
		            <h3 class="caption-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3><!-- Others -->
				    <div class="caption-excerpt"><?php echo passport_excerpt( '32' ); ?></div>     
				<?php endif; ?>
			</figcaption>
        </figure>
        <div class="caption-background"></div>
    </div>
    <?php endif;
    }
}


/**
 * 
 * Gallery post format function
 * -------------------------------------------------------------------------
 * Choose the proper gallery post format
 *
 * @package WordPress
 * @subpackage passport
 * @since Passport 1.0
 *
 **/
if ( ! function_exists ( 'passport_display_gallery_post_format' ) ) {

    function passport_display_gallery_post_format() {
        $gallery_type   = get_post_meta( get_the_ID(), 'g_type', true );    
        
        switch ( $gallery_type ) { //Start the switch
		    default:
				
		    case ( "column" ): // Column
			    echo passport_display_column_gallery_post_format();
		    break;
				
		    case ( "grid" ): // Grid
			    echo passport_display_grid_gallery_post_format(); 
		    break;
				
		    case ( "slider" ): // Slider
			    echo passport_display_slides_gallery_post_format();
			break; 
        }
    }
}


/**
 * 
 * Column - Gallery post format function
 * -------------------------------------------------------------------------
 * Use gallery shortcode to display in column format.
 *
 * @package WordPress
 * @subpackage passport
 * @since Passport 1.0
 *
 **/
if ( ! function_exists ( 'passport_display_column_gallery_post_format' ) ) {

    function passport_display_column_gallery_post_format() {
	    global $passport_template_name;
        global $passport_section_settings;

	    $gallery_ids	  = get_post_meta( get_the_ID(), 'g_ids', true ); 
	    $gallery_column	  = get_post_meta( get_the_ID(), 'g_column', true );
        $gallery_link	  = get_post_meta( get_the_ID(), 'g_link', true );
	
	    $gallery_ids	  = wp_filter_nohtml_kses( $gallery_ids ); 

	    // Gallery column shortcode configuration
	    if( 'template-masonry.php' == $passport_template_name ) {
		    //Image Size
		    $image_size = 'masonry-template-550-550';
	    } else {
		    if( 5 == $gallery_column ) {
			    $image_size = 'gallery-228-300';
		    } elseif( 4 == $gallery_column ) {
			    $image_size = 'gallery-285-300';
		    } elseif( 3 == $gallery_column ) {
			    $image_size = 'gallery-380-300';
		    } elseif( 2 == $gallery_column ) {
			    $image_size = 'gallery-570-300';
		    } elseif( 1 == $gallery_column ) {
			    $image_size = 'large-image';
		    }
	    }
   
	    if( ! empty( $gallery_ids ) ) : ?>

	        <?php
			    $gallery_shortcode = '[gallery ids="' . $gallery_ids . '" size="' . $image_size . '" columns="' . $gallery_column . '"  link="' . $gallery_link . '"]';
			    echo do_shortcode( $gallery_shortcode );
		    ?>
	    <?php endif; 
    }
}


/**
 * 
 * Grid post format function
 * -------------------------------------------------------------------------
 * Use Masonry of Bootstrap to do in grid format.
 *
 * @package WordPress
 * @subpackage passport
 * @since Passport 1.0
 *
 * @Ref site: http://masonry.desandro.com/
 * 
 **/
if ( ! function_exists ( 'passport_display_grid_from_gallery' ) ) {

    function passport_display_grid_from_gallery() {
	    global $passport_template_name;

        $i  = 0;
	    $html			    = NULL;
	    $gallery_ids	    = get_post_meta( get_the_ID(), 'g_ids', true );
        $gallery_grid_type  = get_post_meta( get_the_ID(), 'g_grid_type', true );
	    $attachment_ids     = explode( ",", $gallery_ids );

	    foreach( $attachment_ids as &$attachment_id ) :
		    $alt		= get_post_meta( $attachment_id, '_wp_attachment_image_alt', true );
	
    	    $caption	= get_post( $attachment_id )->post_excerpt;
    	    $img		= wp_get_attachment_url( $attachment_id );
            $img_masonry= wp_get_attachment_image_src( $attachment_id, 'masonry-template-550-550' );

		    if( 'template-masonry.php' == $passport_template_name ) : ?>
                <div class="frame">
		            <figure class="gallery-item bglayer">			
                        <img src="<?php echo esc_url( $img_masonry[0] ); ?>" width="<?php echo $img_masonry[1]; ?>" height="<?php echo $img_masonry[2]; ?>" class="hvr-grow wp-post-image" alt="<?php echo esc_attr( $alt ) ?>" />
                        <figcaption class="wp-caption-text gallery-caption"><?php echo $caption; ?></figcaption>
                    </figure>
                </div>
		    <?php else : ?>
			    <div class="grid-item <?php if( $i % $gallery_grid_type == 0 ) { echo 'grid-item--width2 '; } ?>">
	                <figure class="gallery-item bglayer">
			            <img src="<?php echo esc_url( $img ); ?>" class="hvr-grow wp-post-image" alt="<?php echo esc_attr( $alt ) ?>" />
			            <figcaption class="wp-caption-text gallery-caption"><?php echo $caption; ?></figcaption>
                    </figure>
			    </div>
		    <?php endif;
            $i++;
	    endforeach;     
    }
}

if ( ! function_exists ( 'passport_display_grid_gallery_post_format' ) ) {
    
    function passport_display_grid_gallery_post_format() { 
    ?>
	    <div class="grid">
	        <div class="grid-sizer"></div>
	        <div class="gutter-sizer"></div>
	        <?php echo passport_display_grid_from_gallery(); ?>
	    </div>
    <?php 
    }
}


/**
 * 
 * Slider post format function
 * -------------------------------------------------------------------------
 *
 * @package WordPress
 * @subpackage passport
 * @since Passport 1.0
 *
 **/
if ( ! function_exists ( 'passport_display_slides_gallery_post_format' ) ) {
 
    function passport_display_slides_gallery_post_format() { 
	    global $passport_template_name;

	    $i					= 0;
	    $image_attributes	= NULL;
	    $id					= get_the_ID();
	    $gallery_ids		= get_post_meta( get_the_ID(), 'g_ids', true );
	    $attachment_ids		= explode( ",", $gallery_ids );
	    $gallery_height		= get_post_meta( get_the_ID(), 'g_height', true );
	    $size				= 'template-masonry.php' == $passport_template_name ? 'masonry-template-550-550' : 'large-image';
	    ?>
        <div id="carousel-generic-<?php echo $id; ?>" class="carousel slide" data-ride="carousel">
		    <!-- Indicators -->
			<ol class="carousel-indicators">
			    <?php  
				    foreach( $attachment_ids as &$attachment_id ) :	?>
					    <li data-target="#carousel-generic-<?php echo $id; ?>" data-slide-to="<?php echo $i; ?>" class=""></li>
				    <?php $i++;
 				    endforeach;
                ?>
		    </ol>
            <?php passport_icon_shows(); ?>
			<div class="a carousel-inner" role="listbox">
		        <?php  
				    foreach( $attachment_ids as &$attachment_id ) :
					    $image_attributes	= wp_get_attachment_image_src( $attachment_id, $size );
					    $alts				= get_post_meta( $attachment_id, '_wp_attachment_image_alt', true );
					    $caption			= get_post( $attachment_id )->post_excerpt; ?>
					    <div class="item">
						    <?php if( ! empty ( $image_attributes ) ) : ?>
                                <figure>
							        <img src="<?php echo esc_url( $image_attributes[0] ); ?>" width="<?php echo $image_attributes[1]; ?>" height="<?php echo $image_attributes[2]; ?>" class="wp-post-image" alt="<?php echo esc_attr( $alts );  ?>">
							    </figure>
                                <div class = "wp-caption-text carousel-caption"><?php echo $caption; ?></div>
						    <?php endif; ?>
					    </div>
			    <?php $i++; 
			        endforeach;
                ?>
		    </div>
		    <!-- Controls -->
		    <a class="left carousel-control hvr-sweep-to-left" href="#carousel-generic-<?php echo $id; ?>" role="button" data-slide="prev" aria-label="Previous Slide"><i class="fa fa-angle-left" aria-hidden="true"></i></a>
		    <a class="right carousel-control hvr-sweep-to-right" href="#carousel-generic-<?php echo $id; ?>" role="button" data-slide="next" aria-label="Next Slide"><i class="fa fa-angle-right" aria-hidden="true"></i></a>
	    </div>
    <?php
    }
}


/**
 * 
 * Audio post format function
 * -------------------------------------------------------------------------
 * @since Passport 1.0 
 *
 **/
if ( ! function_exists ( 'passport_display_audio_post_format' ) ) {

    function passport_display_audio_post_format() {
	    global $passport_template_name;

	    $html				= NULL;
	    $audio_image_url	= NULL;
	    $audio_select		= get_post_meta( get_the_ID(), 'a_select', true );	
	    $audio_music_by		= get_post_meta( get_the_ID(), 'a_reference', true );

	    //Audio Embed
	    $audio_embed	    =  get_post_meta( get_the_ID(), 'a_embed', true );
	    $audio_embed	    = ! empty( $audio_embed ) ? $audio_embed : '';
	
	    //Audio URL
	    $audio_url			= get_post_meta( get_the_ID(), 'a_url', true );
	    $audio_url			= ! empty( $audio_url ) ? $audio_url : '';

	    $attr = array(
		    'src'			=> esc_url( $audio_url ),
		    'loop'			=> '',
		    'autoplay'		=> '',
		    'preload'		=> 'none'
	    );

	    if ( 'audio_url' == $audio_select ) :
            echo passport_display_image();
            echo wp_audio_shortcode( $attr ); ?>
	        <div class="overlay">
	            <div class="post-group">
	                <div class="corner">
                        <span class="credit"><?php passport_icon_shows(); ?> <?php echo $audio_music_by; ?></span>
	                </div>
	            </div>
	        </div>
	    <?php elseif ( 'audio_embed_code' == $audio_select ) :
		    echo $audio_embed;
	    endif;
    }
}


/**
 * 
 * Video post format function
 * -------------------------------------------------------------------------
 *
 * @package WordPress
 * @subpackage passport
 * @since Passport 1.0
 *
 **/
if ( ! function_exists ( 'passport_display_video_post_format' ) ) {

    function passport_display_video_post_format() {
	    global $passport_template_name;

	    $html	      = NULL;
	    $video_select = get_post_meta( get_the_ID(), 'v_select', true );

	    //Video Embed
	    $video_embed  = get_post_meta( get_the_ID(), 'v_embed', true );

	    //Video URL
	    $video_url    = get_post_meta( get_the_ID(), 'v_url', true );
	    $video_url	  = ! empty( $video_url ) ? esc_url( $video_url ) : '';
	    $width		  = 'blog-masonry.php' == $passport_template_name ? '276px' : ( "template-medium-image.php" == $passport_template_name || is_search() || is_archive() ? '570px' : '1366px' );
	    $height		  = 'blog-masonry.php' == $passport_template_name ? '276px' : ( "template-medium-image.php" == $passport_template_name || is_search() || is_archive() ? '301px' : '768px' );
        $poster       = wp_get_attachment_image_src( get_post_thumbnail_id(), 'poster' );

	    $attr = array(
		    'src'			=> $video_url,
            'poster'        => $poster['0'],
		    'loop'			=> '',
		    'autoplay'		=> '',
            'preload'       => 'auto',
		    'width'			=> $width,
	        'height'		=> $height,
	    );

	    if ( 'video_embed_code' == $video_select ) : ?> <!-- Video Embmed Code --> 
		    <div class="embed-responsive embed-responsive-16by9">
		        <?php if ( ! empty( $video_embed ) ) { echo  $video_embed; } ?>
		    </div>	
	    <?php	
	    elseif ( 'video_url' == $video_select ) : ?> <!-- Video URL -->
		    <div class="embed-responsive  embed-responsive-16by9">
		        <?php if ( ! empty( $video_url ) ) { echo wp_video_shortcode( $attr ); } ?>
		    </div>
        <?php	
        endif;
    }
} 