<?php
/**
 * Setup the WordPress Metabox.
 * -------------------------------------------------------------------------
 * Setup the Post and Page metabox 
 *
 * @package WordPress
 * @subpackage passport
 * @since Passport 1.0
 *
 **/

$metaboxes = array(
	/*Post Metabox*/
	'aside_setting' => array(
		'title' => esc_html__( 'Aside Post Format', 'passport' ),
		'applicableto' => 'post',
		'location' => 'normal',
		'display_condition' => 'post-format-aside',
		'priority' => 'low',
		'fields' => array(
			'as_active' => array(
				'label'=> esc_html__( 'Aside Active Checkbox', 'passport' ),
				'desc' => esc_html__( 'Click on to active aside format.', 'passport' ),				
				'type' => 'checkbox',
			),
			'as_no_content' => array(
				'label'=> esc_html__( 'Do not show any content', 'passport' ),
				'desc' => esc_html__( 'Check this checkbox if you do not want to show the title, meta, and content.', 'passport' ),
				'type' => 'checkbox',
			),
			'as_desc' => array(
				'label'=> esc_html__( 'Description', 'passport' ),
				'desc' => esc_html__( 'Please fill your aside description.', 'passport' ),
				'type' => 'textarea',
			),
			'as_author' => array(
				'label'=> esc_html__( 'Author Name: ', 'passport' ),
				'desc' => '',	
				'type' => 'text',
				'size' => 30,
			),
			'as_color' => array(
				'label'=> esc_html__( 'Font Color', 'passport' ),
				'desc' => esc_html__( 'Please choose font color.', 'passport' ),
				'type' => 'colorpicker',
				'value' => '#333333',
			),
			'as_bgcolor' => array(
				'label'=> esc_html__( 'Backgrond Color', 'passport' ),
				'desc' => esc_html__( 'Please choose Aside background color.', 'passport' ),
				'type' => 'colorpicker',
				'value' => '#eeeeee',
			),
		)
	),
	'link_setting' => array(
		'title' => esc_html__( 'Link Post Format', 'passport' ),
		'applicableto' => 'post',
		'location' => 'normal',
		'display_condition' => 'post-format-link',
		'priority' => 'low',
		'fields' => array(
			'l_active' => array(
				'label'=> esc_html__( 'Link Active', 'passport' ),	
				'desc' => esc_html__( 'Click on to active link format.', 'passport' ),					
				'type' => 'checkbox',
			),
			'l_no_content' => array(
				'label'=> esc_html__( 'Do not show any content.', 'passport' ),
				'desc' => esc_html__( 'Check this checkbox if you do not want to show the title, meta, and content.', 'passport' ),
				'type' => 'checkbox',
			),
			'l_title' => array(
				'label'=> esc_html__( 'Title : ', 'passport' ),
				'type' => 'text',
				'desc' => esc_html__( 'Your title link', 'passport' ),
				'size' => 30,
			),
			'l_desc' => array(
				'label'=> esc_html__( 'Description', 'passport' ),
				'desc' => esc_html__( 'Fill your description.', 'passport' ),
				'type' => 'textarea',
			),
			'l_url' => array(
				'label'=> esc_html__( 'Link URL: ', 'passport' ),
				'desc' => esc_html__( 'Your URL that you would like to link.', 'passport' ),
				'type' => 'text',
				'size' => 60,
			),
			'l_font' => array(
				'label'=> esc_html__( 'Title Font Size (px): ', 'passport' ),
				'desc' => esc_html__( 'For example: 50', 'passport' ),
				'type' => 'text',
				'size' => 3,
			),
			'l_span_font' => array(
				'label'=> esc_html__( 'Description Font Size (px): ', 'passport' ),
				'desc' => esc_html__( 'For example: 16', 'passport' ),
				'type' => 'text',
				'size' => 3,
			),
			'l_color' => array(
				'label'=> esc_html__( 'Title Color', 'passport' ),
				'desc' => esc_html__( 'Please choose text color.', 'passport' ),
				'type' => 'colorpicker',
				'value' => '#ffffff',
			),
			'l_span_color' => array(
				'label'=> esc_html__( 'Description Color', 'passport' ),
				'desc' => esc_html__( 'Please choose text color.', 'passport' ),
				'type' => 'colorpicker',
				'value' => '#3a3231',
			),
           	'l_text_align' => array(
				'label'=> esc_html__( 'Text Alignment: ', 'passport' ),
				'desc' => esc_html__( 'Setting the text alignment.', 'passport' ),
				'type' => 'select',
				'size' => 30,
				'options' => array (					
					'left' => array (
						'label' => esc_html__( 'Left', 'passport' ),
						'value' => 'left',
					),
					'right' => array (
						'label' => esc_html__( 'Right', 'passport' ),
						'value' => 'right',
					),
					'center' => array (
						'label' => esc_html__( 'Center', 'passport' ),
						'value' => 'center',
					),
				)
			),	
		)
	),
	'quote_setting' => array(
		'title' => esc_html__( 'Quote Post Format', 'passport' ),
		'applicableto' => 'post',
		'location' => 'normal',
		'display_condition' => 'post-format-quote',
		'priority' => 'low',
		'fields' => array(
			'q_active' => array(
				'label'=> esc_html__( 'Quote Active', 'passport' ),
				'desc' => esc_html__( 'Click on to active quote format.', 'passport' ),
				'type' => 'checkbox',
			),
			'q_no_content' => array(
				'label'=> esc_html__( 'Do not show any content.', 'passport' ),
				'desc' => esc_html__( 'Check this checkbox if you do not want to show the title, meta, and content.', 'passport' ),
				'type' => 'checkbox',
			),
			'q_desc' => array(
				'label'=> esc_html__( 'Quote Description', 'passport' ),
				'desc' => esc_html__( 'Dropcap example: <code>&lt;span class="dropcap"&gt;L&lt;/span&gt;</code>', 'passport' ),
				'type' => 'textarea',
			),
            'q_media' => array(
				'label'=> esc_html__( 'Author Photo', 'passport' ),
				'desc' => esc_html__( 'Upload an author photo.', 'passport' ),
				'type' => 'upload',
				'value' => '',
			),
			'q_author' => array(
				'label'=> esc_html__( 'Author Name: ', 'passport' ),
				'desc' => '',	
				'type' => 'text',
				'size' => 30
			),
            'q_color' => array(
				'label'=> esc_html__( 'Font Color', 'passport' ),
				'desc' => esc_html__( 'Please choose Quote font color.', 'passport' ),
				'type' => 'colorpicker',
				'value' => '#333333',
			),
            'q_bgcolor' => array(
				'label'=> esc_html__( 'Background Color', 'passport' ),
				'desc' => esc_html__( 'Please choose Quote background color.', 'passport' ),
				'type' => 'colorpicker',
				'value' => '#eeeeee',
			),
		)
	),
	'image_setting' => array(
		'title' => esc_html__( 'Image Post Format', 'passport' ),
		'applicableto' => 'post',
		'location' => 'normal',
		'display_condition' => 'post-format-image',
		'priority' => 'low',
		'fields' => array(
			'i_active' => array(
				'label'=> esc_html__( 'Image Active', 'passport' ),
				'desc' => esc_html__( 'Click on to active image format.', 'passport' ),				
				'type' => 'checkbox',
			),
			'i_no_content' => array(
				'label'=> esc_html__( 'Do not show any content.', 'passport' ),
				'desc' => esc_html__( 'Check this checkbox if you do not want to show the title, meta, and content.', 'passport' ),	
				'type' => 'checkbox',
			),
			'i_color' => array(
				'label'=> esc_html__( 'Font Color', 'passport' ),
				'desc' => esc_html__( 'Please choose Image font color.', 'passport' ),
				'type' => 'colorpicker',
				'value' => '#333333',
			),
            'i_bgcolor' => array(
				'label'=> esc_html__( 'Caption Background Color', 'passport' ),
				'desc' => esc_html__( 'Please choose Image caption background color.', 'passport' ),
				'type' => 'colorpicker',
				'value' => '#eeeeee',
			),
			'i_picture' => array(
				'label'=> esc_html__( 'Photographer | Supported By : ', 'passport' ),
				'desc' => '',
				'type' => 'textarea',
			),
		)
	),
	'gallery_setting' => array(
		'title' => esc_html__( 'Gallery Post Format', 'passport' ),
		'applicableto' => 'post',
		'location' => 'normal',
		'display_condition' => 'post-format-gallery',
		'priority' => 'low',
		'fields' => array(
			'g_active' => array(
				'label'=> esc_html__( 'Gallery Active', 'passport' ),
				'desc' => esc_html__( 'Click on to active gallery format.', 'passport' ),
				'type' => 'checkbox',
			),
			'g_no_content' => array(
				'label'=> esc_html__( 'Do not show any content.', 'passport' ),
				'desc' => esc_html__( 'Check this checkbox if you do not want to show the title, meta, and content.', 'passport' ),
				'type' => 'checkbox',
			),
			'g_ids' => array(
				'label'=> esc_html__( 'Gallery IDs: ', 'passport' ),
				'desc' => esc_html__( 'Please fill you Gallery IDs, for example: 174, 175, 177.', 'passport' ),
				'type' => 'textarea',
			),
			'g_type' => array(
				'label'=> esc_html__( 'Type of Gallery: ', 'passport' ),
				'desc' => '',
				'type' => 'select',
				'size' => 30,
				'options' => array (
					'one' => array (
						'label' => esc_html__( 'Column', 'passport' ),
						'value' => 'column',
					),
					'two' => array (
						'label' => esc_html__( 'Grid', 'passport' ),
						'value' => 'grid',
					),
					'three' => array (
						'label' => esc_html__( 'Slider', 'passport' ),
						'value' => 'slider',
					),
				)
			),
            'g_color' => array(
				'label'=> esc_html__( 'Hover Font Color', 'passport' ),
				'desc' => esc_html__( 'Please choose gallery font color in hover state.', 'passport' ),
				'type' => 'colorpicker',
				'value' => '#333333',
			),
            'g_bgcolor' => array(
				'label'=> esc_html__( 'Hover Background Color', 'passport' ),
				'desc' => esc_html__( 'Please choose gallery background color in hover state.', 'passport' ),
				'type' => 'colorpicker',
				'value' => '#eeeeee',
			),
			// HEADING -  Not used but needed for plugin
			'g_columnh' => array(
				'label' => '',
				'desc' => '',
				'type' => 'heading', 
				'name' => esc_html__( 'Column Section', 'passport' ),
			),
			'g_column' => array(
				'label'=> esc_html__( 'No. of Column ', 'passport' ),
				'desc' => '',
				'type' => 'select',
				'size' => 30,
				'options' => array (
					'one' => array (
						'label' => esc_html__( '1', 'passport' ),
						'value' => '1',
					),
					'two' => array (
						'label' => esc_html__( '2', 'passport' ),
						'value' => '2',
					),
					'three' => array (
						'label' => esc_html__( '3', 'passport' ),
						'value' => '3',
					),
					'four' => array (
						'label' => esc_html__( '4', 'passport' ),
						'value' => '4',
					),
					'five' => array (
						'label' => esc_html__( '5', 'passport' ),
						'value' => '5',
					),
				)
			),
			'g_link' => array(
				'label'=> esc_html__( 'Link to ', 'passport' ),
				'desc' => '',
				'type' => 'select',
				'size' => 30,
				'options' => array (
					'attachment' => array (
						'label' => esc_html__( 'Attachment Page', 'passport' ),
                        'value' => '',
					),
					'media' => array (
						'label' => esc_html__( 'Media', 'passport' ),
						'value' => 'file',
					),
					'none' => array (
						'label' => esc_html__( 'None', 'passport' ),
						'value' => 'none',
					),
				)
			),
			// HEADING -  Not used but needed for plugin
			'g_grid' => array(
				'label'=> '',
				'desc' => '',
				'type' => 'heading', 
				'name' => esc_html__( 'Grid Section', 'passport' ),
			),
			'g_grid_type' => array(
				'label'=> esc_html__( 'Type ', 'passport' ),
				'desc' => esc_html__( 'Choose the grid type', 'passport' ),
				'type' => 'select',
				'size' => 30,
				'options' => array (
					'attachment' => array (
						'label' => esc_html__( 'Type 1', 'passport' ),
						'value' => '3',
					),
					'media' => array (
						'label' => esc_html__( 'Type 2', 'passport' ),
						'value' => '4',
					),
					'none' => array (
						'label' => esc_html__( 'Type 3', 'passport' ),
						'value' => '5',
					),
				)
			),
		)
	),
	'audio_setting' => array(
		'title' => esc_html__( 'Audio Post Format', 'passport' ),
		'applicableto' => 'post',
		'location' => 'normal',
		'display_condition' => 'post-format-audio',
		'priority' => 'low',
		'fields' => array(
			'a_active' => array(
				'label'=> esc_html__( 'Audio Active Checkbox', 'passport' ),
				'desc' => esc_html__( 'Click on to active audio format.', 'passport' ),
				'type' => 'checkbox',
				'value' => 'on',
			),
			'a_no_content' => array(
				'label'=> esc_html__( 'Do not show any content.', 'passport' ),	
				'desc' => esc_html__( 'Check this checkbox if you do not want to show the title, meta, and content.', 'passport' ),	
				'type' => 'checkbox',
			),
			'a_reference' => array(
				'label'=> esc_html__( 'Reference: ', 'passport' ),
				'desc' => '',
				'type' => 'textarea',
			),
			'a_select' => array(
				'label'=> esc_html__( 'Select Audio Type', 'passport' ),
				'desc' => '',
                'type' => 'select',
				'size' => '30',
				'options' => array (
					'embed' => array (
						'label' => esc_html__( 'Audio Embed Code', 'passport' ),
						'value' => 'audio_embed_code',
					),
					'shortcode' => array (
						'label' => esc_html__( 'Audio URL', 'passport' ),
						'value' => 'audio_url',
					),
				)
			),
            'a_bgcolor' => array(
				'label'=> esc_html__( 'Media Element Color', 'passport' ),
				'desc' => esc_html__( 'Please choose media element color.', 'passport' ),
				'type' => 'colorpicker',
				'value' => '#eeeeee',
			),
			// HEADING -  Not used but needed for plugin
			'a_embedh' => array(
				'label' => '',
				'desc' => '',
				'type' => 'heading', 
				'name' => esc_html__( 'Audio Embed Section', 'passport' ),
			),
			'a_embed' => array(
				'label'=> esc_html__( 'Audio Embed Code: ', 'passport' ),
				'desc' => '',
				'type' => 'textarea',
			),
			// HEADING -  Not used but needed for plugin
			'a_urls' => array(
				'label' => '',
				'desc' => '',
				'type' => 'heading', 
				'name' => esc_html__( 'Audio URL Section', 'passport' ),
			),
			'a_url' => array(
				'label'=> esc_html__( 'Audio URL: ', 'passport' ),
    			'desc' => esc_html__( 'Please fill you Audio URL. Default supported audio formats are: mp3, ogg, wma, m4a, wav.', 'passport' ),
				'type' => 'textarea',
	    	),
		)
	),
	'video_setting' => array(
		'title' => esc_html__( 'Video Post Fortmat', 'passport' ),
		'applicableto' => 'post',
		'location' => 'normal',
		'display_condition' => 'post-format-video',
		'priority' => 'low',
		'fields' => array(				
			'v_active' => array(
				'label'=> esc_html__( 'Video Active', 'passport' ),
				'desc' => esc_html__( 'Click on to active video format.', 'passport' ),
				'type' => 'checkbox',
			),
			'v_no_content' => array(
				'label'=> esc_html__( 'Do not show any content.', 'passport' ),
				'desc' => esc_html__( 'Check this checkbox if you do not want to show the title, meta, and content.', 'passport' ),
				'type' => 'checkbox',
			),
			'v_film' => array(
				'label'=> esc_html__( 'A Film By : ', 'passport' ),
				'desc' => '',
				'type' => 'textarea',
			),
			'v_select' => array(
				'label'=> esc_html__( 'Select Video Type', 'passport' ),
				'desc' => '',
				'type' => 'select',
				'size' => '30',
				'options' => array (
					'shortcode ids' => array (
						'label' => esc_html__( 'Video URL', 'passport' ),
						'value' => 'video_url',
					),
					'embed' => array (
						'label' => esc_html__( 'Video Embed Code', 'passport' ),
						'value' => 'video_embed_code',
					),
				)
			),
			// HEADING -  Not used but needed for plugin
			'v_embedh' => array(
				'label' => '',
				'desc' => '',
				'type' => 'heading', 
				'name' => esc_html__( 'Video Embed Section', 'passport' ),
			),
			'v_embed' => array(
				'label'=> esc_html__( 'Video Embed Code', 'passport' ),
				'desc' => esc_html__( 'Please fill your Video Embed Code', 'passport' ),
				'type' => 'textarea',
			),
			// HEADING -  Not used but needed for plugin
			'v_idsh' => array(
				'label' => '',
				'desc' => '',
				'type' => 'heading', 
				'name' => esc_html__( 'Video URLs Section', 'passport' ),
			),
			'v_url' => array(
				'label'=> esc_html__( 'Video URL: ', 'passport' ),
				'desc' => esc_html__( 'Please fill you video URL. Default supported video formats are: mp4, m4v, webm, ogv, wmv, flv.', 'passport' ),
				'type' => 'textarea',
			),
		)
	),
	/*Page Metabox*/
	'large_setting' => array(
		'title'				=> esc_html__( 'Large Image Template', 'passport' ),
		'applicableto'		=> 'page',
		'location'			=> 'normal',
		'display_condition' => 'template-large-image.php',
		'priority'			=> 'low',
		'fields'			=> array(
			'la_term_active' => array(
				'label'				=> esc_html__( 'Show the specific post format', 'passport' ),
				'desc'				=> esc_html__( 'Check this checkbox if you would like to show only the specific post format.', 'passport' ),
				'type'				=> 'checkbox',
			),
			'la_page_post_format' => array(
				'label'				=> esc_html__( 'Post Format: ', 'passport' ),
				'desc'				=> 'Please select the post format.',
				'type'				=> 'select',
				'size'				=> 30,
				'options' => array (
					'format aside'		=> array (
						'label'			=> esc_html__( 'Post Format Aside', 'passport' ),
						'value'			=> 'post-format-aside',
					),
					'format link'		=> array (
						'label'			=> esc_html__( 'Post Format Link', 'passport' ),
						'value'			=> 'post-format-link',
					),
					'format quote'		=> array (
						'label'			=> esc_html__( 'Post Format Quote', 'passport' ),
						'value'			=> 'post-format-quote',
					),
					'format image'		=> array (
						'label'			=> esc_html__( 'Post Format Image', 'passport' ),
						'value'			=> 'post-format-image',
					),
					'format gallery'	=> array (
						'label'			=> esc_html__( 'Post Format Gallery', 'passport' ),
						'value'			=> 'post-format-gallery',
					),
					'format audio'		=> array (
						'label'			=> esc_html__( 'Post Format Audio', 'passport' ),
						'value'			=> 'post-format-audio',
					),
					'format video'		=> array (
						'label'			=> esc_html__( 'Post Format Video', 'passport' ),
						'value'			=> 'post-format-video',
					)
				)
			),
			'la_exclude' => array(
				'label'=> esc_html__( 'Exclude IDs', 'passport' ),
				'desc' => esc_html__( 'Exclude unwanted ids. For example: 2444, 2304, 2408', 'passport' ),
				'type' => 'textarea',
			),
			'la_order_by'			=> array(
				'label'				=> esc_html__( 'Order By: ', 'passport' ),
				'desc'				=> '',
				'type'				=> 'select',
				'size'				=> 30,
				'options'			=> array (
					'none'				=> array (
						'label'			=> esc_html__( 'None', 'passport' ),
						'value'			=> 'none',
					),
					'date'				=> array (
						'label'			=> esc_html__( 'Date', 'passport' ),
						'value'			=> 'date',
					),
					'author'			=> array (
						'label'			=> esc_html__( 'Author', 'passport' ),
						'value'			=> 'author',
					),
					'title'				=> array (
						'label'			=> esc_html__( 'Title', 'passport' ),
						'value'			=> 'title',
					),
					'name'				=> array (
						'label'			=> esc_html__( 'Name', 'passport' ),
						'value'			=> 'name',
					),
					'type'				=> array (
						'label'			=> esc_html__( 'Type', 'passport' ),
						'value'			=> 'type',
					),
					'modified'			=> array (
						'label'			=> esc_html__( 'Modified', 'passport' ),
						'value'			=> 'modified',
					),
					'rand'				=> array (
						'label'			=> esc_html__( 'Rand', 'passport' ),
						'value'			=> 'rand',
					),
				)
			),
			'la_order' => array(
				'label'				=> esc_html__( 'Order: ', 'passport' ),
				'desc'				=> '',
				'type'				=> 'select',
				'size'				=> 30,
				'options'			=> array (
					'asc'				=> array (
						'label'			=> esc_html__( 'ASC', 'passport' ),
						'value'			=> 'asc',
					),
					'date' => array (
						'label'			=> esc_html__( 'DESC', 'passport' ),
						'value'			=> 'desc',
					),
				)
			),
		)
	),
	'masonry_setting' => array(
		'title' => esc_html__( 'Masonry Image Template', 'passport' ),
		'applicableto' => 'page',
		'location' => 'normal',
		'display_condition' => 'template-masonry.php',
		'priority' => 'low',
		'fields' => array(
			'ma_term_active' => array(
				'label'				=> esc_html__( 'Show the specific post format', 'passport' ),
				'desc'				=> esc_html__( 'Check this checkbox if you would like to show only the specific post format..', 'passport' ),
				'type'				=> 'checkbox',
			),
			'ma_page_post_format' => array(
				'label'				=> esc_html__( 'Post Format: ', 'passport' ),
				'desc'				=> 'Please select the post format.',
				'type'				=> 'select',
				'size'				=> 30,
				'options' => array (
					'format aside'		=> array (
						'label'			=> esc_html__( 'Post Format Aside', 'passport' ),
						'value'			=> 'post-format-aside',
					),
					'format link'		=> array (
						'label'			=> esc_html__( 'Post Format Link', 'passport' ),
						'value'			=> 'post-format-link',
					),
					'format quote'		=> array (
						'label'			=> esc_html__( 'Post Format Quote', 'passport' ),
						'value'			=> 'post-format-quote',
					),
					'format image'		=> array (
						'label'			=> esc_html__( 'Post Format Image', 'passport' ),
						'value'			=> 'post-format-image',
					),
					'format gallery'	=> array (
						'label'			=> esc_html__( 'Post Format Gallery', 'passport' ),
						'value'			=> 'post-format-gallery',
					),
					'format audio'		=> array (
						'label'			=> esc_html__( 'Post Format Audio', 'passport' ),
						'value'			=> 'post-format-audio',
					),
					'format video'		=> array (
						'label'			=> esc_html__( 'Post Format Video', 'passport' ),
						'value'			=> 'post-format-video',
					)
				)
			),
			'ma_exclude' => array(
				'label'=> esc_html__( 'Exclude IDs', 'passport' ),
				'desc' => esc_html__( 'Exclude unwanted ids. For example: 2444, 2304, 2408', 'passport' ),
				'type' => 'textarea',
			),
			'ma_order_by' => array(
				'label'				=> esc_html__( 'Order By: ', 'passport' ),
				'desc'				=> '',
				'type'				=> 'select',
				'size'				=> 30,
				'options'			=> array (
					'none'				=> array (
						'label'			=> esc_html__( 'None', 'passport' ),
						'value'			=> 'none',
					),
					'date'				=> array (
						'label'			=> esc_html__( 'Date', 'passport' ),
						'value'			=> 'date',
					),
					'author'			=> array (
						'label'			=> esc_html__( 'Author', 'passport' ),
						'value'			=> 'author',
					),
					'title'				=> array (
						'label'			=> esc_html__( 'Title', 'passport' ),
						'value'			=> 'title',
					),
					'name'				=> array (
						'label'			=> esc_html__( 'Name', 'passport' ),
						'value'			=> 'name',
					),
					'type'				=> array (
						'label'			=> esc_html__( 'Type', 'passport' ),
						'value'			=> 'type',
					),
					'modified'			=> array (
						'label'			=> esc_html__( 'Modified', 'passport' ),
						'value'			=> 'modified',
					),
					'rand'				=> array (
						'label'			=> esc_html__( 'Rand', 'passport' ),
						'value'			=> 'rand',
					),
				)
			),
			'ma_order' => array(
				'label'				=> esc_html__( 'Order: ', 'passport' ),
				'desc'				=> '',
				'type'				=> 'select',
				'size'				=> 30,
				'options'			=> array (
					'asc'				=> array (
						'label'			=> esc_html__( 'ASC', 'passport' ),
						'value'			=> 'asc',
					),
					'date' => array (
						'label'			=> esc_html__( 'DESC', 'passport' ),
						'value'			=> 'desc',
					),
				)
			),
		)
	),
	'medium_setting' => array(
		'title' => esc_html__( 'Medium Image Template', 'passport' ),
		'applicableto' => 'page',
		'location' => 'normal',
		'display_condition' => 'template-medium-image.php',
		'priority' => 'low',
		'fields' => array(
			'me_term_active' => array(
				'label'				=> esc_html__( 'Show the specific post format', 'passport' ),
				'desc'				=> esc_html__( 'Check this checkbox if you would like to show only the specific post format..', 'passport' ),
				'type'				=> 'checkbox',
			),
			'me_page_post_format' => array(
				'label'				=> esc_html__( 'Post Format: ', 'passport' ),
				'desc'				=> 'Please select the post format.',
				'type'				=> 'select',
				'size'				=> 30,
				'options' => array (
					'format aside'		=> array (
						'label'			=> esc_html__( 'Post Format Aside', 'passport' ),
						'value'			=> 'post-format-aside',
					),
					'format link'		=> array (
						'label'			=> esc_html__( 'Post Format Link', 'passport' ),
						'value'			=> 'post-format-link',
					),
					'format quote'		=> array (
						'label'			=> esc_html__( 'Post Format Quote', 'passport' ),
						'value'			=> 'post-format-quote',
					),
					'format image'		=> array (
						'label'			=> esc_html__( 'Post Format Image', 'passport' ),
						'value'			=> 'post-format-image',
					),
					'format gallery'	=> array (
						'label'			=> esc_html__( 'Post Format Gallery', 'passport' ),
						'value'			=> 'post-format-gallery',
					),
					'format audio'		=> array (
						'label'			=> esc_html__( 'Post Format Audio', 'passport' ),
						'value'			=> 'post-format-audio',
					),
					'format video'		=> array (
						'label'			=> esc_html__( 'Post Format Video', 'passport' ),
						'value'			=> 'post-format-video',
					)
				)
			),
			'me_exclude' => array(
				'label'=> esc_html__( 'Exclude IDs', 'passport' ),
				'desc' => esc_html__( 'Exclude unwanted ids. For example: 2444, 2304, 2408', 'passport' ),
				'type' => 'textarea',
			),
			'me_order_by' => array(
				'label'				=> esc_html__( 'Order By: ', 'passport' ),
				'desc'				=> '',
				'type'				=> 'select',
				'size'				=> 30,
				'options'			=> array (
					'none'				=> array (
						'label'			=> esc_html__( 'None', 'passport' ),
						'value'			=> 'none',
					),
					'date'				=> array (
						'label'			=> esc_html__( 'Date', 'passport' ),
						'value'			=> 'date',
					),
					'author'			=> array (
						'label'			=> esc_html__( 'Author', 'passport' ),
						'value'			=> 'author',
					),
					'title'				=> array (
						'label'			=> esc_html__( 'Title', 'passport' ),
						'value'			=> 'title',
					),
					'name'				=> array (
						'label'			=> esc_html__( 'Name', 'passport' ),
						'value'			=> 'name',
					),
					'type'				=> array (
						'label'			=> esc_html__( 'Type', 'passport' ),
						'value'			=> 'type',
					),
					'modified'			=> array (
						'label'			=> esc_html__( 'Modified', 'passport' ),
						'value'			=> 'modified',
					),
					'rand'				=> array (
						'label'			=> esc_html__( 'Rand', 'passport' ),
						'value'			=> 'rand',
					),
				)
			),
			'me_order' => array(
				'label'				=> esc_html__( 'Order: ', 'passport' ),
				'desc'				=> '',
				'type'				=> 'select',
				'size'				=> 30,
				'options'			=> array (
					'asc'				=> array (
						'label'			=> esc_html__( 'ASC', 'passport' ),
						'value'			=> 'asc',
					),
					'date' => array (
						'label'			=> esc_html__( 'DESC', 'passport' ),
						'value'			=> 'desc',
					),
				)
			),
		)
	),
    /*All*/
	'program_setting' => array(
		'title' => esc_html__( 'Program', 'passport' ),
		'applicableto' => 'post',
		'location' => 'side',
        'display_condition' => '',
		'priority' => 'low',
		'fields' => array(
			'event_place' => array(
				'label'				=> esc_html__( 'Place', 'passport' ),
				'desc'				=> esc_html__( 'Event Place', 'passport' ),
				'type'				=> 'text',
				'size'				=> '20',
			),
			'event_start' => array(
				'label'				=> esc_html__( 'Event Start', 'passport' ),
				'desc'				=> esc_html__( 'Event Start Date.', 'passport' ),
				'type'				=> 'text',
				'size'				=> '10',
			),
			'event_finish' => array(
				'label'				=> esc_html__( 'Event Finish', 'passport' ),
				'desc'				=> esc_html__( 'Event Finished Date', 'passport' ),
				'type'				=> 'text',
				'size'				=> '10',
			),
			'format_options' => array(
				'label'				=> esc_html__( 'Date Format: ', 'passport' ),
				'desc'				=> '',
				'type'				=> 'select',
				'size'				=> 30,
				'options'			=> array (
					'default'			=> array (
						'label'			=> esc_html__( 'Default - mm/dd/yy', 'passport' ),
						'value'			=> 'mm/dd/yy',
					),
					'iso'				=> array (
						'label'			=> esc_html__( 'ISO 8601 - yy-mm-dd', 'passport' ),
						'value'			=> 'yy-mm-dd',
					),
					'short'				=> array (
						'label'			=> esc_html__( 'Short - d M, y', 'passport' ),
						'value'			=> 'd M, y',
					),
					'medium'			=> array (
						'label'			=> esc_html__( 'Medium - d MM, y', 'passport' ),
						'value'			=> 'd MM, y',
					),
					'full'				=> array (
						'label'			=> esc_html__( 'Full - DD, d MM, yy', 'passport' ),
						'value'			=> 'DD, d MM, yy',
					),
					'text'				=> array (
						'label'			=> esc_html__( 'With text', 'passport' ),
						'value'			=> '&apos;day&apos; d &apos;of&apos; MM &apos;in the year&apos; yy',
					),
				)
			),
        )
	),
	'progress_setting' => array(
		'title' => esc_html__( 'Progress', 'passport' ),
		'applicableto' => 'post',
		'location' => 'side',
        'display_condition' => '',
		'priority' => 'low',
		'fields' => array(
            'progressbar' => array(
				'label'				=> esc_html__( 'Progress Bar', 'passport' ),
				'desc'				=> esc_html__( 'The percentage of progress', 'passport' ),
				'type'				=> 'text',
				'size'				=> '15',
			),
        )
	)
);

add_action( 'admin_init', 'passport_add_metabox' );


/**
 * Add metabox in Post and Page.
 * -------------------------------------------------------------------------
 * 
 * @since Passport 1.0
 *
 **/
function passport_add_metabox() {
    global $metaboxes;
	
    if ( ! empty( $metaboxes ) ) {
        foreach ( $metaboxes as $id => $metabox ) {
            add_meta_box( $id, $metabox['title'], 'passport_show_metaboxes', $metabox['applicableto'], $metabox['location'], $metabox['priority'] );
        }
    }
}


/**
 * Display metabox in Post/Page Admin page.
 * -------------------------------------------------------------------------
 * 
 * @since Passport 1.0
 *
 **/
if( ! function_exists( 'passport_show_metaboxes' ) ) {

    function passport_show_metaboxes( $post, $args ) {
        global $metaboxes;
	    global $allowedtags;

        $custom = get_post_custom( $post->ID );
  
        $fields = $tabs = $metaboxes[ $args['id'] ]['fields'];
	
        /** Nonce **/
        echo '<input type="hidden" name="post_format_meta_box_nonce" value="' . wp_create_nonce( basename( __FILE__ ) ) . '" />';

	    // Begin the field table and loop
        echo '<table class="form-table">';
        if ( sizeof( $fields ) ) {
            foreach ( $fields as $id => $field ) {
          
                $custom[ $id ][0] = ( isset( $custom[ $id ][0] ) && $custom[ $id ][0] == TRUE ) ? wp_kses( $custom[ $id ][0], $allowedtags ) : '';

			    echo  '<tr><th><label for="'. $id .'">'. esc_html( $field['label'] ) .'</label></th><td>';
			    switch ( $field['type'] ) {
                    default:
				    // heading
				    case 'heading':
					    echo '<h4 id="'. $id .'" class="alignright"><em>'. esc_html( $field['name'] ) .'</em></h3>
					    <p>'. esc_html( $field['desc'] ) .'</p>';
		
				    break;

				    // text
                    case 'text': 
				    echo  '<input id="'. $id .'" type="text" name="'. esc_attr( $id ) .'" value="'. esc_attr( $custom[ $id ][0] ) .'" size="' . $field['size'] . '" /><br /><span class="description">'. esc_html( $field['desc'] ) .'</span><br />';

				    break;

				    // textarea
				    case 'textarea':
				    echo '<textarea name="'. esc_attr( $id ) .'" id="'. $id .'" cols="60" rows="4">'. esc_html( $custom[ $id ][0] ) .'</textarea><br />
				    <span class="description">'. esc_html( $field['desc'] ) .'</span><br /><br />';

				    break;
				
				    // checkbox
				    case 'checkbox':
				    echo '<input type="checkbox" name="'. esc_attr( $id ) .'" id="'. $id .'"';
				    if ( 'on' == $custom[ $id ][0] ) { echo 'checked="checked"'; } else { echo 'check=""'; }
				    echo '/><br />
				    <span class="description">'. esc_html( $field['desc'] ) .'</span><br /><br />';

				    break;
		
				    // select
				    case 'select':
					    echo '<select name="'. esc_attr( $id ) .'" id="'. $id .'">';
					    foreach ( $field['options'] as $option) {
						    echo '<option', $custom[ $id ][0] == $option['value'] ? '
						    selected="selected"' : '', ' 
						    value="'. $option['value'] .'">'. $option['label'] .'</option>';
						    }
						    echo '</select><br /><span class="description">'. esc_html( $field['desc'] ).'</span><br />';
  
				    break;

				    // colorpicker
				    case 'colorpicker':
					      echo '<input class="color-field" type="text" name="'. esc_attr( $id ) .'" value="'. esc_attr( $custom[ $id ][0] ) .'"/>';
                    
				    break;

				    // upload
				    case 'upload':

				    echo	
					    '
                        <div id="'. $id .'" class="media-upload-wrapper">
					        <p class="hide-if-no-js">
						        <a title="Choose Image" href="javascript:;" class="choose-image button button-small">'. esc_html__( 'Choose Image', 'passport' ) .'</a>				
					        </p>
					        <div class="media-upload-container hidden">
						        <img src="'. esc_url( $custom[ $id ][0] ) .'" class="wp-post-image" />
					        </div><!-- #media-upload-container -->
					        <p class="hide-if-no-js hidden">
						        <a title="Remove Image" href="javascript:;" class="remove-image button button-small">'. esc_html__( 'Remove Image', 'passport' ) .'</a>
					        </p><!-- .hide-if-no-js -->
					        <p class="media-upload-meta">
						        <input type="hidden" class="media" name="'. esc_attr( $id ) .'" value="'.  esc_attr( $custom[ $id ][0] ) .'" />
						        <span class="description">'. esc_html( $field['desc'] ) .'</span><br />
					        </p><!-- #media-upload-meta -->
                        </div>';

				    break;
                }
			    echo '</td></tr>';
            }
		    echo '</table>';
        }
    }
}


/**
 * Save metabox.
 * -------------------------------------------------------------------------
 * 
 * @since Passport 1.0
 *
 **/
add_action( 'save_post', 'passport_save_metaboxes' );

if( ! function_exists( 'passport_save_metaboxes' ) ) {

    function passport_save_metaboxes( $post_id ) {
        global $metaboxes;
	    global $allowedtags;

        // verify nonce
        if ( ! isset( $_POST['post_format_meta_box_nonce']) || ! wp_verify_nonce( $_POST['post_format_meta_box_nonce'], basename( __FILE__ ) ) ) {
            return $post_id;
        }

        // check autosave
        if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
            return $post_id;
        }

        // check permissions
        if ( 'page' == $_POST['post_type'] ) {
            if ( ! current_user_can( 'edit_page', $post_id ) )
                return $post_id;
	    } elseif ( ! current_user_can( 'edit_post', $post_id ) ) {
			    return $post_id;
        }
 
        $post_type = get_post_type();
 
        // loop through fields and save the data
        foreach ( $metaboxes as $id => $metabox ) {
            // check if metabox is applicable for current post type
            if ( $metabox['applicableto'] == $post_type ) {
                $fields = $metaboxes[ $id ]['fields'];
 
                foreach ( $fields as $id => $field ) {
                    $old = get_post_meta( $post_id, $id, true );
                    $new = isset( $_POST[ $id ] ) ? $_POST[ $id ] : '';
			
				    if ( $new && $new != $old ) {
                       update_post_meta( $post_id, $id, $new );
                    }
                    elseif ( '' == $new && $old || ! isset( $_POST[ $id ] ) ) {
                       delete_post_meta( $post_id, $id, $old );
                    }
                }
            }
        }
    }
}


/**
 * Display metabox in condition function
 * -------------------------------------------------------------------------
 * 
 *
 * @since Passport 1.0
 *
 **/
add_action( 'admin_print_scripts', 'passport_display_metaboxes', 1000 );

if( ! function_exists( 'passport_display_metaboxes' ) ) {

    function passport_display_metaboxes() {
        global $metaboxes;

        if ( 'post' == get_post_type() ) :

            ?>
            <script type="text/javascript">// <![CDATA[
                $ = jQuery;
 
                <?php 
                $formats = $ids = array();
		
                foreach ( $metaboxes as $id => $metabox ) {
                    array_push( $formats, "'" . $metabox['display_condition'] . "': '" . $id . "'" );
                    array_push( $ids, "#" . $id );
                }
                ?>
 
                var formats = { <?php echo implode( ',', $formats ); ?> };
                var ids = "<?php echo implode( ',', $ids ); ?>";

			    function displayMetaboxes() {
				    // Hide all post format metaboxes
				    $(ids).hide();
			
				    // Get current post format
				    var selectedElt = $("input[name='post_format']:checked").attr("id");
				
                    // If exists, fade in current post format metabox
                    if ( formats[selectedElt] ) {
                        $("#" + formats[selectedElt]).fadeIn();
                    } else {
                        $("#program_setting").fadeIn();
                        $("#progress_setting").fadeIn();
                    }
                }
 
                $(function() {
                    // Show/hide metaboxes on page load
                    displayMetaboxes();

                    // Show/hide metaboxes on change event
                    $("input[name='post_format']").change(function() {
                        displayMetaboxes();
                    });

                });
 
            // ]]></script>
            <?php
   
        elseif( 'page' == get_post_type() ) :

	    ?>
            <script type="text/javascript">// <![CDATA[
                $ = jQuery;
 
                <?php 
                $formats = $ids = array();

                foreach ( $metaboxes as $id => $metabox ) {
                    array_push( $formats, "'" . $metabox['display_condition'] . "': '" . $id . "'" );
                    array_push( $ids, "#" . $id );
                }
                ?>
 
                var formats = { <?php echo implode( ',', $formats ); ?> };
                var ids = "<?php echo implode( ',', $ids ); ?>";
	
			    function displayMetaboxes() {
                    // Hide all page template metaboxes
                    $(ids).hide();
			
                    // Get current page template
			        var selectedElt = $("select[name='page_template'] option:selected").attr("value");

                    // If exists, fade in current page template metabox
	               if ( formats[selectedElt] )
                        $("#" + formats[selectedElt]).fadeIn();

                }
 
                $(function() {
                    // Show/hide metaboxes on page load
                    displayMetaboxes();

                    // Show/hide metaboxes on change event

				      $("select[name='page_template']").change(function() {
                        displayMetaboxes();
                    });
                });
 
            // ]]></script>
            <?php
	    endif;
    }

}