<?php
/*
 * Custom Editor Buttons
 * -------------------------------------------------------------------------
 *
 * @package WordPress
 * @subpackage passport
 * @since passport 1.0
 *
 */
add_action( 'init', 'passport_buttons' );

function passport_buttons() {
    add_filter( 'mce_external_plugins', 'passport_add_buttons' );
    add_filter( 'mce_buttons', 'passport_register_buttons' );
}

function passport_add_buttons( $plugin_array ) {
    $plugin_array['passport'] = get_template_directory_uri() . "/includes/editor-buttons/editor-plugin.js";
    return $plugin_array;
}

function passport_register_buttons( $buttons ) {
    array_push( $buttons, 'dropcap', 'typed' ); // dropcap and typed
    return $buttons;
}