<?php
/**
 * Save and style the post formats function.
 * -------------------------------------------------------------------------
 * This function is for saving and styling the post formats, such as, Quote, 
 * Link, Aside, Gallery, Audio. Using the metabox concept
 * 
 * @package WordPress
 * @subpackage passport
 * @since Passport 1.0
 * @see metabox.php
 *
 **/

 /**
 * Get and update metabox option function
 * -------------------------------------------------------------------------
 * 
 *
 * @since Passport 1.0 
 *
 **/
if( ! function_exists( 'passport_option_save_post' ) ) {

    function passport_option_save_post( $post_id ) {
	
	    if ( wp_is_post_revision( $post_id ) )
		    return;
		
	     $custom_options = get_option( 'custom_options' );
    
	    if( 'aside' == get_post_format( $post_id ) ) {
	        $custom_options[$post_id]['as_color']	    = get_post_meta( $post_id, 'as_color', true );
	        $custom_options[$post_id]['as_bgcolor']	    = get_post_meta( $post_id, 'as_bgcolor', true );
	    }

        if ( 'quote' == get_post_format( $post_id ) ) {
	         $custom_options[$post_id]['q_media']	    = get_post_meta( $post_id, 'q_media', true );
	         $custom_options[$post_id]['q_color']	    = get_post_meta( $post_id, 'q_color', true );
	         $custom_options[$post_id]['q_bgcolor']	    = get_post_meta( $post_id, 'q_bgcolor', true );
	    }

	    if( 'link' == get_post_format( $post_id ) ) {
	         $custom_options[$post_id]['l_font']	    = get_post_meta( $post_id, 'l_font', true );
	         $custom_options[$post_id]['l_span_font']   = get_post_meta( $post_id, 'l_span_font', true );
	         $custom_options[$post_id]['l_text_align']  = get_post_meta( $post_id, 'l_text_align', true );
	         $custom_options[$post_id]['l_color']	    = get_post_meta( $post_id, 'l_color', true );
	         $custom_options[$post_id]['l_span_color']  = get_post_meta( $post_id, 'l_span_color', true );
	    }

        if( 'image' == get_post_format( $post_id ) ) {
	        $custom_options[$post_id]['i_color']	    = get_post_meta( $post_id, 'i_color', true );
	        $custom_options[$post_id]['i_bgcolor']	    = get_post_meta( $post_id, 'i_bgcolor', true );
	    }

        if( 'gallery' == get_post_format( $post_id ) ) {
	        $custom_options[$post_id]['g_color']	    = get_post_meta( $post_id, 'g_color', true );
	        $custom_options[$post_id]['g_bgcolor']	    = get_post_meta( $post_id, 'g_bgcolor', true );
	    }

        if( 'audio' == get_post_format( $post_id ) ) {
	        $custom_options[$post_id]['a_bgcolor']	    = get_post_meta( $post_id, 'a_bgcolor', true );
	    }

	    update_option( 'custom_options',  $custom_options);
    }

}
add_action( 'save_post', 'passport_option_save_post' );


 /**
 * Styling the post format function
 * -------------------------------------------------------------------------
 * Use wp_add_inline_style() function to style 
 * Add custom-style.css for inline style.
 * Enqueue style named 'custom-style' in functions.php
 * 
 * @since Passport 1.0 
 *
 **/
if( ! function_exists( 'passport_metabox_inline_style' ) ) {

    function passport_metabox_inline_style( $post_id ) {
	
	    $i = 0;
	    $custom_options = get_option( 'custom_options' );

		    $custom_metabox_css = '';
            if( is_array( $custom_options ) && count( $custom_options ) > 0 ) {
			    foreach ( $custom_options as $key =>  $custom_option ) {

                    /*Aside*/
				    if ( isset( $custom_option['as_color'] ) || isset( $custom_option['as_bgcolor'] ) ) {
                        $custom_metabox_css .= "#post-{$key}.format-aside .post-group-cell span, #post-{$key}.format-aside .post-group-cell p, #post-{$key}.format-aside .post-media .fa {";
					    $custom_metabox_css .= ! empty( $custom_option['as_color'] ) ? 'color:'. $custom_option['as_color'].';' :'color: #333333;';
					    $custom_metabox_css .= "}";
                        $custom_metabox_css .= "#post-{$key}.format-aside .overlay, #post-{$key}.format-aside .post-media .fa {";
					    $custom_metabox_css .= ! empty( $custom_option['as_bgcolor'] ) ? 'background-color:'. $custom_option['as_bgcolor'].';' :'background-color: #eeeeee;';
					    $custom_metabox_css .= "}";
				    }

				    /*Quote*/
				    if ( isset( $custom_option['q_color'] ) || isset( $custom_option['q_bgcolor'] ) || isset( $custom_option['q_media'] ) ) {
                        $custom_metabox_css .= "#post-{$key} .quote-photo {";
					    $custom_metabox_css .= ! empty( $custom_option['q_media'] ) ? 'background-image:url( '. $custom_option['q_media'].' );' :'';
					    $custom_metabox_css .= "}";
					    $custom_metabox_css .= "#post-{$key}.format-quote .post-group-cell span, #post-{$key}.format-quote .post-media .fa {";
					    $custom_metabox_css .= ! empty( $custom_option['q_color'] ) ? 'color:'. $custom_option['q_color'].';' :'color: #333333;';
					    $custom_metabox_css .= "}";
                        $custom_metabox_css .= "#post-{$key}.format-quote .overlay, #post-{$key}.format-quote .post-media .fa   {";
					    $custom_metabox_css .= ! empty( $custom_option['q_bgcolor'] ) ? 'background-color:'. $custom_option['q_bgcolor'].';' :'background-color: #eeeeee;';
					    $custom_metabox_css .= "}"; 
                        $custom_metabox_css .= "#post-{$key}.format-quote .author {";
					    $custom_metabox_css .= ! empty( $custom_option['q_color'] ) ? 'border-color:'. $custom_option['q_color'].';' :'border-color: #333333;';
					    $custom_metabox_css .= "}"; 
				    }
				
				    /*Link*/
				    if ( isset( $custom_option['l_font'] ) || isset( $custom_option['l_span_font'] ) ||  isset( $custom_option['l_text_align'] ) || isset( $custom_option['l_color'] ) || isset( $custom_option['l_span_color'] ) || isset( $custom_option['l_bgcolor'] ) || isset( $custom_option['l_media'] ) ) {
					    $custom_metabox_css .= "#post-{$key} .link-text {";
					    $custom_metabox_css .= ! empty( $custom_option['l_text_align'] ) ? 'text-align:'. $custom_option['l_text_align'].';' :'text-align: left';
					    $custom_metabox_css .= "}";
					    $custom_metabox_css .= "#post-{$key}.format-link .post-media .fa {";
					    $custom_metabox_css .= ! empty( $custom_option['l_color'] ) ? 'color:'. $custom_option['l_color'].';' :'color: #ffffff;';
					    $custom_metabox_css .= "}";
					    $custom_metabox_css .= "#post-{$key} .link-text header {";
					    $custom_metabox_css .= ! empty( $custom_option['l_color'] ) ? 'color:'. $custom_option['l_color'].';' :'color: #ffffff;';
					    $custom_metabox_css .= ! empty( $custom_option['l_font'] ) ? 'font-size:'. $custom_option['l_font'].'px;' :'font-size: 40px;';
					    $custom_metabox_css .= "}";
					    $custom_metabox_css .= "#post-{$key} .link-text span {";
					    $custom_metabox_css .= ! empty( $custom_option['l_span_color'] ) ? 'color:'. $custom_option['l_span_color'].';' :'color: #ffffff;';
					    $custom_metabox_css .= ! empty( $custom_option['l_span_font'] ) ? 'font-size:'. $custom_option['l_span_font'].'px;' :'font-size: 14px;';
					    $custom_metabox_css .= "}";
                        $custom_metabox_css .= "#post-{$key} .format-link .overlay, #post-{$key}.format-link .post-media .fa  {";
					    $custom_metabox_css .= ! empty( $custom_option['l_bgcolor'] ) ? 'background-color:'. $custom_option['l_bgcolor'].';' :'background-color: #eeeeee;';
					    $custom_metabox_css .= "}";
				    }

                    /*Image*/
				    if ( isset( $custom_option['i_color'] ) || isset( $custom_option['i_bgcolor'] ) ) {
                        $custom_metabox_css .= "#post-{$key}.format-image .caption-title a,  #post-{$key}.format-image .caption-excerpt p, #post-{$key}.format-image .post-media .fa {";
					    $custom_metabox_css .= ! empty( $custom_option['i_color'] ) ? 'color:'. $custom_option['i_color'].';' :'color: #ffffff;';
					    $custom_metabox_css .= "}";
                        $custom_metabox_css .= "#post-{$key}.format-image .caption-background, #post-{$key}.format-image .overlay, #post-{$key}.format-image .post-media .fa {";
					    $custom_metabox_css .= ! empty( $custom_option['i_bgcolor'] ) ? 'background-color:'. $custom_option['i_bgcolor'].';' :'background-color: #1e6864;';
					    $custom_metabox_css .= "}";
				    }

                    /*Gallery*/
				    if ( isset( $custom_option['g_color'] ) || isset( $custom_option['g_bgcolor'] ) ) {
                        $custom_metabox_css .= "#post-{$key}.format-gallery .wp-caption-text, #post-{$key}.format-gallery .gallery-caption, #post-{$key}.format-gallery .post-media .fa, .format-gallery .gallery-item:before {";
					    $custom_metabox_css .= ! empty( $custom_option['g_color'] ) ? 'color:'. $custom_option['g_color'].';' :'color: #ffffff;';
					    $custom_metabox_css .= "}";
                        $custom_metabox_css .= "#post-{$key}.format-gallery .bglayer,  #post-{$key}.format-gallery .landscape,  #post-{$key}.format-gallery.portrait, #post-{$key}.format-gallery .post-media .fa, #post-{$key}.format-gallery .carousel-control .fa:before, #post-{$key}.format-gallery .carousel-indicators li.active {";
					    $custom_metabox_css .= ! empty( $custom_option['g_bgcolor'] ) ? 'background-color:'. $custom_option['g_bgcolor'].';' :'background-color: #1e6864;';
					    $custom_metabox_css .= "}";
                        $custom_metabox_css .= "#post-{$key}.format-gallery .carousel-indicators li {";
					    $custom_metabox_css .= ! empty( $custom_option['g_bgcolor'] ) ? 'border-color:'. $custom_option['g_bgcolor'].';' :'border-color: #1e6864;';
					    $custom_metabox_css .= "}";
				    }

                    /*Audio*/
				    if ( isset( $custom_option['a_bgcolor'] ) ) {
                        $custom_metabox_css .= "#post-{$key} .mejs-container, #post-{$key} .mejs-container .mejs-controls, #post-{$key} .mejs-embed, .mejs-embed body, #post-{$key}.format-audio .post-media .fa {";
					    $custom_metabox_css .= ! empty( $custom_option['a_bgcolor'] ) ? 'background:'. $custom_option['a_bgcolor'].';' :'background: #1e6864;';
					    $custom_metabox_css .= "}";
				    }

			    $i++;
			    }
            }
			    wp_add_inline_style( PASSPORT_THEME_SLUG . '-custom-style', $custom_metabox_css);   
    }

}
add_action( 'wp_enqueue_scripts', 'passport_metabox_inline_style' );