<?php
/**
 * Author avatar functionality
 * -------------------------------------------------------------------------
 * Specify size of avatar by the column and sidebar width.
 *
 * @package WordPress
 * @subpackage passport
 * @since Passport 1.0
 *
**/
if ( ! function_exists ( 'passport_author_avatar' ) ) {

    function passport_author_avatar() {

	    global $passport_post_content_column;
	    global $passport_post_sidebar_position;
	    global $passport_post_sidebar_width;
	
	    //Avatar size
	    if( 'main_content' == $passport_post_content_column ) {
		    echo get_avatar( get_the_author_meta( 'ID' ) , 350, null, 'avatar', array( 'class' => array( 'wp-post-image' ) )  );
	    } elseif( 'sidebar_25' == $passport_post_sidebar_width && 'sidebar' == $passport_post_content_column ) { 
		    echo get_avatar( get_the_author_meta( 'ID' ) , 275, null, 'avatar', array( 'class' => array( 'wp-post-image' ) ) ); 
	    } elseif( 'sidebar_33' == $passport_post_sidebar_width && 'sidebar' == $passport_post_content_column ) {
		    echo get_avatar( get_the_author_meta( 'ID' ) , 250, null, 'avatar', array( 'class' => array( 'wp-post-image' ) ) ); 
	    } 
    }
}


/**
 * Author section functionality
 * -------------------------------------------------------------------------
 * Show the author section in single post.
 * This section shows the author's avatar, biography, and contact.
 *
 * @package WordPress
 * @subpackage passport
 * @since Passport 1.0
 *
 */

if ( ! function_exists ( 'passport_author_section' ) ) {

    function passport_author_section() { 
    ?>
	    <div class="col-sm-4 col-md-4 col-lg-4">
		    <div class="row">
			    <div class="img-responsive"><?php echo passport_author_avatar(); ?></div>
		    </div>
	    </div>
	    <div class="col-sm-8 col-md-8 col-lg-8">
		    <div class="row">
			    <div class="author-content">
                    <div class="author-share">
				        <?php echo passport_show_social_share(); ?>
                    </div>
                    <h4 class="entry-title"><b><?php the_author_meta( 'nickname' ); ?></b></h4>
				    <hr>
				    <p><?php the_author_meta( 'description' ); ?></p>
			    </div>
		    </div>
	    </div>
    <?php 
    }
}

 
/**
 * Related post thumbnail function
 * -------------------------------------------------------------------------
 * Specify the thumbnail size of each post.
 *
 * @since Passport 1.0 
 * @Ref site: owlgraphic.com/owlcarousel/
 *
 **/
if ( ! function_exists ( 'passport_related_post_thumbnails' ) ) {

    function passport_related_post_thumbnails() {

	    global $passport_post_content_column;
	    global $passport_post_sidebar_position;
	    global $passport_post_sidebar_width;

	    if( is_single() && 'main_content' == $passport_post_content_column ) {
		    the_post_thumbnail( 'related-post-276-276' );
	    } elseif( is_single() && 'sidebar_25' == $passport_post_sidebar_width ) {
		    the_post_thumbnail( 'related-post-285-190' );
	    } elseif( is_single() && 'sidebar_33' == $passport_post_sidebar_width) {
		    the_post_thumbnail( 'related-post-285-190' );					
	    }
    }
}

 
/**
 * Related post function
 * -------------------------------------------------------------------------
 * Related post format used in the post page.
 *
 * @since Passport 1.0 
 *
 **/
if ( ! function_exists ( 'passport_related_posts' ) ) {

    function passport_related_posts() {

	    global $post;

	    $tags	 = wp_get_post_tags( $post->ID );
	    $tag_ids = array();
	    $related_posts_title	= get_theme_mod( 'passport_related_posts_title', '' );

	    foreach( $tags as $tag ) 
		    $tag_ids[]	= $tag->term_id;
		    $args		= array(
			    'tag__in'			  => $tag_ids,
			    'post__not_in'		  => array( $post->ID ),
			    'ignore_sticky_posts' => 1,
		    );

	    $passport_related_posts_query = new wp_query( $args ); ?>

    <?php if( ! empty ( $tags ) && $tag->count > 1 ) : ?>
	    <?php if( ! empty ( $related_posts_title ) ) : ?>
		    <h3 class="related-posts-title"><?php  echo $related_posts_title; ?></h3>
	    <?php else: ?>
		    <h3 class="related-posts-title"><?php  esc_html_e( 'Related Posts', 'passport' ); ?></h3>
	    <?php endif; ?>
		    <div class="owl-related-posts">
			    <?php while( $passport_related_posts_query->have_posts() ) : $passport_related_posts_query->the_post(); ?>
				    <div class="post-item">
					    <a href="<?php the_permalink(); ?>"><?php echo passport_related_post_thumbnails(); ?></a>
					    <div class="posts-caption">
						    <h5 class="post-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h5>
						    <h6><span><?php the_category( ' &bull; ' ); ?></span></h6>
					    </div>
				    </div>
			    <?php endwhile; ?>
		    </div>	
	    <?php wp_reset_postdata(); ?>
    <?php endif;
    }
}


/**
 * 
 * Program and Progress Function
 * -----------------------------------------------------------------------
 * This function displays at the left side of the post. To give more info
 * about the program name, place, schedule and the progress status.
 *
 * @since passport 1.0
 *
 */

if ( ! function_exists ( 'passport_program_and_progress' ) ) {

    function passport_program_and_progress() {
   
        $event_place  = get_post_meta( get_the_ID(), 'event_place', true );
	    $event_start  = get_post_meta( get_the_ID(), 'event_start', true );
	    $event_finish = get_post_meta( get_the_ID(), 'event_finish', true );
	    $progressbar  = get_post_meta( get_the_ID(), 'progressbar', true );
	    $progressbar  = str_replace( '%', '', $progressbar );
	    $progressbar_name	= get_theme_mod( 'passport_progressbar_name', 'Progress Bar' );

        if( ! empty ( $event_start ) || ! empty( $event_finish ) || ! empty( $event_place ) || ! empty( $progressbar ) ) : 
            if( is_single() ) : ?>
                <aside class="additional-info">
                    <?php if ( ! empty( $event_place ) ) : ?>
                        <div class="event-info">
                            <span class="symbol"><i class="fa fa-map-marker fa-2x"></i></span>
                            <?php esc_html_e( 'Place: ', 'passport' ); ?><span><?php echo $event_place; ?></span>
                        </div>
                    <?php endif; ?>
                    <?php if( ! empty( $event_start ) && ! empty( $event_finish ) ) : ?>
                        <div class="event-info">
                            <span class="symbol"><i class="fa fa-calendar fa-2x"></i></span>
                            <?php esc_html_e( 'Start Date: ', 'passport' ); ?><span><?php echo $event_start; ?></span><br>
                            <?php esc_html_e( 'End Date: ', 'passport' ); ?><span><?php echo $event_finish; ?></span>
                        </div>
                    <?php endif; ?>
                    <?php if( ! empty( $progressbar ) ) : ?>
				        <div class="event-info">
                            <span class="symbol"><i class="fa fa-tachometer fa-2x"></i></span>
                            <?php if( ! empty( $progressbar_name ) ) { echo $progressbar_name; } else { esc_html_e( 'Progress: ', 'passport' ); } ?><span><?php echo $progressbar; ?>%</span>
                        </div>
                    <?php endif; ?>
                </aside>
            <?php 
            endif;
        endif;
    }
}


/**
 * 
 * Program Schedule Function
 * -----------------------------------------------------------------------
 * This function shows about the program schedule. It is the one of three 
 * parts in Column widget.
 *
 * @since passport 1.0
 *
 */

if ( ! function_exists ( 'passport_program_schedule' ) ) {

    function passport_program_schedule() {

	    $content = '';
	    $event_topic	= __( 'Event Schedule', 'passport' );

	    $args = array(
		    'order'				=> 'ASC',
		    'posts_per_page'	=> 10,
		    'meta_key'			=> 'event_start',
		    'ignore_sticky_posts'	=> true,
 	    );

	    $wp_query = new WP_Query( $args );

	    if( $wp_query -> have_posts() ) : ?>
	    <h4 class="column-title"><?php if( ! empty( $event_topic ) ) { echo $event_topic; } else { echo esc_html__( 'Event Schedule', 'passport' ); } ?></h4>
		    <ul>
	            <?php 
                    while ( $wp_query -> have_posts() ) : $wp_query -> the_post();
			            $event_place  = get_post_meta( get_the_ID(), 'event_place', true );
			            $event_start  = get_post_meta( get_the_ID(), 'event_start', true );
			            $event_finish = get_post_meta( get_the_ID(), 'event_finish', true );
 	
                        if( ( ! empty( $event_start ) || ! empty( $event_finish ) || ! empty( $event_place ) ) ): ?>
		                <li class="event">
			                <p class="event-title"><a href="<?php the_permalink(); ?>"><?php echo passport_short_title( get_the_title(), 25 ); ?></a></p>
			                <div class="schedule-wrapper">
				                <p class="event-info"><?php esc_html_e( 'Place: ', 'passport' ); ?><span><?php echo $event_place; ?></span></p>
				                <p class="event-info"><?php esc_html_e( 'Show time: ', 'passport' ); ?><span><?php echo $event_start; ?> -</span>
				                <span> <?php echo $event_finish; ?></span></p>
			                </div>
		                </li>
		                <?php 
                        endif;
		            endwhile; 
                ?>
		    </ul>
	    <?php endif;
    }
}


/**
 * 
 * Progress Bar Function
 * -----------------------------------------------------------------------
 * This function shows about the progress status. It is the one of three 
 * parts in Column widget.
 *
 * @since passport 1.0
 *
 */

if ( ! function_exists ( 'passport_progressbar' ) ) {

    function passport_progressbar() { 
	
	    $progressbar_name	= __( 'Progress Bar', 'passport' );
	    $args = array(
		    'meta_key'			=> 'progressbar',
		    'order'				=> 'DESC',
		    'orderby'			=> 'meta_value_num',
		    'posts_per_page'	=> 10,
		    'ignore_sticky_posts'	=> true,
	    );

	    $wp_query = new WP_Query( $args );

	    if( $wp_query -> have_posts() ) : ?>
	    <h4 class="column-title"><?php if( ! empty( $progressbar_name ) ) { echo $progressbar_name; } else { echo esc_html__( 'Progress Bar', 'passport' ); } ?></h4>
		    <ul id="#progress-bar" class="progress-group">
		    <?php while ( $wp_query -> have_posts() ) : $wp_query -> the_post(); ?>
 		    <?php $progressbar = get_post_meta( get_the_ID(), 'progressbar', true );  ?>
		    <?php $progressbar = str_replace( '%', '', $progressbar ); ?>
			    <li>
				    <div class="label"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></div>
				    <div class="progress">
				        <div class="progress-bar" role="progressbar" aria-valuenow="<?php echo esc_attr( $progressbar ); ?>" aria-valuemin="0" aria-valuemax="100" style="width:<?php echo $progressbar; ?>%">
					        <?php echo $progressbar; ?>%
					    </div>
				    </div>
			    </li>
		    <?php endwhile; ?>
		    </ul>
    <?php endif; 
    }
}


/**
 * 
 * News Update Function
 * -----------------------------------------------------------------------
 * This fucntion shows about the news update. It is the one of three 
 * parts in Column widget.
 *
 * @since passport 1.0
 *
 */

if ( ! function_exists ( 'passport_news_update' ) ) {

    function passport_news_update() {

	    $news_update_name	= __( 'News Update', 'passport' );
	    $args = array(
            'order_by'          => 'date',
		    'posts_per_page'	=> 1,
		    'ignore_sticky_posts'	=> true,
	    );

	    $wp_query = new WP_Query( $args );

	    if( $wp_query -> have_posts() ) : ?>
	    <h4 class="column-title"><?php if( ! empty ( $news_update_name ) ) { echo $news_update_name; } else { echo esc_html__( 'News Update', 'passport' ); } ?></h4>
		    <?php while ( $wp_query -> have_posts() ) : $wp_query -> the_post(); ?>
 			    <?php the_post_thumbnail( 'standard-image' ); ?> 
                <div class="post-content">
                    <header class="entry-header">
			            <h4 class="entry-title">
                            <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                        </h4>
                    </header>
				    <div class="entry-content"><?php echo passport_excerpt( '30' ); ?></div>
                </div>
		    <?php endwhile; ?>
    <?php endif; 
    }
}

 
/**
 * 
 * Popular Posts Function
 * -----------------------------------------------------------------------
 * This fucntion shows about the popular posts. It is the one of three 
 * parts in Tab widget.
 *
 * @since passport 1.0
 *
 */

if ( ! function_exists ( 'passport_popular_posts' ) ) {

    function passport_popular_posts() {

        global $post;

	    $args = array(
		    'meta_key'				=> '_post_like_count',
		    'orderby'				=> 'meta_value_num',
		    'order'					=> 'DESC',
		    'posts_per_page'		=> 3,
		    'ignore_sticky_posts'	=> TRUE,
		     );

	    $wp_query = new WP_Query( $args );

        if ( $wp_query -> have_posts() ) : ?>
            <ul class="list-unstyled">
                <?php while ( $wp_query->have_posts() ) : $wp_query->the_post();
                    $title = get_the_title( $post->ID );
                    $image = get_the_post_thumbnail( $post->ID, 'standard-image', array( 'class' => 'alignleft' ) );

                ?>
                <li class="<?php if( ! empty( $image ) || 0 != $attachment_id ) { echo 'has-thumbnail'; } else { echo 'no-thumbnail'; } ?> widget-list widget-post-item clearfix">
                    <div class="col-xs-12 col-sm-12 col-md-6 col-lg-6 enlarge">
                        <div class="post-standard frame">
				            <a href="<?php echo get_permalink( $post->ID ); ?>" class="alignleft img-position hvr-grow">
                                <div class="bglayer">
                                    <?php if( ! empty( $image ) ) { echo $image; } ?>
                                </div>
                                <span class="icon-hero"><?php echo passport_icon_shows(); ?></span>
                            </a>
                        </div>
                    </div>
                    <div class="col-xs-12 col-sm-12 col-md-6 col-lg-6">
			            <div class="post-content clearfix">
                            <?php
					            get_template_part( 'partials/partials', 'header' ); 
			                    get_template_part( 'partials/partials', 'content' ); 
                            ?>
		                </div>
			        </div>
		        </li>
		        <?php endwhile; ?>
	        </ul>
        <?php endif; // if has_post() ?>
        <?php wp_reset_postdata(); // Reset postdata ?>
    <?php 
    }
}


/**
 * 
 * Recent Posts Function
 * -----------------------------------------------------------------------
 * This fucntion shows about the recent posts. It is the one of three 
 * parts in Tab widget.
 *
 * @since passport 1.0
 *
 */

if ( ! function_exists ( 'passport_recent_posts' ) ) {

    function passport_recent_posts() {

        global $post;

        $args =	array(
		    'post_type'				=> 'post',
		    'posts_per_page'		=> 3,
		    'no_found_rows'			=> true,
		    'post_status'			=> 'publish',
		    'ignore_sticky_posts'	=> true,
		    'post__not_in'			=> array( get_the_ID() ), //Not include current post
		    'meta_query' => array(
			    array(
				    'key'			=> '_thumbnail_id',
				    'compare'		=> '!=',
				    'value'			=> ''
			    )
		    )
	    ); 
    
        $wp_query = new WP_Query( $args );

            if (  $wp_query -> have_posts() ) : 
    ?>
            <ul class="list-unstyled">
		        <?php while ( $wp_query->have_posts() ) : $wp_query->the_post(); 
                    $title = get_the_title( $post->ID );
				    $image = get_the_post_thumbnail( $post->ID, 'standard-image', array( 'class' => 'alignleft' ) );
                ?>
			    <li class="<?php if( ! empty( $image ) || 0 != $attachment_id ) { echo 'has-thumbnail'; } else { echo 'no-thumbnail'; } ?> widget-list widget-post-item clearfix">
				    <div class="col-xs-12 col-sm-12 col-md-6 col-lg-6 enlarge">
                        <div class="post-standard frame">
					        <a href="<?php echo esc_url( get_permalink( $post->ID ) ); ?>" class="alignleft img-position hvr-grow">
                                <div class="bglayer">
                                    <?php if( ! empty( $image ) ) { echo $image; } ?>
                                </div>
                                <span class="icon-hero"><?php echo passport_icon_shows(); ?></span>
                            </a>
                        </div>
                    </div>
				    <div class="col-xs-12 col-sm-12 col-md-6 col-lg-6">
					    <div class="post-content clearfix">
                            <?php
							    get_template_part( 'partials/partials', 'header' ); 
                                get_template_part( 'partials/partials', 'content' ); 			 
                            ?>                        
					    </div>
				    </div>
			    </li>
		    <?php endwhile; ?>
		    </ul>
		    <?php endif; // if has_post() ?>
		    <?php wp_reset_postdata(); // Reset postdata ?>
     <?php 
    }
}


/**
 * 
 * Category Grid Function
 * -----------------------------------------------------------------------
 * This fucntion shows about the category images in grid. It is the one of three 
 * parts in Tab widget.
 *
 * @since passport 1.0
 *
 */

if ( ! function_exists ( 'passport_category_grid' ) ) {

    function passport_category_grid() {
        $i = 0;

        $categories = get_categories( array(
            'orderby' => 'rand',
            'parent'  => 0
        ) );
     
     ?>
        <div class="grid masonry-widget">
		    <div class="grid-sizer"></div>
		    <div class="gutter-sizer"></div>
            <?php foreach ( $categories as $category ) :
  
                $category_id        = $category->term_id;
                $category_option    = 'category_custom_order_' . $category_id;
	            $category_img_src	= get_option( $category_option );
                $category_link      = get_category_link( $category->term_id );
                $category_alt       = $category->name;
            ?>
                <?php if ( ! empty( $category_img_src ) ) : ?>
                    <?php if ( $i%4 == 0 ) : 
                        $category_img_src = substr_replace($category_img_src, '-562x276', -4, 0);
                      ?>
				        <div class="grid-item grid-item-width2 animateblock btm frame">
					        <div class="bglayer">
                                <a href="<?php echo esc_url( $category_link ); ?>" class="lightbox hvr-grow" title="<?php echo esc_attr( $category_alt ); ?>">
                                    <img src="<?php echo esc_url( $category_img_src ); ?>" class ="wp-post-image" alt="<?php echo esc_attr( $category_alt ); ?>"/>
                                    <span class="icon-plus"><i class="fa fa-plus"></i></span>
                                </a>
                            </div>
                            <span class="on-top"><?php echo $category_alt; ?></span>
	    		        </div>
		            <?php else : 
                        $category_img_src = substr_replace($category_img_src, '-276x276', -4, 0);
                     ?>
 				        <div class="grid-item  animateblock btm frame">
					        <div class="bglayer">
                                <a href="<?php echo esc_url( $category_link ); ?>" class="lightbox hvr-grow" title="<?php echo esc_attr( $category_alt ); ?>">
							        <img src="<?php echo esc_url( $category_img_src ); ?>" class ="wp-post-image" alt="<?php echo esc_attr( $category_alt ); ?>"/>
                                    <span class="icon-plus"><i class="fa fa-plus"></i></span>
						        </a>
					        </div>	   
                            <span class="on-top"><?php echo $category_alt; ?></span>
				        </div>
                    <?php endif; ?>
	            <?php endif; ?>
            <?php $i++; ?>
            <?php endforeach; ?>
        </div>
    <?php 
    }
}