<?php
/**
 * Pagination template functionality
 * -------------------------------------------------------------------------
 * Show the author section in single post.
 * This section shows the author's avatar, biography, and contact.
 *
 * @package WordPress
 * @subpackage passport
 * @since Passport 1.0
 * @Ref: Matthew Lewis's and Bootstrap
 * @Ref site: https://x00.io/blog/2015/05/bootstrap-pagination-with-wordpress/
 */

if ( ! function_exists( 'passport_theme_paging_nav' ) ) {

    function passport_theme_paging_nav() {
	    // Don't print empty markup if there's only one page.
	    if ( $GLOBALS['wp_query']->max_num_pages < 2 ) {
		    return;
	    }
 
	    $paged        = get_query_var( 'paged' ) ? intval( get_query_var( 'paged' ) ) : 1;

	    $pagenum_link = html_entity_decode( get_pagenum_link() );
	    $query_args   = array();
	    $url_parts    = explode( '?', $pagenum_link );
 
	    if ( isset( $url_parts[1] ) ) {
		    wp_parse_str( $url_parts[1], $query_args );
	    }
 
	    $pagenum_link = remove_query_arg( array_keys( $query_args ), $pagenum_link );
	    $pagenum_link = trailingslashit( $pagenum_link ) . '%_%';
 
	    $format  = $GLOBALS['wp_rewrite']->using_index_permalinks() && ! strpos( $pagenum_link, 'index.php' ) ? 'index.php/' : '';
	    $format .= $GLOBALS['wp_rewrite']->using_permalinks() ? user_trailingslashit( 'page/%#%', 'paged' ) : '?paged=%#%';
 
	    // Set up paginated links.
	    $links = paginate_links( array(
		    'base'				=> $pagenum_link,
		    'format'			=> $format,
		    'total'				=> $GLOBALS['wp_query']->max_num_pages,
		    'current'			=> $paged,
		    'show_all'			=> true,
		    'add_args'			=> array_map( 'urlencode', $query_args ),
		    'prev_next'			=> false,
		    //'prev_text'		=> esc_html__( '<span aria-hidden="true">&laquo;</span>', 'passport' ),
		    //'next_text'		=> esc_html__( '<span aria-hidden="true">&raquo;</span>', 'passport' ),
		    'type'				=> 'array',
	    ) );
 
    if ( $paged && 1 < $paged ) {
		    $prevLink = $pagenum_link;
		    $prevLink = str_replace( '%_%', $format, $prevLink );
		    $prevLink = str_replace( '%#%', $paged - 1, $prevLink );
    }
 
    if ( $paged && ( $paged < $GLOBALS['wp_query']->max_num_pages || -1 == $GLOBALS['wp_query']->max_num_pages ) ) {
		    $nextLink = $pagenum_link;
		    $nextLink = str_replace( '%_%', $format, $nextLink );
		    $nextLink = str_replace( '%#%', $paged + 1, $nextLink );
    } 
	    if ( isset( $links ) ) :
	    ?>
	    <nav class="navigation paging-navigation text-center">
		    <h1 class="screen-reader-text sr-only"><?php esc_html_e( 'Posts navigation', 'passport' ); ?></h1>
		    <ul class="pagination">
			    <li class="prev <?php if ( ! isset( $prevLink ) ) { echo 'disabled'; } ?>">
			      <?php if ( isset( $prevLink ) ) { echo '<a href="' . esc_url( $prevLink ) . '" aria-label="Previous">'; } ?>
				    <span aria-hidden="true">&laquo;</span>
			      <?php if ( isset( $prevLink ) ) { echo '</a>'; } ?>
			    </li>
			    <?php foreach( $links as $keyLink => $valueLink ) {
				    $class = '';
				    if ( ! strstr( $valueLink, '<a' ) ) {
					    $class = 'active';
				    }
				    echo '<li' . ( ! empty( $class ) ? ' class="' . $class . '"' : '') . '>' . $valueLink . '</li>';
			    }; ?>
 
			    <li class="next <?php if ( ! isset( $nextLink ) ) { echo 'disabled'; } ?>">
			      <?php if ( isset( $nextLink ) ) { echo '<a href="' . esc_url( $nextLink ) . '" aria-label="Next">'; } ?>
				    <span aria-hidden="true">&raquo;</span>
			      <?php if ( isset( $nextLink ) ) { echo '</a>'; } ?>
			    </li>
		    </ul>
	    </nav><!-- .navigation -->
	    <?php
	    endif;
    }
}