<?php
/**
 * Passport Theme back compat functionality
 * -------------------------------------------------------------------------
 * Prevents Passport theme from running on WordPress versions prior to 4.1,
 * since this theme is not meant to be backward compatible beyond that and
 * relies on many newer functions and markup changes introduced in 4.1.
 *
 * @package WordPress
 * @subpackage passport
 * @since Passport 1.0
 *
 **/
/**
 * Prevent switching to passport on old versions of WordPress.
 *
 * Switches to the default theme.
 *
 * @since Passport 1.0
 */
if( ! function_exists( 'passport_switch_theme' ) ) {

    function passport_switch_theme() {
	    switch_theme( WP_DEFAULT_THEME, WP_DEFAULT_THEME );
	    unset( $_GET['activated'] );
	    add_action( 'admin_notices', 'passport_upgrade_notice' );
    }

}
add_action( 'after_switch_theme', 'passport_switch_theme' );


/**
 * Add message for unsuccessful theme switch.
 *
 * Prints an update nag after an unsuccessful attempt to switch to
 * passport on WordPress versions prior to 4.1.
 *
 * @since Passport 1.0
 */
if( ! function_exists( 'passport_upgrade_notice' ) ) {

    function passport_upgrade_notice() {
	    $message = sprintf( esc_html__( 'This theme requires at least WordPress version 4.1. You are running version %s. Please upgrade and try again.', 'passport' ), $GLOBALS['wp_version'] );
	    printf( '<div class="error"><p>%s</p></div>', $message );
    }

}


/**
 * Prevent the Customizer from being loaded on WordPress versions prior to 4.1.
 *
 * @since Passport 1.0
 */
if( ! function_exists( 'passport_customize' ) ) {

    function passport_customize() {
	    wp_die( sprintf( esc_html__( 'This theme requires at least WordPress version 4.1. You are running version %s. Please upgrade and try again.', 'passport' ), $GLOBALS['wp_version'] ), '', array(
		    'back_link' => true,
	    ) );
    }

}
add_action( 'load-customize.php', 'passport_customize' );


/**
 * Prevent the Theme Preview from being loaded on WordPress versions prior to 4.1.
 *
 * @since Passport 1.0
 */
if( ! function_exists( 'passport_preview' ) ) {

    function passport_preview() {
	    if ( isset( $_GET['preview'] ) ) {
		    wp_die( sprintf( esc_html__( 'This theme requires at least WordPress version 4.1. You are running version %s. Please upgrade and try again.', 'passport' ), $GLOBALS['wp_version'] ) );
	    }
    }
}
add_action( 'template_redirect', 'passport_preview' );