<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>" />
<meta http-equiv="X-UA-Compatible" content="IE=edge" />
<meta name="viewport" content="width=device-width, initial-scale=1.0" />

<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<?php 
    global $passport_theme_setting;

    $passport_theme_setting	= get_theme_mod( 'passport_theme_setting', 'full_width_container' );
    $header_image			= get_header_image();
    $hide_extra_menu_bar	= get_theme_mod( 'passport_hide_extra_menu_section', 'false' );
        
	if( ! empty( $header_image ) ) : ?>
		<div id="header-image">
			<div class="row">
				<a href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" rel="home">
				    <!-- Header Image-->
				    <img src="<?php echo esc_url( $header_image ); ?>" height="<?php echo get_custom_header()->height; ?>" width="<?php echo get_custom_header()->width; ?>" alt="header-image" class="size-full"/>
				</a>
			</div>
		</div><!-- #header-image -->
	<?php endif; ?><!-- End of header image -->
	    <div id="header" class="site-header <?php if( 'full_width_container' == $passport_theme_setting && is_front_page() && ! is_home() ) { echo 'full'; } else { echo 'fix'; } ?>">
		    <nav id="primary-menu-bar" class="navbar navbar-default navbar-static-top">
			    <div class="container">
				    <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#primary-menu-container">
					    <span class="sr-only">Toggle navigation</span>
					    <span class="icon-bar"></span>
					    <span class="icon-bar"></span>
					    <span class="icon-bar"></span>
				    </button>
				    <?php get_template_part( 'partials/partials', 'site-header' ); ?>
				    <?php echo passport_primary_menu(); ?>
			    </div>
		    </nav><!-- #primary-menu-bar -->
		    <?php if ( is_front_page() ) : ?>
			    <div id="primary-header" class="container">
				    <?php get_template_part( 'partials/partials', 'headline' ); ?>
			    </div><!-- #primary-header -->
		    <?php elseif( ! is_front_page() ) :
				    if ( function_exists( 'passport_the_breadcrumb' ) ) : ?>
				    <div class="container">
					    <div class="content-column fix-width clearfix">
						    <?php echo passport_the_breadcrumb(); ?>
					    </div>
				    </div>
				    <?php endif;
		    endif; ?>
		    <?php if ( empty ( $hide_extra_menu_bar ) ) : ?>
		    <nav id="extra-menu-bar" class="extra-navbar navbar navbar-default">
			    <div class="container">
				    <?php get_template_part( 'partials/partials', 'site-header' ); ?>
				    <?php echo passport_extra_menu(); ?>
			    </div>
		    </nav><!-- #extra-menu-bar -->
		    <?php endif; ?>
	    </div><!-- #header -->
	    <div class="clear"></div>