<?php
/**
 * Back compatibility
 * Wordpress version can not be less than version 4.1.
 */
if ( version_compare( $GLOBALS['wp_version'], '4.1', '<' ) ) {
    require( get_template_directory() . '/includes/back-compat.php' );
}


/**
 * The current version of the theme and theme slug
 */
define( 'PASSPORT_VERSION', '1.0.0' );
define( 'PASSPORT_THEME_SLUG' , 'passport' );


/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
if( ! function_exists( 'passport_content_width' ) ) {

    function passport_content_width() {
	    $GLOBALS['content_width'] = apply_filters( 'passport_content_width', 1170 );
    }
}
add_action( 'after_setup_theme', 'passport_content_width', 0 );


/**
 * Adjust the content width when the page templates is being used
 */
if( ! function_exists( 'passport_adjust_content_width' ) ) {

    function passport_adjust_content_width() {

        global $content_width;
	    global $passport_template_name;
        global $passport_post_content_column;
	    global $passport_post_sidebar_width;
 
	    if ( is_single() && 'main_content' == $passport_post_content_column ) {
		    $content_width = 1170;
	    } elseif (  is_single() && 'sidebar_33' == $passport_post_sidebar_width ) {
		    $content_width = 760; 
	    } elseif (  is_single() && 'sidebar_25' == $passport_post_sidebar_width ) {
		    $content_width = 855; 
	    } elseif ( "template-large-image.php" == $passport_template_name ) {
		    $content_width = 1140;
	    } elseif ( "template-masonry.php" == $passport_template_name ) {
		    $content_width = 350;
	    } elseif ( "template-medium-image.php" == $passport_template_name || is_archive() || is_search() ) {
		    $content_width = 540;
	    }
    }
}
add_action( 'template_redirect', 'passport_adjust_content_width' );


/*
 * Set up theme menus
 */
require_once ( get_template_directory() . '/includes/theme-menu.php' );

/*
 * Set up the widget area 
 */
require_once ( get_template_directory() . '/includes/widgets/widget-area.php' );

/*
 * Set up Bootstrap pagination
 */
require_once ( get_template_directory() . '/includes/bootstrap-pagination.php' ); 

/*
 * Set up the post format
 */
require_once ( get_template_directory() . '/includes/post-formats.php' ); 

/*
 * Set up metabox
 */
require_once ( get_template_directory() . '/includes/metabox.php' );

/*
 * Load post like 
 */
require_once ( get_template_directory() . '/includes/post-like.php' );

/*
 * Load social share
 */
require_once ( get_template_directory() . '/includes/social-share.php' );

/*
 * Add more editor plugins
 */
require_once ( get_template_directory() . '/includes/editor-buttons/editor.php' );

/*
 * Force SSL URL Scheme
 */
require_once ( get_template_directory() . '/includes/force-ssl-url-scheme.php' );

/*
 * Set up Bootstrap navwalker
 */
require_once ( get_template_directory() . '/includes/wp_bootstrap_navwalker.php' );


/**
 * Including the widget functions.
 * 
 *
 * @since passport 1.0 
 * 
 */
include_once 'includes/widgets/parallax.php';
include_once 'includes/widgets/slider.php';
include_once 'includes/widgets/featured-posts-by-category.php';
include_once 'includes/widgets/featured-posts-by-post-format.php';
include_once 'includes/widgets/post-list-by-category.php';
include_once 'includes/widgets/post-list-by-post-format.php';
include_once 'includes/widgets/post-by-id.php';
include_once 'includes/widgets/recent-posts-with-thumbnails.php';
include_once 'includes/widgets/recent-posts-with-video.php';
include_once 'includes/widgets/posts-in-box-format.php';
include_once 'includes/widgets/posts-in-carousel-slider.php';
include_once 'includes/widgets/most-popular-posts-widget.php';
include_once 'includes/widgets/accordion.php';
include_once 'includes/widgets/tabs.php';
include_once 'includes/widgets/column.php';
include_once 'includes/widgets/contact-us.php';
include_once 'includes/widgets/image-widget.php';


/**
 * Setup the WordPress core custom header feature.
 * -------------------------------------------------------------------------
 * Use add_theme_support to register support for WordPress 3.4+
 *
 * @since Passport 1.0 
 *
 **/

if( ! function_exists( 'passport_custom_header_setup' ) ) {

    function passport_custom_header_setup() {
	    $args = array(
		    'default-text-color' => 'fff',
		    'width'				 => 1379,
		    'height'			 => 570,
		    'flex-width'		 => true,
		    'flex-height'		 => true,
		    'default-image'		 => '',
		    'upload'			 => true,
		    'wp-head-callback'	 => '',
	    );

	    $args = apply_filters( 'passport_custom_header_args', $args );
 
	    add_theme_support( 'custom-header', $args );

    }
}
add_action( 'after_setup_theme', 'passport_custom_header_setup' );


/**
 * Setup the WordPress core custom background feature.
 * ------------------------------------------------------------------------
 * Use add_theme_support to register support for WordPress 3.4+
 * Hooks into the after_setup_theme action.
 *
 * @since Passport 1.0 
 *
 */
if( ! function_exists( 'passport_register_custom_background' ) ) {

    function passport_register_custom_background() {
        $args = array(
            'default-color'          => 'f1f1f1',
       	    'default-repeat'         => 'no-repeat',
	        'default-position-x'     => '',
	        'default-attachment'     => 'fixed',
	        'wp-head-callback'       => '_custom_background_cb',
	        'admin-head-callback'    => '',
	        'admin-preview-callback' => ''
        );
 
        $args = apply_filters( 'passport_custom_background_args', $args );
	    add_theme_support( 'custom-background', $args );

    }

}
add_action( 'after_setup_theme', 'passport_register_custom_background' );


/**
 * Setup the WordPress core custom.
 * ------------------------------------------------------------------------
 * Use add_theme_support to register support for WordPress 3.4+
 * Hooks into the after_setup_theme action.
 *
 * @since Passport 1.0 
 *
 */
if( ! function_exists( 'passport_custom_theme_setup' ) ) {

    function passport_custom_theme_setup() {

        // Add default posts and comments RSS feed links to head.
	    add_theme_support( 'automatic-feed-links' );


        /*
	     * Let WordPress manage the document title.
	     * By adding theme support, we declare that this theme does not use a
	     * hard-coded <title> tag in the document head, and expect WordPress to
	     * provide it for us.
	     */
	    add_theme_support( 'title-tag' );


	    /*
	     * Enable support for Post Thumbnails on posts and pages.
	     *
	     * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
	     */
	    add_theme_support( 'post-thumbnails' );


        /*
	     * Switch default core markup for search form, comment form, and comments
	     * to output valid HTML5.
	     */
	    add_theme_support( 'html5', array(
		    'comment-form',
		    'comment-list',
		    'gallery',
		    'caption',
	    ) );


        /* Adds post formats to theme. */
	    add_theme_support( 
            'post-formats', 
            array( 
                'aside', 
                'link', 
                'quote', 
                'image', 
                'gallery', 
                'audio', 
                'video'
            ) 
        );

        /* Add Custom Logo to theme. */
        add_theme_support( 
            'custom-logo', 
            array(
	            'height'      => 50,
	            'width'       => 100,
	            'flex-height' => true,
	            'flex-width'  => true,
	            'header-text' => array( 'site-title', 'site-description' ),
            ) 
        ); 
    }

}
add_action( 'after_setup_theme', 'passport_custom_theme_setup', 20 );


/**
 * Enqueue the front-end script and style function
 * ------------------------------------------------------------------------
 * Function to enqueue the front-end scrip and style.
 * 
 *
 * @since passport 1.0 
 *
 */
if( ! function_exists( 'passport_adding_script' ) ) {

    function passport_adding_scripts() {
        global $wp_styles;
        /**
		  * Front end Scripts
		  */
	    /*Comment Reply*/
	    if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		    wp_enqueue_script( 'comment-reply' );
	    }


	    /* bootstrap */
	    wp_enqueue_script( 
            PASSPORT_THEME_SLUG . '-bootstrap', 
            get_template_directory_uri() . '/assets/third-party/bootstrap/dist/js/bootstrap.min.js', 
            array( 
                'jquery' 
            ),
            '3.3.4', 
            true 
        );

	    /* Masonry and ImagesLoaded */
	    wp_enqueue_script( 
            PASSPORT_THEME_SLUG . '-masonry', 
            get_template_directory_uri() . '/assets/third-party/masonry/dist/masonry.pkgd.min.js', 
            array( 
                'jquery', 
                PASSPORT_THEME_SLUG . '-bootstrap' 
            ),
            '3.2',
            true 
        );

        /* Images loaded */
	    wp_enqueue_script( 
            PASSPORT_THEME_SLUG . '-imagesloaded', 
            get_template_directory_uri() . '/assets/third-party/imagesloaded/imagesloaded.pkgd.min.js', 
            array( 
                'jquery', 
                PASSPORT_THEME_SLUG . '-bootstrap', 
                PASSPORT_THEME_SLUG . '-masonry' 
            ), 
            '3.1.8', 
            true 
        );


	    /* Imagefill */
	    wp_enqueue_script( 
            PASSPORT_THEME_SLUG . '-imagefill', 
            get_template_directory_uri() . '/assets/third-party/imagefill/js/jquery-imagefill.js', 
            array( 
                'jquery', 
                PASSPORT_THEME_SLUG . '-imagesloaded' 
            ), 
            '1.0.0', 
            true 
        );
  	

        /* Owl */
	    wp_enqueue_script( 
            PASSPORT_THEME_SLUG . '-owl-carousel', 
            get_template_directory_uri() . '/assets/third-party/owl.carousel/owl.carousel.min.js', 
            array( 
                'jquery' 
            ),
            '2.0.0', 
            true 
        );


	    /* Like Post */
	    wp_enqueue_script( 
            PASSPORT_THEME_SLUG . '-simple-likes-public-js', 
            get_template_directory_uri() . '/assets/js/simple-likes-public.js', 
            array( 
                'jquery' 
            ), 
            '0.5', 
            true 
        );


        /*Simple Like Script*/
	    wp_localize_script( 
            PASSPORT_THEME_SLUG . '-simple-likes-public-js', 
            'simpleLikes', 
            array(
		        'ajaxurl'   => admin_url( 'admin-ajax.php' ),
		        'like'      => esc_html__( 'Like', 'passport' ),
		        'unlike'    => esc_html__( 'Unlike', 'passport' )
	        )
        ); 


	    /* Typed.js */
	    wp_enqueue_script( 
            PASSPORT_THEME_SLUG . '-typed', 
            get_template_directory_uri() . '/assets/js/typed.js', 
            array( 
                'jquery' 
            ), 
            '1.1.4', 
            true 
        );

	    wp_localize_script( 
            PASSPORT_THEME_SLUG . '-typed', 
            'site', 
            array( 
                'sitename' => get_bloginfo() 
            ) 
        );


	    $facebook_id = get_theme_mod( 'passport_facebook_app_id', '' );
	    /* Social Media */
	    wp_enqueue_script( 
            PASSPORT_THEME_SLUG . '-social_media-js', 
            get_template_directory_uri().'/assets/js/social-media.js', 
            array( 
                'jquery' 
            ), 
            PASSPORT_VERSION,
            true 
        );

	    wp_localize_script( 
            PASSPORT_THEME_SLUG . '-social_media-js', 
            'facebook', 
            array( 
                'app_id' => $facebook_id 
            ),
            PASSPORT_VERSION
        );


	    /*Setup*/
	    wp_register_script( 
            PASSPORT_THEME_SLUG . '-setup-script-js', 
            get_template_directory_uri() . '/assets/js/setup.js', 
            array( 
                'jquery' 
            ), 
            PASSPORT_VERSION,
            true
        );
	    wp_enqueue_script( PASSPORT_THEME_SLUG . '-setup-script-js' );


        /*Slider*/
	    wp_register_script( 
            PASSPORT_THEME_SLUG . '-slider-js', 
            get_template_directory_uri() . '/assets/js/slider.js', 
            array( 
                'jquery' 
            ), 
            PASSPORT_VERSION,
            true
        );
	    wp_enqueue_script( PASSPORT_THEME_SLUG . '-slider-js' );


        /**
          * Front end Styles
	      */
        /*Bootstrap*/
   	    wp_enqueue_style( 
            'bootstrap', 
            get_template_directory_uri() . '/assets/third-party/bootstrap/dist/css/bootstrap.css',
            array(),
            '3.3.4' 
       );


        /*Google Fonts*/
	    wp_enqueue_style( 
            PASSPORT_THEME_SLUG . '-google-fonts', 
            'https://fonts.googleapis.com/css?family=Roboto:300,400,500,700|Handlee',
            array(),
            PASSPORT_VERSION
        );


	    /* FontAwesome */
	    wp_enqueue_style( 
            PASSPORT_THEME_SLUG . '-font-awesome', 
            get_template_directory_uri() . '/assets/third-party/font-awesome-4.5.0/css/font-awesome.css',
            array(),
            '4.5.0' 
        );


	    /* Owl Carousel */
	    wp_enqueue_style( 
            PASSPORT_THEME_SLUG . '-owl-carousel', 
            get_template_directory_uri() . '/assets/third-party/owl.carousel/assets/owl.carousel.css',
            array(),
            '2.0.0'
        );


        /*Typography*/
	    wp_register_style( 
            PASSPORT_THEME_SLUG . '-typography', 
            get_template_directory_uri() . '/assets/css/typography.css',
            array(),
            PASSPORT_VERSION
        );
        wp_enqueue_style( PASSPORT_THEME_SLUG . '-typography' );


        /*Layout*/
	    wp_register_style( 
            PASSPORT_THEME_SLUG . '-layout', 
            get_template_directory_uri() . '/assets/css/layout.css',
            array(),
            PASSPORT_VERSION
        );
        wp_enqueue_style( PASSPORT_THEME_SLUG . '-layout' );


        /*Module*/
	    wp_register_style( 
            PASSPORT_THEME_SLUG . '-module', 
            get_template_directory_uri() . '/assets/css/module.css',
            array(),
            PASSPORT_VERSION 
        );
        wp_enqueue_style( PASSPORT_THEME_SLUG . '-module' );


	    /* Responsive */
        wp_enqueue_style( 
            PASSPORT_THEME_SLUG . '-responsive',
            get_template_directory_uri() . '/assets/css/responsive.css',
            array(),
            PASSPORT_VERSION 
        );
    }
}

add_action( 'wp_enqueue_scripts', 'passport_adding_scripts' );


/**
 * Stylesheet function.
 * ------------------------------------------------------------------------
 * Load parent stylesheet.
 * 
 *
 * @since passport 1.0 
 *
 */
if( ! function_exists( 'passport_scripts' ) ) {

    function passport_scripts() {

	    /*load our main stylesheet*/
        wp_enqueue_style( 
            PASSPORT_THEME_SLUG . '-parent-stylesheet', 
            get_stylesheet_uri(), 
            PASSPORT_VERSION,
            false 
        );

    }
}
add_action( 'wp_enqueue_scripts', 'passport_scripts' );


/**
 * Enqueue the custom style function
 * ------------------------------------------------------------------------
 * Function to enqueue the custom style.
 * 
 *
 * @since passport 1.0 
 *
 */
if( ! function_exists( 'passport_custom_style' ) ) {

    function passport_custom_style() {
	    /* Custom Inline Style - Please do not delete this file. */
	    wp_enqueue_style( 
            PASSPORT_THEME_SLUG . '-custom-style', 
            get_template_directory_uri() . '/assets/css/custom-style.css',
            array(),
            PASSPORT_VERSION
        );
    }

}
add_action( 'wp_enqueue_scripts', 'passport_custom_style' );


/**
 * Enqueue the admin script function
 * ------------------------------------------------------------------------
 * Function to enqueue the admin script and style.
 * 
 *
 * @since passport 1.0 
 *
 */
if( ! function_exists( 'passport_admin_script' ) ) {

    function passport_admin_script(){
        
	    /*jQuery UI*/
        wp_enqueue_style( 
            'jquery-ui', 
            get_template_directory_uri() . '/assets/third-party/jquery-ui-1.11.4/jquery-ui.min.css',
            array(),
            '1.11.4'
        );

	    wp_enqueue_script( 
            'jquery-ui', 
            get_template_directory_uri() . '/assets/third-party/jquery-ui-1.11.4/jquery-ui.min.js', 
             array( 
                'jquery' 
             ), 
            '1.11.4',
             true 
         );
    

        /*Media*/
        wp_enqueue_media();
        wp_enqueue_style( 'thickbox' );
	    wp_enqueue_script( 'thickbox' );


	    /* Media Upload */
	    wp_register_script( 
            PASSPORT_THEME_SLUG . '-wp-media-upload', 
            get_template_directory_uri().'/assets/js/wp-media-upload.js', 
            array( 
                'jquery',
                'thickbox' 
            ),
            PASSPORT_VERSION,
            true 
        );
	    wp_enqueue_script( PASSPORT_THEME_SLUG . '-wp-media-upload' );


	    /* Color Picker */
	    wp_enqueue_style( 'wp-color-picker' );
	    wp_enqueue_script( 'wp-color-picker' );
	    wp_enqueue_script( 
            PASSPORT_THEME_SLUG . '-wp-color-picker-settings', 
            get_template_directory_uri() . '/assets/js/colorpicker.js', 
            array( 
                'jquery' 
            ), 
            '1.11.4',
            true 
        );


        /*Google Fonts*/
	    wp_enqueue_style( 
            PASSPORT_THEME_SLUG . '-google-fonts', 
            'https://fonts.googleapis.com/css?family=Roboto:300,400,500,700|Handlee', 
            array(),
            PASSPORT_VERSION
        );


        /*Admin Script*/
        wp_enqueue_script( 
            PASSPORT_THEME_SLUG . '-admin-script', 
            get_template_directory_uri() . '/assets/js/admin-script.js', 
            array( 
                'jquery', 
                'jquery-ui', 
                'wp-color-picker', 
                PASSPORT_THEME_SLUG . '-wp-color-picker-settings' 
            ),
            PASSPORT_VERSION,
            true 
            );

	    /* Admin */
	    wp_enqueue_style( 
            PASSPORT_THEME_SLUG . '-admin', 
            get_template_directory_uri() . '/assets/css/admin.css',
            array(),
            PASSPORT_VERSION
        );
    }
}
add_action( 'admin_enqueue_scripts', 'passport_admin_script' );


/**
 * Insert Custom Image Sizes function
 * ------------------------------------------------------------------------
 * Insert Custom Image Sizes in Add Media (Backend)
 * 
 *
 * @since passport 1.0 
 * @Ref site: http://kucrut.org/insert-image-with-custom-size-into-post/
 */
 
if( ! function_exists( 'passport_insert_custom_image_sizes' ) ) {

    function passport_insert_custom_image_sizes( $sizes ) {
	    global $_wp_additional_image_sizes;
		
        if ( empty( $_wp_additional_image_sizes ) ) {
		    return $sizes;
        }

	    foreach ( $_wp_additional_image_sizes as $id => $data ) {
		    if ( ! isset( $sizes[ $id ] ) )
		    $sizes[ $id ] = ucfirst( str_replace( '-', ' ', $id ) );
	    }

	    return $sizes;
    }

}
add_filter( 'image_size_names_choose', 'passport_insert_custom_image_sizes' );


/**
 * 
 * Get Image Size function
 * -----------------------------------------------------------------------
 * Get the available image sizes.
 *
 *
 * @since passport 1.0
 *
 */

if( ! function_exists( 'passport_get_image_sizes' ) ) {

    function passport_get_image_sizes( $size = '' ) {

	    global $_wp_additional_image_sizes;

		    $sizes = array();
		    $get_intermediate_image_sizes = get_intermediate_image_sizes();

		    // Create the full array with sizes and crop info
		    foreach( $get_intermediate_image_sizes as $_size ) {
			    if ( in_array( $_size, array( 'thumbnail', 'medium', 'medium_large', 'large' ) ) ) {
				    $sizes[ $_size ]['width']	= get_option( $_size . '_size_w' );
				    $sizes[ $_size ]['height']	= get_option( $_size . '_size_h' );
				    $sizes[ $_size ]['crop']	= (bool) get_option( $_size . '_crop' );
			    } elseif ( isset( $_wp_additional_image_sizes[ $_size ] ) ) {
				    $sizes[ $_size ] = array( 
					    'width'		=> $_wp_additional_image_sizes[ $_size ]['width'],
					    'height'	=> $_wp_additional_image_sizes[ $_size ]['height'],
					    'crop'		=> $_wp_additional_image_sizes[ $_size ]['crop']
				    );
			    }
		    }
		    // Get only 1 size if found
		    if ( $size ) {
			    if( isset( $sizes[ $size ] ) ) {
				    return $sizes[ $size ];
			    } else {
				    return false;
			    }
		    }
	    return $sizes;
    }

}


/**
 * Default image function.
 * ------------------------------------------------------------------------
 * Function to call the default image from HOME page.
 * 
 *
 * @since passport 1.0 
 *
 */

add_filter( 'post_thumbnail_html', 'passport_post_image_html', 10, 5 );

if( ! function_exists( 'passport_post_image_html' ) ) {

    function passport_post_image_html( $html, $post_id, $post_thumbnail_id, $size, $attr ) {

	    global $passport_template_name;
	    global $_wp_additional_image_sizes;
	
	    $frontpage_id		= get_option( 'page_on_front' );
	    $attachment_id		= get_post_thumbnail_id( $frontpage_id );

	    if( '' == $html ) {
		    if ( "template-masonry.php" == $passport_template_name ) {
			    $image_attributes	= wp_get_attachment_image_src( $attachment_id, 'masonry-template-550-550' ); 
		    } else {
			    $image_attributes	= wp_get_attachment_image_src( $attachment_id, 'large-image' ); 
		    }
		    if( isset( $_wp_additional_image_sizes[$size] ) ) {
			    $width		= $_wp_additional_image_sizes[$size]['width'];
			    $height		= $_wp_additional_image_sizes[$size]['height'];
		    } 

		    if( ! empty( $attachment_id) ) {
			    $html = '<img src="' . esc_url( $image_attributes[0] ) . '" width="'. $width .'" height="'. $height .'" class="default-image">';
		    } else {
			    $html = '';
		    }
	    } 
	    return $html;
    }

}

/**
 * Add Additional Image Size function
 * ------------------------------------------------------------------------
 * Function to add the additional image size.
 * 
 *
 * @since passport 1.0 
 * @use add_image_size( $name, $width, $height, $crop )
 *
 */

if( ! function_exists( 'passport_add_image_size' ) ) {

    function passport_add_image_size() {
	    /* Adds Image Size */
	    add_image_size( 'menu-80-43.5', 80, 43.5, array( 'center', 'center' ) ); /*Menu - Left, Right*/
	    add_image_size( 'gallery-228-300', 228, 300, array( 'center', 'center' ) ); /*Five Column Gallery Post Format*/
	    add_image_size( 'gallery-285-300', 285, 300, array( 'center', 'center' ) );  /*Four Column Gallery Post Format*/
	    add_image_size( 'gallery-380-300', 380, 300, array( 'center', 'center' ) ); /*Three Column Gallery Post Format*/
	    add_image_size( 'gallery-570-300', 570, 300, array( 'center', 'center' ) );  /*Two Column Gallery Post Format*/
        add_image_size( 'large-image-1349-670', 1349, 670, array( 'center', 'center' ) );  /*Home, Single, Page, Slider Widget, Short Content*/  
	    add_image_size( 'large-image', 1140, 600, array( 'center', 'center' ) );  /*Home, Single, Page, Slider Widget, Short Content*/
        add_image_size( 'large-image-855-450', 855, 450, array( 'center', 'center' ) );
        add_image_size( 'large-image-760-400', 760, 400, array( 'center', 'center' ) );
        add_image_size( 'large-image-756-398', 756.66, 398.23, array( 'center', 'center' ) );
        add_image_size( 'large-image-566-298', 566.66, 298.23, array( 'center', 'center' ) );
        add_image_size( 'column-image-565-375', 565, 375.92, array( 'center', 'center' ) );   
        add_image_size( 'column-image-373-196', 373.33, 196.53, array( 'center', 'center' ) );
        add_image_size( 'column-image-277-184', 277.5, 184.63, array( 'center', 'center' ) );
	    add_image_size( 'standard-image', 825, 434, array( 'center', 'center' ) ); /*Front page, Medium image template, search, archive Accordian, etc*/
	    add_image_size( 'masonry-template-550-550', 550, 550, array( 'center', 'center' ) ); /*Masonry Template*/
	    add_image_size( 'related-post-276-276', 276.25, 276.25, array( 'center', 'center' )); /*Related-posts-full-width*/
	    add_image_size( 'related-post-285-190', 285, 190, array( 'center', 'center' ) ); /*Related-posts sidebar 33, 25*/
        add_image_size( 'small-140-110', 140, 110, array( 'center', 'center' ) ); /*Widget - post id */
	    add_image_size( 'small-100-70', 100, 70, array( 'center', 'center' ) ); /*Widget - post-list, post-format-list, post-widget, popular-posts, thumbnail-widget */
	    add_image_size( 'small-120-70', 120, 70, array( 'center', 'center' ) ); /*Slider Widget*/
        add_image_size( 'medium-570-299', 570, 299.98, array( 'center', 'center' ) ); /*Post ID Widget */
	    add_image_size( 'box-900-507', 900, 507, array( 'center', 'center' ) );/*Box Widget*/
	    add_image_size( 'box-760-400', 760, 400, array( 'center', 'center' ) ); /*Box Widget*/
	    add_image_size( 'box-225-169', 225, 169, array( 'center', 'center' ) ); /*Box - Small*/
	    add_image_size( 'box-240-168', 240, 168, array( 'center', 'center' ) ); /*Box - Small*/
	    add_image_size( 'carousel-276-276', 276.25, 276.25, array( 'center', 'center' ) ); /*Carousel Slider Widget*/
        add_image_size( 'carousel-300-225', 300, 225, array( 'center', 'center' ) ); /*Carousel Slider Widget*/
        add_image_size( 'carousel-300-300', 300, 300, array( 'center', 'center' ) ); /*Carousel Slider Widget*/
	    add_image_size( 'grid-276-276', 276, 276, array( 'center', 'center' ) ); /*Tab Widget*/	
	    add_image_size( 'grid-562-276', 562, 276, array( 'center', 'center' ) ); /*Tab Widget*/
        add_image_size( 'banner-image', 1140, 300, array( 'center', 'center' ) ); /*Post Format*/
    }
}
add_action( 'after_setup_theme', 'passport_add_image_size', 20 );


/**
 * Display image function.
 * ------------------------------------------------------------------------
 * This function uses for displaying the image with the suitable size.
 * 
 *
 * @since passport 1.0 
 *
 */
if ( ! function_exists ( 'passport_display_image' ) ) {

    function passport_display_image() {
	    global $passport_template_name;
        global $passport_headline_column;
        global $passport_section_settings;
        global $passport_post_content_column;
        global $passport_post_sidebar_width;
        global $passport_page_content_column;
        global $passport_page_sidebar_width;
        global $passport_blog_content_column;
        global $passport_blog_sidebar_width;
        global $passport_front_page_column;
        global $passport_footer_column;

        if( is_single() && 'sidebar' == $passport_post_content_column && 'sidebar_33' == $passport_post_sidebar_width || is_page() && 'sidebar' == $passport_page_content_column && 'sidebar_33' == $passport_page_sidebar_width ) {
		    $images = the_post_thumbnail( 'large-image-760-400' );
        } elseif( is_single() && 'sidebar' == $passport_post_content_column && 'sidebar_25' == $passport_post_sidebar_width || is_page() && 'sidebar' == $passport_page_content_column && 'sidebar_25' == $passport_page_sidebar_width ) {
		    $images = the_post_thumbnail( 'large-image-855-450' );
        } elseif( is_single() || is_page() ) {
		    $images = the_post_thumbnail( 'large-image' );
	    } elseif( "template-masonry.php" == $passport_template_name ) {
		    $images = the_post_thumbnail( 'masonry-template-550-550' ); //Default:'masonry-image'
	    } elseif( "template-medium-image.php" == $passport_template_name ) {
		    $images = the_post_thumbnail( 'standard-image' );
	    } elseif( "template-large-image.php" == $passport_template_name && 'sidebar' == $passport_blog_content_column && 'sidebar_33' == $passport_blog_sidebar_width ||  is_home() && 'sidebar' == $passport_blog_content_column && 'sidebar_33' == $passport_blog_sidebar_width ) {
		    $images = the_post_thumbnail( 'large-image-760-400' );
	    } elseif( "template-large-image.php" == $passport_template_name && 'sidebar' == $passport_blog_content_column && 'sidebar_25' == $passport_blog_sidebar_width ||  is_home() && 'sidebar' == $passport_blog_content_column && 'sidebar_25' == $passport_blog_sidebar_width ) {
		    $images = the_post_thumbnail( 'large-image-855-450' );
	    } elseif( "template-large-image.php" == $passport_template_name || is_home() ) {
		    $images = the_post_thumbnail( 'large-image' );
	    } elseif( is_search() || is_archive() ) {
		    $images = the_post_thumbnail( 'standard-image' );
		} elseif( is_front_page() && '4' == $passport_front_page_column || '4' == $passport_footer_column ) {
		    $images = the_post_thumbnail( 'column-image-277-184' );
		} elseif( is_front_page() && '3' == $passport_front_page_column || '3' == $passport_footer_column ) {
		    $images = the_post_thumbnail( 'column-image-373-196' );
		} elseif( is_front_page() && '2' == $passport_front_page_column || '2' == $passport_footer_column ) {
		    $images = the_post_thumbnail( 'column-image-565-375' );
	    } elseif( is_front_page() && is_home() ) {
		    $images = the_post_thumbnail( 'large-image' );
        } elseif( is_front_page() && 'sidebar' == $passport_section_settings ) {
	        $images = the_post_thumbnail( 'large-image-756-398' );
        } elseif( is_front_page() && 'main_content' == $passport_section_settings ) {
            $images = the_post_thumbnail( 'large-image-756-398' );
		} elseif( is_front_page() ) {
		    $images = the_post_thumbnail( 'large-image' );
	    } else {
		    $images = the_post_thumbnail( 'large-image' );
	    }
        return $images;
    }
}


/**
 * Download image function.
 * ------------------------------------------------------------------------
 * This function uses for the attachment.php file. There are only three 
 * standard image size.
 * 
 *
 * @since passport 1.0 
 *
 */
if ( ! function_exists ( 'passport_download_image' ) ) {

    function passport_download_image() {
	    $images = array();
	    $image_sizes = array( 'thumbnail', 'medium', 'large' );
	    array_unshift( $image_sizes, 'full' );

	    foreach( $image_sizes as $image_size ) {
		    $image = wp_get_attachment_image_src( get_the_ID(), $image_size );
		    $name = $image_size . ' ( ' . $image[1] . 'x' . $image[2] . ' )';
		    $images[] = '<a href="' . esc_url( $image[0] ) . '">' . $name . '</a>';
	    }
	    echo implode( ' | ', $images );
    }
}


/**
 * 
 * Short title function
 * -----------------------------------------------------------------------
 * Limit Post Title by amount of characters
 *
 *
 * @since passport 1.0
 * @use strlen() to count the string length
 * @use mb_substr (Multibyte String function) to limit the length of the title.
 * @You can set $limit in the desirable file.
 * @please see the example at the featured-posts-by-category widget.
 */
 if ( ! function_exists ( 'passport_short_title' ) ) {

    function passport_short_title( $title, $limit ) {
      //$limit = 40; /*If you would like to change all short title. Change here*/
	    $pad="...";

	    if( strlen( $title ) >= ( $limit+3 ) ) {
		    $title = mb_substr( $title, 0, $limit ) . $pad; 
	    }
	    echo $title;
    }
}


/**
 * 
 * Customize excerpt word count length
 * ------------------------------------------------------------------------
 * The excerpt length will be set automatically if there is no 
 * setting in admin panel. 
 * For the excerpt in sidebar, you can use the default wordpress setting 
 * to set the excerpt length. Example: the more tag (<!--more-->) or the 
 * excerpt option.
 *
 * @since passport 1.0 
 *
 */
if ( ! function_exists ( 'passport_custom_excerpt_length' ) ) {

    function passport_custom_excerpt_length() {

	    global $passport_template_name;
        global $passport_theme_setting;
        global $passport_section_settings;
        global $passport_sidebar_width;
        global $passport_blog_content_column;
	    global $passport_blog_sidebar_width;

        if( ( "template-large-image.php" == $passport_template_name ) ) { // Excerpt - Large image template
		    return 100;
        } elseif( ( "template-masonry.php" == $passport_template_name ) ) { // Excerpt - Masonry template
		    return 25;
	    } elseif( ( "template-medium-image.php" == $passport_template_name || is_archive() || is_search() )  && "sidebar" == $passport_blog_content_column && "sidebar_33" == $passport_blog_sidebar_width && has_post_thumbnail() ) { // Excerpt - Medium image template (Size 33)
		    return 18;
	    } elseif( ( "template-medium-image.php" == $passport_template_name || is_archive() || is_search() )  && "sidebar" == $passport_blog_content_column && "sidebar_25" == $passport_blog_sidebar_width && has_post_thumbnail() ) { // Excerpt - Medium image template (Size 25)
		    return 25;		
        } elseif( ( "template-medium-image.php" == $passport_template_name || is_archive() || is_search() ) && "main_content" == $passport_blog_content_column ) { // Excerpt - Medium image template (Full)
		    return 65;
        } elseif( is_front_page() && 'full_width_container' == $passport_theme_setting ) { //Front page and Full width container
            return 65;
        } elseif( is_front_page() && 'sidebar' == $passport_section_settings && 'sidebar_33' == $passport_sidebar_width ) { //Front page and sidebar 33
            return 35;
        } elseif( is_front_page() && 'sidebar' == $passport_section_settings && 'sidebar_25' == $passport_sidebar_width ) { //Front page and sidebar 25
            return 30;
        } elseif( is_front_page() && ! is_page_template() ) { //Front page and magazine template
            return 100;
        } elseif( is_home() ) { //Home
            return 100;
	    } elseif( is_front_page() ) { //Front page
		    return 30;
        } else { //Else
		    return 55;
	    }
    }

}
add_filter( 'excerpt_length', 'passport_custom_excerpt_length' );


/**
 * 
 * Change Excerpt More Style function.
 * Version 2.9 and higher
 * ------------------------------------------------------------------------
 * This excerpt more function will be used when no excerpt is set in the 
 * admin panel. It will work with the custom excerpt length function
 *
 * @since passport 1.0
 *
 */
if ( ! function_exists ( 'passport_new_excerpt_more' ) ) {

    function passport_new_excerpt_more( $more ) {
	    return '  ...';
    }

}
add_filter( 'excerpt_more', 'passport_new_excerpt_more' );


/**
 *
 * Custom Excerpt or Content Word Limit
 * ------------------------------------------------------------------------
 * Set the custom excerpt with the content word limit.
 * You can set the continue reading by setting limit lower than the setting in
 * passport_custom_excerpt_length function. 
 * And, you can adjust the continue reading by use the following statement.
 *
 * @since passport 1.0
 * @For linked Continue reading "post title" use:
 * @'... <a href="'. get_permalink( $post->ID ) . '">Continue reading "'.get_the_title( $post->ID).'"</a>'
 * @For linked Continue reading >> use:
 * @'... <a href="'. get_permalink( $post->ID ) . '">Continue &raquo</a>'
 * @You can set $limit in the desirable file.
 */
if ( ! function_exists ( 'passport_excerpt' ) ) {
    function passport_excerpt( $limit, $line_breaks = TRUE ) {
	    global $post;
        global $more;

        $the_post    = get_post( $post->ID ); //Gets post ID
        $the_excerpt = $the_post->post_excerpt ? $the_post->post_excerpt : $the_post->post_content; //Gets post_excerpt or post_content to be used as a basis for the excerpt
        $the_excerpt = apply_filters( 'the_excerpt', $the_excerpt );

        $excerpt = explode( ' ', $the_excerpt, $limit );

	    if ( count( $excerpt ) >= $limit ) {
		    array_pop( $excerpt );
		    $excerpt = implode( " ", $excerpt ).'...';
	    } else {
		    $excerpt = implode( " ", $excerpt );
	    }

	    $excerpt = preg_replace( '`\[[^\]]*\]`', '', $excerpt );
      
	    return $excerpt;
    }
}


/**
 * 
 * Modify read more link
 * ------------------------------------------------------------------------
 * This function is to change more ( <!--more--> ) to the read more button
 * It uses for the widget in Show in Post Format.
 * 
 *
 * @since passport 1.0
 *
 */
if ( ! function_exists ( 'passport_modify_read_more_link' ) ) {

    function passport_modify_read_more_link() {
    return '

    <a class="btn btn-color" href="' . esc_url( get_the_permalink() ) . '" role="button">'. esc_html__( 'Read more', 'passport' ) .'</a>';
    }

}
add_filter( 'the_content_more_link', 'passport_modify_read_more_link' );


/**
 * 
 * Link Pages 
 * ------------------------------------------------------------------------
 * Displays page-links for paginated posts.
 *
 *
 * @since passport 1.0
 * @uses wp_link_pages( $default ) function.
 * @changes $default to change the default usage.
 *
 */

$defaults = array(
	'before'           => '<div class="small link-pages" role="toolbar" aria-label="...">' . esc_html__( 'Pages:', 'passport' ),
	'after'            => '</div>',
	'link_before'      => '<button type="button" class="btn btn-default btn-xs">',
	'link_after'       => '</button>',
	'next_or_number'   => 'number',
	'separator'        => ' ',
	'nextpagelink'     => esc_html__( 'Next page', 'passport' ),
	'previouspagelink' => esc_html__( 'Previous page', 'passport' ),
	'pagelink'         => '%',
	'echo'             => 1
);
	wp_link_pages( $defaults );


/**
 * 
 * Breadcrumb function
 * -----------------------------------------------------------------------
 * Get all information, ie. the category, the title, the post type name
 * and others, to present in the breadcrumb.
 *
 *
 * @since passport 1.0
 * 
 */
if ( ! function_exists ( 'passport_the_breadcrumb' ) ) {

    function passport_the_breadcrumb() {
	    global $post;
	
	    //Get the category
	    $categories = wp_get_post_categories( get_the_ID(), array( 'fields' => 'ids' ) );
	    if( $categories ) {
 		    $sep		= ' &bull; ';
 		    $cat_ids	= implode( ',' , $categories );
 		    $cats		= wp_list_categories( 'title_li=&style=none&echo=0&include='.$cat_ids );
 		    $cats		= rtrim( trim( str_replace( '<br />',  $sep, $cats ) ), $sep );
	    }

	    //Get post type object
	    $post_type_obj					= get_post_type_object( get_post_type() );
	    //Get post type's label
	    if( ! empty ( $post_type_obj ) ) {
		    $post_type_title			= apply_filters( 'post_type_archive_title', $post_type_obj->labels->name );
		    $post_type_link				= get_post_type_archive_link( strtolower( $post_type_title ) );
	    }

        if ( ! is_home() ) {
		    echo '<ol class="small breadcrumb">';
		    echo '<li><a href="';
		    echo esc_url( home_url() );
		    echo '">';
		    echo esc_html__( 'Home', 'passport' );
		    echo '</a></li>';
		    if ( is_category() || is_single() || is_post_type_archive() ) {
			    if( is_category() ) {
				    echo '<li>';
				    echo  single_cat_title();
				    echo '</li>';
			    } elseif ( ! empty ( $cats ) ) {
				    echo '<li>';
				    echo $cats;
				    echo '</li>';
			    } elseif ( ! empty( $post_type_title ) ) {
				    echo '<li>';
				    echo '<a href="'. esc_url( $post_type_link ) .'">';
				    echo $post_type_title;
				    echo '</a>';
				    echo '</li>';
			    }
			    if ( is_single() ) {
				    echo '<li>';
				    the_title();
				    echo '</li>';
			    }
		    } elseif ( is_page() ) {
			    if( $post->post_parent){
				    $anc	= get_post_ancestors( $post->ID );
				    $title	= get_the_title();
				    foreach ( $anc as $ancestor ) {
					    $output		= '<li><a href="'. esc_url( get_permalink( $ancestor ) ) .'" title="'. esc_attr( get_the_title( $ancestor ) ) .'">'.get_the_title( $ancestor ).'</a></li>';
				    }
				    echo $output;
				    echo '<li><strong title="'. $title .'">'. $title .'</strong></li>';
			    } else {
				    echo '<li>'.get_the_title().'</li>';
			    }
		    } elseif ( is_tag() ) { echo"<li>"; single_tag_title(); echo'</li>';
		    } elseif ( is_day() ) { echo'<li>'; echo esc_html__( 'Archives for ', 'passport' ); the_time( 'F jS, Y' ); echo'</li>';
		    } elseif ( is_month() ) { echo'<li>'; echo esc_html__( 'Archives for ', 'passport' ); echo'</li>';
		    } elseif ( is_year() ) { echo'<li>'; echo esc_html__( 'Archives for ', 'passport' ); the_time( 'Y' ); echo'</li>';
		    } elseif ( is_author() ) { echo'<li>'; echo esc_html__( 'Author Archives: ', 'passport' ); the_author(); echo'</li>';
		    } elseif ( isset( $_GET['paged'] ) && ! empty( $_GET['paged']) ) { echo'<li>'; echo esc_html__( 'Blog Archives', 'passport' ); echo'</li>';
		    } elseif ( is_search() ) { echo'<li>'; echo esc_html__( 'Search Results: ', 'passport' ); echo get_search_query(); echo'</li>';
		    } 
	    }  echo '</ol>';
    }
}


/**
 * 
 * Allowed Tags Function for Validation On Input
 * -----------------------------------------------------------------------
 * This is the security function for wp_kses function in metabox. You can
 * set the allowed tags for the validation on input here. Most tags are for
 * the iframe.
 * 
 * @since passport 1.0
 *
 */
if ( ! function_exists ( 'passport_allowed_tags' ) ) {

    function passport_allowed_tags() {
	
	    global $allowedtags;

	    $allowedtags['iframe'] = array(
		    'src'             => array(),
		    'height'          => array(),
		    'width'           => array(),
		    'frameborder'     => array(),
		    'allowfullscreen' => array(),
		    'marginwidth'	  => array(),
		    'marginheight'	  => array(),
	    );

	    return( $allowedtags );
    }

}
add_action( 'init', 'passport_allowed_tags' );


/**
 * 
 * Icon Show Function
 * -----------------------------------------------------------------------
 * Each post format will use the different icons. This function helps to
 * specify the correct icon to them.
 *
 * @since passport 1.0
 *
 */
if ( ! function_exists ( 'passport_icon_shows' ) ) {

    function passport_icon_shows() {
	    global $post;

	    $post_format = get_post_format( $post->ID );

	    if( false == $post_format ) {
		    echo '<i class="fa fa-file-o fa-2x" aria-hidden="true"></i>';
	    } elseif( 'aside' == $post_format ) {
		    echo '<i class="fa fa-file-text-o fa-2x" aria-hidden="true"></i>';
	    } elseif( 'link' == $post_format ) {
		    echo '<i class="fa fa-link fa-2x" aria-hidden="true"></i>';
	    } elseif( 'quote' == $post_format ) {
		    echo '<i class="fa fa-quote-left fa-2x" aria-hidden="true"></i>';
	    } elseif( 'image' == $post_format ) {
		    echo '<i class="fa fa-camera fa-2x" aria-hidden="true"></i>';
	    } elseif( 'gallery' == $post_format ) {
		    echo '<i class="fa fa-picture-o fa-2x" aria-hidden="true"></i>';
	    } elseif( 'audio' == $post_format )	{
		    echo '<i class="fa fa-music fa-2x" aria-hidden="true"></i>';
	    } elseif( 'video' == $post_format ) {
		    echo '<i class="fa fa-video-camera fa-2x" aria-hidden="true"></i>';
	    }
    }
}


// Remove Gallery Styling 
if ( ! function_exists ( 'passport_remove_gallery_css' ) ) {

    function passport_remove_gallery_css( $css ) {
	    return preg_replace( "#<style type='text/css'>(.*?)</style>#s", '', $css );
    }

}
add_filter( 'gallery_style', 'passport_remove_gallery_css' );


/**
 * Manage category columns in the category table and category form function.
 * -------------------------------------------------------------------------
 * Add featured image column and edit the columns on the current taxonomy.
 *
 * @package WordPress
 * @subpackage passport
 * @since Passport 1.0
 *
**/
if ( ! function_exists ( 'passport_manage_category_columns' ) ) {

    function passport_manage_category_columns( $columns ) {
	
	    // only edit the columns on the current taxonomy
	    if ( ! isset( $_REQUEST['taxonomy'] ) || $_REQUEST['taxonomy'] != 'category' )
	    return $columns;

	    // Add 'Featured Image Column'
	    $columns['featured_image_column'] = esc_html__( 'Featured Image', 'passport' );
	    return $columns;
    }

}
add_filter( 'manage_edit-category_columns', 'passport_manage_category_columns' );


/**
 * Put the featured image value in each column.
 * -------------------------------------------------------------------------
 * Filtering manage_category_custom_column
 *
 * @since Passport 1.0 
 *
 **/
if ( ! function_exists ( 'passport_manage_category_custom_fields' ) ) {

    function passport_manage_category_custom_fields( $deprecated, $column_name, $term_id ) {

	    $category_id		= $term_id;
	    $category_option	= 'category_custom_order_' . $category_id;
	    $category_img_src	= get_option( $category_option );
	    $category_alt_name	= esc_attr( get_cat_name( $category_id ) );
	    if ( 'featured_image_column' == $column_name ) : 
		    if( ! empty ( $category_img_src ) ) : ?>
			    <div class="media-upload-container">
				    <img src="<?php echo esc_url( $category_img_src );  ?>" class="size-small" alt="<?php echo $category_alt_name; ?>"/>
			    </div>
    <?php   endif;
        endif;
    }

}
add_filter ( 'manage_category_custom_column', 'passport_manage_category_custom_fields', 10, 3 );


/**
 * Add Custom Field To Category Form (Add and Edit)
 * -------------------------------------------------------------------------
 * This featured custom field will be add in Category Admin page. 
 *
 * @since Passport 1.0 
 *
 **/

add_action( 'category_add_form_fields', 'passport_category_form_custom_field_add', 10 );
add_action( 'category_edit_form_fields', 'passport_category_form_custom_field_edit', 10, 2 );

if ( ! function_exists ( 'passport_category_form_custom_field_add' ) ) {

    function passport_category_form_custom_field_add( $taxonomy ) { 

    ?>
    <div class="form-field">
	    <label for="featured-image"><?php esc_html_e( 'Category Image', 'passport' ); ?></label></th>
        <div id="abc" class="media-upload-wrapper" > 
	        <p class="hide-if-no-js">
		        <a title="Set Category Image" href="javascript:;" class="choose-image button button-small"><?php esc_html_e( 'Set Category Image ', 'passport' ); ?></a>
	        </p>
	        <div class="media-upload-container hidden">
		        <img src="" class="wp-post-image size-medium" alt=""/><!-- JS script generates value of the attributes.-->
	        </div><!-- #media-upload-container -->
	        <p class="hide-if-no-js hidden">
		        <a title="Remove Category Image" href="javascript:;" class="remove-image button button-small"><?php esc_html_e( 'Remove Category Image ', 'passport' ); ?></a>
	        </p><!-- .hide-if-no-js -->
	        <p class="media-upload-meta">
		        <input type="hidden" class="media" name="media" value="" />
		        <span class="description"><?php esc_html_e( 'Please choose your category image.', 'passport' ); ?></span><br />
	        </p><!-- #media-upload-meta -->
        </div>
    </div>
    <?php
    } 
}

/**
 * Edit custom field function
 * -------------------------------------------------------------------------
 * This featured custom field will be add in Edit Category Admin page. 
 *
 * @since Passport 1.0 
 *
 **/
if ( ! function_exists ( 'passport_category_form_custom_field_edit' ) ) {

    function passport_category_form_custom_field_edit( $tag, $taxonomy ) {

	    $category_id	  = $tag->term_id;
	    $category_option  = 'category_custom_order_' . $category_id;
	    $category_img_src = get_option( $category_option );

    ?>
    <!-- Use <table></table> from Wordpress. -->
    <tr class="form-field">
	    <th scope="row" valign="top"><label for="featured-image"><?php esc_html_e( 'Category Image', 'passport' ); ?></label></th>
	    <td>
            <div id="abc" class="media-upload-wrapper"> 
		        <p class="hide-if-no-js">					
			        <a title="Set Category Image" href="javascript:;" class="choose-image button button-small"><?php esc_html_e( 'Set Category Image ', 'passport' ); ?></a>				
		        </p>
		        <div class="media-upload-container hidden">
			        <img src="<?php echo esc_url( $category_img_src );  ?>"  class="wp-post-image size-medium" alt="<?php echo esc_attr( $tag->name ); ?>"/>
		        </div><!-- #media-upload-container -->
		        <p class="hide-if-no-js hidden">
			        <a title="Remove Category Image" href="javascript:;" class="remove-image button button-small"><?php esc_html_e( 'Remove Category Image ', 'passport' ); ?></a>
		        </p><!-- .hide-if-no-js -->
		        <p class="media-upload-meta">
			        <input type="hidden" class="media" name="media" value="<?php echo esc_url( $category_img_src ); ?>" />
			        <span class="description"><?php esc_html_e( 'Please choose your category image.', 'passport' ); ?></span><br />
		        </p><!-- #media-upload-meta -->
            </div>
	    </td>
    </tr>
    <?php
    }
}


/**
 * Save Custom Field Of Category Form
 * -------------------------------------------------------------------------
 * Save and update the custom fields of category form. 
 *
 * @since Passport 1.0 
 *
 **/

add_action( 'created_category', 'passport_category_form_custom_field_save', 10, 2 ); 
add_action( 'edited_category', 'passport_category_form_custom_field_save', 10, 2 );

if ( ! function_exists ( 'passport_category_form_custom_field_save' ) ) {

    function passport_category_form_custom_field_save( $term_id, $tt_id ) {

        if ( isset( $_POST['media'] ) ) {
            $category_option = 'category_custom_order_' . $term_id;

            update_option( $category_option, $_POST['media'] );
        }
    }
}

/**
 * Manage the columns in the posts table function.
 * -------------------------------------------------------------------------
 * Add featured image column and edit the columns on the post page.
 *
 * @package WordPress
 * @subpackage passport
 * @since Passport 1.0
 *
**/
/**
 * 
 * Add new column in posts table function
 * -----------------------------------------------------------------------
 * Add new column named featured image in posts table of admin page.
 *
 *
 * @since Passport 1.0
 *
 */

if ( ! function_exists ( 'passport_columns_head' ) ) {

    function passport_columns_head( $defaults ) {
        $defaults['featured_image'] = esc_html__( 'Featured Image', 'passport' );
        return $defaults;
    }
}


/**
 * 
 * Get Featured Image function
 * -----------------------------------------------------------------------
 * Get featured image URLs.
 *
 *
 * @since Passport 1.0
 *
 */

if ( ! function_exists ( 'passport_get_featured_image' ) ) {

    function passport_get_featured_image( $post_ID ) {
        $post_thumbnail_id = get_post_thumbnail_id( $post_ID );
        if ( $post_thumbnail_id ) {
            $post_thumbnail_img = wp_get_attachment_image_src( $post_thumbnail_id, esc_html__( 'featured_preview', 'passport' ) );
            return $post_thumbnail_img[ 0 ];
        }
    }
}

/**
 * 
 * Show featured image in posts table function
 * -----------------------------------------------------------------------
 * Show the post thumbnail in the posts table.
 *
 *
 * @since Passport 1.0
 * @Use passport_columns_head( $defaults ) function.
 * @Use passport_get_featured_image( $post_ID ) function
 *
 */

if ( ! function_exists ( 'passport_columns_content' ) ) {

    function passport_columns_content( $column_name, $post_ID ) {
        if ( $column_name == 'featured_image' ) {
            $post_featured_image = passport_get_featured_image( $post_ID );
            if ( $post_featured_image ) {
                echo '<img src="' . esc_url( $post_featured_image ) . '" class="size-small" />';
            }
        }
    }
}
add_filter( 'manage_posts_columns', 'passport_columns_head' );
add_action( 'manage_posts_custom_column', 'passport_columns_content', 10, 2 );



/**
 * Editor Styles
 * ------------------------------------------------------------------------
 * Function to enqueue the front-end scrip and style.
 * 
 *
 * @since Passport 1.0 
 * @uses add_editor_style() Links a stylesheet to visual editor
 * @uses get_stylesheet_uri() Returns URI of theme stylesheet
 *
 */
if ( ! function_exists ( 'passport_custom_editor_styles' ) ) {

    function passport_custom_editor_styles() {
	    add_editor_style( 'assets/css/custom-editor-style.css' );
    }
}
add_action( 'admin_init', 'passport_custom_editor_styles' );


/**
 * Timeout to WordPress API in update.php
 * ------------------------------------------------------------------------
 * Increase timeout for API request. This function is to solve timeout requests  
 * of update.php in admin page.
 *
 * @since Passport 1.0
 * @Ref: https://core.trac.wordpress.org/ticket/27091
 *
 */
if ( ! function_exists ( 'passport_increase_timeout_for_api_requests_27091' ) ) {

    function passport_increase_timeout_for_api_requests_27091( $r, $url ) {
	    if ( false !== strpos( $url, '//api.wordpress.org/' ) ) {
		    $r['timeout'] = 30;
	    }

	    return $r;
    }
}
add_filter( 'http_request_args', 'passport_increase_timeout_for_api_requests_27091', 10, 2 );


/**
 * 
 * Customize theme
 * -----------------------------------------------------------------------
 * Be careful! Arrangement of the statement below is very important.
 *
 *
 * @since passport 1.0
 *
 */
require( get_template_directory() . '/includes/theme-customizer.php' ); // General Style
require( get_template_directory() . '/includes/custom-setup.php' ); // Custom Set up Style
require( get_template_directory() . '/includes/custom-style.php' ); // Post Format Style


/**
 * This file represents an example of the code that themes would use to register
 * the required plugins.
 *
 * It is expected that theme authors would copy and paste this code into their
 * functions.php file, and amend to suit.
 *
 * @see http://tgmpluginactivation.com/configuration/ for detailed documentation.
 *
 * @package    TGM-Plugin-Activation
 * @subpackage Example
 * @version    2.6.1 for parent theme themevilles for publication on ThemeForest
 * @author     Thomas Griffin, Gary Jones, Juliette Reinders Folmer
 * @copyright  Copyright (c) 2011, Thomas Griffin
 * @license    http://opensource.org/licenses/gpl-2.0.php GPL v2 or later
 * @link       https://github.com/TGMPA/TGM-Plugin-Activation
 */

/**
 * Include the TGM_Plugin_Activation class.
 *
 * Depending on your implementation, you may want to change the include call:
 *
 * Parent Theme:
 * require_once get_template_directory() . '/includes/class-tgm-plugin-activation.php';
 *
 * Child Theme:
 * require_once get_stylesheet_directory() . '/includes/class-tgm-plugin-activation.php';
 *
 * Plugin:
 * require_once dirname( __FILE__ ) . '/includes/class-tgm-plugin-activation.php';
 */
require_once get_template_directory() . '/includes/class-tgm-plugin-activation.php';

add_action( 'tgmpa_register', 'passport_register_required_plugins' );

/**
 * Register the required plugins for this theme.
 *
 * In this example, we register five plugins:
 * - one included with the TGMPA library
 * - two from an external source, one from an arbitrary source, one from a GitHub repository
 * - two from the .org repo, where one demonstrates the use of the `is_callable` argument
 *
 * The variables passed to the `tgmpa()` function should be:
 * - an array of plugin arrays;
 * - optionally a configuration array.
 * If you are not changing anything in the configuration array, you can remove the array and remove the
 * variable from the function call: `tgmpa( $plugins );`.
 * In that case, the TGMPA default settings will be used.
 *
 * This function is hooked into `tgmpa_register`, which is fired on the WP `init` action on priority 10.
 */
if ( ! function_exists ( 'passport_register_required_plugins' ) ) {

    function passport_register_required_plugins() {
	    /*
	     * Array of plugin arrays. Required keys are name and slug.
	     * If the source is NOT from the .org repo, then source is also required.
	     */
	    $plugins = array(
             // This is an example of how to include a plugin from the WordPress Plugin Repository.
            array(
			    'name'              => 'Email Subscribers', // The plugin name.
			    'slug'              => 'email-subscribers', // The plugin slug (typically the folder name).
			    'required'          => false,	
		    ),
            array(
			    'name'              => 'Regenerate Thumbnails Plugin', 
			    'slug'              => 'regenerate-thumbnails', 
			    'required'          => false,
		    ),
            array(
                'name'              => 'Shareaholic',
                'slug'              => 'shareaholic',
                'required'          => false,
            ),
	    );

	    /*
	     * Array of configuration settings. Amend each line as needed.
	     *
	     * TGMPA will start providing localized text strings soon. If you already have translations of our standard
	     * strings available, please help us make TGMPA even better by giving us access to these translations or by
	     * sending in a pull-request with .po file(s) with the translations.
	     *
	     * Only uncomment the strings in the config array if you want to customize the strings.
	     */
	    $config = array(
		    'id'           => 'themevilles',           // Unique ID for hashing notices for multiple instances of TGMPA.
		    'default_path' => '',                      // Default absolute path to bundled plugins.
		    'menu'         => 'tgmpa-install-plugins', // Menu slug.
		    'has_notices'  => true,                    // Show admin notices or not.
		    'dismissable'  => true,                    // If false, a user cannot dismiss the nag message.
		    'dismiss_msg'  => '',                      // If 'dismissable' is false, this message will be output at top of nag.
		    'is_automatic' => false,                   // Automatically activate plugins after installation or not.
		    'message'      => '',                      // Message to output right before the plugins table.
	    );

	    tgmpa( $plugins, $config );
    }

}