<?php
/*
 * Comments
 * 
 * Adapted Version of Kubrick's and Bootstrap
 * @package passport
 * @subpackage passport
 * @since Passport v.1.0.
 * 
**/
 
// Do not delete these lines
if ( isset( $_SERVER['SCRIPT_FILENAME'] ) && 'comments.php' == basename( $_SERVER['SCRIPT_FILENAME'] ) ){
    die ( esc_html_e( 'Please do not load this page directly. Thanks!', 'passport' ) ); }
if ( post_password_required() ) { ?>
    <p class="nocomments"><?php esc_html_e( 'This post is password protected. Enter the password to view comments.', 'passport' ); ?></p>
<?php
    return; }
// End do not delete section
 
// Display Comments Section
if ( have_comments() ) : ?>
	<h4 id="comments" class="comments"><i class="fa fa-comments-o"></i> <?php comments_number( esc_html__( 'No Responses', 'passport' ), esc_html__( 'One Response', 'passport' ), '% Responses' );?> <?php printf( 'to "%s"', the_title( '', '', false ) ); ?></h4>
	<ul class="commentlist">
		<?php
			wp_list_comments(array(
			// see http://codex.wordpress.org/Function_Reference/wp_list_comments
			// 'login_text'       => 'Login to reply',
			   'callback'         => 'passport_comments',
			// 'end-callback'     => null,
			// 'type'             => 'all',
				'reply_text'      => '<i class="fa fa-reply"></i>',
				'avatar_size'     => 50,
			// 'reverse_top_level'=> null,
			// 'reverse_children' =>
				'style'           => 'ul'
			));
		?>
	</ul>
	<ul class="pager comments-link clearfix">
		<li class="icon previous">
			<?php previous_comments_link( esc_html__( 'Previous Comments', 'passport' ) ); ?>
		</li>
		<li class="icon next">
			<?php next_comments_link( esc_html__( 'Next Comments', 'passport' ) ); ?>
		</li>
	</ul>
	<?php
endif;


/* 
 * Comment List
 * Callback Function
 */

function passport_comments( $comment, $args, $depth ) {
	$GLOBALS['comment'] = $comment; ?>
	
	<li <?php comment_class(); ?> id="li-comment-<?php comment_ID() ?>">
		<div id="comment-<?php comment_ID(); ?>" class="comment-body">
			<?php if ( $comment->comment_approved == '0' ) : ?>
			<div class="comment-approved">
				<a href="#" data-toggle="tooltip" title="esc_html_e( 'Your comment is awaiting moderation.', 'passport' )"><i class='fa fa-exclamation-circle'></i></a>
			</div>
			<?php endif; ?>
			<div class="comment-author vcard clearfix">
				<div class="comment-image">
				    <?php echo get_avatar( $comment, $args['avatar_size'], $default='' ); ?>
				</div>
				<div class="comment-info">
				    <?php printf( __( '<b class="fn">%s</b> <span class="says">says:</span>', 'passport' ), get_comment_author_link() ) ?>
				    <div class="comment-meta commentmetadata">
				        <a href="<?php echo esc_url( htmlspecialchars( get_comment_link( $comment->comment_ID ) ) ) ?>">
					        <?php printf( __( '%1$s at %2$s', 'passport' ), get_comment_date(),  get_comment_time() ) ?>
				        </a>
				    </div>
				</div>
			</div>
			<?php comment_text(); ?>
			<div class="icon reply comment-reply">
				<?php comment_reply_link( array_merge( $args, array( 'depth' => $depth, 'max_depth' => $args['max_depth'] ) ) ) ?>
			</div>
			<div class="icon reply comment-edit">
				<?php edit_comment_link( __( '<i class="fa fa-wrench"></i>', 'passport' ), '', '' ) ?>
			</div>
		</div>
<?php }


/* Display Form/Login info Section
 * the comment_form() function handles this and can be used without any paramaters simply as "comment_form()"
 * see codex http://codex.wordpress.org/Function_Reference/comment_form for default values
 */

$fields =  array(

	'author' =>
		'<p class="comment-form-author"><label for="author">' . esc_html__( 'Your Name', 'passport' ) . '</label> ' .
		( $req ? '<span class="required">*</span>' : '' ) .
		'<input id="author" class="form-control" name="author" type="text" value="' . esc_attr( $commenter['comment_author'] ) .
		'" size="30" placeholder="'. esc_html__( 'Name', 'passport' ) .'" /></p>',

	'email' =>
		'<p class="comment-form-email"><label for="email">' . esc_html__( 'Your Email', 'passport' ) . '</label> ' .
		( $req ? '<span class="required">*</span>' : '' ) .
		'<input id="email" class="form-control" name="email" type="text" value="' . esc_attr(  $commenter['comment_author_email'] ) .
		'" size="30" placeholder="'. esc_html__( 'Email Address', 'passport' ) .'"/></p>',

);

$comments_args = array(
	'fields' => apply_filters( 'comment_form_default_fields', $fields ),
	'title_reply' => esc_html__( 'Leave a Reply', 'passport' ),
	'class_submit' => 'btn btn-color',
	'label_submit' => esc_html__( 'Submit Comment', 'passport' ),
	'logged_in_as' => '<p class="logged-in-as">' . sprintf( __( '<a href="%2$s">%1$s</a>  <a href="%2$s">%3$s</a><br><a href="%4$s" title="Log out of this account" class="comment-logout"><i class="fa fa-circle-o-notch"></i></a>', 'passport' ), get_avatar( get_the_author_meta( 'ID' ) , 50 ), esc_url( admin_url( 'profile.php' ) ), $user_identity, esc_url( wp_logout_url( apply_filters( 'the_permalink', get_permalink( ) ) ) ) ) . '</p>',
	'comment_field' => '<p><label for="comment">' . esc_html__( 'Your Comment', 'passport' ) . '</label><textarea name="comment" id="comment" cols="58" rows="10" tabindex="4"  class="form-control" aria-required="true" placeholder="'. esc_html__( 'Enter your comment', 'passport' ) .'"></textarea></p>',
	'comment_notes_after' => '<p class="form-allowed-tags">' . sprintf( esc_html__( '', 'passport' ), ' <code>' . allowed_tags() . '</code>' ) . '</p>',
	);

comment_form( $comments_args );