/**
 * This file adds some LIVE to the Theme Customizer live preview. To leverage
 * this, set your custom settings to 'postMessage' and then add your handling
 * here. Your javascript should grab settings from customizer controls, and 
 * then make any necessary changes to the page using jQuery.
 */
(function ($) {
    // Update the site title in real time...
    wp.customize('blogname', function (value) {
        value.bind(function (newval) {
            $('#site-title a').html(newval);
        });
    });

    //Update the site description in real time...
    wp.customize('blogdescription', function (value) {
        value.bind(function (newval) {
            $('#site-description').html(newval);
        });
    });

    wp.customize('passport_primary_color', function (value) {
        value.bind(function (newval) {
            $('.navbar-default, .navbar-default .navbar-collapse, .navbar-default .navbar-nav > li > a, .navbar-default .navbar-nav > li > a:link, .navbar-default .navbar-nav > li > a:visited, .footer-widget-title, .license, .on-top').css('background-color', newval);
            $('.navbar-default, .navbar-default .navbar-collapse, .navbar-default .navbar-nav > li > a, .navbar-default .navbar-nav > li > a:link, .navbar-default .navbar-nav > li > a:visited, .footer-widget-title, .license, .on-top').css('border-color', newval);
        });
    });

    wp.customize('passport_primary_font_color', function (value) {
        value.bind(function (newval) {
            $('.navbar-default, .navbar-default .navbar-collapse, .navbar-default .navbar-nav > li > a, .navbar-default .navbar-nav > li > a:link, .navbar-default .navbar-nav > li > a:visited, .footer-widget-title, .license, .on-top').css('color', newval);
            $('.navbar-default .navbar-nav > li > a > span, .navbar-default .navbar-nav > li > a:link > span, .navbar-default .navbar-nav > li > a:visited > span, .footer-widget-item .widget .footer-widget-title span, .footer-widget-item .widget .footer-widget-title span a').css('color', newval);
        });
    });

    wp.customize('passport_secondary_color', function (value) {
        value.bind(function (newval) {
            $('.navbar-inverse, .widget-title, .owl-next, .owl-prev, #wp-calendar thead, .pagination > .active > a, .pagination > .active > span, .pagination > .active > a:hover, .pagination > .active > span:hover, .pagination > .active > a:focus, .pagination > .active > span:focus, .comment-edit-link, .breadcrumb, .nav-tabs > li.active > a.tab-title ').css('background-color', newval);
            $('.related-posts-title, .comments, .comment-reply-title, .breadcrumb, .pagination > .active > a, .pagination > .active > span, .pagination > .active > a:hover, .pagination > .active > span:hover, .pagination > .active > a:focus, .pagination > .active > span:focus, .commentlist .bypostauthor, .commentlist li ul.children li.bypostauthor').css('border-color', newval);
            $('.pagination > .active > a, .pagination > .active > span, .pagination > .active > a:hover, .pagination > .active > span:hover, .pagination > .active > a:focus, .pagination > .active > span:focus, .breadcrumb > li, .breadcrumb > li > a, .breadcrumb > li + li:before, #wp-calendar caption, #wp-calendar td a').css('color', newval);
            $('.fa-paper-plane, .related-posts .post-title a, .comment-author .fn, .lightbox-target a.lightbox-close:hover').css('color', newval);
        });
    });

    wp.customize('passport_secondary_font_color', function (value) {
        value.bind(function (newval) {
            $('.navbar-inverse .navbar-nav > li > a, .widget-title span, .widget-title span a, .owl-next, .owl-prev, td#prev a, td#next a, #wp-calendar thead, .pagination > .active > a, .pagination > .active > span, .pagination > .active > a:hover, .pagination > .active > span:hover, .pagination > .active > a:focus, .pagination > .active > span:focus').css('color', newval);
            $('.comment-body .icon a').css('color', newval);
        });
    });

    wp.customize('passport_secondary_font_color', function (value) {
        value.bind(function (newval) {
            $('.navbar-inverse .navbar-nav > li > a, .widget-title span, .widget-title span a, .owl-next, .owl-prev, #wp-calendar thead, .pagination > .active > a, .pagination > .active > span, .pagination > .active > a:hover, .pagination > .active > span:hover, .pagination > .active > a:focus, .pagination > .active > span:focus').css('color', newval);
        });
    });

    wp.customize('passport_widget_bgcolor', function (value) {
        value.bind(function (newval) {
            $('.widget-post-item, .widget_archive li, .widget_categories li, .widget_meta li, .widget_pages li, .widget_nav_menu li, .widget_recent_comments li, .widget_recent_entries li, .widget_rss li, .widget_calendar, .widget_tag_cloud .tagcloud a, .widget_author .author-widget, .full-width .widget.widget_column').css('background-color', newval);
        });
    });

    wp.customize('passport_widget_heading_color', function (value) {
        value.bind(function (newval) {
            $('.widget_categories li, .widget_categories li a, .widget_archive li a, .widget_meta li a, .widget_pages li a, .widget_nav_menu li a, .widget_recent_comments li a, .widget_recent_entries li a, .widget_rss li a, .widget_rss li span, .widget_rss li .rssSummary').css('color', newval);
        });
    });

    wp.customize('passport_hover_widget_bgcolor', function (value) {
        value.bind(function (newval) {
            $('.link-pages .btn:hover, .pager li > a:hover, .pager li > a:focus, .widget_nav_menu li:hover, .widget_nav_menu li ul li:hover, .widget_archive li:hover, .widget_categories li:hover, .widget_categories li ul li:hover, .widget_pages li:hover, .widget_pages li ul li:hover, .widget_tag_cloud .tagcloud a:hover, .widget_meta li:hover, .widget_recent_comments li:hover, .widget_recent_entries li:hover, .widget_rss li:hover').css('background-color', newval);
            $('.link-pages .btn:hover, .pager li > a:hover, .pager li > a:focus, .widget_nav_menu li:hover, .widget_nav_menu li ul li:hover, .widget_archive li:hover, .widget_categories li:hover, .widget_categories li ul li:hover, .widget_pages li:hover, .widget_pages li ul li:hover, .widget_tag_cloud .tagcloud a:hover, .widget_meta li:hover, .widget_recent_comments li:hover, .widget_recent_entries li:hover, .widget_rss li:hover').css('border-color', newval);
        });
    });

    wp.customize('passport_hover_widget_font_color', function (value) {
        value.bind(function (newval) {
            $('.link-pages .btn:hover, .pager li > a:hover, .pager li > a:focus, .widget_nav_menu li:hover a, .widget_nav_menu li ul li:hover a, .widget_archive li:hover a, .widget_categories li:hover, .widget_categories li:hover a,  .widget_tag_cloud .tagcloud a, .widget_meta li:hover a, .widget_pages li:hover a, .widget_nav_menu li:hover a, .widget_recent_comments li:hover a, .widget_recent_entries li:hover a, .widget_rss li:hover a, .widget_rss li:hover span, .widget_rss li:hover .rssSummary, .widget_recent_comments li:hover .comment-author-link, .breadcrumb > li:hover > a').css('color', newval);
        });
    });

    wp.customize('passport_post_bgcolor', function (value) {
        value.bind(function (newval) {
            $('.post-item, .page-item, .grid-item, .link-pages .btn, .pager li > a, .pager li > span').css('background-color', newval);
        });
    });

    wp.customize('passport_author_bgcolor', function (value) {
        value.bind(function (newval) {
            $('.author-post').css('background-color', newval);
        });
    });

    wp.customize('passport_related_posts_bgcolor', function (value) {
        value.bind(function (newval) {
            $('.related-posts .post-item').css('background-color', newval);
        });
    });

    wp.customize('passport_comment_bgcolor', function (value) {
        value.bind(function (newval) {
            $('.comment-form, .comment-reply-title').css('background-color', newval);
        });
    });

    wp.customize('passport_horizontal_line_color', function (value) {
        value.bind(function (newval) {
            $('.page-header').css('border-bottom-color', newval);
            $('hr').css('border-top-color', newval);
        });
    });

    wp.customize('passport_active_menu_bgcolor', function (value) {
        value.bind(function (newval) {
            $('.navbar-default .navbar-nav > li.active > a, .navbar-default .navbar-nav > li.active > a:focus, .navbar-default .navbar-nav > li.active > a > span, .navbar-default .navbar-nav > li.active > a:focus > span').css('background-color', newval);
            $('.dropdown-menu > .active > a, .dropdown-menu > .active > a:hover, .dropdown-menu > .active > a:focus').css('background-color', newval);
        });
    });

    wp.customize('passport_active_menu_font_color', function (value) {
        value.bind(function (newval) {
            $('.navbar-default .navbar-nav > li.active > a, .navbar-default .navbar-nav > li.active > a:focus, .navbar-default .navbar-nav > li.active > a > span, .navbar-default .navbar-nav > li.active > a:focus > span').css('color', newval);
            $('.dropdown-menu > .active > a, .dropdown-menu > .active > a:hover, .dropdown-menu > .active > a:focus').css('color', newval);
        });
    });

    wp.customize('passport_hover_menu_item_bgcolor', function (value) {
        value.bind(function (newval) {
            $('.navbar-default .navbar-nav > li.active > a:hover > span, .navbar-default .navbar-nav > li.active > a:focus > span').css('background-color', newval);
            $('.navbar-default .navbar-nav > li > a:hover,  .navbar-default .navbar-nav > li > a:active, .dropdown-menu > li > a:hover, .dropdown-menu > li > a:active, .dropdown-menu > li > a:hover > span, .dropdown-menu > li > a:active > span, .navbar-default .navbar-nav .open .dropdown-menu > li > a:hover, .navbar-default .navbar-nav .open .dropdown-menu > li > a:focus, .navbar-default .navbar-nav > .active > a, .navbar-default .navbar-nav > .active > a:hover, .navbar-default .navbar-nav > .active > a:focus').css('background-color', newval);
            $('.navbar-default .navbar-nav > .open > a, .navbar-default .navbar-nav > .open > a:hover, .navbar-default .navbar-nav > .open > a:focus').css('background-color', newval);            
            $('.navbar-default .navbar-nav > li.active > a:hover > span, .navbar-default .navbar-nav > li.active > a:focus > span').css('border-color', newval);
            $('.navbar-default .navbar-nav > li > a:hover,  .navbar-default .navbar-nav > li > a:active, .dropdown-menu > li > a:hover, .dropdown-menu > li > a:active, .dropdown-menu > li > a:hover > span, .dropdown-menu > li > a:active > span, .navbar-default .navbar-nav .open .dropdown-menu > li > a:hover, .navbar-default .navbar-nav .open .dropdown-menu > li > a:focus, .navbar-default .navbar-nav > .active > a, .navbar-default .navbar-nav > .active > a:hover, .navbar-default .navbar-nav > .active > a:focus').css('border-color', newval);
            $('.navbar-default .navbar-nav > .open > a, .navbar-default .navbar-nav > .open > a:hover, .navbar-default .navbar-nav > .open > a:focus').css('border-color', newval);   
        });
    });

    wp.customize('passport_hover_menu_font_color', function (value) {
        value.bind(function (newval) {
            $('.navbar-default .navbar-nav > li.active > a:hover > span, .navbar-default .navbar-nav > li.active > a:focus > span').css('color', newval);
            $('.navbar-default .navbar-nav > li > a:hover,  .navbar-default .navbar-nav > li > a:active, .dropdown-menu > li > a:hover, .dropdown-menu > li > a:active, .dropdown-menu > li > a:hover > span, .dropdown-menu > li > a:active > span, .navbar-default .navbar-nav .open .dropdown-menu > li > a:hover, .navbar-default .navbar-nav .open .dropdown-menu > li > a:focus, .navbar-default .navbar-nav > .active > a, .navbar-default .navbar-nav > .active > a:hover, .navbar-default .navbar-nav > .active > a:focus').css('color', newval);
            $('.navbar-default .navbar-nav > .open > a, .navbar-default .navbar-nav > .open > a:hover, .navbar-default .navbar-nav > .open > a:focus').css('color', newval);
            $('.navbar-default .navbar-nav > li > a:hover > span, .navbar-default .navbar-nav > li > a:focus > span').css('color', newval);
        });
    });

    wp.customize('passport_dropdown_menu_bgcolor', function (value) {
        value.bind(function (newval) {
            $('.navbar-nav .open .dropdown-menu').css('background-color', newval);
        });
    });

    wp.customize('passport_dropdown_menu_font_color', function (value) {
        value.bind(function (newval) {
            $('.dropdown-menu > li > a').css('color', newval);
        });
    });

    wp.customize('passport_h1_color', function (value) {
        value.bind(function (newval) {
            $('h1').css('color', newval);
        });
    });

    wp.customize('passport_h2_color', function (value) {
        value.bind(function (newval) {
            $('h2').css('color', newval);
        });
    });

    wp.customize('passport_h3_color', function (value) {
        value.bind(function (newval) {
            $('h3').css('color', newval);
        });
    });

    wp.customize('passport_h4_color ', function (value) {
        value.bind(function (newval) {
            $('h4, .widget h4.entry-title a').css('color', newval);
        });
    });

    wp.customize('passport_h5_color', function (value) {
        value.bind(function (newval) {
            $('h5, .related-posts h5 a').css('color', newval);
        });
    });

    wp.customize('passport_p_color', function (value) {
        value.bind(function (newval) {
            $('p, ins').css('color', newval);
        });
    });

    wp.customize('passport_p_meta_color', function (value) {
        value.bind(function (newval) {
            $('p.post-info, .post-info, p.post-info a:link, p.post-info a:visited, p.post-info span, del').css('color', newval);
        });
    });

    wp.customize('passport_hover_p_meta_color', function (value) {
        value.bind(function (newval) {
            $('p.post-info span:hover, p.post-info a:hover').css('color', newval);
        });
    });

    wp.customize('passport_span_color', function (value) {
        value.bind(function (newval) {
            $('span').css('color', newval);
        });
    });

    wp.customize('passport_link_color', function (value) {
        value.bind(function (newval) {
            $('a, a:link, a:visited, .pagination > li > a, .pagination > li > span').css('color', newval);
        });
    });

    wp.customize('passport_link_color', function (value) {
        value.bind(function (newval) {
            $('.progress-bar').css('background-color', newval);
        });
    });

    wp.customize('passport_related_post_color', function (value) {
        value.bind(function (newval) {
            $('.related-posts a').css('color', newval);
        });
    });

    wp.customize('passport_footer_bgcolor', function (value) {
        value.bind(function (newval) {
            $('.site-footer').css('background-color', newval);
        });
    });

    wp.customize('passport_footer_heading_color', function (value) {
        value.bind(function (newval) {
            $('.footer-widget-item .widget .entry-title, .footer-widget-item .widget .entry-title a').css('color', newval);
        });
    });

    wp.customize('passport_footer_p_color', function (value) {
        value.bind(function (newval) {
            $('.footer-widget-item .widget p, .footer-widget-item .rssSummary').css('color', newval);
        });
    });

    wp.customize('passport_footer_meta_color', function (value) {
        value.bind(function (newval) {
            $('.footer-widget-item .widget p.post-info, .footer-widget-item .widget .post-info, .footer-widget-item .widget p.post-info a:link, .footer-widget-item .widget p.post-info a:visited, .footer-widget-item .widget p.post-info span, .footer-widget-item .widget .recentcomments').css('color', newval);
        });
    });

    wp.customize('passport_footer_span_color', function (value) {
        value.bind(function (newval) {
            $('.footer-widget-item .widget span, .footer-widget-item .widget.widget_recent_comments li span, .footer-widget-item .widget.widget_recent_entries li span').css('color', newval);
        });
    });

    wp.customize('passport_footer_link_color', function (value) {
        value.bind(function (newval) {
            $('.footer-widget-item .widget a, .footer-widget-item .widget.widget_categories li, .footer-widget-item .widget.widget_categories li a, .footer-widget-item .widget.widget_archive li, .footer-widget-item .widget.widget_archive li a, .footer-widget-item .widget.widget_meta li a, .footer-widget-item .widget.widget_pages li a, .footer-widget-item .widget.widget_nav_menu li a, .footer-widget-item .widget.widget_recent_comments li a, .footer-widget-item .widget.widget_recent_entries li a, .footer-widget-item .widget.widget_rss li a, .footer-widget-item .widget.widget_nav_menu ul li.active a, .footer-widget-item .widget.widget_categories ul li.active a').css('color', newval);
        });
    });

    wp.customize('passport_footer_hover_color', function (value) {
        value.bind(function (newval) {
            $('.footer-widget-item .widget.widget_archive li:hover, .footer-widget-item .widget.widget_categories li:hover, .footer-widget-item .widget.widget_archive li:hover a, .footer-widget-item .widget.widget_categories li:hover a, .footer-widget-item .widget.widget_meta li:hover a, .footer-widget-item .widget.widget_pages li:hover a, .footer-widget-item .widget.widget_nav_menu li:hover a, .footer-widget-item .widget.widget_nav_menu li ul li:hover a, .footer-widget-item .widget.widget_recent_comments li:hover a, .footer-widget-item .widget.widget_recent_entries li:hover a, .footer-widget-item .widget.widget_rss li:hover a, .footer-widget-item .widget.widget_tag_cloud .tagcloud a:hover, .footer-widget-item .widget.widget_categories li:hover ul.children li a, .footer-widget-item .widget.widget_categories li:hover ul.children li a:before, .footer-widget-item .widget.widget_categories li ul.children li:hover a, .footer-widget-item .widget.widget_categories li ul.children li:hover a:before, .footer-widget-item .widget.widget_categories li.active:hover a, .footer-widget-item .widget.widget_recent_comments li:hover span, .footer-widget-item .widget.widget_recent_entries li:hover span').css('color', newval);
        });
    });

    wp.customize('passport_button_color', function (value) {
        value.bind(function (newval) {
            $('.btn-color, .btn-color:link, .btn-color:visited, .es_textbox_button, .es_textbox_button:link, .es_textbox_button, button, input[type="button"], input[type="reset"], input[type="submit"]:visited, .back-to-top').css('background-color', newval);
            $('.comment-reply-link, .comment-logout').css('background-color', newval);
        });
    });

    wp.customize('passport_button_border_color', function (value) {
        value.bind(function (newval) {
            $('.btn-color, .btn-color:link, .btn-color:visited, .es_textbox_button, .es_textbox_button:link, .es_textbox_button:visited, button, input[type="button"], input[type="reset"], input[type="submit"], .back-to-top').css('border-color', newval);
            $('.comment-reply-link, .comment-logout').css('border-color', newval);
        });
    });

    wp.customize('passport_button_link_color', function (value) {
        value.bind(function (newval) {
            $('.btn-color, .btn-color:link, .btn-color:visited, .es_textbox_button, .es_textbox_button:link, .es_textbox_button:visited, button, input[type="button"], input[type="reset"], input[type="submit"], a.back-to-top').css('color', newval);
            $('a.btn-color, a.btn-color:link, a.btn-color:visited').css('color', newval);
            $('.comment-reply-link, .comment-logout, a.comment-logout, a.comment-logout:link, a.comment-logout:visited').css('color', newval);
        });
    });

    wp.customize('passport_hover_button_color', function (value) {
        value.bind(function (newval) {
            $('.btn:hover, .btn-color:hover, .btn-color:link:hover, .btn-color:visited:hover, a.btn-color:hover, a.btn-color:link:hover, a.btn-color:visited:hover, a.comment-logout:hover, a.comment-reply-link:hover, .es_textbox_button:hover, button:hover, input[type="button"]:hover, input[type="reset"]:hover, input[type="submit"]:hover, a.back-to-top:hover').css('backgrond-color', newval);
        });
    });

    wp.customize('passport_hover_border_color', function (value) {
        value.bind(function (newval) {
            $('.btn:hover, .btn-color:hover, .btn-color:link:hover, .btn-color:visited:hover, a.btn-color:hover, a.btn-color:link:hover, a.btn-color:visited:hover, a.comment-logout:hover, a.comment-reply-link:hover, .es_textbox_button:hover,button:hover, input[type="button"]:hover, input[type="reset"]:hover, input[type="submit"]:hover, a.back-to-top:hover').css('border-color', newval);
        });
    });

    wp.customize('passport_hover_button_link_color', function (value) {
        value.bind(function (newval) {
            $('.btn:hover, .btn-color:hover, .btn-color:link:hover, .btn-color:visited:hover, a.btn-color:hover, a.btn-color:link:hover, a.btn-color:visited:hover, a.comment-logout:hover, a.comment-reply-link:hover, .es_textbox_button:hover, button:hover, input[type="button"]:hover, input[type="reset"]:hover, input[type="submit"]:hover').css('color', newval);
        });
    });

    wp.customize('passport_slider_background_color', function (value) {
        value.bind(function (newval) {
            $('.carousel-control:before, .carousel-control:link:before, .carousel-control:visited:before, .carousel-control:hover:before, .caption-format, .additional-info').css('background', newval);
        });
    });

    wp.customize('passport_slider_text_color', function (value) {
        value.bind(function (newval) {
            $('.carousel-control:before, .carousel-control:link:before, .carousel-control:visited:before, .carousel-control:hover:before, .carousel-title a, .owl-carousel-slider .carousel-caption a').css('color', newval);
        });
    });

    wp.customize('passport_slider_excerpt_color', function (value) {
        value.bind(function (newval) {
            $('.carousel.gallery .carousel-excerpt p').css('color', newval);
        });
    });

    wp.customize('passport_box_background_color', function (value) {
        value.bind(function (newval) {
            $('.box-item .caption-background').css('background-color', newval);
        });
    });

    wp.customize('passport_box_text_color', function (value) {
        value.bind(function (newval) {
            $('.widget_posts_in_box_format .box-caption a, .widget_posts_in_box_format .box-caption a:link, .widget_posts_in_box_format .box-caption a:visited, .widget_posts_in_box_format .box-caption p.post-info').css('color', newval);
        });
    });

    wp.customize('passport_box_excerpt_color', function (value) {
        value.bind(function (newval) {
            $('.box-item .caption-excerpt p').css('color', newval);
        });
    });

    wp.customize('passport_hide_box_shadow', function (value) {
        value.bind(function (newval) {
            $('.grid-item, .page-item, .post-item, .widget-post-item, .author-post, .related-posts-title, .related-posts .post-item, .comments, .comment-body, .comment-form, .comment-reply-title, .breadcrumb, .pager li > a, .pager li > span, .widget-title, .widget_archive ul, .widget_meta ul, .widget_pages ul, .widget_nav_menu ul, .widget_recent_comments ul, .widget_recent_entries ul, .widget_rss ul, .widget_calendar, .widget_tag_cloud .tagcloud a, .navbar-default, ul.dropdown-menu').css('box_shadow', newval);
        });
    });

    wp.customize('passport_sticky_label_color', function (value) {
        value.bind(function (newval) {
            $('.sticky .ribbon').css('background-color', newval);
        });
    });

    wp.customize('passport_sticky_text_color', function (value) {
        value.bind(function (newval) {
            $('.sticky .ribbon').css('color', newval);
        });
    });

    wp.customize('passport_primary_bg_opacity', function (value) {
        value.bind(function (newval) {
            $('#primary-menu-bar.navbar-default').css('opacity', newval);
        });
    });

})(jQuery);