/**
 * This file is to set up PASSPORT theme. There are several function, such as,
 * Bootstrap function, Tab, Flip container, Masonry, Bottom to Top ,and so on..
 */

(function ($) {
    "use strict";

    // -----------
    // Bootstrap function
    // -----------
    $(document).ready(function () {

        // Style
        $('select').addClass('form-control');


        // Activate Carousel
        $('.carousel').carousel();
    });


    // -----------
    // Add active class in Tab Widget
    // -----------
    $(document).ready(function () {

        $('.nav-tabs li:first').addClass('active');
        $('.tab-content div:first').addClass('active');
    });


    // -----------
    // Flip Container - solve the HTML5 W3C validator
    // -----------   
    $(document).ready(function () {

        $('.flip-container').live('ontouchstart', function (e) {
            this.classList.toggle('hover');
        });
    });


    // -----------
    // Masonry
    // -----------
    // external js: masonry.pkgd.js, imagesloaded.pkgd.js
    // Masonry template
    $(document).ready(function () {

        var $blogGrid = $('.blog-masonry.grid').masonry({
            columnWidth: '.grid-sizer',
            itemSelector: '.grid-item',
            gutter: '.gutter-sizer',
            isFitWidth: true
        });


        // layout Isotope after each image loads
        $blogGrid.imagesLoaded().progress(function () {
            $('.blog-masonry.grid').masonry('layout');
        });


        //Grid Post Format
        var $postGrid = $('.format-gallery .grid').masonry({
            columnWidth: '.grid-sizer',
            itemSelector: '.grid-item',
            gutter: '.gutter-sizer',
            percentPosition: true
        });


        // layout Isotope after each image loads
        $postGrid.imagesLoaded().progress(function () {
            $('.format-gallery > .post-media > .grid').masonry('layout');
        });


        // Tab Widget
        var $postGrid = $('.grid.masonry-widget').masonry({
            columnWidth: '.grid-sizer',
            itemSelector: '.grid-item',
            gutter: '.gutter-sizer',
            percentPosition: true
        });


        // layout Isotope after each image loads
        $postGrid.imagesLoaded().progress(function () {
            $('.grid.masonry-widget').masonry('layout');
        });
    });


    // -----------
    // Owl Carousel. Widget
    // -----------
    $(document).ready(function () {

        var owlslider = $(".owl-carousel-slider");

        owlslider.owlCarousel({
            loop: true,
            margin: 0,
            nav: true,
            center: false,
            navText: ["&#xf104;", "&#xf105;"],
            responsiveClass: true,
            responsive: {
                0: {
                    items: 1
                },
                450: {
                    items: 2
                },
                600: {
                    items: 2
                },
                700: {
                    items: 2
                },
                1000: {
                    items: 4
                },
                1400: {
                    items: 4
                },
                1500: {
                    items: 5
                }
            }
        });

        var owlrelated = $(".owl-related-posts");

        owlrelated.owlCarousel({
            loop: true,
            margin: 0,
            nav: true,
            center: false,
            navText: ["&#xf104;", "&#xf105;"],
            responsiveClass: true,
            responsive: {
                0: {
                    items: 1
                },
                450: {
                    items: 2
                },
                600: {
                    items: 2
                },
                700: {
                    items: 2
                },
                1000: {
                    items: 3
                },
                1400: {
                    items: 4
                },
                1500: {
                    items: 4
                }
            }
        });
    });


    // -----------
    // Typing in the posts and widgets.
    // -----------
    $(document).ready(function () {

        $(function () {
            var ids = $('.post, .widget').map(function () {
                var site_name = (site.sitename); //From wp_localize_script in functions file.
                var element = $('#' + this.id + ' .css-typing').text();
                $('#' + this.id + ' .css-typing').typed({
                    strings: [site_name, element],
                    typeSpeed: 0
                });
            })
        });
    });


    // -----------
    // Tree - Use for menu in sidebar
    // -----------
    $(document).ready(function () {

        $('.widget_nav_menu li, .widget_categories li, .widget_pages li').each(function () {
            if ($(this).children('ul').length > 0) {
                $(this).addClass('parent');
            }
        });

        $('.widget_nav_menu li.parent > a, .widget_categories li.parent > a, .widget_pages li.parent > a').click(function () {
            $(this).parent().toggleClass('active');
            $(this).parent().children('ul').slideToggle('fast');
            return false;
        });
    });


    // -----------
    // Extra menu - when you scroll down, it will show the extra menu. (Sticky nav)
    // -----------
    $(document).ready(function () {

        var starting_position = $('.navbar-brand').outerHeight(true) + $('#header-image').outerHeight(true);

        $(window).scroll(function () {
            var yPos = ($(window).scrollTop());
            if (yPos > starting_position && window.innerWidth > 770) { // show sticky menu after these many (starting_position) pixels have been scrolled down from the top and only when viewport width is greater than 770px.
                $(".extra-navbar").fadeIn();
            } else {
                $(".extra-navbar").fadeOut();
            }
        });
    });


    // -----------
    // Scrollup - Click the right-bottom button to move from the button to top.
    // -----------
    $(document).ready(function () {

        var offset = 220;
        var duration = 500;
        $(window).scroll(function () {
            if ($(this).scrollTop() > offset) {
                $('.back-to-top').fadeIn(duration);
            } else {
                $('.back-to-top').fadeOut(duration);
            }
        });

        $('.back-to-top').click(function (event) {
            event.preventDefault();
            $('html, body').animate({ scrollTop: 0 }, duration);
            return false;
        })
    });


    // -----------
    // Animated - All widgets in the frontpage move up when scrolling.
    // -----------
    $(document).ready(function () {

        var wintop = '';
        var $elm = '';
        var topcoords = '';
        var $elems = $('.animateblock');
        var winheight = $(window).height();
        var fullheight = $(document).height();

        $(window).scroll(function () {
            animate_elems();
        });

        function animate_elems() {
            wintop = $(window).scrollTop(); // calculate distance from top of window

            // loop through each item to check when it animates
            $elems.each(function () {
                $elm = $(this);

                if ($elm.hasClass('animated')) { return true; } // if already animated skip to the next item

                topcoords = $elm.offset().top; // element's distance from top of page in pixels

                if (wintop > (topcoords - (winheight * .75))) {
                    // animate when top of the window is 3/4 above the element
                    $elm.addClass('animated');
                }
            });
        } // end animate_elems()
    });


    // -----------
    // Add placeholder in Subscribe box.
    // -----------
    $(document).ready(function () {

        $("#es_txt_name").attr("placeholder", "Name");
        $("#es_txt_email").attr("placeholder", "Email Address");
    });


    // -----------
    // Debugger that shows view port size. Helps when making responsive designs.
    // -----------
    $(document).ready(function () {

        function showViewPortSize(display) {
            if (display) {
                var height = window.innerHeight;
                var width = window.innerWidth;
                $('body').prepend('<div id="viewportsize" style="z-index:9999;position:fixed;bottom:0px;left:0px;color:#fff;background:#000;padding:10px">Height: ' + height + '<br>Width: ' + width + '</div>');
                $(window).resize(function () {
                    height = window.innerHeight;
                    width = window.innerWidth;
                    $('#viewportsize').html('Height: ' + height + '<br>Width: ' + width);

                });
            }
        }
    });

})(jQuery);	