/**
 * Solve Bug ticket: https://core.trac.wordpress.org/ticket/25809#comment:4
 *
 * Plugin Name: Color Picker Widget
 * Description: A widget with a WordPress color picker. (use in widget)
 * Version: 1.0
 * Author: Dominik Schilling (ocean90)
 * Plugin URI: https://core.trac.wordpress.org/ticket/25809
 */
 (function ($) {

     "user strict";

     function initColorPicker(widget) {
         widget.find('.color').wpColorPicker({
             change: _.throttle(function () { // For Customizer
                 $(this).trigger('change');
             }, 3000)
         });
     }

     function onFormUpdate(event, widget) {
         initColorPicker(widget);
     }

     $(document).on('widget-added widget-updated', onFormUpdate);

     $(document).ready(function () { // For Widgets
         $('#widgets-right .widget:has(.color)').each(function () {
             initColorPicker($(this));
         });

        $('.color-field').wpColorPicker(); // For Metabox
     });

     $(document).ajaxComplete(function () { // For Site Origin Page Builder
         $('.panel-dialog .color').wpColorPicker();
     });

 } (jQuery));