<?php
/**
 * Archives Page
 *
 * @package passport
 * @subpackage passport
 * @since Passport v.1.0.
 * 
**/
	
	get_header(); 
      
    $passport_blog_content_column       = get_theme_mod( 'passport_blog_main_content', 'main_content' );
	$passport_blog_sidebar_position     = get_theme_mod( 'passport_blog_sidebar_position', 'left' );
	$passport_blog_sidebar_width	    = get_theme_mod( 'passport_blog_sidebar_width', 'sidebar_25' );

   ?>
<div id="primary" class="container">
	<div id="wrapper" class="content-column fix-width clearfix">
		<?php if( have_posts() ) : ?>
			<h3 class="page-title"><?php
				if ( is_category() ) {
					    single_cat_title();
					} elseif ( is_tag() ) {
						single_tag_title();
					} elseif ( is_author() ) {
						the_post();
						echo esc_html__( 'Author Archives: ', 'passport' ) . get_the_author();
						rewind_posts();
					} elseif ( is_day() ) {
						echo esc_html__( 'Daily Archives: ', 'passport' ) . get_the_date();
					} elseif ( is_month() ) {
						echo esc_html__( 'Monthly Archives: ', 'passport' ) . get_the_date('F Y');
					} elseif ( is_year() ) {
						echo esc_html__( 'Yearly Archives: ', 'passport' ) . get_the_date('Y');
					} elseif ( is_post_type_archive() ) {
						post_type_archive_title(); 
					} else {
						echo esc_html__( 'Archives: ', 'passport' );
					}
			?></h3>
	        <?php 
	        /* Left Sidebar */
	        if ( 'main_content' == $passport_blog_content_column )  : ?>
		        <!-- Left sidebar shows nothing -->
	        <?php elseif ( 'left' == $passport_blog_sidebar_position ) : 
		        if( 'sidebar_25' == $passport_blog_sidebar_width ) : ?>
			        <div id="sidebar" class="col-xs-12 col-sm-6 col-md-3 col-lg-3">
		        <?php elseif( 'sidebar_33' == $passport_blog_sidebar_width ) : ?>
			        <div id="sidebar" class="col-xs-12 col-sm-6 col-md-4 col-lg-4">
		        <?php endif; ?><!--End of sidebar width loop -->
				        <div class="row">
					        <div class="left-sidebar">
						        <?php get_sidebar(); ?>
					        </div>
				        </div>
		        <?php if( 'sidebar_25' == $passport_blog_sidebar_width ) : ?>
			        </div>
		        <?php elseif( 'sidebar_33' == $passport_blog_sidebar_width ) : ?>
			        </div>
		        <?php endif; ?><!--End of sidebar width loop -->
	        <?php endif; ?><!--End of loop -->

	        <?php 
	        /* Archive */
	        if( 'main_content' == $passport_blog_content_column ) : ?>
		        <div id="content" class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
			        <div class="row">
				        <?php get_template_part( 'partials/partials', 'page-template' ); ?>
			        </div>
		        </div>
	        <?php elseif( 'sidebar' == $passport_blog_content_column ) : ?>
		        <?php if( 'sidebar_25' == $passport_blog_sidebar_width ) : ?>
			        <div id="content" class="col-xs-12 col-sm-12 col-md-9 col-lg-9">
		        <?php elseif( 'sidebar_33' == $passport_blog_sidebar_width ) : ?>
			        <div id="content" class="col-xs-12 col-sm-12 col-md-8 col-lg-8">
		        <?php endif; ?><!--End of loop -->
				        <div class="row">
					        <?php get_template_part( 'partials/partials', 'page-template' ); ?>
				        </div>
		        <?php if( 'sidebar_25' == $passport_blog_sidebar_width ) : ?>
			        </div>
		        <?php elseif( 'sidebar_33' == $passport_blog_sidebar_width ) : ?>
			        </div>
		        <?php endif; ?><!--End of loop -->
	        <?php endif;  ?><!-- End of Loop -->

	        <?php 
	        /*Right Sidebar*/
	        if ( 'main_content' == $passport_blog_content_column )  : ?>
		        <!-- Right sidebar shows nothing -->
	        <?php elseif( 'sidebar' == $passport_blog_content_column ) : ?>	
		        <?php if( 'sidebar_25' == $passport_blog_sidebar_width ) : ?>
			        <div id="sidebar" class="col-xs-12 col-sm-6 col-md-3 col-lg-3">
		        <?php elseif( 'sidebar_33' == $passport_blog_sidebar_width ) : ?>
			        <div id="sidebar" class="col-xs-12 col-sm-6 col-md-4 col-lg-4">
		        <?php endif; ?><!--End of loop -->
				        <div class="row">
					        <div class="right-sidebar">
					        <?php get_sidebar(); ?>
					        </div>
				        </div>
		        <?php if( 'sidebar_25' == $passport_blog_sidebar_width ) : ?>
			        </div>
		        <?php elseif( 'sidebar_33' == $passport_blog_sidebar_width ) : ?>
			        </div>
		        <?php endif; ?><!--End of loop -->
	        <?php endif; ?>

		<?php endif; // if has_post() ?>
	</div><!-- #wrapper -->
</div><!-- #primary -->
<?php get_footer();