<?php
/**
 * Error404 page template
 *
 * @package passport
 * @subpackage passport
 * @since Passport v.1.0.
 * 
**/
	get_header();

	//Email the 404 error to administrator
	$adminemail		= get_option( 'admin_email' ); #the administrator email address, according to wordpress
	$website		= home_url(); #gets your blog's url from wordpress
	$websitename	= get_bloginfo( 'name' ); #sets the blog's name, according to wordpress
	$title_404		= get_theme_mod( 'passport_title_404', '' );
  
    if ( ! isset( $_SERVER['HTTP_REFERER'] ) ) { 
        #politely blames the user for all the problems they caused
   //   echo "tried going to "; #starts assembling an output paragraph
	    $casemessage = __( 'All is not lost!', 'passport' );

	} elseif ( isset( $_SERVER['HTTP_REFERER'] ) ) { 
		#setup a message to be sent to administrator.
		$failuremess = sprintf( __( 'A user tried to go to %s and recevied a 404 (page not found) error. ', 'passport' ), $website"
        .$_SERVER['REQUEST_URI']." ) );
        $failuremess .= sprintf( __( 'It was not their fault, so try fixing it. They came from %s', 'passport' ), $_SERVER['HTTP_REFERER'] );
        
        #email you about problem
        mail($adminemail), sprintf( __( 'Bad Link To %s', 'passport' ), $_SERVER['REQUEST_URI'] ), $failuremess, sprintf( 'From: %s <noreply@%s>', $websitename, $website );

        #set a friendly message
        $casemessage = __( 'An administrator has been emailed about this problem, too.', 'passport' ); #set a friendly message
	}
?>
<div id="primary" class="container">
	<div id="content" class="page-item" role="main">
		<?php get_template_part( 'partials/partials', 'image' ); ?>
			<?php if ( ! empty( $text_404 ) ||  ! empty( $title_404 ) ) : ?> 
		    <div class="page-content">
			    <?php get_template_part( 'partials/partials', 'header' ); ?>
			    <?php get_template_part( 'partials/partials', 'content' ); ?>
           	</div>
            <?php endif; ?>
	</div><!-- #content -->
</div><!-- #primary -->
<?php get_footer(); 