<?php
/**
 * The template for displaying all pages.
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site may use a
 * different template.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Passionate
 */
$site_layout = passionate_get_layout();
get_header(); ?>

	<div class="container">
        <div class="dt-main-cont layout-<?php echo esc_attr( $site_layout ); ?>">
			<div class="row">

                <div class="content-area-wrapper <?php if ( $site_layout == 'left_sidebar' || $site_layout == 'right_sidebar' ) : ?>col-lg-8 col-md-8<?php else: ?>col-lg-12 col-md-12<?php endif; ?> <?php if ( $site_layout == 'left_sidebar' ) echo 'push-md-4'; ?>">
                    <div id="primary" class="content-area">
						<main id="main" class="site-main" role="main">

							<?php while ( have_posts() ) : the_post(); ?>

								<?php get_template_part( 'template-parts/content', 'page' ); ?>

								<?php
								// If comments are open or we have at least one comment, load up the comment template.
								if ( comments_open() || get_comments_number() ) :
									comments_template();
								endif;
								?>

							<?php endwhile; // End of the loop. ?>

						</main><!-- #main -->
					</div><!-- #primary -->
				</div><!-- .col-lg-8 .col-md-8 -->

                <?php if ( $site_layout == 'left_sidebar' || $site_layout == 'right_sidebar' ) : ?>
                    <div class="sidebar-wrapper col-lg-4 col-md-4 <?php if ( $site_layout == 'left_sidebar' ) echo 'pull-md-8'; ?>">
                        <?php get_sidebar(); ?>
                    </div><!-- .col-lg-4 .col-md-4 -->
                <?php endif; ?>

			</div><!-- .row -->
		</div><!-- .dt-main-cont -->
	</div><!-- .container -->

<?php get_footer(); ?>
