<?php
/**
 * Template Name: Grid Page
 *
 */

$site_layout = passionate_get_layout();
get_header(); ?>

	<div class="container">
		<div class="dt-main-cont layout-<?php echo esc_attr( $site_layout ); ?>">
			<div class="row">

				<div class="content-area-wrapper <?php if ( $site_layout == 'left_sidebar' || $site_layout == 'right_sidebar' ) : ?>col-lg-8 col-md-8<?php else: ?>col-lg-12 col-md-12<?php endif; ?>">
					<div id="primary" class="content-area">
						<main id="main" class="site-main" role="main">

							<?php while ( have_posts() ) : the_post(); ?>
								<?php get_template_part( 'template-parts/content', 'page' ); ?>
								<?php
								// If comments are open or we have at least one comment, load up the comment template.
								if ( comments_open() || get_comments_number() ) :
									comments_template();
								endif;
								?>

							<?php endwhile; // End of the loop. ?>

						</main><!-- #main -->
					</div><!-- #primary -->

                    <?php
                    global $post;
                    $child_pages = new WP_Query( array(
                        'post_type'      => 'page',
                        'orderby'        => 'menu_order',
                        'order'          => 'ASC',
                        'post_parent'    => $post->ID,
                        'posts_per_page' => -1,
                        'no_found_rows'  => true,
                    ) );

                    $layout =  apply_filters( 'grid_child_page_layout', 3 );
                    ?>
                    <?php if ( $child_pages->have_posts() ) : ?>
                        <div class="grid-child-pages">
                            <div class="row">
                                <div class="col-lg-12 col-md-12">
                                    <div class="dt-works-wrap eq-row-col-<?php echo $layout; ?>">
                                        <?php while ( $child_pages->have_posts() ) : $child_pages->the_post(); ?>
                                            <?php get_template_part( 'template-parts/content', 'grid' ); ?>
                                        <?php endwhile; ?>
                                    </div><!-- .grid-area -->
                                </div><!-- .col-lg-12 -->
                            </div><!-- .row -->
                        </div><!-- .container -->
                        <?php
                        wp_reset_postdata();
                    endif;
                    ?>

				</div><!-- .col-lg-8 .col-md-8 -->

                <?php if ( $site_layout == 'left_sidebar' || $site_layout == 'right_sidebar' ) : ?>
                    <div class="sidebar-wrapper col-lg-4 col-md-4">
                        <?php get_sidebar(); ?>
                    </div><!-- .col-lg-4 .col-md-4 -->
                <?php endif; ?>

			</div><!-- .row -->


		</div><!-- .dt-main-cont -->
	</div><!-- .container -->

<?php get_footer(); ?>
