<?php

$widget_ultimate_url = trailingslashit( get_template_directory_uri().'/inc/widgets/widgets-ultimate/' );
$widget_ultimate_path = trailingslashit( get_template_directory().'/inc/widgets/widgets-ultimate/');
if ( ! class_exists( 'Widget_Ultimate' ) ) {
    include_once $widget_ultimate_path.'inc/init.php';
}
if ( class_exists( 'Widget_Ultimate' ) ) {
    $GLOBALS['Widget_Ultimate'] = new Widget_Ultimate( $widget_ultimate_path, $widget_ultimate_url );
}


/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function passionate_widgets_init() {

    // Register Right Sidebar
    register_sidebar( array(
        'name'          => esc_html__( 'Sidebar', 'passionate' ),
        'id'            => 'dt-right-sidebar',
        'description'   => __( 'Add widgets to Show widgets at right panel of page', 'passionate' ),
        'before_widget' => '<aside id="%1$s" class="widget %2$s">',
        'after_widget'  => '</aside>',
        'before_title'  => '<h2 class="widget-title">',
        'after_title'   => '</h2>',
    ) );

    // Register sidebar for top social icons
    register_sidebar( array(
        'name'          => esc_html__( 'Top Bar Social', 'passionate' ),
        'id'            => 'dt-top-bar-social',
        'description'   => __( 'Top Bar Search social icons', 'passionate' ),
        'before_widget' => '<aside id="%1$s" class="widget %2$s">',
        'after_widget'  => '</aside>',
        'before_title'  => '<h2 class="widget-title">',
        'after_title'   => '</h2>',
    ) );

    // Register sidebar for Top Search
    register_sidebar( array(
        'name'          => esc_html__( 'Top Bar Search', 'passionate' ),
        'id'            => 'dt-top-bar-search',
        'description'   => __( 'Top Bar Search Position', 'passionate' ),
        'before_widget' => '<aside id="%1$s" class="widget %2$s">',
        'after_widget'  => '</aside>',
        'before_title'  => '<h2 class="widget-title">',
        'after_title'   => '</h2>',
    ) );

    // Register Image Slider
    register_sidebar( array(
        'name'          => esc_html__( 'Image Slider', 'passionate' ),
        'id'            => 'dt-image-slider',
        'description'   => __( 'Add Image slider widget to show at Frontpage', 'passionate' ),
        'before_widget' => '<aside id="%1$s" class="widget %2$s">',
        'after_widget'  => '</aside>',
        'before_title'  => '<h2 class="widget-title">',
        'after_title'   => '</h2>',
    ) );

    // Register front page sidebar
    register_sidebar( array(
        'name'          => esc_html__( 'Front Page: Widgets', 'passionate' ),
        'id'            => 'dt-front-page-widgets',
        'description'   => __( 'Add widgets to show at Frontpage', 'passionate' ),
        'before_widget' => '<aside id="%1$s" class="widget %2$s">',
        'after_widget'  => '</aside>',
        'before_title'  => '<h2 class="widget-title">',
        'after_title'   => '</h2>',
    ) );

    // Register Footer Position 1
    register_sidebar( array(
        'name'          => esc_html__( 'Footer Position 1', 'passionate' ),
        'id'            => 'dt-footer1',
        'description'   => __( 'Add widgets to Show widgets at Footer Position 1', 'passionate' ),
        'before_widget' => '<aside id="%1$s" class="widget %2$s">',
        'after_widget'  => '</aside>',
        'before_title'  => '<h2 class="widget-title"><span></span>',
        'after_title'   => '</h2>',
    ) );

    // Register Footer Position 2
    register_sidebar( array(
        'name'          => esc_html__( 'Footer Position 2', 'passionate' ),
        'id'            => 'dt-footer2',
        'description'   => __( 'Add widgets to Show widgets at Footer Position 2', 'passionate' ),
        'before_widget' => '<aside id="%1$s" class="widget %2$s">',
        'after_widget'  => '</aside>',
        'before_title'  => '<h2 class="widget-title"><span></span>',
        'after_title'   => '</h2>',
    ) );

    // Register Footer Position 3
    register_sidebar( array(
        'name'          => esc_html__( 'Footer Position 3', 'passionate' ),
        'id'            => 'dt-footer3',
        'description'   => __( 'Add widgets to Show widgets at Footer Position 3', 'passionate' ),
        'before_widget' => '<aside id="%1$s" class="widget %2$s">',
        'after_widget'  => '</aside>',
        'before_title'  => '<h2 class="widget-title"><span></span>',
        'after_title'   => '</h2>',
    ) );

    // Register Footer Position 4
    register_sidebar( array(
        'name'          => esc_html__( 'Footer Position 4', 'passionate' ),
        'id'            => 'dt-footer4',
        'description'   => __( 'Add widgets to Show widgets at Footer Position 4', 'passionate' ),
        'before_widget' => '<aside id="%1$s" class="widget %2$s">',
        'after_widget'  => '</aside>',
        'before_title'  => '<h2 class="widget-title"><span></span>',
        'after_title'   => '</h2>',
    ) );
}
add_action( 'widgets_init', 'passionate_widgets_init' );

/**
 * Enqueue Admin Scripts
 */
function passionate_media_script( $hook ) {
    //if ( 'widgets.php' != $hook ) {
        //return;
    //}
    // Update CSS within in Admin
    wp_enqueue_style( 'passionate-widgets', get_template_directory_uri() . '/inc/widgets/widgets.css' );
}
add_action( 'admin_enqueue_scripts', 'passionate_media_script' );


include_once get_template_directory().'/inc/widgets/widget-cta.php';
include_once get_template_directory().'/inc/widgets/widget-image-slider.php';
include_once get_template_directory().'/inc/widgets/widget-logo-slider.php';
include_once get_template_directory().'/inc/widgets/widget-recent-posts.php';
include_once get_template_directory().'/inc/widgets/widget-recent-works.php';
include_once get_template_directory().'/inc/widgets/widget-services.php';
include_once get_template_directory().'/inc/widgets/widget-social-icons.php';
include_once get_template_directory().'/inc/widgets/widget-testimonial.php';





// Register widgets
function passionate_register_widgets() {

    register_widget( 'passionate_social_icons' );
    register_widget( 'Passionate_Image_Slider_Widget' );
    register_widget( 'Passionate_Services_Widget' );
    register_widget( 'Passionate_Recent_Works_Widget' );
    register_widget( 'passionate_call_to_action' );
    register_widget( 'Passionate_Testimonial_Widget' );
    register_widget( 'Passionate_Logo_Slider_Widget' );
    register_widget( 'passionate_recent_posts' );
   

}
add_action( 'widgets_init', 'passionate_register_widgets' );


class Passionate_Widget_Classes{
    function __construct(){
        /**
         * @see $params = apply_filters( 'dynamic_sidebar_params', $params );
         */
        add_filter( 'dynamic_sidebar_params', array( $this, 'add_classes' ) );

        /**
         * see do_action_ref_array( 'in_widget_form', array( &$this, &$return, $instance ) );
         */
        add_action( 'in_widget_form', array( $this, 'add_settings' ), 35, 3 );
        add_filter( 'widget_update_callback', array( $this, 'update_widget' ), 10, 2 );
    }
    function update_widget( $instance, $new_instance ){
        if ( isset( $new_instance['widget_meta_bg'] ) ) {
            $new_instance['widget_meta_bg'] = sanitize_text_field( $new_instance[ 'widget_meta_bg' ] ) == 1 ? 1: null;
        }
        return $new_instance;
    }
    function get_default( $key ){
        $widget_default_setting = array(
            'passionate_recent_works' => 1,
            'passionate_testimonial' => 1,
            'passionate_pricing' => 1,
        );
        if ( isset( $widget_default_setting[ $key ] ) ) {
            return  $widget_default_setting[ $key ];
        } else {
            return false;
        }
    }

    function add_settings( $widget, $return, $instance ){

        $default = $this->get_default( $widget->id_base );
        $key = 'widget_meta_bg';

        if (  empty( $instance ) ) {
            $instance[ $key ] = $default;
        }
        $instance = wp_parse_args( $instance, array(
            'widget_meta_bg' => ''
        ) );
        ?>
        <p class="widget-meta-bg">
            <label for="<?php echo $widget->get_field_id( $key ); ?>">  <input class="widefat" <?php checked( $instance[ $key ] ,  1 ); ?> type="checkbox" id="<?php echo $widget->get_field_id( $key ); ?>" value="1" name="<?php echo $widget->get_field_name( $key ); ?>" /> <?php esc_html_e( 'Apply Meta Background', 'passionate' ); ?></label>
        </p>
        <?php
    }

    function add_classes( $params ){
        if ( is_admin() ) {

        }

        global $wp_registered_widgets, $wp_registered_sidebars , $widget_number;

        if ( ! isset( $params[0] ) ) {
            return $params;
        }

        //$arr_registered_widgets = wp_get_sidebars_widgets(); // Get an array of ALL registered widgets
        $sidebar_id     = $params[0]['id']; // Get the id for the current sidebar we're processing
        $widget_id      = $params[0]['widget_id'];
        $widget_obj     = $wp_registered_widgets[$widget_id];
        $widget_index   = $widget_obj['params'][0]['number'];
        $widget_opt     = null;
        $widget_opt     = get_option( $widget_obj['callback'][0]->option_name );

        // Get registered sidebars
        $sidebar = $wp_registered_sidebars[ $sidebar_id ];
        $settings = $widget_opt[$widget_index];
        $_meta_bg = false;
        $_custom_class = false;
        if ( isset( $settings['widget_meta_bg'] ) && sanitize_title( $settings['widget_meta_bg'] ) != '' ) {
            $_meta_bg =  $settings['widget_meta_bg'] == 1 ? true : false;
        } elseif( empty( $settings ) ) {
            $_meta_bg = $this->get_default( $widget_obj['callback'][0]->id_base );
        }
        $_id = $widget_id;

        $classes = array();
        if ( isset( $widget_obj['classname'] ) ) {
            $classes[] = $widget_obj['classname'];
        }

        if ( $_meta_bg ) {
            $classes[] = 'widget-meta-bg';
        }

        $classes[] =  $widget_obj['callback'][0]->option_name;
        if ( $_custom_class ) {
            $classes[] = $_custom_class;
        }

        $classes = join( ' ', $classes );
        $params[0]['before_widget'] = sprintf( $sidebar['before_widget'], $_id, $classes );
        return $params;
    }
}

new Passionate_Widget_Classes();