<?php

/**
 * Testimonial.
 */
class Passionate_Testimonial_Widget extends Widget_Ultimate_Widget_Base {

    public function __construct() {
        parent::__construct(
            'passionate_testimonial',
            __( 'Passionate: Testimonial', 'passionate' ),
            array(
                'description'   => __( 'to Show client Testimonials', 'passionate' )
            )
        );

    }

    function config() {
       
            $limit = 3;
        
        $fields = array(
            array(
                'type' =>'text',
                'name' => 'title',
                'label' => esc_html__( 'Title', 'passionate' ),
                'default' => esc_html__( 'What Clients Says', 'passionate' ),
            ),
            array(
                'type' =>'text',
                'name' => 'description',
                'label' => esc_html__( 'Description', 'passionate' ),
                'default' => ''
            ),

            array(
                'type' =>'group',
                'name' => 'dt_testimonial',
                'label'    => esc_html__( 'Client Says', 'passionate' ),
                'title_id' => 'name',
                'limit' => $limit,
                'limit_msg' => esc_html__( 'Please Upgrade to Pro version to add unlimited items.', 'passionate' ),
                'default' => array(
                ),
                'fields' => array(
                    array(
                        'type' =>'text',
                        'name' => 'name',
                        'label' => esc_html__( 'Name', 'passionate' ),
                    ),
                    array(
                        'type' =>'image',
                        'name' => 'image',
                        'label' => esc_html__( 'Image', 'passionate' ),
                    ),
                    array(
                        'type' =>'text',
                        'name' => 'company',
                        'label' => esc_html__( 'Company', 'passionate' ),
                    ),
                    array(
                        'type' =>'textarea',
                        'name' => 'description',
                        'label' => esc_html__( 'Description', 'passionate' ),
                    ),

                )
            ),

        );

        return $fields;
    }

    public function widget( $args, $instance ) {

        $title                  = isset( $instance['title'] ) ? $instance['title'] : '';
        $dt_testimonial_values  = isset( $instance['dt_testimonial'] ) ? $instance['dt_testimonial'] : '';
        echo $args['before_widget'];
        ?>

        <div class="dt-testimonial">
            <div class="dt-testimonial-wrap">
                <div class="container">
                    <div class="row">
                        <div class="col-lg-12 col-md-12">
                            <?php if ( $title || $description ) { ?>
                                <div class="dt-widget-meta">
                                    <?php if( ! empty( $title ) ) : ?><h2><?php echo esc_html( $title ); ?><span></span></h2><?php endif; ?>
                                    <?php if( ! empty( $description ) ) : ?><p><?php echo esc_html( $description ); ?></p><?php endif; ?>
                                </div><!-- .dt-services-meta -->
                            <?php } ?>
                            <div class="swiper-container dt-testimonial-slider">
                                <div class="swiper-wrapper">
                                    <?php
                                    if ( $dt_testimonial_values ) {
	                                    foreach ( $dt_testimonial_values as $dt_testimonial_key => $dt_testimonial_value ) : ?>
                                            <div class="swiper-slide">
                                                <div class="dt-testimonial-holder">
				                                    <?php if ( ! empty( $dt_testimonial_value['description'] ) ) : ?>
                                                        <div class="dt-testimonial-desc">
                                                            <p><?php echo esc_textarea( $dt_testimonial_value['description'] ); ?></p>
                                                        </div><!-- .dt-testimonial-desc -->
				                                    <?php endif; ?>
                                                    <div class="dt-testimonial-meta">
					                                    <?php
					                                    $image = $this->get_image( $dt_testimonial_value['image'] );
					                                    if ( $image ) : ?>
                                                            <figure><img src="<?php echo esc_url( $image ); ?>"
                                                                         alt="<?php if ( ! empty ( $dt_testimonial_value['name'] ) ) : echo esc_attr( $dt_testimonial_value['name'] ); else : _e( 'Testimonial User', 'passionate' ); endif; ?>"/>
                                                            </figure><?php
					                                    endif; ?>
					                                    <?php if ( ! empty ( $dt_testimonial_value['name'] ) ) : ?>
                                                            <h5><?php echo esc_html( $dt_testimonial_value['name'] ); ?></h5><?php endif; ?>
					                                    <?php if ( ! empty ( $dt_testimonial_value['company'] ) ) : ?>
                                                            <span><?php echo esc_html( $dt_testimonial_value['company'] ); ?></span><?php endif; ?>
                                                    </div><!-- .dt-testimonial-meta -->
                                                </div><!-- .dt-testimonial-holder -->
                                            </div><!-- .swiper-slide -->
	                                    <?php endforeach;
                                    }
                                    ?>
                                </div><!-- .swiper-wrapper -->

                                <!-- Add Arrows -->
                                <div class="swiper-button-next transition5"><i class="fa fa-angle-right"></i></div>
                                <div class="swiper-button-prev transition5"><i class="fa fa-angle-left"></i></div>
                            </div><!-- .dt-testimonial-slider -->
                        </div><!-- .col-lg-12 .col-md-12 -->
                    </div><!-- .row -->
                </div><!-- .container -->
            </div><!-- .dt-testimonial-wrap-->
        </div>
        <?php
        echo $args['after_widget'];
    }

}