<?php
/**
 * Services
 */
class Passionate_Services_Widget extends Widget_Ultimate_Widget_Base {

    public function __construct() {

        parent::__construct(
            'passionate_services',
            __( 'Passionate: Services', 'passionate' ),
            array(
                'description'   => __( 'Show Service pages with short description and featured image.', 'passionate' )
            )
        );

    }

    function config( ){
       
            $limit = 6;
        

        $fields = array(
            array(
                'type' =>'text',
                'name' => 'title',
                'label' => esc_html__( 'Title', 'passionate' ),
                'default' => esc_html__( 'WordPress Theme Features', 'passionate' ),
            ),

            array(
                'type' =>'text',
                'name' => 'description',
                'label' => esc_html__( 'Description', 'passionate' ),
                'default' => __( 'Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor.', 'passionate' ),
            ),

            array(
                'type' =>'select',
                'name' => 'data_type',
                'default' => 'pages',
                'label' => esc_html__( 'Data Type', 'passionate' ),
                'desc' => esc_html__( 'Chose List Pages or Page have children.', 'passionate' ),
                'options' => array(
                    'pages'   => esc_html__( 'List Pages', 'passionate' ),
                    'parent_page'   => esc_html__( 'Page have children', 'passionate' ),
                ),
            ),

            array(
                'type' =>'source',
                'name' => 'page',
                'label' => esc_html__( 'Service Page', 'passionate' ),
                'desc' => esc_html__( 'Select a page which have children pages.', 'passionate' ),
                'source' => array(
                    'post_type' => 'page', // or any post type
                ),
                'required' => array(
                    'when' => 'data_type' ,
                    'is' => 'parent_page'
                ),
            ),

            array(
                'type' =>'group',
                'name' => 'dt_service_page',
                'label'    => esc_html__( 'Service Pages', 'passionate' ),
                'title_id' => 'page',
                'required' => array(
                    'when' => 'data_type' ,
                    'is' => 'pages'
                ),
                'limit' => $limit,
                'limit_msg' => esc_html__( 'Please Upgrade to Pro version to add unlimited items.', 'passionate' ),
                'fields' => array(
                    array(
                        'type' =>'source',
                        'name' => 'page',
                        'label' => esc_html__( 'Page', 'passionate' ),
                        'source' => array(
                            'post_type' => 'page', // or any post type
                        )
                    ),

                )
            ),

            array(
                'type' =>'select',
                'name' => 'layout',
                'default' => 3,
                'label' => esc_html__( 'Layout Column', 'passionate' ),
                'options' => array(
                    2  => 2,
                    3  => 3,
                    4  => 4,
                ),
            ),

        );

        return $fields;
    }

    function the_loop( $post ){
        ?>
        <div class="eq-col col-border dt-services-holder">
            <?php  if ( has_post_thumbnail( $post ) ) { ?>
            <figure>
                <a href="<?php echo esc_url( get_the_permalink( $post ) ); ?>">
                    <?php
                    $dt_service_page_thumbnail_src = wp_get_attachment_image_src( get_post_thumbnail_id( $post ), 'passionate-service-img' );
                    $dt_service_page_thumbnail_url = $dt_service_page_thumbnail_src[0];
                    ?>
                    <img src="<?php echo esc_url( $dt_service_page_thumbnail_url ); ?>" alt="<?php echo esc_attr( get_the_title( $post ) ); ?>">
                </a>
            </figure>
            <?php } ?>
            <h3><a href="<?php echo esc_url( get_the_permalink( $post ) ); ?>"><?php echo get_the_title( $post ); ?></a></h3>
            <?php
            $content = apply_filters( 'the_content', $post->post_content );
            $content = preg_replace( '/<img[^>]+./','', $content );
            $content = wp_trim_words( $content, 16, '...' );
            ?>
            <p class="dt-service-cont"><?php echo wp_kses_post( $content ); ?></p>
            <div class="dt-service-more">
                <a href="<?php echo esc_url( get_the_permalink( $post ) ); ?>"><?php _e( 'Read More', 'passionate' ); ?></a>
            </div>
        </div>
        <?php
    }

    public function widget( $args, $instance ) {

        $instance = wp_parse_args( $instance, array(
            'title'             => '',
            'description'       => '',
            'dt_service_page'   => '',
            'layout'            => '',
            'data_type'         => '',
            'page'              => '',
        ) );
        $title          = isset( $instance['title'] ) ? $instance['title'] : '';
        $description    = isset( $instance['description'] ) ? esc_textarea( $instance['description'] ) : '';
        $pages          = isset( $instance['dt_service_page'] ) ? $instance['dt_service_page'] : '';
        $layout             = absint( $instance['layout'] );
        if ( ! $layout ) {
            $layout = 3;
        }
        echo $args['before_widget'];
        ?>
        <div class="dt-services">
            <div class="container">
                <div class="col-lg-12 col-md-12">
                    <?php if ( $title || $description ) { ?>
                    <div class="dt-widget-meta dt-services-meta">
                        <?php if( ! empty( $title ) ) : ?><h2><?php echo esc_html( $title ); ?><span></span></h2><?php endif; ?>
                        <?php if( ! empty( $description ) ) : ?><p><?php echo esc_html( $description ); ?></p><?php endif; ?>
                    </div><!-- .dt-services-meta -->
                    <?php } ?>

                    <div class="dt-services-wrap eq-row-no-mg eq-row-col-<?php echo esc_attr( $layout ); ?> dt-services-gt-<?php echo esc_attr( $layout - 1 ); ?>">
                        <?php
                        if ( $instance['data_type'] == 'parent_page' ) {
                            $pages = false;
                            if ( $instance['page'] && is_numeric( $instance['page'] ) ) {
                                $pages = get_posts( array(
                                    'post_type'      => 'page',
                                    'post_parent'    => $instance['page'],
                                    'posts_per_page' => -1,
                                    'orderby'        => 'menu_order',
                                    'order'          => 'ASC'
                                ) );
                            }
                            if ( $pages ) {
                                foreach ( $pages as $p ) {
                                    $this->the_loop( $p );
                                } // end loop pages
                            } // end if pages
                        } else {
	                        if ( $pages ) {
		                        foreach ( $pages as $page ) {
			                        $page_id = absint( $page['page'] );
			                        $post    = get_post( $page_id );
			                        if ( $post ) {
				                        $this->the_loop( $post );
			                        }
		                        };
	                        }
                        }
                        ?>
                        <div class="clearfix"></div>
                    </div><!-- .dt-services-wrap -->
                </div><!-- .col-lg-12 .col-md-12 -->

            </div><!-- .container -->
        </div>

        <?php
        echo $args['after_widget'];
    }

}
