<?php
/**
 * Recent Works.
 */
class Passionate_Recent_Works_Widget extends Widget_Ultimate_Widget_Base {

    public function __construct() {

        parent::__construct(
            'passionate_recent_works',
            __( 'Passionate: Recent Works', 'passionate' ),
            array(
                'description'   => __( 'Recent Works Widget', 'passionate' )
            )
        );

    }

    function config( ){
       
            $limit = 6;
        

        $fields = array(
            array(
                'type' =>'text',
                'name' => 'title',
                'label' => esc_html__( 'Title', 'passionate' ),
                'default' => esc_html__( 'Our Works Define Themselves', 'passionate' ),
            ),
            array(
                'type' =>'text',
                'name' => 'description',
                'label' => esc_html__( 'Description', 'passionate' ),
                'default' => __( 'Lorem ipsum dolor sit amet, consectetuer adipiscing elit', 'passionate' ),
            ),
            array(
                'type' =>'select',
                'name' => 'data_type',
                'default' => 'pages',
                'label' => esc_html__( 'Data Type', 'passionate' ),
                'desc' => esc_html__( 'Chose List Pages or Page have children.', 'passionate' ),
                'options' => array(
                    'pages'   => esc_html__( 'List Pages', 'passionate' ),
                    'parent_page'   => esc_html__( 'Page have children', 'passionate' ),
                ),
            ),
            array(
                'type' =>'source',
                'name' => 'page',
                'label' => esc_html__( 'Portfolio Page', 'passionate' ),
                'desc' => esc_html__( 'Select a page which have children pages.', 'passionate' ),
                'source' => array(
                    'post_type' => 'page', // or any post type
                ),
                'required' => array(
                    'when' => 'data_type' ,
                    'is' => 'parent_page'
                ),
            ),
            array(
                'type' =>'group',
                'name' => 'dt_recent_works_page',
                'label'    => esc_html__( 'Portfolio Pages', 'passionate' ),
                'title_id' => 'page',
                'required' => array(
                    'when' => 'data_type' ,
                    'is' => 'pages'
                ),
                'limit' => $limit,
                'limit_msg' => esc_html__( 'Please Upgrade to Pro version to add unlimited items.', 'passionate' ),
                'fields' => array(
                    array(
                        'type' =>'source',
                        'name' => 'page',
                        'label' => esc_html__( 'Page', 'passionate' ),
                        'source' => array(
                            'post_type' => 'page', // or any post type
                        )
                    ),
                )
            ),
            array(
                'type' =>'select',
                'name' => 'layout',
                'default' => 3,
                'label' => esc_html__( 'Layout Column', 'passionate' ),
                'options' => array(
                    2  => 2,
                    3  => 3,
                    4  => 4,
                ),
            ),
            array(
                'type' =>'select',
                'name' => 'show_more',
                'label' => esc_html__( 'Show more button', 'passionate' ),
                'options' => array(
                    'show'   => esc_html__( 'Show', 'passionate' ),
                    'hide'   => esc_html__( 'Hide', 'passionate' ),
                ),
            ),
            array(
                'type' =>'text',
                'name' => 'more_label',
                'label' => esc_html__( 'More Label', 'passionate' ),
                'default' => esc_html__( 'View more', 'passionate' ),
                'required' => array(
                    'when' => 'show_more' ,
                    'is' => 'show'
                ),
            ),
            array(
                'type' =>'text',
                'name' => 'more_link',
                'label' => esc_html__( 'More Link', 'passionate' ),
                'default' => '#',
                'required' => array(
                    'when' => 'show_more' ,
                    'is' => 'show'
                ),
            ),

        );

        return $fields;
    }

    function the_loop( $post ){
        ?>
        <div class="eq-col dt-works-holder">
            <figure>
                <?php
                if (  has_post_thumbnail( $post ) ) {
                    $src = wp_get_attachment_image_src( get_post_thumbnail_id( $post ), 'passionate-works-img' );
                    $src = $src[0];
                    ?>
                    <img src="<?php echo esc_url( $src ); ?>" alt="<?php echo esc_attr( get_the_title( $post ) ); ?>">
                <?php } ?>
                <div class="dt-works-desc transition5">
                    <div class="dt-work-ttl transition5">
                        <h3><?php echo esc_html( get_the_title( $post ) ); ?></h3>
                        <a href="<?php echo esc_url( get_the_permalink( $post ) ); ?>"><?php _e( 'Views Details', 'passionate' ); ?></a>
                    </div>
                </div><!-- .dt-works-desc -->
            </figure>
        </div><!-- .dt-works-holder -->
        <?php
    }

    public function widget( $args, $instance ) {
        $instance = $this->setup_default_values( $instance , $this->get_configs() );
        $instance = wp_parse_args( $instance, array(
            'title'             => '',
            'description'       => '',
            'dt_service_page'   => '',
            'layout'            => '',
            'data_type'         => '',
            'page'              => '',
            'show_more'         => '',
            'more_label'        => '',
            'more_link'         => '',
        ) );
        $title          = isset( $instance['title'] ) ? $instance['title'] : '';
        $description    = isset( $instance['description'] ) ? esc_textarea( $instance['description'] ) : '';
        $pages          = isset( $instance['dt_recent_works_page'] ) ? $instance['dt_recent_works_page'] : '';
        $layout             = absint( $instance['layout'] );
        if ( ! $layout ) {
            $layout = 3;
        }

        echo $args['before_widget'];
        ?>
        <div class="dt-recent-works">
            <div class="container">

                <div class="col-lg-12 col-md-12">
                    <?php if ( $title || $description ) { ?>
                    <div class="dt-widget-meta">
                        <?php if( ! empty( $title ) ) : ?><h2><?php echo esc_html( $title ); ?><span></span></h2><?php endif; ?>
                        <?php if( ! empty( $description ) ) : ?><p><?php echo wp_kses_post( $description ); ?></p><?php endif; ?>
                    </div>
                    <?php } ?>

                    <div class="dt-works-wrap eq-row-col-<?php echo esc_attr( $layout ); ?>">
                        <?php
                        if ( $instance['data_type'] == 'parent_page' ) {
                            $pages = false;
                            if ( $instance['page'] && is_numeric( $instance['page'] ) ) {
                                $pages = get_posts( array(
                                    'post_type'      => 'page',
                                    'post_parent'    => $instance['page'],
                                    'posts_per_page' => -1,
                                    'orderby'        => 'menu_order',
                                    'order'          => 'ASC'
                                ) );
                            }
                            if ( $pages ) {
                                foreach ( $pages as $p ) {
                                    $this->the_loop( $p );
                                } // end loop pages
                            } // end if pages
                        } else {
	                        if ( $pages ) {
		                        foreach ( $pages as $page ) {
			                        $page_id = absint( $page['page'] );
			                        $post    = get_post( $page_id );
			                        if ( $post ) {
				                        $this->the_loop( $post );
			                        }
		                        };
	                        }
                        }
                        ?>
                        <div class="clearfix"></div>
                    </div><!-- .dt-works-wrap -->
                    <?php

                    if ( $instance['show_more'] != 'hide' ) {
                        ?>
                        <div class="dt-works-more text-center">
                            <a class="btn btn-theme" href="<?php echo $instance['more_link'] ?>"><?php echo wp_kses_post( $instance['more_label'] ); ?></a>
                        </div>
                        <?php
                    }
                    ?>
                </div><!-- .col-lg-12 .col-md-12 -->

            </div><!-- .container -->
        </div>
        <?php
        echo $args['after_widget'];
    }

}