<?php
/**
 * News Recent Posts
 */
class passionate_recent_posts extends WP_Widget {

    public function __construct() {

        parent::__construct(
            'passionate_recent_posts',
            __( 'Passionate: Front Recent Posts', 'passionate' ),
            array(
                'description'   => __( 'Posts display widget for recently published post', 'passionate' )
            )
        );
    }

    public function widget( $args, $instance ) {

        global $post;
        $title          = isset( $instance['title'] ) ? $instance['title'] : '';
        $category       = isset( $instance['category'] ) ? $instance['category'] : '';
        $no_of_posts    = isset( $instance['no_of_posts'] ) ? $instance['no_of_posts'] : '';

        $news_layout1 = new WP_Query( array(
            'post_type'         => 'post',
            'category__in'      => $category,
            'posts_per_page'    => $no_of_posts
        ) );
        echo $args['before_widget'];
        ?>

        <div class="widget dt-recent-posts">

            <div class="dt-news-layout-wrap">
                <div class="container">
                    <div class="row">
                        <div class="col-lg-12 col-md-12">
                            <?php
                            if ( $news_layout1->have_posts() ) :

                                if ( !empty( $title ) ) : ?>
                                    <div class="dt-widget-meta">
                                        <h2><?php echo esc_html( $title ); ?><span></span></h2>
                                    </div>
                                <?php endif; ?>

                                <div class="dt-front-blog-wrap">

                                    <?php while ( $news_layout1->have_posts() ) : $news_layout1->the_post(); ?>

                                        <div class="dt-recent-post-holder">
                                            <figure class="dt-recent-post-img transition5">
                                                <?php

                                                if ( has_post_thumbnail() ) :
                                                    $image = '';
                                                    $title_attribute = get_the_title( $post->ID );
                                                    $image .= '<a href="'. esc_url( get_permalink() ) . '" title="' . esc_attr( the_title( '', '', false ) ) .'">';
                                                    $image .= get_the_post_thumbnail( $post->ID, 'passionate-front-blog-img', array( 'title' => esc_attr( $title_attribute ), 'alt' => esc_attr( $title_attribute ) ) ).'</a>';
                                                    echo $image;
                                                endif;
                                                ?>

                                            </figure><!-- .dt-recent-post-img -->

                                            <div class="dt-recent-post-content">
                                                <h3><a href="<?php esc_url( the_permalink() ); ?>" title="<?php the_title_attribute(); ?>"><?php esc_attr( the_title() ); ?></a></h3>

                                                <p><?php
                                                    $excerpt = get_the_excerpt();
                                                    $limit   = "125";
                                                    $pad     = "...";

                                                    if( strlen( $excerpt ) <= $limit ) {
                                                        echo esc_attr( $excerpt );
                                                    } else {
                                                        $excerpt = substr( $excerpt, 0, $limit ) . $pad;
                                                        echo esc_attr( $excerpt );
                                                    }
                                                    ?></p>
                                            </div><!-- .dt-recent-post-content -->
                                        </div><!-- .dt-recent-post-holder -->

                                    <?php endwhile; ?>

                                    <?php wp_reset_postdata(); ?>

                                </div>

                            <?php else : ?>
                                <p><?php _e( 'Sorry, no posts found in selected category.', 'passionate' ); ?></p>
                            <?php endif; ?>

                            <div class="clearfix"></div>
                        </div><!-- .col-lg-12 .col-md-12 -->
                    </div><!-- .row -->
                </div><!-- .container -->
            </div><!-- .dt-news-layout-wrap -->
        </div>

        <?php
        echo $args['after_widget'];
    }

    public function form( $instance ) {

        $instance = wp_parse_args(
            (array) $instance, array(
                'title'              => '',
                'category'           => '',
                'no_of_posts'        => '4'
            )
        );

        ?>

        <div class="dt-admin-recent-posts">
            <div class="dt-admin-input-wrap">
                <label for="<?php echo $this->get_field_id( 'title' ); ?>"><strong><?php _e( 'Title', 'passionate' ); ?></strong></label>

                <input type="text" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo esc_attr( $instance['title'] ); ?>" >
            </div><!-- .dt-admin-input-wrap -->

            <div class="dt-admin-input-wrap">
                <label for="<?php echo $this->get_field_id( 'category' ); ?>"><strong><?php _e( 'Category', 'passionate' ); ?></strong></label>

                <select id="<?php echo $this->get_field_id( 'category' ); ?>" name="<?php echo $this->get_field_name( 'category' ); ?>">
                    <?php foreach( get_terms( 'category','parent=0&hide_empty=0' ) as $term ) { ?>
                        <option <?php selected( $instance['category'], $term->term_id ); ?> value="<?php echo $term->term_id; ?>"><?php echo $term->name; ?></option>
                    <?php } ?>
                </select>
            </div><!-- .dt-admin-input-wrap -->

            <div class="dt-admin-input-wrap">
                <label for="<?php echo $this->get_field_id( 'no_of_posts' ); ?>"><strong><?php _e( 'No. of Posts', 'passionate' ); ?></strong></label>

                <input type="number" id="<?php echo $this->get_field_id( 'no_of_posts' ); ?>" name="<?php echo $this->get_field_name( 'no_of_posts' ); ?>" value="<?php echo esc_attr( $instance['no_of_posts'] ); ?>">
            </div><!-- .dt-admin-input-wrap -->
        </div><!-- .dt-news-list-1 -->
        <?php
    }

    public function update( $new_instance, $old_instance ) {

        $instance                   = $old_instance;
        $instance['title']          = strip_tags( stripslashes( $new_instance['title'] ) );
        $instance['category']       = $new_instance['category'];
        $instance['no_of_posts']    = strip_tags( stripslashes( $new_instance['no_of_posts']  ) );
        return $instance;

    }

}
