<?php

/**
 * Logo Slider
 */
class Passionate_Logo_Slider_Widget extends Widget_Ultimate_Widget_Base {

    public function __construct() {

        parent::__construct(
            'passionate_logo_slider',
            __( 'Passionate: Logo Display','passionate' ),
            array(
                'description'   => __( 'Widget to show clients logos', 'passionate' )
            )
        );

    }

    function config() {
       
            $limit = 5;
        
        $fields = array(

            array(
                'type' =>'group',
                'name' => 'dt_logo_slider',
                'label'    => esc_html__( 'Logos', 'passionate' ),
                'title_id' => 'title',
                'limit' => $limit,
                'limit_msg' => esc_html__( 'Please Upgrade to Pro version to add unlimited items.', 'passionate' ),
                'default' => array(
                ),
                'fields' => array(
                    array(
                        'type' =>'text',
                        'name' => 'title',
                        'label' => esc_html__( 'Title', 'passionate' ),
                    ),
                    array(
                        'type' =>'image',
                        'name' => 'image',
                        'label' => esc_html__( 'Image', 'passionate' ),
                    ),
                    array(
                        'type' =>'text',
                        'name' => 'url',
                        'label' => esc_html__( 'URL', 'passionate' ),
                    ),

                )
            ),

        );

        return $fields;
    }

    public function widget( $args, $instance ) {
        $instance = $this->setup_default_values( $instance, $this->get_configs() );
        $images  = isset( $instance['dt_logo_slider'] ) ? $instance['dt_logo_slider'] : '';
        echo $args['before_widget'];
        ?>
        <div class="dt-logo-display">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12 col-md-12">
                        <ul>
                            <?php
                            if ( is_array( $images ) ) :
                                foreach ( $images as $key => $image ) :
                                    $image = wp_parse_args( $image, array(
                                        'image' => '',
                                        'url'   => '',
                                        'title' => ''
                                    ) );
                                    $img = $this->get_image( $image['image'] );
                                    if(  $img ) :
                                        ?>
                                        <li class="transition35">
                                            <a href="<?php if( ! empty ( $image['link'] )  ): echo esc_url( $image['link']  ); else : echo esc_attr( '#' ); endif; ?>" title="<?php if( ! empty ( $image['title'] ) ) : echo esc_attr( $image['title'] ); else : echo _e( 'Logo', 'passionate' ); endif; ?>" target="_blank">
                                                <img src="<?php echo esc_url( $img ); ?>" title="<?php if( ! empty ( $image['title'] ) ) : echo esc_attr( $image['title'] ); else : echo _e( 'Logo', 'passionate' ); endif; ?>" alt="<?php if( ! empty ( $image['title'] ) ) : echo esc_attr( $image['title'] ); else : echo _e( 'Logo', 'passionate' ); endif; ?>" />
                                            </a>
                                        </li>
                                    <?php endif;

                                endforeach;
                            endif;
                            ?>

                            <div class="clearfix"></div>
                        </ul>
                    </div><!-- .col-lg-12 .col-md-12 -->
                </div><!-- .row -->
            </div><!-- .container -->
        </div>
        <?php
        echo $args['after_widget'];
    }


}