<?php

/**
 * Image Slider.
 */
class Passionate_Image_Slider_Widget extends Widget_Ultimate_Widget_Base {

    public function __construct() {

        parent::__construct(
            'passionate_image_slider',
            __( 'Passionate: Image Slider', 'passionate' ),
            array(
                'description'   => __( 'Adds Images for Banner Slider', 'passionate' )
            )
        );
    }

    function config() {
       
            $limit = 4;
        
        $fields = array(

            array(
                'type' =>'group',
                'name' => 'dt_img_slider',
                'label'    => esc_html__( 'Slider Images', 'passionate' ),
                'title_id' => 'title',
                'limit' => $limit,
                'limit_msg' => esc_html__( 'Please Upgrade to Pro version to add unlimited items.', 'passionate' ),
                'default' => array(
                ),
                'fields' => array(
                    array(
                        'type' =>'text',
                        'name' => 'title',
                        'label' => esc_html__( 'Title', 'passionate' ),
                    ),
                    array(
                        'type' =>'image',
                        'name' => 'image',
                        'label' => esc_html__( 'Image', 'passionate' ),
                    ),
                    array(
                        'type' =>'text',
                        'name' => 'description',
                        'label' => esc_html__( 'Description', 'passionate' ),
                    ),
	                array(
		                'type' =>'text',
		                'name' => 'link',
		                'label' => esc_html__( 'URL', 'passionate' ),
	                ),
                )
            ),

        );

        return $fields;
    }

    public function widget( $args, $instance ) {

        $sliders   = isset( $instance['dt_img_slider'] ) ? $instance['dt_img_slider'] : '';
        if ( $sliders ) {
	        echo $args['before_widget'];
	        ?>
            <div class="widget dt-image-slider">
                <div class="swiper-container">
                    <div class="swiper-wrapper">
				        <?php foreach ( $sliders as $slide ) :
					        $slide = wp_parse_args( $slide, array(
						        'title'       => '',
						        'image'       => '',
						        'description' => '',
					        ) );
					        $img = $this->get_image( $slide['image'] );
					        if ( $img ) {
						        ?>
                                <div class="swiper-slide">
                                    <div class="dt-image-slider-holder">
                                        <figure class="dt-slider-img">
                                            <a href="<?php echo isset($slide['link']) ? esc_url( $slide['link'] ) : '#'; ?>">
                                                <img src="<?php echo esc_url( $img ); ?>"
                                                     alt="<?php echo esc_attr( $slide['title'] ); ?>"/>
                                            </a>
									        <?php if ( $slide['title'] != '' ) : ?>
                                                <div class="dt-image-slider-desc">
                                                    <h2><?php echo esc_html( $slide['title'] ); ?></h2>
											        <?php if ( $slide['description'] != '' ) : ?>
                                                        <p><?php echo esc_html( $slide['description'] ); ?></p>
											        <?php endif; ?>
                                                </div><!-- .dt-image-slider-desc -->
									        <?php endif; ?>
                                        </figure><!-- .dt-featured-post-img -->
                                    </div><!-- .dt-image-slider-holder -->
                                </div><!-- .swiper-slide -->
						        <?php
					        }
				        endforeach; ?>

                    </div><!-- .swiper-wrapper -->

                    <!-- Add Arrows -->
                    <div class="swiper-button-next transition5"><i class="fa fa-angle-right"></i></div>
                    <div class="swiper-button-prev transition5"><i class="fa fa-angle-left"></i></div>
                </div><!-- .swiper-container -->
            </div>
	        <?php

	        echo $args['after_widget'];
        }

    }

}
