<?php
/**
 * Call to Action
 */
class passionate_call_to_action extends WP_Widget {

    public function __construct() {

        parent::__construct(
            'passionate_call_to_action',
            __( 'Passionate: Call to Action', 'passionate' ),
            array(
                'description'   => __( 'Show call to action button with link', 'passionate' )
            )
        );

    }

    public function widget( $args, $instance ) {

        $title          = isset( $instance['title'] ) ? $instance['title'] : '';
        $description    = isset( $instance['description'] ) ? $instance['description'] : '';
        $button         = isset( $instance['button'] ) ? $instance['button'] : '';
        $button_url     = isset( $instance['button-url'] ) ? $instance['button-url'] : 'Button';


        echo $args['before_widget'];
        ?>
        <div class="dt-call-to-action">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12 col-md-12">
                        <div class="dt-call-to-action-wrap">
                            <div class="dt-call-to-action-meta">
                                <?php if( ! empty ( $title ) ) : ?><h2><?php echo esc_html( $title ); ?></h2> <?php endif; ?>
                                <?php if( ! empty ( $description ) ) : ?><p><?php echo esc_html( $description ); ?></p><?php endif; ?>
                            </div><!-- .dt-call-to-action-meta -->

                            <div class="dt-call-to-action-btn">
                                <a href="<?php echo esc_url( $button_url ); ?>"><?php echo esc_html( $button ); ?></a>
                            </div><!-- .dt-call-to-action-btn -->

                            <div class="clearfix"></div>
                        </div><!-- .dt-call-to-action-wrap -->
                    </div><!-- .col-lg-12 .col-md-12 -->
                </div><!-- .row -->
            </div><!-- .container -->
        </div>
        <?php
        echo $args['after_widget'];
    }

    public function form( $instance ) {

        $instance = wp_parse_args(
            (array) $instance, array(
                'title'              => _x( 'Get a Special Discount', 'demo-content', 'passionate' ),
                'description'        => _x( 'Be a first customer to get special discount of 15% from Daisy Themes.', 'demo-content', 'passionate' ),
                'button'             => _x( 'Buy a Theme Now', 'demo-content', 'passionate' ),
                'button-url'         => _x( 'http://daisythemes.com/theme/passionate/', 'demo-content', 'passionate' ),
            )
        );

        ?>

        <div class="dt-admin-input-wrap">
            <label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title', 'passionate' ); ?></label>
            <input type="text" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo esc_attr( $instance['title'] ); ?>" placeholder="<?php _e( 'Title', 'passionate' ); ?>" >
        </div><!-- .dt-admin-input-wrap -->

        <div class="dt-admin-input-wrap">
            <label for="<?php echo $this->get_field_id( 'description' ); ?>"><?php _e( 'Description', 'passionate' ); ?></label>
            <textarea id="<?php echo $this->get_field_id( 'description' ); ?>" name="<?php echo $this->get_field_name( 'description' ); ?>" placeholder="<?php _e( 'Some Description ...', 'passionate' ); ?>" ><?php echo esc_html( $instance['description'] ); ?></textarea>
        </div><!-- .dt-admin-input-wrap -->

        <div class="dt-admin-input-wrap">
            <label for="<?php echo $this->get_field_id( 'button' ); ?>"><?php _e( 'Button Text', 'passionate' ); ?></label>
            <input type="text" id="<?php echo $this->get_field_id( 'button' ); ?>" name="<?php echo $this->get_field_name( 'button' ); ?>" value="<?php echo esc_attr( $instance['button'] ); ?>" placeholder="<?php _e( 'Button Text', 'passionate' ); ?>" >
        </div><!-- .dt-admin-input-wrap -->

        <div class="dt-admin-input-wrap">
            <label for="<?php echo $this->get_field_id( 'button-url' ); ?>"><?php _e( 'Button URL', 'passionate' ); ?></label>
            <input type="text" id="<?php echo $this->get_field_id( 'button-url' ); ?>" name="<?php echo $this->get_field_name( 'button-url' ); ?>" value="<?php echo esc_attr( $instance['button-url'] ); ?>" placeholder="<?php _e( 'Button URL', 'passionate' ); ?>" >
        </div><!-- .dt-admin-input-wrap -->

        <?php
    }

    public function update( $new_instance, $old_instance ) {

        $instance                   = $old_instance;
        $instance['title']        = esc_attr( $new_instance['title'] );
        $instance['description']  = esc_textarea( $new_instance['description'] );
        $instance['button']       = esc_attr( $new_instance['button'] );
        $instance['button-url']   = esc_url( $new_instance['button-url'] );
        return $instance;

    }

}