<?php
/**
 * Services
 */
class Passionate_Contact_Widget extends Widget_Ultimate_Widget_Base {

    public function __construct() {
        parent::__construct(
            'passionate_contact',
            __( 'Passionate: Contact', 'passionate' ),
            array(
                'description'   => __( 'Show contact info', 'passionate' )
            )
        );
    }

    function config( ){
       
            $limit = 2;
        
        $fields = array(
            array(
                'type' =>'text',
                'name' => 'title',
                'label' => esc_html__( 'Title', 'passionate' ),
                'default' => '',
            ),
            array(
                'type' =>'group',
                'name' => 'items',
                'label'    => esc_html__( 'Items', 'passionate' ),
                'title_id' => 'title',
                'limit' => $limit,
                'limit_msg' => esc_html__( 'Please Upgrade to Pro version to add unlimited items.', 'passionate' ),
                'default' => array(
                    array(
                        'title' => __( 'contact@example.com', 'passionate' ),
                        'icon'  => 'fa fa-envelope-o',
                    ),
                    array(
                        'title' => __( '0123-456-680', 'passionate' ),
                        'icon' => 'fa fa-phone',
                    ),
                ),
                'fields' => array(
                    array(
                        'type' =>'text',
                        'name' => 'title',
                        'label' => esc_html__( 'title', 'passionate' ),
                    ),
                    array(
                        'type' =>'icon',
                        'name' => 'icon',
                        'label' => esc_html__( 'Icon', 'passionate' ),
                    ),
                    array(
                        'type' =>'text',
                        'name' => 'link',
                        'label' => esc_html__( 'URL', 'passionate' ),
                    ),
                )
            )

        );

        return $fields;
    }

    public function widget( $args, $instance ) {
        $instance = $this->setup_default_values( $instance, $this->get_configs() );
        $instance = wp_parse_args( $instance, array(
            'title' => '',
            'items' => '',
        ) );

        $title             = $instance['title'];
        $items             = $instance['items'];

        echo $args['before_widget'];
        ?>
        <?php if ( $title ) { ?>
            <div class="dt-widget-meta">
                <?php if( ! empty( $title ) ) : ?><h2><?php echo esc_html( $title ); ?><span></span></h2><?php endif; ?>
            </div>
        <?php } ?>

        <div class="dt-contact-items-wrap">
            <?php foreach (( array )$items as $item) {
                $item = wp_parse_args($item, array(
                    'title' => '',
                    'icon' => '',
                    'url' => '',
                ));

                $icon =  '';
                if ( $item['icon'] ) {
                    $icon = '<i class="'.esc_attr( $item['icon'] ).'"></i> ';
                }

                if ( $item['title'] && $item['link'] ) {
                    echo '<a class="contact-item" href="'.esc_url( $item['link'] ).'">'.$icon.wp_kses_post( $item['title'] ).'</a>';
                } elseif ( $item['title'] ) {
                    echo '<span class="contact-item">'.$icon.wp_kses_post( $item['title'] ).'</span>';
                }
                ?>
            <?php } // loop items
            ?>
            <div class="clearfix"></div>
        </div>
        <?php
        echo $args['after_widget'];
    }

}
