<?php
/**
 * Custom functions that act independently of the theme templates.
 *
 * Eventually, some of the functionality here could be replaced by core features.
 *
 * @package Passionate
 */

function passionate_get_premium_url(){
	return 'https://www.famethemes.com/themes/passionate-pro/#download_pricing';
}

/**
 * Adds custom classes to the array of body classes.
 *
 * @param array $classes Classes for the body element.
 * @return array
 */
function passionate_body_classes( $classes ) {
	// Adds a class of group-blog to blogs with more than 1 published author.
	if ( is_multi_author() ) {
		$classes[] = 'group-blog';
	}

	// Adds a class of hfeed to non-singular pages.
	if ( ! is_singular() ) {
		$classes[] = 'hfeed';
	}

	return $classes;
}
add_filter( 'body_class', 'passionate_body_classes' );

if ( ! function_exists( 'passionate_get_layout' ) ) {
    function passionate_get_layout()
    {
        $layout = '';
        if (is_page()) {
            $layout = get_theme_mod('passionate_page_layout', 'right_sidebar');
        } else {
            $layout = get_theme_mod('passionate_single_page_layout', 'right_sidebar');
        }

        return apply_filters('passionate_get_site_layout', $layout);
    }
}
