<?php
/**
 * The template for displaying the footer.
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Passionate
 */

?>

	<footer class="dt-footer">
		<?php if ( is_active_sidebar( 'dt-footer1' ) || is_active_sidebar( 'dt-footer2' ) || is_active_sidebar( 'dt-footer3' ) || is_active_sidebar( 'dt-footer4' ) ) : ?>
                <div class="dt-footer-cont">
                    <div class="container">
                        <div class="row">
                        <?php if( is_active_sidebar( 'dt-footer1' ) ) : ?>

                            <div class="col-lg-3 col-md-3 col-sm-6 dt-sidebar">
                                <?php dynamic_sidebar( 'dt-footer1' ); ?>
                            </div><!-- .col-lg-3 -->

                        <?php endif; ?>

                        <?php if( is_active_sidebar( 'dt-footer2' ) ) : ?>
                            <div class="col-lg-3 col-md-3 col-sm-6 dt-sidebar">
                                <?php dynamic_sidebar( 'dt-footer2' ); ?>
                            </div><!-- .col-lg-3 -->
                        <?php endif; ?>

                        <?php if( is_active_sidebar( 'dt-footer3' ) ) : ?>
                            <div class="col-lg-3 col-md-3 col-sm-6 dt-sidebar">
                                <?php dynamic_sidebar( 'dt-footer3' ); ?>
                            </div><!-- .col-lg-3 -->
                        <?php endif; ?>

                        <?php if( is_active_sidebar( 'dt-footer4' ) ) : ?>

                        <div class="col-lg-3 col-md-3 col-sm-6 dt-sidebar">
                            <?php dynamic_sidebar( 'dt-footer4' ); ?>
                        </div><!-- .col-lg-3 -->
                        <?php endif; ?>
                        <div class="clearfix"></div>
                        </div>
                    </div>
                </div><!-- .dt-sidebar -->
		<?php endif; ?>
        <?php

        $copyright_default = sprintf( esc_html__( 'Copyright &copy; %1$s %2$s. All rights reserved.', 'passionate' ), date_i18n('Y'), '<a href="'.esc_url( home_url( '/' ) ).'" title="'. esc_attr( get_bloginfo( 'name', 'display' ) ).'">'.esc_attr( get_bloginfo( 'name', 'display' ) ).'</a>' );
        $credit_default =  sprintf( esc_html__( 'Designed by %1$s', 'passionate' ), '<a href="'.esc_url( 'https://www.famethemes.com/').'" target="_blank" rel="designer">FameThemes</a>' );
       
            $copyright = apply_filters( 'passionate_copyright', $copyright_default );
            $credit = apply_filters( 'passionate_credit', $credit_default );
        

        if ( ! $copyright ) {
            $copyright = $copyright_default;
        }

        if ( ! $credit ) {
            $credit = $credit_default;
        }

        if ( $copyright || $credit ) {
        ?>
        <div class="dt-footer-bar">
            <div class="row">
                <?php if ( $copyright ) { ?>
                <div class="col-lg-6 col-md-6">
                    <div class="dt-copyright">
                        <?php echo $copyright; ?>
                    </div><!-- .dt-copyright -->
                </div><!-- .col-lg-6 .col-md-6 -->
                <?php } ?>

                <?php if ( $credit ) { ?>
                <div class="col-lg-6 col-md-6">
                    <div class="dt-footer-designer">
                        <?php echo $credit; ?>
                    </div><!-- .dt-footer-designer -->
                </div><!-- .col-lg-6 .col-md-6 -->
                <?php } ?>

            </div><!-- .row -->
		</div><!-- .dt-footer-bar -->
        <?php } ?>

	</footer><!-- .dt-footer -->
</div><!-- .dt-body-wrap -->

<a id="back-to-top" class="transition35"><i class="fa fa-angle-up"></i></a><!-- #back-to-top -->

<?php wp_footer(); ?>

</body>
</html>
