<?php
function parallax_theme_options_init() {
	wp_enqueue_style( 'parallax-theme-options-style', get_template_directory_uri() . '/settings/options.css' );
}
add_action( 'admin_init', 'parallax_theme_options_init' );

global $parallax_options;
$settings = get_option( 'parallax_options', $parallax_options );
$shortname = "parallax";


$parallax_options = array(
	'parallax_favicon_url' => '',
	'parallax_feat_cat1' => '',
);


function parallax_validate_options( $input ) {
	global $parallax_options;	

	$settings = get_option( 'parallax_options', $parallax_options );
	
	if ( ! isset( $input['parallax_favicon_url'] ) )
	$input['parallax_favicon_url'] = null;
	$input['parallax_favicon_url'] = esc_url_raw( $input['parallax_favicon_url'] );

	return $input;
}


if ( is_admin() ) : 

//register settings and call sanitation functions
function parallax_register_settings() {
	register_setting( 'parallax_theme_options', 'parallax_options', 'parallax_validate_options' );
}
add_action( 'admin_init', 'parallax_register_settings' );

function parallax_theme_options() {
	add_theme_page('parallax'.__('Theme Options','parallax'), 'Parallax-effect '.__('Theme Options','parallax'), 'edit_theme_options', 'theme-options', 'parallax_theme_options_page' );
}
add_action( 'admin_menu', 'parallax_theme_options' );

//default options
function parallax_default_options() {
     global $parallax_options;
     $parallax_options_temp = $parallax_options;
     $options = get_option( 'parallax_options', $parallax_options );
	foreach ( $parallax_options as $parallax_option_key => $parallax_option_value ) {
		if ( isset($options[$parallax_option_key])) {
			$parallax_options[$parallax_option_key] = $options[$parallax_option_key];
		}
	}     
     update_option( 'parallax_options', $parallax_options );
}
add_action( 'init', 'parallax_default_options' );

//generate options page
function parallax_theme_options_page() {
	global $parallax_options;
	if ( ! isset( $_REQUEST['settings-updated'] ) )
		$_REQUEST['settings-updated'] = false;
	if( isset( $_REQUEST['action'])&&('reset' == $_REQUEST['action']) ) 
		delete_option( 'parallax_options' );
?>

	<div id="admin" class="wrap">

	
	
	<div class="options-form">
	
	
	<?php screen_icon(); echo "<h2>" . __( 'Theme Options' ,'parallax' ) . "</h2>"; ?>
	<?php if ( isset( $_REQUEST['action'])&&('reset' == $_REQUEST['action']) ) : ?>
	<div class="updated_status fade"><?php _e( 'Options reset successfully. Remember to save the default settings!','parallax' ); ?></div>
	<?php elseif ( $_REQUEST['settings-updated'] ) : ?>
	<div class="updated_status fade"><?php _e( 'Options saved successfully!','parallax' ); ?></div>
	<?php endif;?>
	
	<form method="post" action="options.php">

	<?php $settings = get_option( 'parallax_options', $parallax_options ); ?>	
	<?php settings_fields( 'parallax_theme_options' ); ?>
		
		
	<div class="field">
		<label><?php _e( 'Favicon URL','parallax' ); ?></label>
          	<input class="input" id="parallax_favicon_url" name="parallax_options[parallax_favicon_url]" type="text" value="<?php echo esc_url($settings['parallax_favicon_url']); ?>" />
		<span><?php _e( 'Enter full URL for favicon starting with <strong>http:// </strong>.','parallax' ); ?></span>
	</div>		
	
	<div class="field">
		<label><?php _e( 'Bottom Category','parallax' ); ?></label>
		<?php 
		$categories = get_categories( array( 'hide_empty' => 0, 'hierarchical' => 0 ) );  ?>
		<select id="parallax_feat_cat1" name="parallax_options[parallax_feat_cat1]">
		<option <?php selected( 0 == $settings['parallax_feat_cat1'] ); ?> value="0"><?php _e( '--none--', 'parallax' ); ?></option>
		<?php foreach( $categories as $category ) : ?>
			<option <?php selected( $category->term_id == $settings['parallax_feat_cat1'] ); ?> value="<?php echo $category->term_id; ?>"><?php echo $category->cat_name; ?></option>
		<?php endforeach; ?>
		</select>
			</div>
	
		<div class="field">
		<p><?php _e( 'Top blocks include sticky posts.', 'parallax' ); ?></p>
	</div>	
	
	
	
	<a href="https://twitter.com/wpmole" class="twitter-follow-button" data-show-count="false">Follow @wpmole</a>
<script>!function(d,s,id){var js,fjs=d.getElementsByTagName(s)[0],p=/^http:/.test(d.location)?'http':'https';if(!d.getElementById(id)){js=d.createElement(s);js.id=id;js.src=p+'://platform.twitter.com/widgets.js';fjs.parentNode.insertBefore(js,fjs);}}(document, 'script', 'twitter-wjs');</script> <a href="http://www.facebook.com/pages/WPMole/142454599181539" target="_blank"><img src="<?php echo get_template_directory_uri(); ?>/images/facebook.png" /></a>  <a href="http://wpmole.com" target="_blank">WPMole</a>
	
	</div> <!-- /greenpage_options -->
	<!---- /form fields ---->
	
	
<?php submit_button(); ?>
	</form>
	
	<form method="post">
		<p class="submit">
			<input class="button" name="reset" type="submit" value="Reset All Settings" />
			<input type="hidden" name="action" value="reset" />
		</p>
	</form>

	</div>

	<?php
}

endif;  // EndIf is_admin() ?>
