<?php
/**
 * palabras Theme Customizer
 *
 * @package palabras
 */

/**
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function palabras_customize_register( $wp_customize ) {
	$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';

	/*$choices = array("#e5e5e5" => __('Gray', 'palabras'),
					"#ecf0f1" => __('Clouds', 'palabras'),
					"#bdc3c7" => __('Silver', 'palabras'),
					"#1abc9c" => __('Turquoise', 'palabras'),
					"#16a085" => __('Green Sea', 'palabras'),
					"#2ecc71" => __('Emerald', 'palabras'),
					"#27ae60" => __('Nephritis', 'palabras'),
					"#3498db" => __('Peter River', 'palabras'),
					"#2980b9" => __('Belize Hole', 'palabras'),
					"#9b59b6" => __('Amethyst', 'palabras'),
					"#8e44ad" => __('Wisteria', 'palabras'),
					"#34495e" => __('Wet Asphalt', 'palabras'),
					"#2c3e50" => __('Midnight Blue', 'palabras'),
					"#f1c40f" => __('Sun Flower', 'palabras'),
					"#f39c12" => __('Orange', 'palabras'),
					"#e67e22" => __('Carrot', 'palabras'),
					"#d35400" => __('Pumpkin', 'palabras'),
					"#e74c3c" => __('Alizarin', 'palabras'),
					"#c0392b" => __('Pomegranate', 'palabras'),
					"#95a5a6" => __('Concrete', 'palabras'),
					"#7f8c8d" => __('Asbestos', 'palabras'),
					"#DEB887" => __('Burly Wood', 'palabras'),
					"#8B4513" => __('Saddle Brown', 'palabras'),
					"#9400D3" => __('Dark Violet', 'palabras'),
					"#FF00FF" => __('Fuchsia', 'palabras')
					);*/

    // Add color scheme setting and control.
	$wp_customize->add_setting( 'palabras_color_scheme', array(
		'default'           => '#2980b9',
		'type'           => 'theme_mod',
		'capability'     => 'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );
  
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'palabras_color_scheme', array(
		'settings' => 'palabras_color_scheme',
		'label'    => __( 'Color Schema: ', 'palabras' ),
		'section'  => 'colors',
		'priority' => 1,
	) ) );

	// Fonts
	  //___Fonts___//
    $wp_customize->add_section(
        'palabras_typography',
        array(
            'title' => __('Fonts', 'palabras' ),
            'priority' => 15,
        )
    );
  $font_choices = 
    array(
     'Arimo:400,700,400italic,700italic' => 'Arimo',
        'Arvo:400,700,400italic,700italic' => 'Arvo',
        'Abel' => 'Abel',

        'Cabin:400,700' => 'Cabin',
        'Cuprum:400,400italic,700' => 'Cuprum',

        'Bitter:400,700,400italic' => 'Bitter',
        'Bree+Serif' => 'Bree Serif',

        'Dancing+Script:400,700' => 'Dancing Script',
        'Droid Sans:400,700' => 'Droid Sans',
        'Droid Serif:400,700,400italic,700italic' => 'Droid Serif',
        'Dosis:300,400,700' => 'Dosis',
      
        'Fira Sans:400,700,400italic,700italic' => 'Fira Sans',

        'Indie+Flower' => 'Indie Flower',
        'Inconsolata:400,700' => 'Inconsolata',

        'Josefin+Sans:400,700' => 'Josefin Sans',

        'Fjalla+One' => 'Fjalla One',

        'Karla:700,400,400italic' => 'Karla',

        'Lato:400,700,400italic,700italic' => 'Lato',
        'Lora:400,700,400italic,700italic' => 'Lora',
        'Lobster' => 'Lobster',
        'Libre+Baskerville:400,700,400italic' => 'Libre Baskerville',

        'Maven+Pro:400,700' => 'Maven Pro',
        'Merriweather:900,700' => 'Merriweather',
        'Montserrat:400,700' => 'Montserrat',
        'Muli:400,400italic' => 'Muli',

        'Noto+Sans:400,700,400italic,700italic' => 'Noto Sanas',
        'Nunito:400,300,700' => 'Nunito',
        
        'Open+Sans:400italic,700italic,400,700' => 'Open Sans',
        'Oswald:400,700' => 'Oswald',
        'Open Sans Condensed:700,300italic,300' => 'Open Sans Condensed',
        'Oxygen:400,300,700' => 'Oxygen',
        
        'Pacifico' => 'Pacifico',
        'Play:400,700' => 'Play',
        'PT Sans:400,700,400italic,700italic' => 'PT Sans',
        'PT+Sans+Narrow:400,700' => 'PT Sans Narrow',
        'Playfair+Display:400,700' => 'Playfair Display',
        'Poiret+One' => 'Poiret One',

        'Raleway:400,700' => 'Raleway',
        'Roboto:400,400italic,700,700italic' => 'Roboto',
        'Roboto Condensed:400italic,700italic,400,700' => 'Roboto Condensed',
        'Roboto Slab:400,700' => 'Roboto Slab',
        'Rokkitt:400' => 'Rokkitt',

        'Source Sans Pro:400,700,400italic,700italic' => 'Source Sans Pro',
        'Slabo+27px;' => 'Slabo',
        'Shadows+Into+Light' => 'Shadows Into Light',
        'Signika:700,400' => 'Signika',

        'Titillium+Web:400,300,400italic,700' => 'Titillium Web',

        'Ubuntu:400,700,400italic,700italic' => 'Ubuntu',
        'Ubuntu Condensed' => 'Ubuntu',

        'Vollkorn:400italic,400,700' => 'Vollkorn',

        'Yanone Kaffeesatz:400,700' => 'Yanone Kaffeesatz',
    );
  
  $wp_customize->add_setting(
    'palabras_headings_fonts',
    array(
      'sanitize_callback' => 'palabras_sanitize_fonts',
    )
  );
  
  $wp_customize->add_control(
    'palabras_headings_fonts',
    array(
      'type' => 'select',
      'priority'    => 9,
      'label' => __('Select your desired font for the heading.', 'palabras'),
      'section' => 'palabras_typography',
      'choices' => $font_choices
    )
  );
  
  $wp_customize->add_setting(
    'palabras_body_fonts',
    array(
      'sanitize_callback' => 'palabras_sanitize_fonts',
    )
  );
  
  $wp_customize->add_control(
    'palabras_body_fonts',
    array(
      'type' => 'select',
      'priority'    => 10,
      'label' => __('Select your desired font for the body.', 'palabras'),
      'section' => 'palabras_typography',
      'choices' => $font_choices
    )
  );

	// Columns //
    $wp_customize->add_section(
        'palabras_columns',
        array(
            'title' => __('Columns', 'palabras' ),
            'priority' => 1,
        )
    );

  $column_choices = array('1' => '1',
						'2' => '2',
						'3' => '3',
						'4' => '4');
  
  $wp_customize->add_setting(
    'palabras_columns_number',
    array(
	  'default' => 0,
      'sanitize_callback' => 'esc_attr',
    )
  );
  
  $wp_customize->add_control(
    'palabras_columns_number',
    array(
      'type' => 'select',
      'priority'    => 1,
      'label' => __('Select the number of columns.', 'palabras'),
      'section' => 'palabras_columns',
      'choices' => $column_choices,
    )
	);

}
add_action( 'customize_register', 'palabras_customize_register' );

function palabras_sanitize_fonts( $input ) {
    $valid = array(
      'Arimo:400,700,400italic,700italic' => 'Arimo',
        'Arvo:400,700,400italic,700italic' => 'Arvo',
        'Abel' => 'Abel',

        'Cabin:400,700' => 'Cabin',
        'Cuprum:400,400italic,700' => 'Cuprum',

        'Bitter:400,700,400italic' => 'Bitter',
        'Bree+Serif' => 'Bree Serif',

        'Dancing+Script:400,700' => 'Dancing Script',
        'Droid Sans:400,700' => 'Droid Sans',
        'Droid Serif:400,700,400italic,700italic' => 'Droid Serif',
        'Dosis:300,400,700' => 'Dosis',
      
        'Fira Sans:400,700,400italic,700italic' => 'Fira Sans',

        'Indie+Flower' => 'Indie Flower',
        'Inconsolata:400,700' => 'Inconsolata',

        'Josefin+Sans:400,700' => 'Josefin Sans',

        'Fjalla+One' => 'Fjalla One',

        'Karla:700,400,400italic' => 'Karla',

        'Lato:400,700,400italic,700italic' => 'Lato',
        'Lora:400,700,400italic,700italic' => 'Lora',
        'Lobster' => 'Lobster',
        'Libre+Baskerville:400,700,400italic' => 'Libre Baskerville',

        'Maven+Pro:400,700' => 'Maven Pro',
        'Merriweather:900,700' => 'Merriweather',
        'Montserrat:400,700' => 'Montserrat',
        'Muli:400,400italic' => 'Muli',

        'Noto+Sans:400,700,400italic,700italic' => 'Noto Sanas',
        'Nunito:400,300,700' => 'Nunito',
        
        'Open+Sans:400italic,700italic,400,700' => 'Open Sans',
        'Oswald:400,700' => 'Oswald',
        'Open Sans Condensed:700,300italic,300' => 'Open Sans Condensed',
        'Oxygen:400,300,700' => 'Oxygen',
        
        'Pacifico' => 'Pacifico',
        'Play:400,700' => 'Play',
        'PT Sans:400,700,400italic,700italic' => 'PT Sans',
        'PT+Sans+Narrow:400,700' => 'PT Sans Narrow',
        'Playfair+Display:400,700' => 'Playfair Display',
        'Poiret+One' => 'Poiret One',

        'Raleway:400,700' => 'Raleway',
        'Roboto:400,400italic,700,700italic' => 'Roboto',
        'Roboto Condensed:400italic,700italic,400,700' => 'Roboto Condensed',
        'Roboto Slab:400,700' => 'Roboto Slab',
        'Rokkitt:400' => 'Rokkitt',

        'Source Sans Pro:400,700,400italic,700italic' => 'Source Sans Pro',
        'Slabo+27px;' => 'Slabo',
        'Shadows+Into+Light' => 'Shadows Into Light',
        'Signika:700,400' => 'Signika',

        'Titillium+Web:400,300,400italic,700' => 'Titillium Web',

        'Ubuntu:400,700,400italic,700italic' => 'Ubuntu',
        'Ubuntu+Condensed' => 'Ubuntu',

        'Vollkorn:400italic,400,700' => 'Vollkorn',

        'Yanone Kaffeesatz:400,700' => 'Yanone Kaffeesatz',
    );
 
    if ( array_key_exists( $input, $valid ) ) {
        return $input;
    } else {
        return '';
    }
}

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function palabras_customize_preview_js() {
	wp_enqueue_script( 'palabras_customizer', get_template_directory_uri() . '/js/customizer.js', array( 'customize-preview' ), '20130508', true );
}
add_action( 'customize_preview_init', 'palabras_customize_preview_js' );

function palabras_print_color_schemas(){

$color_schema = get_theme_mod("palabras_color_scheme", "#2980b9");
$headings_font = esc_html(get_theme_mod('palabras_headings_fonts'));
$body_font = esc_html(get_theme_mod('palabras_body_fonts'));
$headings_font = explode(":", $headings_font);
$body_font = explode(":", $body_font);
$background_color = "#" . esc_attr(get_background_color());

	echo "<style>
		body{
			font-family: $body_font[0];}
		#top-bar, #content, #menu-principal li{
			background: $background_color;}
		}
		a {
			color: $color_schema;
			text-decoration: none;}
		a:visited {
			color: $color_schema;}
		pre {
			background: $color_schema;}
		input[type='submit'] {
			border-color: #ccc #ccc #bbb;
			background: $color_schema;}
		@media(min-width:768px){
			#menu-principal ul ul{
				border-bottom:4px solid $color_schema;}
			#menu-principal ul ul li{
				border-left:2px solid $color_schema;}
		}
		.widget-title{
			background-color: $color_schema;}
		#masthead{
			border-bottom: 1px solid $color_schema;
			font-family: $headings_font[0];}
		#cosa{
			background-color: $color_schema;}
		article, section, .navigation, #comments{
			border-bottom: 1px solid $color_schema;}
		.widget-title{
			background-color: $color_schema;
			color: white;}
		#up_buttom{
			background-color: $color_schema;}
		.entry-footer-index, .entry-footer{
			background-color: $color_schema;
		}
		</style>";
}
add_action( 'wp_head', 'palabras_print_color_schemas');