<?php
/**
 * The header for our theme.
 *
 * Displays all of the <head> section and everything up till <div id="content">
 *
 * @package palabras
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="profile" href="http://gmpg.org/xfn/11">
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">

<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

<div id="cosa">
<?php if ( get_header_image() ) : ?>
	<a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home">
		<img id="header-image" src="<?php header_image(); ?>" width="<?php echo esc_attr( get_custom_header()->width ); ?>" alt="<?php bloginfo( 'name' ); ?>">
	</a>
<?php endif; // End header image check. ?>
</div>

<div id="page" class="hfeed site">
	<a class="skip-link screen-reader-text" href="#content"><?php _e( 'Skip to content', 'palabras' ); ?></a>

	<header id="masthead" class="site-header" role="banner">
		<div class="site-branding">
			<h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
			<h2 class="site-description"><?php bloginfo( 'description' ); ?></h2>
		</div><!-- .site-branding -->

		<div id="top-bar">

		<div id="top-icon-left">
		<a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><i class="icon ion-home"></i></a>
		</div>		

		<nav id="site-navigation" class="main-navigation" role="navigation">
			<div id="open-menu"><a href="#"><i class="icon ion-navicon-round"></i></a></div><!--Responsive Menu Link-->
			<?php			
			if(has_nav_menu('primary')){
				wp_nav_menu(array( 'theme_location' => 'primary', 'container' => 'nav', 'container_class' => false, 'container_id' => 'menu-principal', 'fallback_cb' => false)); 
			}else{
				echo "<nav><div id='menu-principal'>";
				wp_nav_menu();
				echo "</div></nav>";
			}
			?>
		</nav><!-- #site-navigation -->
		
		<div id="top-icon-right">
		<a href="#" id="open-search"><i class="icon ion-search"></i></a>
		</div>

		</div><!-- #top-bar -->

		<?php get_search_form() ?>
		

	</header><!-- #masthead -->

<!-- Up buttom when scrolled --> 
<div id="up_buttom">
    <a href="#"><i class="icon ion-chevron-up"></i></a>
</div>

	<div id="content" class="site-content">
