<?php
/**
 * @package palabras
 */
global $palabras_columns;
if(!$palabras_columns){
	$post_class = "post-alternative-1";
}else{
	$post_class = "post-alternative-";
	$post_class = $post_class . $palabras_columns;
}
?>

<article id="post-<?php the_ID(); ?>" <?php post_class("$post_class"); ?>>
	<header class="entry-header-index">
		<?php the_title( sprintf( '<h1 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h1>' ); ?>

		<?php if ( 'post' == get_post_type() ) : ?>
		<div class="entry-meta">
			<?php palabras_posted_on(); ?>
		</div><!-- .entry-meta -->
		<?php endif; ?>
	</header><!-- .entry-header -->

	<div class="entry-content-index">
		<?php
			if($palabras_columns> 1){

				the_excerpt();
				palabras_keep_reading();

			}else{

				/* translators: %s: Name of current post */
				the_content( sprintf(
					__( 'Continue reading %s <span class="meta-nav">&rarr;</span>', 'palabras' ),
					the_title( '<span class="screen-reader-text">"', '"</span>', false )
				) );

			}
		?>

		<?php
			wp_link_pages( array(
				'before' => '<div class="page-links">' . __( 'Pages:', 'palabras' ),
				'after'  => '</div>',
			) );
		?>
	</div><!-- .entry-content -->

	<footer class="entry-footer-index">
		<?php palabras_entry_footer(); ?>
	</footer><!-- .entry-footer -->
</article><!-- #post-## -->