<?php

// Custom control for carousel category
 
if (class_exists('WP_Customize_Control')) {
    class pakwall_Customize_Category_Control extends WP_Customize_Control {
 
        public function render_content() {
   
            $dropdown = wp_dropdown_categories( 
                array(
                    'name'              => '_customize-dropdown-category-' . $this->id,
                    'echo'              => 0,
                    'show_option_none'  => __( '&mdash; Select &mdash;', 'pakwall' ),
                    'option_none_value' => '0',
                    'selected'          => $this->value(),
                    
                )
            );
 
            $dropdown = str_replace( '<select', '<select ' . $this->get_link(), $dropdown );
  
            printf(
                '<label class="customize-control-select"><span class="customize-control-title">%s</span> %s</label>',
                $this->label,
                $dropdown
            );
        }
    }
}
 
// Register slider customizer section 
 
add_action( 'customize_register' , 'pakwall_carousel_options' );
 
function pakwall_carousel_options( $wp_customize ) {

/*  HomePage Setting Panel*/

$wp_customize->add_panel( 'homepage_panel', array(
    'priority'       => 50,
    'capability'     => 'edit_theme_options',
    'theme_supports' => '',
    'title'          => __('Custom HomePage Settings', 'pakwall'),
    'description'    => __('Customize HomePage Sections', 'pakwall'),
) );

/* HomePage Setting Panel */
 
$wp_customize->add_section(
    'carousel_section',
    array(
		'title'    => __( 'Carousel Settings', 'pakwall' ),
        'capability'  => 'edit_theme_options',
        'panel'  => 'homepage_panel',
    )
);
 
/* End HomePage Setting Panel */

/*Carousel Slider Setting Start*/

$wp_customize->add_setting(
    'carousel_setting',
     array(
    'default'   => '1',
	'sanitize_callback' => 'sanitize_text_field',
    'panel'  => 'homepage_panel',
  )
);
 
$wp_customize->add_control(
    new pakwall_Customize_Category_Control(
        $wp_customize,
        'carousel_category',
        array(
			'label'          => __( 'Category', 'pakwall' ),
            'settings' => 'carousel_setting',
            'section'  => 'carousel_section'
        )
    )
);
 
$wp_customize->add_setting(
    'count_setting',
     array(
    'default'   => '4',
	'sanitize_callback' => 'sanitize_text_field',
 
  )
);
 
$wp_customize->add_control(
    new WP_Customize_Control(
        $wp_customize,
        'carousel_count',
        array(
            'label'          => __( 'Number of posts', 'pakwall' ),
            'section'        => 'carousel_section',
            'settings'       => 'count_setting',
            'type'           => 'text',
        )
    )
);
 
/* --------------------------- END Carousel Slider Setting Start -------------------------*/

/* Start Shope Now Section */

    $wp_customize->add_section( 'Welcome_section', array(
        'title'       => __( 'Shop Now Section', 'pakwall' ),
        'description' => 'This section will appear below the slider. ',
        'panel'  => 'homepage_panel',
    ) );

    /*Welcome Display Option*/

        $wp_customize->add_setting( 
            'welcome_display_option',
            array(
            'default' => true,
            'sanitize_callback' => 'pakwall_sanitize_checkbox',
            'panel'  => 'homepage_panel',
        ) );

        $wp_customize->add_control( 'welcome_display_option', array(
            'type' => 'checkbox',
            'label' => __('Display Shop Now Section','pakwall'),
            'section' => 'Welcome_section',
        ) );

    /*Welcome Heading*/

        $wp_customize->add_setting( 'Welcome_message_heading', array(
            'default' => 'Wanna Buy Somethings ?',
            'sanitize_callback' => 'sanitize_text_field',
            'panel'  => 'homepage_panel',
        ) );
        $wp_customize->add_control( 'welcome_heading_control', array(
            'label'    => __( 'Title ', 'pakwall' ),
            'section'  => 'Welcome_section',
            'settings' => 'Welcome_message_heading' 
        ) );

    /*Welcome Description*/

        $wp_customize->add_setting( 'Welcome_message_description', array(
            'default' => 'Lets Do This',
            'sanitize_callback' => 'sanitize_text_field',
            'panel'  => 'homepage_panel',
        ) );
        $wp_customize->add_control( 'welcome_description_control', array(
            'label'    => __( 'Description ', 'pakwall' ),
            'section'  => 'Welcome_section',
            'settings' => 'Welcome_message_description' 
    ) );

/* Second Section Button Description */

        $wp_customize->add_setting( 'second_section_button_description', array(
            'default' => 'Go Shopping',
            'sanitize_callback' => 'sanitize_text_field',
            'panel'  => 'homepage_panel',
        ) );
        $wp_customize->add_control( 'second_section_button_description', array(
            'label'    => __( 'Button Description: ', 'pakwall' ),
            'section'  => 'Welcome_section',
            'settings' => 'second_section_button_description'    
        ) );    

    // Second Section Button link
        $wp_customize->add_setting('second_section_button_link', array(
            'sanitize_callback' => 'esc_url_raw',
            'panel'  => 'homepage_panel',
            'default' => '#',
        ) );
        $wp_customize->add_control('second_section_button_link', array(
            'label' => __('Button Link URL','pakwall'),
            'section' => 'Welcome_section',
            'type' => 'text',
        ) );

    /* Welcome Section Image Upload */
        $wp_customize->add_setting( 
            'welcome_section_image', array(
            'sanitize_callback' => 'pakwall_sanitize_image',
        ) );

        $wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 
            'welcome_section_image', array(
            'label'    => __( 'Choose Background Image', 'pakwall' ),
            'section'  => 'Welcome_section',
            'settings' => 'welcome_section_image',) 
        ) );

/* ---------------- END Shope Now Section ----------------------- */

/* Start Show Latest Products */

$wp_customize->add_section( 'product_section', array(
        'title'       => __( 'Products Section', 'pakwall' ),
        'description' => 'Show Your Latest Products ',
        'panel'  => 'homepage_panel',
    ) );

$wp_customize->add_setting( 
            'product_section_option',
            array(
            'default' => 8,
            'sanitize_callback' => 'absint',
            'panel'  => 'homepage_panel',
        ) );

        $wp_customize->add_control( 'product_section_option', array(
            'type' => 'number',
            'label' => __('Number Of Latest Products To Show','pakwall'),
            'section' => 'product_section',
        ) );

/* --------------------- END Start Show Latest Products --------------- */

}

?>