<?php
/**
 * Template part for displaying Grid Post Layout
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package pagli
 */

?>
<article id="post-<?php the_ID(); ?>" <?php post_class('grid-blog'); ?>>

	<?php if( has_post_thumbnail()) : ?>
		<?php
			$img = wp_get_attachment_image_src( get_post_thumbnail_id(), 'medium' );
		?>
		<a class="blog-post-thumbnail" href="<?php the_permalink(); ?>">
			<figure>
				<img src="<?php echo esc_url($img[0]); ?>">
			</figure>
		</a>
	<?php endif; ?>

	<header class="entry-header">
		<?php
			$categories_list = get_the_category_list( esc_html__( ', ', 'pagli' ) );
		?>
		<div class="blog-categories">
			<?php echo $categories_list; ?>
		</div>

		<?php
		if ( is_single() ) :
			the_title( '<h1 class="entry-title">', '</h1>' );
		else :
			the_title( '<h3 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h3>' );
		endif;
		?>
	</header><!-- .entry-header -->

	<div class="entry-content">
		<?php the_excerpt(); ?>
	</div><!-- .entry-content -->

	<footer class="entry-footer">
		<?php
		if ( 'post' === get_post_type() ) : ?>
		<div class="entry-meta">
			<i class="fa fa-calendar-o"></i><?php pagli_posted_on(); ?>
		</div><!-- .entry-meta -->
		<?php
		endif; ?>
	</footer><!-- .entry-footer -->
</article><!-- #post-## -->
