<?php
/**
 * Template part for displaying Fullwidth Post Layout
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package pagli
 */

?>
<article id="post-<?php the_ID(); ?>" <?php post_class('fullwidth-blog clearfix'); ?>>
	<header class="entry-header">
		<?php
			$categories_list = get_the_category_list( esc_html__( ', ', 'pagli' ) );
		?>
		<div class="blog-categories">
			<?php echo $categories_list; ?>
		</div>

		<?php the_title( '<h3 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h3>' ); ?>

		<?php if ( 'post' === get_post_type() ) : ?>
		<div class="entry-meta">
			<i class="fa fa-calendar-o"></i><?php pagli_posted_on(); ?>
		</div><!-- .entry-meta -->
		<?php
		endif; ?>
	</header><!-- .entry-header -->

	<?php if( has_post_thumbnail()) : ?>
		<?php
			$img = wp_get_attachment_image_src( get_post_thumbnail_id(), 'full' );
		?>
		<div class="blog-post-thumbnail">
			<img src="<?php echo esc_url($img[0]); ?>">
		</div>
	<?php endif; ?>

	<div class="entry-content">
		<?php the_excerpt(); ?>
		<a class="read-more" href="<?php the_permalink(); ?>"><?php esc_html_e( 'CONTINUE READING' , 'pagli' ); ?></a>
	</div><!-- .entry-content -->

	<footer class="entry-footer">
		<div class="comment-count">
			<?php comments_number(); ?>
		</div>
		<div class="by-author">
			<?php
				$byline = sprintf(
					esc_html_x( 'by %s', 'post author', 'pagli' ),
					'<span class="author vcard"><a class="url fn n" href="' . esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ) . '">' . esc_html( get_the_author() ) . '</a></span>'
				);
				echo $byline;
			?>
		</div>
	</footer><!-- .entry-footer -->
</article><!-- #post-## -->