<?php
	/** Woocommerce Tweaks **/
	// Change number or products per row to 3
	add_filter('loop_shop_columns', 'pagli_loop_shop_columns');
	if (!function_exists('pagli_loop_shop_columns')) {
		function pagli_loop_shop_columns() {
			return 3; // 3 products per row
		}
	}
	
	add_action( 'body_class', 'pagli_woo_body_class');
	if (!function_exists('pagli_woo_body_class')) {
	   function pagli_woo_body_class( $class ) {
	          $class[] = 'columns-'.pagli_loop_shop_columns();
	          return $class;
	   }
	}

	add_filter( 'woocommerce_output_related_products_args', 'pagli_related_products_args' );
  	function pagli_related_products_args( $args ) {
		$args['posts_per_page'] = 3; // 4 related products
		$args['columns'] = 3; // arranged in 2 columns
		return $args;
	}