<?php
	/*
	*
	* * * * Pagli Custom Functions * * * 
	*
	*/

	/**
	 * Filter the except length to 20 words.
	 *
	 * @param int $length Excerpt length.
	 * @return int (Maybe) modified excerpt length.
	 */
	function pagli_custom_excerpt_length( $length ) {
		$excerpt_length = get_theme_mod('pagli_blog_excerpt_length', 40);
	    return 40;
	}
	add_filter( 'excerpt_length', 'pagli_custom_excerpt_length', 999 );

	/**
	 * Filter the excerpt "read more" string.
	 *
	 * @param string $more "Read more" excerpt string.
	 * @return string (Maybe) modified "read more" excerpt string.
	 */
	function pagli_excerpt_more( $more ) {
	    return '';
	}
	add_filter( 'excerpt_more', 'pagli_excerpt_more' );