<?php
	/** Home Page Header  **/
	if(!function_exists('pagli_header')) {
		function pagli_header_callback() {
			$header_img = (get_header_image() != '') ? get_header_image() : get_template_directory_uri().'/assets/images/banner.jpg';
			$header_vid = get_header_video_url();
			$fixed_header = get_theme_mod('header_nature', '');
			$fixed_header = !empty($fixed_header) ? 'fixed-header' : '';
			$style = '';
			if(has_header_video())  {
				$style = '';
			} elseif($header_img != '') {
				$style = 'style="background-image: url(\''.esc_url($header_img).'\');"';
			}

			?>
			<header id="masthead" class="site-header" role="banner" <?php echo $style; ?>>
				<?php if(has_header_video()) : ?>
					<div class="video-background">
						<div class="video-foreground">
							<?php
								echo $embed_code = wp_oembed_get( $header_vid );
							?>
						</div>
					</div>
				<?php endif; ?>

				<div class="pagli-container">
					<div class="banner-text">
						<?php
							$banner_title = get_theme_mod('header_banner_title', esc_html__('Welcome to <span>Pagli</span>', 'pagli'));
							$banner_subtitle = get_theme_mod('header_banner_subtitle', esc_html__('Lorem ipsum dolor sit amet.', 'pagli'));
							$prime_btn_text = get_theme_mod('header_primary_btn_text', esc_html__('View Details', 'pagli'));
							$prime_btn_url = get_theme_mod('header_primary_btn_url', home_url() );
							$second_btn_text = get_theme_mod('header_secondary_btn_text', esc_html__('Buy Now', 'pagli'));
							$second_btn_url = get_theme_mod('header_secondary_btn_url', home_url() );
						?>
						<h1 class="banner-title"><?php echo wp_kses_post($banner_title); ?></h1>
						<h2 class="banner-subtitle"><?php echo esc_html($banner_subtitle); ?></h2>
						<div class="btn-wrapper">
							<?php if($prime_btn_text != '') : ?>
								<a class="primary-btn btn" href="<?php echo esc_url($prime_btn_url); ?>">
									<?php echo esc_html($prime_btn_text); ?>
								</a>
							<?php endif; ?>

							<?php if($second_btn_text != '') : ?>
								<a class="secondary-btn btn" href="<?php echo esc_url($second_btn_url); ?>">
									<?php echo esc_html($second_btn_text); ?>
								</a>
							<?php endif; ?>
						</div>
					</div>
				</div> <!-- .pagli-container -->
			</header><!-- #masthead -->

			<div class="nav-logo-wrapper clearfix home <?php echo $fixed_header; ?>">
				<div class="pagli-container">
					<div class="site-branding">
						<?php
							$custom_logo_id = get_theme_mod( 'custom_logo' );
							$custom_logo = wp_get_attachment_image_src( $custom_logo_id , 'full' );
							$description = get_bloginfo( 'description', 'display' );
						?>

						<?php if($custom_logo) : ?>
							<a href="<?php echo esc_url( home_url( '/' ) ); ?>">
								<img src="<?php echo esc_url($custom_logo[0]); ?>">
							</a>
						<?php else : ?>
							<h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
							<p class="site-description"><?php echo wp_kses_post($description); /* WPCS: xss ok. */ ?></p>
						<?php endif; ?>
					</div><!-- .site-branding -->

					<nav id="site-navigation" class="main-navigation" role="navigation">
						<?php wp_nav_menu( array( 'theme_location' => 'menu-1', 'menu_id' => 'primary-menu' ) ); ?>
					</nav><!-- #site-navigation -->
					
				</div>
			</div>
			<?php
		}
	} 
	add_action('pagli_home_header', 'pagli_header_callback');

	/** Inner Page Header **/
	if(!function_exists('pagli_inner_header_callback')) {

		function pagli_inner_header_callback() {
			$header_img = (get_header_image() != '') ? get_header_image() : '';
			$style = '';
			if($header_img != '') {
				$style = 'style="background-image: url(\''.esc_url($header_img).'\');"';
			}
			?>
			<div class="nav-logo-wrapper clearfix">
				<div class="pagli-container">
					<div class="site-branding">
						<?php
							$custom_logo_id = get_theme_mod( 'custom_logo' );
							$custom_logo = wp_get_attachment_image_src( $custom_logo_id , 'full' );
							$description = get_bloginfo( 'description', 'display' );
						?>

						<?php if($custom_logo) : ?>
							<a href="<?php echo esc_url( home_url( '/' ) ); ?>">
								<img src="<?php echo esc_url($custom_logo[0]); ?>">
							</a>
						<?php else : ?>
							<h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
							<p class="site-description"><?php echo wp_kses_post($description); /* WPCS: xss ok. */ ?></p>
						<?php endif; ?>
					</div><!-- .site-branding -->

					<nav id="site-navigation" class="main-navigation" role="navigation">
						<?php wp_nav_menu( array( 'theme_location' => 'menu-1', 'menu_id' => 'primary-menu' ) ); ?>
					</nav><!-- #site-navigation -->
				</div>
			</div>

			<?php if(!is_home()) : ?>
				<header id="masthead" class="inner-site-header" role="banner" <?php echo $style; ?>>
					<div class="header-overlay"></div>
					<div class="pagli-container">
						<?php if(is_page() || is_single()) : ?>
							<?php the_title( '<h1 class="page-title">', '</h1>' ); ?>
						<?php elseif(is_404()) : ?>
							<h1 class="page-title"><?php echo esc_html_e('404 Error', 'pagli'); ?></h1>
						<?php elseif(is_archive()) : ?>
							<?php the_archive_title( '<h1 class="page-title">', '</h1>' ); ?>
						<?php endif; ?>
					</div> <!-- .pagli-container -->
				</header><!-- #masthead -->
			<?php endif; ?>
			<?php
		}

	}
	add_action('pagli_inner_header', 'pagli_inner_header_callback');