<?php
/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package pagli
 */

get_header(); ?>

	<div id="primary" class="content-area">
		<main id="main" class="site-main" role="main">

		<?php
		if ( have_posts() ) :
			?>
			<div class="blog-allpost-wrapper clearfix">
				<?php
				$pagli_blog_layout = get_theme_mod( 'pagli_blog_layout', 'grid' );
				$pagli_flag = true;
				/* Start the Loop */
				while ( have_posts() ) : the_post();

					switch($pagli_blog_layout){
						case 'grid' :
						case 'fullwidth' :
							get_template_part( 'template-parts/content', $pagli_blog_layout );
							break;

						case 'grid_with_fullwidth_block' :
							if($pagli_flag) {
								get_template_part( 'template-parts/content', 'fullwidth' );
							} else {
								get_template_part( 'template-parts/content', 'grid' );
							}
							break;

					}
					$pagli_flag = false;

				endwhile;
				?>
			</div>
			<?php
			the_posts_pagination();
		else :

			get_template_part( 'template-parts/content', 'none' );

		endif; ?>

		</main><!-- #main -->
	</div><!-- #primary -->

<?php
get_sidebar();
get_footer();
