<?php
/**
 * pagli Theme Customizer
 *
 * @package pagli
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function pagli_customize_register( $wp_customize ) {
	$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';

	/** Custom Customizer Options **/

	/**
	 * Header Settings
	 */
	//Header Panel
	$wp_customize->add_panel( 'pagli_header_panel' , array(
        'priority' => 15,
        'title' => esc_html__( 'Header Settings', 'pagli' ),
        'description' => esc_html__( 'Configure Header Settings', 'pagli' ),
    ));

	/** Shifting default sections to Header Setting Panel **/
    $wp_customize->remove_section( 'title_tagline' );
    $wp_customize->add_section( 'title_tagline' , array(
		'title' => esc_html__( 'Site Identity' , 'pagli'),
		'panel' => 'pagli_header_panel',
	) );

	/** Header General Settings **/
	$wp_customize->add_section( 'header_general_settings' , array(
		'title' => esc_html__( 'General Settings' , 'pagli'),
		'panel' => 'pagli_header_panel',
	) );

	/** Fixed Header **/
	$wp_customize->add_setting( 'header_nature' , array(
	    'default'     => '',
	    'sanitize_callback' => 'sanitize_text_field',
	) );

	$wp_customize->add_control( 'header_nature', array(
	    'settings' => 'header_nature',
	    'label'    => esc_html__( 'Fixed Header' , 'pagli' ),
	    'section'  => 'header_general_settings',
	    'type'     => 'checkbox',
	) );

	// Header Banner Title
	$wp_customize->add_setting( 'header_banner_title' , array(
	    'default'     => esc_html__('Welcome to <span>Pagli</span>', 'pagli'),
	    'sanitize_callback' => 'wp_kses_post',
	    'transport'   => 'postMessage',
	) );

	$wp_customize->add_control(
		'header_banner_title', 
		array(
			'label'    => esc_html__( 'Header Banner Title', 'pagli' ),
			'section'  => 'header_image',
			'settings' => 'header_banner_title',
			'type'     => 'text',
		)
	);

	// Header Banner Sub Title
	$wp_customize->add_setting( 'header_banner_subtitle' , array(
	    'default'     => esc_html__('Lorem ipsum dolor sit amet.', 'pagli'),
	    'sanitize_callback' => 'sanitize_text_field',
	    'transport'   => 'postMessage',
	) );

	$wp_customize->add_control(
		'header_banner_subtitle', 
		array(
			'label'    => esc_html__( 'Header Banner Sub Title', 'pagli' ),
			'section'  => 'header_image',
			'settings' => 'header_banner_subtitle',
			'type'     => 'textarea',
		)
	);

	// Header Primary Button Text
	$wp_customize->add_setting( 'header_primary_btn_text' , array(
	    'default'     => esc_html__('View Details', 'pagli'),
	    'sanitize_callback' => 'sanitize_text_field',
	    'transport'   => 'postMessage',
	) );

	$wp_customize->add_control(
		'header_primary_btn_text', 
		array(
			'label'    => esc_html__( 'Primary Button Text', 'pagli' ),
			'section'  => 'header_image',
			'settings' => 'header_primary_btn_text',
			'type'     => 'text',
		)
	);

	// Header Primary Button Url
	$wp_customize->add_setting( 'header_primary_btn_url' , array(
	    'default'     => esc_url(home_url()),
	    'sanitize_callback' => 'sanitize_text_field',
	    'transport'   => 'postMessage',
	) );

	$wp_customize->add_control(
		'header_primary_btn_url', 
		array(
			'label'    => esc_html__( 'Primary Button URL', 'pagli' ),
			'section'  => 'header_image',
			'settings' => 'header_primary_btn_url',
			'type'     => 'text',
		)
	);

	// Header Secondary Button Text
	$wp_customize->add_setting( 'header_secondary_btn_text' , array(
	    'default'     => esc_html__('Buy Now', 'pagli'),
	    'sanitize_callback' => 'sanitize_text_field',
	    'transport'   => 'postMessage',
	) );

	$wp_customize->add_control(
		'header_secondary_btn_text', 
		array(
			'label'    => esc_html__( 'Secondary Button Text', 'pagli' ),
			'section'  => 'header_image',
			'settings' => 'header_secondary_btn_text',
			'type'     => 'text',
		)
	);

	// Header Primary Button Url
	$wp_customize->add_setting( 'header_secondary_btn_url' , array(
	    'default'     => esc_url(home_url()),
	    'sanitize_callback' => 'sanitize_text_field',
	    'transport'   => 'postMessage',
	) );

	$wp_customize->add_control(
		'header_secondary_btn_url', 
		array(
			'label'    => esc_html__( 'Secondary Button URL', 'pagli' ),
			'section'  => 'header_image',
			'settings' => 'header_secondary_btn_url',
			'type'     => 'text',
		)
	);

	/*
	*** Design Settings
	*/
	// Design Panel
	$wp_customize->add_panel( 'pagli_design_panel' , array(
        'priority' => 15,
        'title' => esc_html__( 'Design Settings', 'pagli' ),
        'description' => esc_html__( 'Configure Design Settings', 'pagli' ),
    ));

	// Blog Section
	$wp_customize->add_section( 'pagli_blog_section' , array(
		'title' => esc_html__( 'Blog Section' , 'pagli'),
		'panel' => 'pagli_design_panel',
		'description' => esc_html__( 'Contains Blog Related Settings and Options', 'pagli' )
	) );

	// Blog Layout
	$wp_customize->add_setting( 'pagli_blog_layout' , array( 'default' => 'grid', 'sanitize_callback' => 'sanitize_text_field' ));
	$wp_customize->add_control(
        'pagli_blog_layout', 
        array(
            'label'    => esc_html__( 'Blog Layout', 'pagli' ),
            'section'  => 'pagli_blog_section',
            'type'     => 'select',
            'description' => esc_html__('Select a layout for blog page', 'pagli'),
            'choices' => array(
                'grid' => esc_html__('Grid', 'pagli'),
                'grid_with_fullwidth_block' => esc_html__('Full width with grid', 'pagli'),
                'fullwidth' => esc_html__('Fullwidth', 'pagli'),
            ),
        )
    );

    // Blog Excerpt Length
	$wp_customize->add_setting( 'pagli_blog_excerpt_length' , array( 'default' => 200, 'sanitize_callback' => 'intval' ));
	$wp_customize->add_control(
        'pagli_blog_excerpt_length', 
        array(
            'label'    => esc_html__( 'Excerpt Length', 'pagli' ),
            'section'  => 'pagli_blog_section',
            'type'     => 'number',
            'description' => esc_html__('Set the length for the blog post text.', 'pagli'),
        )
    );

	// Footer Settings
	$wp_customize->add_section( 'pagli_social_icons' , array(
		'title' => esc_html__( 'Social Icons' , 'pagli'),
		'description' => esc_html__( 'Configure Social Icons', 'pagli' )
	) );

	// Facebook
	$wp_customize->add_setting( 'pagli_fb_link' , array( 'default' => '', 'sanitize_callback' => 'esc_url_raw' ));
	$wp_customize->add_control( 'pagli_fb_link', array(
	    'settings' => 'pagli_fb_link',
	    'label'    => esc_html__( 'Facebook' , 'pagli' ),
	    'section'  => 'pagli_social_icons',
	    'type'     => 'text',
	) );

	// Twitter
	$wp_customize->add_setting( 'pagli_twitter_link' , array( 'default' => '', 'sanitize_callback' => 'esc_url_raw' ));
	$wp_customize->add_control( 'pagli_twitter_link', array(
	    'settings' => 'pagli_twitter_link',
	    'label'    => esc_html__( 'Twitter' , 'pagli' ),
	    'section'  => 'pagli_social_icons',
	    'type'     => 'text',
	) );

	// Google Plus
	$wp_customize->add_setting( 'pagli_gplus_link' , array( 'default' => '', 'sanitize_callback' => 'esc_url_raw' ));
	$wp_customize->add_control( 'pagli_gplus_link', array(
	    'settings' => 'pagli_gplus_link',
	    'label'    => esc_html__( 'Google Plus' , 'pagli' ),
	    'section'  => 'pagli_social_icons',
	    'type'     => 'text',
	) );

	// LinkedIn
	$wp_customize->add_setting( 'pagli_linkedin_link' , array( 'default' => '', 'sanitize_callback' => 'esc_url_raw' ));
	$wp_customize->add_control( 'pagli_linkedin_link', array(
	    'settings' => 'pagli_linkedin_link',
	    'label'    => esc_html__( 'LinkedIn' , 'pagli' ),
	    'section'  => 'pagli_social_icons',
	    'type'     => 'text',
	) );

	// Youtube
	$wp_customize->add_setting( 'pagli_youtube_link' , array( 'default' => '', 'sanitize_callback' => 'esc_url_raw' ));
	$wp_customize->add_control( 'pagli_youtube_link', array(
	    'settings' => 'pagli_youtube_link',
	    'label'    => esc_html__( 'Youtube' , 'pagli' ),
	    'section'  => 'pagli_social_icons',
	    'type'     => 'text',
	) );
}
add_action( 'customize_register', 'pagli_customize_register' );

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function pagli_customize_preview_js() {
	wp_enqueue_script( 'pagli_customizer', get_template_directory_uri() . '/js/customizer.js', array( 'customize-preview' ), '20151215', true );
}
add_action( 'customize_preview_init', 'pagli_customize_preview_js' );